#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: download.py
#  Author: Alfredo Jr. <junix>
#  Creation: 28/10/2006
#  Changed: 08/12/2006 by Laudeci Oliveira <laudeci@gmail.com>
#  Purpose: Download Class
##
######################################################

import urllib2
import gtk
import os
import sys
import gobject

(PACKAGE, VERSION, FILENAME, SIZE, DEBFILENAME,REMOTEFILEPATH,SECTION) = range(7)
 
def getRemoteFileSize(url):
    try:
        instream=urllib2.urlopen(url, None)
        return instream.info().getheader("Content-Length")
    except:
        return 0
        
class Download(gobject.GObject):
    
    __gsignals__ = dict(download_status=(gobject.SIGNAL_RUN_FIRST, gobject.TYPE_NONE, (gobject.TYPE_STRING, gobject.TYPE_FLOAT,gobject.TYPE_FLOAT, gobject.TYPE_INT)))

    def __init__(self, url = "", filepath = ""):
        gobject.GObject.__init__(self)
        self.url = url
        self.FileName = ""
        self.downSize = 1024
        self.Folder = filepath
        self.downloadSize = 0
        self.canceled = False
    
    def cancelDownload(self):
        self.canceled = True
        
    def getDownloadSize(self):
         return self.downloadSize
     
    def getURLName(self):
        name = "%s%s%s" % ( self.Folder, os.sep, self.url.split("/")[-1] )
        return name
        
    def createDownload(self):       
        instream=urllib2.urlopen(self.url, None)
        #self.initialtime = time.time()
        return (instream, instream.info().getheader("Content-Length"))

    def download(self, progressgui = False):
        downloaded = False
        if self.url == "":
            return False

        #try:
        outfile=open( self.getURLName(), "wb")
        url, length = self.createDownload()
        fileName=outfile.name.split(os.sep)[-1]
        self.FileName = fileName
        
        if not length:
            length = "?"

        if length!="?":
            length=float(length)
 
        bytesRead = 0.0
        
        while True:
                bytes = url.read(int(self.downSize))
                bytesRead+= len(bytes)
                fraction = float((100 * bytesRead) / length)
                outfile.write(bytes)
                if progressgui:
                    self.emit('download_status',fileName, length, len(bytes) , (fraction))

                if bytes == "":
                    outfile.close()
                    break
                if self.canceled: 
                    try:
                        outfile.close()
                        os.remove(self.getURLName())
                    except:
                        pass
                    break

        url.close()
        outfile.close()
        
        downloaded = True
        #except :
         #   print "Error downloading %s" % (self.url)

        return downloaded
gobject.type_register(Download)
