#!/usr/bin/env python
# -*- coding: utf-8 -*-

import CreateAptOncd
import ProgressWindow
import config
import gettext
import gtk
import gtk.glade
import locale
from messageBox import MessageBox
import os
import pygtk
import restore
import time
import utils
import HalManager
import RepDownload
import webbrowser
import sys
from mediaInfo import mediaInfo
from optparse import OptionParser
import msg

(RESTORE, RESTORE_ISO,CREATE,HIDE_MAIN,CREATE_LIST, DOWNLOAD, NONE) = range(7)
# ---- Config file ----
config.init(config.CONFIG_FILE)

# ---- i18n ----
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(config.I18N_APP, config.I18N_DIR)
gettext.textdomain(config.I18N_APP)

_ = gettext.gettext

gtk.glade.bindtextdomain(config.I18N_APP, config.I18N_DIR)
gtk.glade.textdomain(config.I18N_APP)
gettext.install(config.I18N_APP, config.I18N_DIR, unicode=1)

class AboutDialog:
	def __init__(self, gladeFileName):
		self.formName = "frmAbout"
		self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
		
	def run(self):
		"""This function will show the aboutDialog"""
		
		#Get the actual dialog widget
		frmAbout = self.gladeFile.get_widget(self.formName)
		frmAbout.set_position(gtk.WIN_POS_CENTER)
		frmAbout.set_modal(True)
		#run the dialog and store the response		
		result = frmAbout.run()
		
		#we are done with the dialog, destory it
		frmAbout.destroy()
		
		#return the result
		return 	result

class RestoreISO:
    def __init__(self,gladeFileName, frmWindow = None):
        self.gladeFileName = gladeFileName
        self.frmMainWindow = frmWindow
        self.cursorManager = utils.cursorManager()
        
    def run(self):
        if os.getuid() != 0:
            os.execl("/usr/bin/gksu", "gksu", "--desktop",
                         "/usr/share/applications/aptoncd.desktop",
                         "--", "aptoncd", "--restore-iso")
            sys.exit()
            return
        result, filename = utils.openSelectDialog (msg.MESSAGE_0029,msg.MESSAGE_0030,"*.iso")
#        print 'Result is:', result, filename
        if result == gtk.RESPONSE_OK:
            isofile = filename[0]
            
            if os.path.isfile(isofile):
                fromPath = "/tmp/aptoncd-mnt-image/"
                utils.mkdir(fromPath,True)
                
                command = "gksu --desktop /usr/share/applications/aptoncd.desktop 'mount -o loop %s %s'" % (isofile.replace(' ','\ '), fromPath.replace(' ','\ '))
                ret = os.system(command)
                time.sleep(0.1)
                cdinfo = mediaInfo(os.path.join(fromPath,'aptoncd.info'))
                result, msgError = cdinfo.infoFromFile()
                if result:
                    isValid,strMsg = cdinfo.compare_version()
                    if isValid:
                        s = restore.restoreAptOnCd(self.gladeFileName,fromPath)
                        s.run()
                    else:
                        MessageBox().ShowError(strMsg,self.frmMainWindow)
                else:
                    MessageBox().ShowError(msgError,self.frmMainWindow)
                    
                command = "gksu --desktop /usr/share/applications/aptoncd.desktop 'umount %s'" % fromPath.replace(' ','\ ')
                ret = os.system(command)
                utils.removePath(fromPath)
            
            else:
                MessageBox().ShowError(msg.MESSAGE_0031,self.frmMainWindow)
        else:
            sys.exit()

class RestoreCD:
    def __init__(self, gladeFileName, frmwindow = None):
        self.gladeFileName = gladeFileName
        self.frmMainWindow = frmwindow
        self.cursorManager = utils.cursorManager()
        
    def run(self):
        if os.getuid() != 0:
            os.execl("/usr/bin/gksu", "gksu", "--desktop",
                         "/usr/share/applications/aptoncd.desktop",
                         "--", "aptoncd", "--restore")
            return
        self.cursorManager.setBusy(self.frmMainWindow,True)
        utils.updateUI()
        CancelMount = False
        deviceEjected = False
        hal = HalManager.HalManager()
        
        mountedName = hal.get_first_mounted_name()
        
        if mountedName == "" and hal.get_property(mountedName,HalManager.LABEL) != "APTonCD":
            f = os.popen("eject")
            mountedName =""
            deviceEjected = True
            while mountedName == "" :
                if not MessageBox().ShowQuestionOkCancel(msg.MESSAGE_0025, self.frmMainWindow):
                    CancelMount = True
                    break
                while hal.get_first_mounted_name() == "":
                        time.sleep(0.1)
                mountedName = hal.get_first_mounted_name()
                
                if mountedName !="":
                    cdName = hal.get_property(mountedName,HalManager.LABEL)
                    if cdName !="APTonCD":
                        MessageBox().ShowError(msg.MESSAGE_0026,self.frmMainWindow)
                        mountedName =""
                        
        elif mountedName != "" and hal.get_property(mountedName,HalManager.LABEL) != "APTonCD":
            f = os.popen("eject")
            mountedName =""
            deviceEjected = True
            while mountedName == "":
                if not MessageBox().ShowQuestionOkCancel(msg.MESSAGE_0027, self.frmMainWindow):
                    CancelMount = True
                    break
                while hal.get_first_mounted_name() == "":
                        time.sleep(0.1)
                mountedName = hal.get_first_mounted_name()
                if mountedName !="":
                    cdName = hal.get_property(mountedName,HalManager.LABEL)
                    if cdName !="APTonCD":
                        MessageBox().ShowError(msg.MESSAGE_0028,self.frmMainWindow)
                        mountedName =""
            
        if not CancelMount:

                self.cursorManager.setBusy(self.frmMainWindow,False)
                mPoint = hal.get_first_mounted_point()
                cdinfo = mediaInfo(os.path.join(mPoint,'aptoncd.info'))
                result, msgError = cdinfo.infoFromFile()
                if result:
                    isValid,strMsg = cdinfo.compare_version()
                    if isValid:
                        s = restore.restoreAptOnCd(self.gladeFileName,mPoint)
                        s.run()
                    else:
                        MessageBox().ShowError(strMsg,self.frmMainWindow)
                else:
                    MessageBox().ShowError(msgError,self.frmMainWindow)
        else:
            if deviceEjected:
                f = os.popen("eject -t &")
        self.cursorManager.setBusy(self.frmMainWindow,False)       
        
        return     result

class ConfigurationDialog:
    def __init__(self, gladeFileName):
        self.formName = "frmConfiguration"
        self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
        
    def run(self):
        """This function will show the Configuration Dialog"""
        
        #Get the actual dialog widget
        frmConfiguration = self.gladeFile.get_widget(self.formName)
        frmConfiguration.set_position(gtk.WIN_POS_CENTER)
        frmConfiguration.set_modal(True)
        
        #run the dialog and store the response        
        result = frmConfiguration.run()
        
        #we are done with the dialog, destory it
        frmConfiguration.destroy()
        
        return     result

class DownloadDialog:
    def __init__(self, gladeFileName):
        self.formName = "frmDownload"
        self.gladeFile = gtk.glade.XML(gladeFileName, self.formName)
        
    def run(self):
        """This function will show the downloadDialog"""
        
        #Get the actual dialog widget
        frmDownload = self.gladeFile.get_widget(self.formName)
        frmDownload.set_position(gtk.WIN_POS_CENTER)
        frmDownload.set_modal(True)
        
        # ---- dictionary ----
        dic = { 'on_btnDownload_clicked' : self.on_btnDownload_clicked}
        
        self.gladeFile.signal_autoconnect(dic)
        
        # -- set default values --
        # set version by cboVersion
        
        self.gladeFile.get_widget("cboMirror").set_active(0)
        self.gladeFile.get_widget("cboArchitecture").set_active(0)
        self.gladeFile.get_widget("cboMedia").set_active(1)
        
        #run the dialog and store the response        
        result = frmDownload.run()
        
        #we are done with the dialog, destory it
        frmDownload.destroy()
        
        #return the result and the Configuration
        #TODO: Create a configuration object an return it
        return result
    
    def on_btnDownload_clicked(self, widget):
        pipe = os.popen("lsb_release -c -s")
        dist = pipe.read().strip()
        if self.gladeFile.get_widget("cboVersion").get_active_text() == None:
            config.set("mkdvd", "version", dist)
        else:
            cboVersion = self.gladeFile.get_widget("cboVersion").get_active_text()
            config.set("mkdvd", "version", cboVersion)

        cboMirror = self.gladeFile.get_widget("cboMirror").get_active_text()
        config.set("mkdvd", "mirror", cboMirror)

        cboArchitecture = self.gladeFile.get_widget("cboArchitecture").get_active_text()
        config.set("mkdvd", "arch", cboArchitecture)    

        cboMedia = self.gladeFile.get_widget("cboMedia").get_active_text()
        config.set("mkdvd", "media", cboMedia)
        
        # write the configuration set
        config.write(config.CONFIG_FILE)
        
        # download repositories
        download.start()
        
        download.mkmedia()
    
class MainForm:
    def __init__(self,args,showform = True):
        self.gladeFileName = config.GUI
        self.formName = "frmMainWindow"
        self.gladeFile = gtk.glade.XML(self.gladeFileName, self.formName)
        self.frmMainWindow = self.gladeFile.get_widget(self.formName)
        self.cursorManager = utils.cursorManager()
        self.init_args = args
        # ---- dictionary ----
        dic = { 'on_frmMainWindow_destroy' : self.on_frmMainWindow_destroy,
             'on_btnCreate_clicked' : self.on_btnCreate_clicked,
             'on_btnRestoreCD_clicked' : self.on_btnRestoreCD_clicked,
             'on_btnDownload_clicked' : self.on_btnDownload_clicked,    
             'on_btnQuit_clicked' : self.on_frmMainWindow_destroy,
             'on_btnRestoreCD_clicked' : self.on_btnRestoreCD_clicked,
             'on_btnRestoreImage_clicked' : self.on_btnRestoreImage_clicked,
             'on_btnAdd_clicked' : self.on_btnAdd_clicked,
             'on_mnuHelpAbout_activate' : self.on_mnuHelpAbout_activate,
             'on_mnuEditPreferences_activate' : self.on_mnuEditPreferences_activate,
             'on_mnuHelpHelp_activate' : self.on_mnuHelpHelp_activate,
             'on_mnuEditPreferences_activate' : self.on_mnuEditPreferences_activate,
             'on_mnuHome_activate' : self.on_mnuHome_activate,
             'on_mnuFileQuit_activate' : self.on_frmMainWindow_destroy }
        
        self.gladeFile.signal_autoconnect(dic)
        self.frmMainWindow.connect('destroy',self.on_frmMainWindow_destroy)
        
        if args == CREATE:
            self.on_btnCreate_clicked(self.frmMainWindow)
        elif args ==    RESTORE:
            self.on_btnRestoreCD_clicked(self.frmMainWindow)
        elif args == RESTORE_ISO:
            self.on_btnRestoreImage_clicked(self.frmMainWindow)
        elif args == DOWNLOAD:
            self.on_btnDownload_clicked(self.frmMainWindow)
        
        if not showform:
            self.frmMainWindow.hide()
    
    # ---- actions and windows (widgets) ----
    def on_btnDownload_clicked(self, widget):
        frmDownload = RepDownload.RepDownload(self.gladeFileName )
        response = frmDownload.SetOptions()

    def on_btnCreate_clicked(self, widget):
        s = CreateAptOncd.createAptOnCd(self.gladeFileName)
        s.run()
    
    def on_btnRestoreCD_clicked(self, widget):
        d = RestoreCD(self.gladeFileName,self.frmMainWindow)
        d.run()
            
    def on_btnRestoreImage_clicked(self, widget):
       d= RestoreISO(self.gladeFileName,self.frmMainWindow)
       d.run()
    
    def on_btnAdd_clicked(self, widget):
        os.system("gksu --desktop /usr/share/applications/aptoncd.desktop 'synaptic --hide-main-window --ask-cdrom' &")
        
    def on_mnuEditPreferences_activate(self, widget):
        frmConfiguration = ConfigurationDialog(self.gladeFileName)
        response = frmConfiguration.run()
        config.write(config.CONFIG_FILE)
        
    def on_mnuHelpAbout_activate(self, widget):
        frmAbout = AboutDialog(self.gladeFileName)
        response = frmAbout.run()

    def on_mnuHelpHelp_activate(self, widget):
        os.system('yelp ' + config.DOC + '&')
    
    def on_frmMainWindow_destroy(self, widget):
        gtk.main_quit()
    
    def on_mnuHome_activate(self, widget):
        webbrowser.open("http://aptoncd.sourceforge.net")

def main(argv=None):
    opt = NONE
    if argv is None:
        argv = sys.argv
    #this will validate if args are in correct way
    parser = OptionParser()
    parser.set_usage('aptoncd [OPTION]\nExecute APTonCD with command-line parameters to save time.' )
    parser.add_option('-c','--create', action='store_true', dest='create', default=False, help=_('starts aptoncd on create media-repository mode.'))
    parser.add_option('-l','--create-from',action='store_true', dest='create_from_list', default=None, help=_('starts aptoncd on create media-repository mode.'))
    parser.add_option('-r','--restore', action='store_true', dest='restore', default=False, help=_('starts aptoncd on restore media mode.'))
    parser.add_option('-i','--restore-iso', action='store_true', dest='restore_iso', default=False, help=_('starts aptoncd on restore .iso image mode.'))
    parser.add_option('-d','--download', action='store_true', dest='download', default=False, help=_('starts aptoncd on download mode.'))
    parser.add_option('-v','--version', action='store_true', dest='app_version', default=False, help=_('output version information and exit.'))       
    
    options, args = parser.parse_args()
    if options.restore_iso and options.restore:
        parser.error("You can't  use restore and restore-iso options together.")
    elif options.create and options.restore:
        parser.error("You can't  use restore and create options together.")
    elif options.create and options.restore_iso:
        parser.error("You can't  use create and restore-iso options together.")
    elif options.create_from_list and options.restore_iso:
        parser.error("You can't  use create-from and restore-iso options together.")
    elif options.create_from_list and options.restore:
        parser.error("You can't  use create-from and restore options together.")
    elif options.create_from_list and options.create:
        parser.error("You can't  use create-from and create options together.")
    elif options.create_from_list and options.restore:
        parser.error("You can't  use create-from and create options together.")
        
    if options.app_version:
        print config.VERSION
        sys.exit()
        
    if options.create_from_list:
        try:
            is_file = utils.fileExist( args[0])
            if not is_file:
                parser.error('File "%s" not found.' % args[0])
        except:
            sys.exit()
    if options.restore:
        d = RestoreCD(config.GUI)
        d.run()
        sys.exit()
    elif options.restore_iso:
        opt = RESTORE_ISO
        d= RestoreISO(config.GUI)
        d.run()
        sys.exit()
    
    elif options.download:
        frmDownload = RepDownload.RepDownload(config.GUI )
        response = frmDownload.SetOptions()
        sys.exit()
    elif options.create:
        s = CreateAptOncd.createAptOnCd(config.GUI)
        s.run()
        sys.exit()
        
    if not options.create_from_list:
        br = MainForm(opt)
    else:
        s = CreateAptOncd.createAptOnCd(config.GUI , loadfrom = CreateAptOncd.LOAD_FILE, file_to_scan =args[0])
        s.run()
        sys.exit()

    gtk.main()

#Starting point
if __name__ == "__main__":

    main(sys.argv[1:])
