#  ProgressWindow.py
#  
#  Author: Laudeci Oliveira <laudeci@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA
import gtk
import pygtk
import gobject
import pango
import msg
import utils
class ProgressDialog(gtk.Window):
	"""
	ProgressWindow returns a window that contains a number of properties to
	access what a common Progress window should have.
	"""
	def __init__(self, title = "", description = "", parent = None, task = ""):
		# Creating the windows and its properties
		gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
		self.parentui = parent
		if self.parentui != None:
			self.set_transient_for(parent)
		self._create_ui(title, description, task)
		self.cancel_status = False

	def _create_ui(self, title, description, task):
		self.set_border_width(6)
		self.set_resizable(False)
		#self.set_has_separator(False)
		self.set_skip_taskbar_hint(True)
		self.set_type_hint(gtk.WINDOW_POPUP)
		self.set_size_request(520,190)
		self.set_title(title)
		self.realize()
		self.window.set_functions(gtk.gdk.FUNC_MOVE)
		# prevent the window from closing with the delete button (there is
		# a cancel button in the window)
		self.connect("delete_event", lambda e,w: True);

		vbox = gtk.VBox()
		vbox.set_border_width(6)
		vbox.show()
		self.add(vbox)

		self.labelTitle = label = gtk.Label('<big><b>%s</b></big>' % title)
		label.set_use_markup(True)
		label.set_alignment(0.0, 0.0)
		label.show()
		vbox.pack_start(label, False)

		self.labelDesc = label = gtk.Label(description)
		label.set_line_wrap(True)
		label.set_alignment(0.5, 0.0)
		label.set_padding(0, 12)
		label.show()
		vbox.pack_start(label, False)

		self.progress = progress = gtk.ProgressBar()
		progress.show()
		vbox.pack_start(progress, False)

		self.progresstext = label = gtk.Label('<i>%s</i>' % task)
		label.set_use_markup(True)
		label.set_alignment(0.0, 0.0)
		label.show()
		vbox.pack_start(label,False)
		
		hbbox =gtk.HButtonBox()
		hbbox.set_border_width(5)
		hbbox.set_layout( gtk.BUTTONBOX_END)
		hbbox.show()
		vbox.pack_start(hbbox,False)

		self.btnCancel = btnCancel =gtk.Button(gtk.STOCK_CANCEL)
		btnCancel.set_use_stock(True)
		btnCancel.show()
		hbbox.pack_start(btnCancel)

		#self.show()        

	def connectEvent(self,functionEvent):
		self.btnCancel.connect("clicked",functionEvent)
	
	
	def set_windowtitle(self,title):
		self.set_title(title)
		
	def set_tasktitle(self,title):
		self.labelTitle.set_markup('<big><b>%s</b></big>' % title)

	def set_task(self,task):
		self.progresstext.set_markup('<i>%s</i>' % task)

	def set_description(self,description):
		self.labelDesc.set_text(description)

class AptOnCDProgressDialog(ProgressDialog):

	def __init__(self, parent = None, start = 0, stop = 0):
		
		
		ProgressDialog.__init__(self,(msg.MESSAGE_0052),
					(msg.MESSAGE_0053),
					parent,(msg.MESSAGE_0054))
		self.start = start
		self.stop = stop
		self.update(start)
		self.cancel_status = False
		self.btnCancel.connect("clicked", self.click)
		self.show()

	def click(self, *args):
		self.cancel_status = True
		self.hide()

	def TaskLenght(self,lenWork):
		self.stop = lenWork
		self.update(self.start)
	
	def TaskTitle(self,title):
		self.set_tasktitle(title)
	
	def Title(self,title):
		self.set_windowtitle(title)

	def Task(self,task):
		self.set_task(task)

	def Description(self,description):
		self.set_description(description)

	def isCancelEnabled(self,value = True):
		self.btnCancel.set_sensitive(value)
		self.btnCancel.set_property('visible',value)
	
	def set_text(self,value):
		self.progress.set_text(value)
		utils.updateUI()
		
	def updateFraction(self,value):
		self.progress.set_fraction(value)
		self.progress.set_text(('%d%%' % (value * 100)))
		utils.updateUI()
		
	def set_fraction(self, value):
		self.progress.set_text(('%d%%' % (value * 100)))
		self.progress.set_fraction(value)
		utils.updateUI()
			
	def update(self, pos):
		try:
			pos = min(max(pos, self.start), self.stop)
			remaining = self.stop - pos
			self.progress.set_text((msg.MESSAGE_0055 % (remaining, self.stop)))
			self.progress.set_fraction(1.0 - float(remaining) / (self.stop - self.start))
		except ZeroDivisionError:
			self.progress.set_fraction(self.start)
		utils.updateUI()
