// -*- C++ -*-
#include <ept/config.h>
#include <ept/test.h>
#include <ept/core/predicate/predicate.h>

using namespace ept::core::predicate;

template< typename T >
struct Equals : PredicateMixin< T, Equals< T > > {
    T value;
    Equals( const T &x ) : value( x ) {}
    bool operator()( const T &x ) {
        return x == value;
    }
};


struct TestCorePredicate {
    Test basic() {
        assert( ( Equals< int >( 5 ) )( 5 ) );
        assert( ! ( Equals< int >( 4 ) )( 5 ) );
    };
};
