// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>
#include <adept/commitwidget.h>
#include <adept/downloadprogress.h>
#include <adept/processevents.h>

#include <QtGui/QApplication>
#include <QtGui/QStackedWidget>
#include <KVBox>

#ifndef ADEPT_PROGRESSWIDGET_H
#define ADEPT_PROGRESSWIDGET_H

namespace adept {

class OpProgressWidget : public KVBox, public OpProgress
{
    Q_OBJECT
public:
    OpProgressWidget( QWidget *p );

    virtual void Update();
    virtual void Done();

public Q_SLOTS:
    void updateValues();

Q_SIGNALS:
    void activated();
    void done();

protected:
    QLabel *m_label;
    QProgressBar *m_pbar;
    bool m_busy;
};

class ProgressWidget : public QStackedWidget
{
    Q_OBJECT
    CommitWidget *m_commit;
    DownloadProgress *m_download;
    OpProgressWidget *m_progress;
    QLabel *m_noop;
    QWidget *m_noopParent;

public:
    ProgressWidget( QWidget *p = 0 );
    DebconfGui *debconf() {
        return m_commit->debconf();
    }

    DownloadProgress *download() {
        return m_download;
    }

    OpProgressWidget *progress() {
        return m_progress;
    }

    CommitWidget *commit() {
        return m_commit;
    }

public Q_SLOTS:
    void downloadStatusChanged( DownloadProgress::Status s ) {
        if ( s == DownloadProgress::StWaiting )
            setCurrentWidget( m_download );
    }

    void raiseCommit() {
        setCurrentWidget( m_commit );
    }

    void progressStart() {
        setCurrentWidget( m_progress );
    }

    void progressDone() {
        setCurrentWidget( m_noopParent );
    }

    void noop();
    void done();
    void downloadCancelled();
    void updateCancelled();
    void error( QString, bool justify = true );
};

}

#endif
