// -*- C++ -*-
#include <ept/core/apt.h>
#include <wibble/sys/fs.h>

namespace wfs = wibble::sys::fs;

namespace ept {
namespace core {
time_t aptTimestamp()
{
    std::auto_ptr<struct stat> st = wfs::stat(
        _config->FindFile( "Dir::Cache::pkgcache" ) );
    time_t t1 = st.get() == NULL ? 0 : st->st_mtime;
 
    std::auto_ptr<struct stat> st1 = wfs::stat(
        _config->FindFile( "Dir::State::status" ) );
    time_t t2 = st1.get() == NULL ? 0 : st1->st_mtime;
 
    return t1 > t2 ? t1 : t2;
}

}
}
