// -*- C++ -*- (c) 2005-2008 Petr Rockai <me@mornfall.net>

#include <adept/guidpkgpm.h>

#ifndef RPM
#include <fcntl.h>
#include <iostream>

#include <apt-pkg/configuration.h>
#include <apt-pkg/error.h>

#include <ept/core/apt.h>

#include <adept/util.h>

#include <QtCore/QStringList>
#include <QtCore/QCoreApplication>

#include <klocale.h>

using namespace ept::core;

namespace adept {

void DpkgGui::dpkgMonitor ()
{
    DpkgHarness::dpkgMonitor();
    if ( m_dcf )
        m_dcf->processAvailable();
    QCoreApplication::processEvents();
}

void DpkgGui::updateStatus( std::string pkg, std::string ev, std::string r )
{
    QString msg;
    DpkgHarness::updateStatus( pkg, ev, r );
    ept::Token t( pkg );
    PackageState s = pkgs.get< package::State >( t );

    if ( m_currentOp == OInstall ) {
        if ( s.newInstall() ) {
            if ( ev == "half-installed" )
                msg = i18n( "Preparing installation of %1...", u8( pkg ) );
            else if ( ev == "unpacked" )
                msg = i18n( "Unpacking %1...", u8( pkg ) );
        } else if ( s.upgrade() ) {
            if ( ev == "half-installed" )
                msg = i18n( "Preparing upgrade of %1...", u8( pkg ) );
            else if ( ev == "unpacked" || ev == "half-configured" )
                msg = i18n( "Replacing %1 with new version...", u8( pkg ) );
        }
    } else if ( m_currentOp == OConfigure ) {
        if ( s.newInstall() ) {
            if ( ev == "unpacked" )
                msg = i18n( "Preparing to configure %1...", u8( pkg ) );
            else if ( ev == "half-configured" )
                msg = i18n( "Configuring %1...", u8( pkg ) );
            else if ( ev == "installed" )
                msg = i18n( "Installed %1", u8( pkg ) );
        } else if ( s.upgrade() ) {
            if ( ev == "unpacked" )
                msg = i18n( "Preparing to configure new version of %1...", u8( pkg ) );
            else if ( ev == "half-configured" )
                msg = i18n( "Configuring new version of %1...", u8( pkg ) );
            else if ( ev == "installed" )
                msg = i18n( "Upgraded %1", u8( pkg ) );
        }
    } else if ( m_currentOp == ORemove ) {
        if ( ev == "installed" )
            msg = i18n( "Preparing to remove %1...", u8( pkg ) );
        else if ( ev == "half-configured" || ev == "half-installed" )
            msg = i18n( "Removing %1...", u8( pkg ) );
        else if ( ev == "config-files" || ev == "not-installed" )
            msg = i18n( "Removed %1", u8( pkg ) );
    } else if ( m_currentOp == OPurge ) {
        if ( ev == "config-files" )
            msg = i18n( "Preparing to purge %1...", u8( pkg ) );
        else if ( ev == "not-installed" )
            msg = i18n( "Purged %1", u8( pkg ) );
    }

    if ( ev == "error " ) { // FIXME, the space there is blaah.
        // AptException later on will swallow this error message here.
        _error->Error( "Error processing %s: %s.", pkg.c_str(), r.c_str() );
    }

    std::cerr << "updateStatus( '" << pkg << "', '" << ev << "', '" << r
              << "')" << ", seen = " << m_seenOpCount
              << "/" << m_totalOpCount << std::endl;
    int progress = 0;
    if ( m_seenOpCount >= m_totalOpCount || m_totalOpCount == 0 )
        progress = 100;
    else
        progress = ( m_seenOpCount * 100 ) / m_totalOpCount;

    statusChanged( progress, msg
                   + ( ( r == "" ) ? "" : ( " (" + u8( r ) + ")" ) ) );
}

void DpkgGui::handleConffile( std::string file, std::string user,
                                std::string system )
{
    DpkgHarness::handleConffile( file, user, system );
    emit conffilePrompt( file, user, system );
}

}

#include "guidpkgpm.moc"
#endif
