/* RenameAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import be.ugent.caagt.swirl.lists.TypedListModel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ListSelectionModel;

import org.grinvin.list.HasName;

/**
 * List action which can be used to rename an element that implements the interface {@link HasName}.
 * A {@link RenamePanel} is used to change the name of the selected element. An action of this type
 * is by default only enabled when exactly one elemented that has an editable name is selected.
 */
public class RenameAction<T extends HasName> extends AbstractListAction<T> {
    
    //
    private Component parent;
    
    //
    private RenamePanel renamePanel;
    
    /**
     * Create an action of this type for the given <code>TypedListModel</code> with the given <code>ListSelectionModel</code>
     * that uses the given <code>RenamePanel</code> and has <code>null</code> as parent.
     */
    public RenameAction(TypedListModel<T> list, ListSelectionModel selection, RenamePanel renamePanel, ResourceBundle bundle, String resourceID) {
        this(list, selection, renamePanel, null, bundle, resourceID);
    }
    
    /**
     * Create an action of this type for the given <code>TypedListModel</code> with the given <code>ListSelectionModel</code>
     * that uses the given <code>RenamePanel</code> and has the given parent.
     */
    public RenameAction(TypedListModel<T> list, ListSelectionModel selection, RenamePanel renamePanel, Component parent, ResourceBundle bundle, String resourceID) {
        super(list, selection, bundle, resourceID);
        this.parent = parent;
        this.renamePanel = renamePanel;
    }
    
    /**
     * Set the parent for the dialog window.
     */
    public void setParent(Component parent) {
        this.parent = parent;
    }
    
    //
    @Override
    public void setEnabled() {
        List<T> selected = getSelectedElements();
        setEnabled(selected.size()==1 && selected.get(0)!=null && selected.get(0).isNameEditable());
    }
    
    //
    public void actionPerformed(ActionEvent ev) {
        List<T> selected = getSelectedElements();
        if (selected.size()==1 && selected.get(0)!=null && selected.get(0).isNameEditable()) {
            renamePanel.showDialog(selected.get(0), parent);
        }
    }
}
