/* DefaultFilterListModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.lists.ArrayListModel;

import java.net.URI;
import java.util.Collection;

import org.grinvin.conjecture.filter.GraphFilter;
import org.grinvin.conjecture.filter.GraphFilterListener;

/**
 * Default implementation of {@link InvariantListModel}.
 */
public class DefaultFilterListModel extends ArrayListModel<GraphFilter> implements FilterListModel, GraphFilterListener {
    
    //
    public void addFilterListModelListener(FilterListModelListener listener) {
        this.addListDataListener(listener);
    }
    
    //
    public void removeFilterListModelListener(FilterListModelListener listener) {
        this.addListDataListener(listener);
    }
    
    //
    public void add(int index, GraphFilter element) {
        element.addGraphFilterListener(this);
        super.add(index, element);
    }
    
    //
    public boolean add(GraphFilter element) {
        element.addGraphFilterListener(this);
        return super.add(element);
    }
    
    //
    public boolean addAll(Collection<? extends GraphFilter> collection) {
        for(GraphFilter filter : collection)
            filter.addGraphFilterListener(this);
        return super.addAll(collection);
    }
    
    //
    public boolean addAll(int index, Collection<? extends GraphFilter> collection) {
        for(GraphFilter filter : collection)
            filter.addGraphFilterListener(this);
        return super.addAll(index, collection);
    }

    //
    public void clear() {
        super.clear();
    }
    
    //
    public boolean remove(Object obj) {
        return super.remove(obj);
    }
    
    //
    public GraphFilter remove(int index) {
        return super.remove(index);
    }
    
    //
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }
    
    //
    public GraphFilter set(int index, GraphFilter element) {
        return super.set(index, element);
    }

    public void filterChanged(GraphFilter filter) {
        int index = indexOf(filter);
        fireContentsChanged(this, index, index);
    }

    //
    private URI uri;
    
    public URI getURI() {
        return uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }
    
}
