/* NumericValue.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.values;

import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantType;

/**
 * Common superclass of {@link IntegerValue} and {@link RealValue}.
 */
public abstract class NumericValue extends AbstractInvariantValue {
    
    /**
     * Internal representation of the actual value. This is a double, allowing
     * the representation of infinity and undefined (as 'not a number'), also
     * when representing integers.
     */
    protected double value;
    
    //
    protected NumericValue (double value, InvariantType type, InvariantComputer computer) {
        super (type, computer);
        this.value = value;
    }
    
    NumericValue(double value, InvariantType type, Invariant invariant, String computerId, String computerVersion) {
        super(type, invariant, computerId, computerVersion);
        this.value = value;
    }
    
    /**
     * Return the actual value as a real number. An undefined value is
     * represented by {@link Double#NaN}.
     */
    public double asDouble () {
        return value;
    }
    
}
