/* FilterDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import java.util.ResourceBundle;
import javax.swing.JComponent;

import org.grinvin.conjecture.filter.GraphFilter;
import org.grinvin.gui.components.AcceptsFilter;

/**
 * Common DropHandler to drop filters on objects that support {@link AcceptsFilter}.
 */
public class FilterDropHandler extends AbstractDropHandler {
    
    // cannot be instantiated by clients
    private FilterDropHandler() {
        super(GraphFilter.class, true);
        // empty
    }
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.gui.dnd.resources");
    
    /**
     * The unique shared object of this type.
     */
    private static final FilterDropHandler DROP_HANDLER = new FilterDropHandler();

    public static FilterDropHandler getInstance() {
        return DROP_HANDLER;
    }

    public boolean acceptDrop(JComponent target, Object object, int seqNr) {
        if(!target.isEnabled())
            return seqNr != 0;
        if (target instanceof AcceptsFilter && object instanceof GraphFilter)
            return ((AcceptsFilter)target).addFilter((GraphFilter)object) || seqNr != 0;
        else
            return seqNr != 0;
    }

}
