/* AbstractDragHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import be.ugent.caagt.swirl.dnd.DragHandler;
import be.ugent.caagt.swirl.dnd.LocalTransferHandler;

import javax.swing.JComponent;

import org.grinvin.list.HasSelectableValues;

/**
 * Abstract implementation of {@link DragHandler}.
 */
public abstract class AbstractDragHandler implements DragHandler {
    
    //
    private final Class type;
    
    //
    private final int sourceActions;
    
    //
    public AbstractDragHandler(Class type, int sourceActions) {
        this.type = type;
        this.sourceActions = sourceActions;
    }
    
    //
    public int getSourceActions(JComponent source) {
        if (source instanceof HasAccessControl) {
            return ((HasAccessControl)source).getDragOperations();
        } else {
            return sourceActions;
        }
    }
    
    //
    public abstract void exportDone(JComponent source, JComponent target, Object[] objects, Class<?> type, int action);
    
    // copy to another type array
    public Object[] getExportedObjects(JComponent source) {
        //TODO: do we have to copy? I think not
        Object[] values = ((HasSelectableValues)source).getSelectedValues();
        Object[] result = new Object[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }
    
    //
    public Class getExportedClass(JComponent source) {
        return type;
    }
    
    //
    @SuppressWarnings("PMD.CompareObjectsWithEquals")
    public boolean isTransferAllowed(JComponent source, JComponent target) {
        if (source == target) {
            return false;
        }
        if (source instanceof HasAccessControl) {
            if ((((HasAccessControl)source).getDragOperations() & LocalTransferHandler.COPY_OR_MOVE) == 0)
                return false;
        }
        if (target instanceof HasAccessControl) {
            if ((((HasAccessControl)target).getDropOperations() & LocalTransferHandler.COPY_OR_MOVE) == 0)
                return false;
        }
        return true;
    }
    
}
