/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.SafeFileTable;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class SaveContext
implements ISaveContext {
    protected Plugin plugin;
    protected int kind;
    protected boolean needDelta;
    protected boolean needSaveNumber;
    protected SafeFileTable fileTable;
    protected int previousSaveNumber;
    protected IProject project;

    protected SaveContext(Plugin plugin, int kind, IProject project) throws CoreException {
        this.plugin = plugin;
        this.kind = kind;
        this.project = project;
        this.needDelta = false;
        this.needSaveNumber = false;
        String pluginId = plugin.getDescriptor().getUniqueIdentifier();
        this.fileTable = new SafeFileTable(pluginId);
        this.previousSaveNumber = this.getWorkspace().getSaveManager().getSaveNumber(pluginId);
    }

    public void commit() throws CoreException {
        if (this.needSaveNumber) {
            String pluginId = this.plugin.getDescriptor().getUniqueIdentifier();
            IPath oldLocation = this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId);
            this.getWorkspace().getSaveManager().setSaveNumber(pluginId, this.getSaveNumber());
            this.fileTable.setLocation(this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId));
            this.fileTable.save();
            oldLocation.toFile().delete();
        }
    }

    public IPath[] getFiles() {
        return this.getFileTable().getFiles();
    }

    protected SafeFileTable getFileTable() {
        return this.fileTable;
    }

    public int getKind() {
        return this.kind;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public int getPreviousSaveNumber() {
        return this.previousSaveNumber;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getSaveNumber() {
        int result = this.getPreviousSaveNumber() + 1;
        return result > 0 ? result : 1;
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public boolean isDeltaNeeded() {
        return this.needDelta;
    }

    public IPath lookup(IPath file) {
        return this.getFileTable().lookup(file);
    }

    public void map(IPath file, IPath location) {
        this.getFileTable().map(file, location);
    }

    public void needDelta() {
        this.needDelta = true;
    }

    public void needSaveNumber() {
        this.needSaveNumber = true;
    }
}

