/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterSuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.ast.SuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;

public abstract class InterTypeDeclaration
extends AjMethodDeclaration {
    public TypeReference onType;
    protected ReferenceBinding onTypeBinding;
    protected ResolvedTypeMunger munger;
    protected int declaredModifiers;
    protected char[] declaredSelector;
    private static final short ACC_ANNOTATION = 8192;
    private static final short ACC_ENUM = 16384;

    public InterTypeDeclaration(CompilationResult result, TypeReference onType) {
        super(result);
        this.onType = onType;
        this.modifiers = 9;
    }

    public void setDeclaredModifiers(int modifiers) {
        this.declaredModifiers = modifiers;
    }

    public void setSelector(char[] selector) {
        this.declaredSelector = selector;
        this.selector = CharOperation.concat(selector, Integer.toHexString(this.sourceStart).toCharArray());
    }

    public boolean isTargetAnnotation(ClassScope classScope, String kind) {
        if ((this.onTypeBinding.getAccessFlags() & 0x2000) != 0) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't make inter-type " + kind + " declarations on annotation types.");
            this.ignoreFurtherInvestigation = true;
            return true;
        }
        return false;
    }

    public boolean isTargetEnum(ClassScope classScope, String kind) {
        if ((this.onTypeBinding.getAccessFlags() & 0x4000) != 0) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't make inter-type " + kind + " declarations on enum types.");
            this.ignoreFurtherInvestigation = true;
            return true;
        }
        return false;
    }

    public void resolve(ClassScope upperScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        InterTypeScope newParent = new InterTypeScope((Scope)upperScope, this.onTypeBinding);
        this.scope.parent = newParent;
        this.scope.isStatic = Modifier.isStatic(this.declaredModifiers);
        this.fixSuperCallsForInterfaceContext(upperScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        super.resolve(newParent);
        this.fixSuperCallsInBody();
    }

    private void fixSuperCallsForInterfaceContext(ClassScope scope) {
        if (this.onTypeBinding.isInterface()) {
            InterSuperFixerVisitor v = new InterSuperFixerVisitor(this, EclipseFactory.fromScopeLookupEnvironment(scope), scope);
            this.traverse((ASTVisitor)v, scope);
        }
    }

    public abstract EclipseTypeMunger build(ClassScope var1);

    public void fixSuperCallsInBody() {
        SuperFixerVisitor v = new SuperFixerVisitor(this, this.onTypeBinding);
        this.traverse((ASTVisitor)v, (ClassScope)null);
        this.munger.setSuperMethodsCalled(v.superMethodsCalled);
    }

    protected void resolveOnType(ClassScope classScope) {
        this.checkSpec();
        this.onTypeBinding = (ReferenceBinding)this.onType.getTypeBindingPublic(classScope);
        if (!this.onTypeBinding.isValidBinding()) {
            classScope.problemReporter().invalidType(this.onType, this.onTypeBinding);
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected void checkSpec() {
        if (Modifier.isProtected(this.declaredModifiers)) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "protected inter-type declarations are not allowed");
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected List makeEffectiveSignatureAttribute(ResolvedMember sig, Shadow.Kind kind, boolean weaveBody) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter(new AjAttribute.EffectiveSignatureAttribute(sig, kind, weaveBody)));
        return l;
    }

    protected void setMunger(ResolvedTypeMunger munger) {
        munger.getSignature().setPosition(this.sourceStart, this.sourceEnd);
        munger.getSignature().setSourceContext(new EclipseSourceContext(this.compilationResult));
        this.munger = munger;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        Shadow.Kind kind = this.getShadowKindForBody();
        List l = kind != null ? this.makeEffectiveSignatureAttribute(this.munger.getSignature(), kind, true) : new ArrayList(0);
        this.addDeclarationStartLineAttribute(l, classFile);
        return classFile.generateMethodInfoAttribute(this.binding, false, l);
    }

    protected abstract Shadow.Kind getShadowKindForBody();

    public ResolvedMember getSignature() {
        if (this.munger == null) {
            return null;
        }
        return this.munger.getSignature();
    }

    public char[] getDeclaredSelector() {
        return this.declaredSelector;
    }
}

