<?php

/***************************************************************************\
 *  SPIP, Systeme de publication pour l'internet                           *
 *                                                                         *
 *  Copyright (c) 2001-2014                                                *
 *  Arnaud Martin, Antoine Pitrou, Philippe Riviere, Emmanuel Saint-James  *
 *                                                                         *
 *  Ce programme est un logiciel libre distribue sous licence GNU/GPL.     *
 *  Pour plus de details voir le fichier COPYING.txt ou l'aide en ligne.   *
\***************************************************************************/


if (!defined('_ECRIRE_INC_VERSION')) return;

include_spip('inc/autoriser');
include_spip('inc/presentation');

/**
 * Crée l'affichage des listes de rubriques dans le privé
 * 
 * @param int $collection
 *  L'identifiant numérique de la rubrique à lister
 * @param int $debut
 * 	Le numéro de la pagination si paginé (> 500)
 * @param int $limite
 * 	Le pas de pagination si paginé (> 500)
 * @return array $res
 * 	Un tableau des sous rubriques
 */
function enfant_rub($collection,$debut=0,$limite=500){
	$voir_logo = (isset($GLOBALS['meta']['image_process']) AND $GLOBALS['meta']['image_process'] != "non");
	$logo = "";

	if ($voir_logo) {
		$chercher_logo = charger_fonction('chercher_logo', 'inc');
		include_spip('inc/filtres_images_mini');
	}

	$res = array();
	
	$result = sql_select("id_rubrique, id_parent, titre, descriptif, lang ", "spip_rubriques", "id_parent=$collection",'', '0+titre,titre',"$debut,$limite");
	while($row=sql_fetch($result)){
		$id_rubrique=$row['id_rubrique'];
		$id_parent=$row['id_parent'];
		$titre=generer_info_entite($id_rubrique,'rubrique','titre'); // pour etre sur de passer par tous les traitements
		if ('' !== ($rang = recuperer_numero($row['titre'])))
			$rang = "$rang. ";

		if (autoriser('voir','rubrique',$id_rubrique)){

			$les_sous_enfants = sous_enfant_rub($id_rubrique);

			changer_typo($row['lang']);
			$lang_dir = lang_dir($row['lang']);
			$descriptif=propre($row['descriptif']);

			if ($voir_logo) {
				if ($logo = $chercher_logo($id_rubrique, 'id_rubrique', 'on')) {
					list($fid, $dir, $nom, $format) = $logo;
					$logo = image_reduire("<img src='$fid' alt='' />", 48, 36);
					if ($logo)
						$logo =  inserer_attribut($logo,'class','logo');
				}
			}

			$lib_bouton = (!acces_restreint_rubrique($id_rubrique) ? "" :
			   http_img_pack('auteur-0minirezo-16.png', '', " width='16' height='16'", _T('image_administrer_rubrique'))) .
			  " <a dir='$lang_dir' href='" .
			  generer_url_entite($id_rubrique,'rubrique') .
			  "'>".
				$rang . $titre .
			  "</a>";

			$titre = (is_string($logo) ? $logo : '') .
				bouton_block_depliable($lib_bouton,$les_sous_enfants ?false:-1,"enfants$id_rubrique");

			$res[] =
			  debut_cadre_sous_rub(($id_parent ? "rubrique-24.png" : "secteur-24.png"), true, "", $titre) .
			  (!$descriptif ? '' : "\n<div class='descriptif'>$descriptif</div>") .
			  $les_sous_enfants .
			  fin_cadre_sous_rub(true);
		}
	}

	changer_typo($GLOBALS['spip_lang']); # remettre la typo de l'interface pour la suite
	return $res;
}

/**
 * Affiche les enfants d'une sous rubrique dans un bloc dépliable
 * (Utilisé dans les pages du privé)
 * 
 * @param int $collection2
 * 	L'identifiant numérique de la rubrique parente
 * @return string
 * 	Le contenu du bloc dépliable 
 */
function sous_enfant_rub($collection2){
	$nb = sql_countsel('spip_rubriques',"id_parent=$collection2");
	
	$retour = '';
	$pagination = '';
	$debut = 0;
	$limite = 500;
	
	/**
	 * On ne va afficher que 500 résultats max
	 * Si > 500 on affiche une pagination
	 */
	if($nb > $limite){
		$debut = _request('debut_rubrique'.$collection2) ? _request('debut_rubrique'.$collection2) : $debut;
		$pagination = chercher_filtre('pagination');
		$pagination = '<p class="pagination">'.$pagination($nb, '_rubrique'.$collection2, $debut, $limite, true, 'prive').'</p>';
		$limite = $debut + $limite;
	}
	
	$result =  sql_select("id_rubrique, id_parent, titre, lang", "spip_rubriques", "id_parent=$collection2",'', '0+titre,titre',"$debut,$limite");
	
	while($row=sql_fetch($result)){
		$id_rubrique2=$row['id_rubrique'];
		$id_parent2=$row['id_parent'];
		$titre2=generer_info_entite($id_rubrique2,'rubrique','titre'); // pour etre sur de passer par tous les traitements
		if ('' !== ($rang2 = recuperer_numero($row['titre'])))
			$rang2 = "$rang2. ";

		changer_typo($row['lang']);
		$lang_dir = lang_dir($row['lang']);
		if (autoriser('voir','rubrique',$id_rubrique2))
			$retour.="\n<li class='item' dir='$lang_dir'><a href='" . generer_url_entite($id_rubrique2,'rubrique') . "'>".$rang2.$titre2."</a></li>\n";
	}
	
	$retour = $pagination.$retour.$pagination;
	 
	if (!$retour) return '';
	
	return debut_block_depliable($debut > 0 ? true : false,"enfants$collection2")
	."\n<ul class='liste-items sous-sous-rub'>\n"
	. $retour
	. "</ul>\n".fin_block()."\n\n";
}

/**
 * Affiche la liste des rubriques enfants d'une rubrique
 * (Utilisé dans les pages du privé notamment ?exec=rubriques)
 * 
 * Si plus de 500 rubriques enfants, on pagine par 500 les résultats
 * 
 * @param int $id_rubrique
 * 	L'identifiant numérique de la rubrique parente (0 par défaut, la racine)
 * @return string $res
 * 	Le contenu textuel affiché, la liste des sous rubriques
 */
function afficher_enfant_rub($id_rubrique=0) {
	$pagination = '';
	$debut = 0;
	$limite = 500;

	$nb = sql_countsel('spip_rubriques',"id_parent=$id_rubrique");
	
	if($nb > $limite){
		$debut = _request('debut_rubrique'.$collection2) ? _request('debut_rubrique'.$collection2) : $debut;
		$pagination = chercher_filtre('pagination');
		$pagination = '<br class="nettoyeur"><p class="pagination">'.$pagination($nb, '_rubrique'.$collection2, $debut, $limite, true, 'prive').'</p>';
	}

	$les_enfants = enfant_rub($id_rubrique,$debut,$limite);

	if (!$n = count($les_enfants)) return "";

	if ($n==1) {
		$les_enfants=reset($les_enfants);
		$les_enfants2="";
	}
	else{
		$n = ceil($n/2);
		$les_enfants2 = implode('',array_slice($les_enfants,$n));
		$les_enfants = implode('',array_slice($les_enfants,0,$n));
	}
	
	$res =
	$pagination
	. "<div class='gauche'>"
	. $les_enfants
	. "</div>"
	. "<div class='droite'>"
	. $les_enfants2
	. "</div>"
	. $pagination;

	return $res;
}

?>
