/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class ConnectionTool
extends AbstractTool {
    private Connector myStartConnector;
    private Connector myEndConnector;
    private Connector myTargetConnector;
    private Figure myTarget;
    private ConnectionFigure myConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection;
    private Figure myAddedFigure;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor drawingEditor, ConnectionFigure connectionFigure) {
        super(drawingEditor);
        this.fPrototype = connectionFigure;
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        this.trackConnectors(mouseEvent, n, n2);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        ConnectionFigure connectionFigure = this.findConnection(n3, n4, this.drawing());
        if (connectionFigure != null) {
            if (!connectionFigure.joinSegments(n3, n4)) {
                this.fSplitPoint = connectionFigure.splitSegment(n3, n4);
                this.fEditedConnection = connectionFigure;
            } else {
                this.fEditedConnection = null;
            }
        } else {
            this.setTargetFigure(this.findConnectionStart(n3, n4, this.drawing()));
            if (this.getTargetFigure() != null) {
                this.setStartConnector(this.findConnector(n3, n4, this.getTargetFigure()));
                if (this.getStartConnector() != null) {
                    this.setConnection(this.createConnection());
                    this.getConnection().startPoint(n3, n4);
                    this.getConnection().endPoint(n3, n4);
                    this.setAddedFigure(this.view().add(this.getConnection()));
                }
            }
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.getConnection() != null) {
            this.trackConnectors(mouseEvent, n, n2);
            if (this.getTargetConnector() != null) {
                point = Geom.center(this.getTargetConnector().displayBox());
            }
            this.getConnection().endPoint(point.x, point.y);
        } else if (this.fEditedConnection != null) {
            Point point2 = new Point(n, n2);
            this.fEditedConnection.setPointAt(point2, this.fSplitPoint);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = null;
        if (this.getStartConnector() != null) {
            figure = this.findTarget(mouseEvent.getX(), mouseEvent.getY(), this.drawing());
        }
        if (figure != null) {
            this.setEndConnector(this.findConnector(mouseEvent.getX(), mouseEvent.getY(), figure));
            if (this.getEndConnector() != null) {
                this.getConnection().connectStart(this.getStartConnector());
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().updateConnection();
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
            }
        } else if (this.getConnection() != null) {
            this.view().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setAddedFigure(null);
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int n, int n2, Drawing drawing) {
        return this.findConnectableFigure(n, n2, drawing);
    }

    protected Figure findTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        Figure figure2 = this.getStartConnector().owner();
        if (figure != null && this.getConnection() != null && figure.canConnect() && !figure.includes(figure2) && this.getConnection().canConnect(figure2, figure)) {
            return figure;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if ((figure = figure.findFigureInside(n, n2)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.myConnection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected void trackConnectors(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = null;
        figure = this.getStartConnector() == null ? this.findSource(n, n2, this.getActiveDrawing()) : this.findTarget(n, n2, this.getActiveDrawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        Connector connector = null;
        if (figure != null) {
            connector = this.findConnector(mouseEvent.getX(), mouseEvent.getY(), figure);
        }
        if (connector != this.getTargetConnector()) {
            this.setTargetConnector(connector);
        }
        this.getActiveView().checkDamage();
    }

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    protected Figure findConnectionStart(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect()) {
            return figure;
        }
        return null;
    }

    protected Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected void setStartConnector(Connector connector) {
        this.myStartConnector = connector;
    }

    protected Connector getStartConnector() {
        return this.myStartConnector;
    }

    protected void setEndConnector(Connector connector) {
        this.myEndConnector = connector;
    }

    protected Connector getEndConnector() {
        return this.myEndConnector;
    }

    protected void setTargetConnector(Connector connector) {
        this.myTargetConnector = connector;
    }

    protected Connector getTargetConnector() {
        return this.myTargetConnector;
    }

    protected void setTargetFigure(Figure figure) {
        this.myTarget = figure;
    }

    protected Figure getTargetFigure() {
        return this.myTarget;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    protected void setAddedFigure(Figure figure) {
        this.myAddedFigure = figure;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getConnection());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private ConnectionFigure myConnection;
        private Connector myStartConnector;
        private Connector myEndConnector;

        public UndoActivity(DrawingView drawingView, ConnectionFigure connectionFigure) {
            super(drawingView);
            this.setConnection(connectionFigure);
            this.myStartConnector = this.getConnection().getStartConnector();
            this.myEndConnector = this.getConnection().getEndConnector();
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getConnection().disconnectStart();
            this.getConnection().disconnectEnd();
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                this.getDrawingView().drawing().orphan(figureEnumeration.nextFigure());
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getConnection().connectStart(this.myStartConnector);
            this.getConnection().connectEnd(this.myEndConnector);
            this.getConnection().updateConnection();
            this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false);
            return true;
        }

        protected void setConnection(ConnectionFigure connectionFigure) {
            this.myConnection = connectionFigure;
        }

        protected ConnectionFigure getConnection() {
            return this.myConnection;
        }
    }
}

