/* panel.c generated by valac 0.40.8, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2018 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <locale.h>
#include <float.h>
#include <math.h>
#include <libnotify/notify.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define PANEL_TYPE_ICON_TYPE (panel_icon_type_get_type ())

#define TYPE_INDICATOR (indicator_get_type ())
#define INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR, Indicator))
#define INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR, IndicatorClass))
#define IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR))
#define IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR))
#define INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR, IndicatorClass))

typedef struct _Indicator Indicator;
typedef struct _IndicatorClass IndicatorClass;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;

#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;

#define BINDING_COMMON_TYPE_KEYBINDING (binding_common_keybinding_get_type ())
#define BINDING_COMMON_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding))
#define BINDING_COMMON_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))
#define BINDING_COMMON_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))

typedef struct _BindingCommonKeybinding BindingCommonKeybinding;
typedef struct _BindingCommonKeybindingClass BindingCommonKeybindingClass;
enum  {
	PANEL_0_PROPERTY,
	PANEL_NUM_PROPERTIES
};
static GParamSpec* panel_properties[PANEL_NUM_PROPERTIES];

#define BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE (binding_common_key_event_func_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define _xkb_layout_unref0(var) ((var == NULL) ? NULL : (var = (xkb_layout_unref (var), NULL)))

#define INDICATOR_TYPE_CATEGORY (indicator_category_get_type ())

#define INDICATOR_TYPE_STATUS (indicator_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

typedef enum  {
	PANEL_ICON_TYPE_STATUS_ICON,
	PANEL_ICON_TYPE_INDICATOR
} PanelIconType;

struct _PanelPrivate {
	IBusBus* m_bus;
	GSettings* m_settings_general;
	GSettings* m_settings_hotkey;
	GSettings* m_settings_panel;
	PanelIconType m_icon_type;
	Indicator* m_indicator;
	GDBusConnection* m_session_bus_connection;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	GHashTable* m_engine_contexts;
	gchar* m_current_context_path;
	gchar* m_real_current_context_path;
	gboolean m_use_global_engine;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	guint m_switcher_focus_set_engine_id;
	PropertyManager* m_property_manager;
	PropertyPanel* m_property_panel;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	gboolean m_use_system_keyboard_layout;
	GHashTable* m_xkb_icon_pixbufs;
	GHashTable* m_xkb_icon_image;
	GdkRGBA m_xkb_icon_rgba;
	XKBLayout* m_xkblayout;
	gboolean inited_engines_order;
	guint m_preload_engines_id;
	gchar* m_icon_prop_key;
	gint m_property_icon_delay_time;
	guint m_property_icon_delay_time_id;
	gboolean m_is_kde;
	gulong m_popup_menu_id;
	gulong m_activate_id;
	gulong m_registered_status_notifier_item_id;
	GList* m_keybindings;
};

typedef enum  {
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING
} BindingCommonKeyEventFuncType;

typedef enum  {
	INDICATOR_CATEGORY_APPLICATION_STATUS,
	INDICATOR_CATEGORY_COMMUNICATIONS,
	INDICATOR_CATEGORY_SYSTEM_SERVICES,
	INDICATOR_CATEGORY_HARDWARE,
	INDICATOR_CATEGORY_OTHER
} IndicatorCategory;

typedef enum  {
	INDICATOR_STATUS_PASSIVE,
	INDICATOR_STATUS_ACTIVE,
	INDICATOR_STATUS_ATTENTION
} IndicatorStatus;

struct _Block6Data {
	int _ref_count_;
	Panel* self;
	GdkRectangle area;
	GdkWindow* window;
	GtkMenuPositionFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, gpointer user_data);
struct _Block7Data {
	int _ref_count_;
	Panel* self;
	gchar** names;
	gint names_length1;
	gint _names_size_;
};

struct _Block8Data {
	int _ref_count_;
	Panel* self;
	IBusEngineDesc* e;
};

struct _Block9Data {
	int _ref_count_;
	Panel* self;
	gchar* symbol;
};


static gpointer panel_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
static GType panel_icon_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType indicator_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_property_manager (GValue* value,
                                 gpointer v_object);
void value_take_property_manager (GValue* value,
                                  gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
GType property_panel_get_type (void) G_GNUC_CONST;
gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_xkb_layout (GValue* value,
                           gpointer v_object);
void value_take_xkb_layout (GValue* value,
                            gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
GType binding_common_keybinding_get_type (void) G_GNUC_CONST;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
void indicator_unregister_connection (Indicator* self);
GType binding_common_key_event_func_type_get_type (void) G_GNUC_CONST;
void binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                            GList* keybindings);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _cairo_surface_destroy0_ (gpointer var);
XKBLayout* xkb_layout_new (void);
XKBLayout* xkb_layout_construct (GType object_type);
static gboolean panel_is_kde (void);
#define PANEL_PRELOAD_ENGINES_DELAY_TIME ((guint) 30000)
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type,
                        IBusBus* bus);
static void panel_init_settings (Panel* self);
static void panel_init_indicator (Panel* self);
static void panel_init_status_icon (Panel* self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda86_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda86__candidate_panel_page_up (CandidatePanel* _sender,
                                           gpointer self);
static void __lambda87_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda87__candidate_panel_page_down (CandidatePanel* _sender,
                                             gpointer self);
static void __lambda88_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda88__candidate_panel_cursor_up (CandidatePanel* _sender,
                                             gpointer self);
static void __lambda89_ (Panel* self,
                  CandidatePanel* w);
static void ___lambda89__candidate_panel_cursor_down (CandidatePanel* _sender,
                                               gpointer self);
static void __lambda90_ (Panel* self,
                  CandidatePanel* w,
                  guint i,
                  guint b,
                  guint s);
static void ___lambda90__candidate_panel_candidate_clicked (CandidatePanel* _sender,
                                                     guint index,
                                                     guint button,
                                                     guint state,
                                                     gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
static void panel_bind_switch_shortcut (Panel* self);
void switcher_set_popup_delay_time (Switcher* self,
                                    guint popup_delay_time);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda91_ (Panel* self,
                  PropertyManager* w,
                  const gchar* k,
                  gint s);
static void ___lambda91__property_manager_property_activate (PropertyManager* _sender,
                                                      const gchar* key,
                                                      gint state,
                                                      gpointer self);
PropertyPanel* property_panel_new (void);
PropertyPanel* property_panel_construct (GType object_type);
static void __lambda92_ (Panel* self,
                  PropertyPanel* w,
                  const gchar* k,
                  gint s);
static void ___lambda92__property_panel_property_activate (PropertyPanel* _sender,
                                                    const gchar* key,
                                                    gint state,
                                                    gpointer self);
static void __lambda32_ (Panel* self,
                  const gchar* key);
static void panel_update_engines (Panel* self,
                           gchar** unowned_engine_names,
                           int unowned_engine_names_length1,
                           gchar** order_names,
                           int order_names_length1);
static void ___lambda32__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda34_ (Panel* self,
                  const gchar* key);
static void panel_set_switcher_delay_time (Panel* self);
static void ___lambda34__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda35_ (Panel* self,
                  const gchar* key);
static void panel_set_use_system_keyboard_layout (Panel* self);
static void ___lambda35__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda36_ (Panel* self,
                  const gchar* key);
static void panel_set_embed_preedit_text (Panel* self);
static void ___lambda36__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda37_ (Panel* self,
                  const gchar* key);
static void panel_set_use_global_engine (Panel* self);
static void ___lambda37__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda38_ (Panel* self,
                  const gchar* key);
static void panel_set_use_xmodmap (Panel* self);
static void ___lambda38__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda39_ (Panel* self,
                  const gchar* key);
static void ___lambda39__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda64_ (Panel* self,
                  const gchar* key);
void binding_common_set_custom_font (GSettings* settings_panel,
                                     GSettings* settings_emoji,
                                     GtkCssProvider* * css_provider);
static void ___lambda64__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda65_ (Panel* self,
                  const gchar* key);
static void ___lambda65__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda66_ (Panel* self,
                  const gchar* key);
static void panel_set_show_icon_on_systray (Panel* self);
static void ___lambda66__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda67_ (Panel* self,
                  const gchar* key);
static void panel_set_lookup_table_orientation (Panel* self);
static void ___lambda67__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda68_ (Panel* self,
                  const gchar* key);
static void panel_set_show_property_panel (Panel* self);
static void ___lambda68__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda69_ (Panel* self,
                  const gchar* key);
static void panel_set_timeout_property_panel (Panel* self);
static void ___lambda69__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda70_ (Panel* self,
                  const gchar* key);
static void panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self);
static void ___lambda70__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda71_ (Panel* self,
                  const gchar* key);
static void panel_set_xkb_icon_rgba (Panel* self);
static void ___lambda71__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda72_ (Panel* self,
                  const gchar* key);
static void panel_set_property_icon_delay_time (Panel* self);
static void ___lambda72__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void panel_popup_menu_at_area_window (Panel* self,
                                      GtkMenu* menu,
                                      GdkRectangle* area,
                                      GdkWindow* window,
                                      GtkMenuPositionFunc func,
                                      gpointer func_target);
static void panel_popup_menu_at_pointer_window (Panel* self,
                                         GtkMenu* menu,
                                         gint x,
                                         gint y,
                                         GdkWindow* window,
                                         GtkMenuPositionFunc func,
                                         gpointer func_target);
static void __lambda73_ (Panel* self,
                  GObject* obj,
                  GAsyncResult* res);
GType indicator_category_get_type (void) G_GNUC_CONST;
Indicator* indicator_new (const gchar* id,
                          GDBusConnection* connection,
                          IndicatorCategory category);
Indicator* indicator_construct (GType object_type,
                                const gchar* id,
                                GDBusConnection* connection,
                                IndicatorCategory category);
void indicator_set_title (Indicator* self,
                          const gchar* value);
static void ___lambda74_ (Panel* self);
GType indicator_status_get_type (void) G_GNUC_CONST;
void indicator_set_status (Indicator* self,
                           IndicatorStatus status);
static void ____lambda74__indicator_registered_status_notifier_item (Indicator* _sender,
                                                              gpointer self);
static void ___lambda75_ (Panel* self,
                   gint x,
                   gint y,
                   GdkWindow* w,
                   guint b,
                   guint t);
static GtkMenu* panel_create_context_menu (Panel* self);
void indicator_position_context_menu (Indicator* self,
                                      GtkMenu* menu,
                                      gint* x,
                                      gint* y,
                                      gboolean* push_in);
static void _indicator_position_context_menu_gtk_menu_position_func (GtkMenu* menu,
                                                              gint* x,
                                                              gint* y,
                                                              gboolean* push_in,
                                                              gpointer self);
static void ____lambda75__indicator_context_menu (Indicator* _sender,
                                           gint x,
                                           gint y,
                                           GdkWindow* window,
                                           guint button,
                                           guint activate_time,
                                           gpointer self);
static void ___lambda82_ (Panel* self,
                   gint x,
                   gint y,
                   GdkWindow* w);
static GtkMenu* panel_create_activate_menu (Panel* self);
void indicator_position_activate_menu (Indicator* self,
                                       GtkMenu* menu,
                                       gint* x,
                                       gint* y,
                                       gboolean* push_in);
static void _indicator_position_activate_menu_gtk_menu_position_func (GtkMenu* menu,
                                                               gint* x,
                                                               gint* y,
                                                               gboolean* push_in,
                                                               gpointer self);
static void ____lambda82__indicator_activate (Indicator* _sender,
                                       gint x,
                                       gint y,
                                       GdkWindow* window,
                                       gpointer self);
static void ___lambda73__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void panel_init_status_icon_menu (Panel* self);
static void _panel_init_status_icon_menu_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda84_ (Block6Data* _data6_,
                  guint b,
                  guint t);
static void ___lambda84__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                              guint button,
                                              guint activate_time,
                                              gpointer self);
static void __lambda85_ (Block6Data* _data6_);
static void ___lambda85__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                            gpointer self);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
KeybindingManager* keybinding_manager_get_instance (void);
void binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                             GList* * keybindings,
                                             const gchar* accelerator,
                                             BindingCommonKeyEventFuncType ftype,
                                             KeybindingManagerKeybindingHandlerFunc handler_normal,
                                             gpointer handler_normal_target,
                                             KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                             gpointer handler_reverse_target);
static void panel_handle_engine_switch_normal (Panel* self,
                                        GdkEvent* event);
static void _panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                    gpointer self);
static void panel_handle_engine_switch_reverse (Panel* self,
                                         GdkEvent* event);
static void _panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                     gpointer self);
static GList* panel_get_engines_from_xkb (Panel* self,
                                   GList* engines);
void xkb_layout_get_layout (gchar* * layout,
                            gchar* * variant,
                            gchar* * option);
static GList* panel_get_engines_from_locale (Panel* self,
                                      GList* engines);
static gint __lambda93_ (IBusEngineDesc* a,
                  IBusEngineDesc* b);
static gint ___lambda93__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void panel_init_engines_order (Panel* self);
void xkb_layout_set_latin_layouts (XKBLayout* self,
                                   gchar** xkb_latin_layouts,
                                   int xkb_latin_layouts_length1);
static void _vala_array_add17 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void xkb_layout_set_use_xmodmap (XKBLayout* self,
                                 gboolean use_xmodmap);
void candidate_panel_set_vertical (CandidatePanel* self,
                                   gboolean vertical);
void property_panel_set_show (PropertyPanel* self,
                              gint _show);
void property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                           guint timeout);
void property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                               gboolean is_follow);
static gint panel_compare_versions (Panel* self,
                             const gchar* version1,
                             const gchar* version2);
static void panel_update_version_1_5_3 (Panel* self);
static void panel_update_version_1_5_8 (Panel* self);
static void panel_set_version (Panel* self);
void panel_load_settings (Panel* self);
void panel_disconnect_signals (Panel* self);
static void panel_engine_contexts_insert (Panel* self,
                                   IBusEngineDesc* engine);
static void panel_set_engine (Panel* self,
                       IBusEngineDesc* engine);
void xkb_layout_set_layout (XKBLayout* self,
                            IBusEngineDesc* engine);
static void panel_switch_engine (Panel* self,
                          gint i,
                          gboolean force);
static void panel_handle_engine_switch (Panel* self,
                                 GdkEvent* event,
                                 gboolean reverse);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event,
                                                            guint primary_modifier);
gint switcher_run (Switcher* self,
                   guint keyval,
                   guint state,
                   GdkEvent* event,
                   IBusEngineDesc** engines,
                   int engines_length1,
                   gint index,
                   const gchar* input_context_path);
static void panel_switcher_focus_set_engine (Panel* self);
static void panel_run_preload_engines (Panel* self,
                                IBusEngineDesc** engines,
                                int engines_length1,
                                gint index);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _vala_array_add19 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static gboolean __lambda33_ (Block7Data* _data7_);
static gboolean ___lambda33__gsource_func (gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          int length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
static void _vala_array_add20 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self,
                                   int length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self,
                                   int length);
static void panel_context_render_string (Panel* self,
                                  cairo_t* cr,
                                  const gchar* symbol,
                                  gint image_width,
                                  gint image_height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static cairo_surface_t* panel_create_cairo_image_surface_with_string (Panel* self,
                                                               const gchar* symbol,
                                                               gboolean cache);
static GdkPixbuf* panel_create_icon_pixbuf_with_string (Panel* self,
                                                 const gchar* symbol);
static void panel_show_setup_dialog (Panel* self);
static void __lambda77_ (Panel* self,
                  GPid pid,
                  gint state);
static void ___lambda77__gchild_watch_func (GPid pid,
                                     gint status,
                                     gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda76_ (Panel* self,
                   GtkMenuItem* i);
static void ____lambda76__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda78_ (Panel* self,
                   GtkMenuItem* i);
static void ____lambda78__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda79_ (Panel* self,
                   GtkMenuItem* i);
static void ____lambda79__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda80_ (Panel* self,
                   GtkMenuItem* i);
static void ____lambda80__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda81_ (Panel* self,
                   GtkMenuItem* i);
static void ____lambda81__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
gint property_manager_create_menu_items (PropertyManager* self,
                                         GtkMenu* menu);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ____lambda83_ (Block8Data* _data8_,
                    GtkMenuItem* item);
static void _____lambda83__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void panel_set_properties (Panel* self,
                           IBusPropList* props);
static void panel_set_property (Panel* self,
                         IBusProperty* prop,
                         gboolean all_update);
static void panel_animate_icon (Panel* self,
                         const gchar* symbol,
                         gboolean all_update);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean __lambda94_ (Block9Data* _data9_);
void indicator_set_cairo_image_surface_full (Indicator* self,
                                             cairo_surface_t* image,
                                             const gchar* icon_desc);
static gboolean ___lambda94__gsource_func (gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self,
                                          gint x,
                                          gint y,
                                          gint width,
                                          gint height);
void property_panel_set_cursor_location (PropertyPanel* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height);
static gboolean panel_switcher_focus_set_engine_real (Panel* self);
IBusEngineDesc* switcher_get_selected_engine (Switcher* self);
gchar* switcher_get_input_context_path (Switcher* self);
void switcher_reset (Switcher* self);
gboolean switcher_is_running (Switcher* self);
static gboolean ___lambda63_ (Panel* self);
static gboolean ____lambda63__gsource_func (gpointer self);
static void panel_real_focus_in (IBusPanelService* base,
                          const gchar* input_context_path);
void property_panel_focus_in (PropertyPanel* self);
static void panel_real_focus_out (IBusPanelService* base,
                           const gchar* input_context_path);
static void panel_real_destroy_context (IBusPanelService* base,
                                 const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base,
                                     IBusPropList* props);
void property_manager_set_properties (PropertyManager* self,
                                      IBusPropList* props);
void property_panel_set_properties (PropertyPanel* self,
                                    IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base,
                                 IBusProperty* prop);
void property_manager_update_property (PropertyManager* self,
                                       IBusProperty* prop);
void property_panel_update_property (PropertyPanel* self,
                                     IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base,
                                     IBusText* text,
                                     guint cursor_pos,
                                     gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self,
                                       IBusText* text,
                                       guint cursor);
void property_panel_set_preedit_text (PropertyPanel* self,
                                      IBusText* text,
                                      guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base,
                                       IBusText* text,
                                       gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self,
                                         IBusText* text);
void property_panel_set_auxiliary_text (PropertyPanel* self,
                                        IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base,
                                     IBusLookupTable* table,
                                     gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self,
                                       IBusLookupTable* table);
void property_panel_set_lookup_table (PropertyPanel* self,
                                      IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_set_content_type (IBusPanelService* base,
                                  guint purpose,
                                  guint hints);
void candidate_panel_set_content_type (CandidatePanel* self,
                                       guint purpose,
                                       guint hints);
static void panel_real_state_changed (IBusPanelService* base);
void indicator_set_icon_full (Indicator* self,
                              const gchar* icon_name,
                              const gchar* icon_desc);
gchar* switcher_get_xkb_language (Switcher* self,
                                  IBusEngineDesc* engine);
static void _vala_array_add22 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void panel_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static GType
panel_icon_type_get_type (void)
{
	static volatile gsize panel_icon_type_type_id__volatile = 0;
	if (g_once_init_enter (&panel_icon_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PANEL_ICON_TYPE_STATUS_ICON, "PANEL_ICON_TYPE_STATUS_ICON", "status-icon"}, {PANEL_ICON_TYPE_INDICATOR, "PANEL_ICON_TYPE_INDICATOR", "indicator"}, {0, NULL, NULL}};
		GType panel_icon_type_type_id;
		panel_icon_type_type_id = g_enum_register_static ("PanelIconType", values);
		g_once_init_leave (&panel_icon_type_type_id__volatile, panel_icon_type_type_id);
	}
	return panel_icon_type_type_id__volatile;
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
_cairo_surface_destroy0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL));
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda86_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void
___lambda86__candidate_panel_page_up (CandidatePanel* _sender,
                                      gpointer self)
{
	__lambda86_ ((Panel*) self, _sender);
}


static void
__lambda87_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void
___lambda87__candidate_panel_page_down (CandidatePanel* _sender,
                                        gpointer self)
{
	__lambda87_ ((Panel*) self, _sender);
}


static void
__lambda88_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_up ((IBusPanelService*) self);
}


static void
___lambda88__candidate_panel_cursor_up (CandidatePanel* _sender,
                                        gpointer self)
{
	__lambda88_ ((Panel*) self, _sender);
}


static void
__lambda89_ (Panel* self,
             CandidatePanel* w)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_down ((IBusPanelService*) self);
}


static void
___lambda89__candidate_panel_cursor_down (CandidatePanel* _sender,
                                          gpointer self)
{
	__lambda89_ ((Panel*) self, _sender);
}


static void
__lambda90_ (Panel* self,
             CandidatePanel* w,
             guint i,
             guint b,
             guint s)
{
	g_return_if_fail (w != NULL);
	ibus_panel_service_candidate_clicked ((IBusPanelService*) self, i, b, s);
}


static void
___lambda90__candidate_panel_candidate_clicked (CandidatePanel* _sender,
                                                guint index,
                                                guint button,
                                                guint state,
                                                gpointer self)
{
	__lambda90_ ((Panel*) self, _sender, index, button, state);
}


static void
__lambda91_ (Panel* self,
             PropertyManager* w,
             const gchar* k,
             gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	ibus_panel_service_property_activate ((IBusPanelService*) self, k, (guint) s);
}


static void
___lambda91__property_manager_property_activate (PropertyManager* _sender,
                                                 const gchar* key,
                                                 gint state,
                                                 gpointer self)
{
	__lambda91_ ((Panel*) self, _sender, key, state);
}


static void
__lambda92_ (Panel* self,
             PropertyPanel* w,
             const gchar* k,
             gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	ibus_panel_service_property_activate ((IBusPanelService*) self, k, (guint) s);
}


static void
___lambda92__property_panel_property_activate (PropertyPanel* _sender,
                                               const gchar* key,
                                               gint state,
                                               gpointer self)
{
	__lambda92_ ((Panel*) self, _sender, key, state);
}


Panel*
panel_construct (GType object_type,
                 IBusBus* bus)
{
	Panel * self = NULL;
	GDBusConnection* _tmp0_;
	IBusBus* _tmp1_;
	gboolean _tmp2_;
	CandidatePanel* _tmp3_;
	CandidatePanel* _tmp4_;
	CandidatePanel* _tmp5_;
	CandidatePanel* _tmp6_;
	CandidatePanel* _tmp7_;
	CandidatePanel* _tmp8_;
	Switcher* _tmp9_;
	gint _tmp10_;
	PropertyManager* _tmp13_;
	PropertyManager* _tmp14_;
	PropertyPanel* _tmp15_;
	PropertyPanel* _tmp16_;
	g_return_val_if_fail (bus != NULL, NULL);
	_vala_assert (ibus_bus_is_connected (bus), "bus.is_connected()");
	_tmp0_ = ibus_bus_get_connection (bus);
	self = (Panel*) g_object_new (object_type, "connection", _tmp0_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp1_ = _g_object_ref0 (bus);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp1_;
	panel_init_settings (self);
	_tmp2_ = self->priv->m_is_kde;
	if (_tmp2_) {
		panel_init_indicator (self);
	} else {
		panel_init_status_icon (self);
	}
	_tmp3_ = candidate_panel_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp3_;
	_tmp4_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp4_, "page-up", (GCallback) ___lambda86__candidate_panel_page_up, self, 0);
	_tmp5_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp5_, "page-down", (GCallback) ___lambda87__candidate_panel_page_down, self, 0);
	_tmp6_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp6_, "cursor-up", (GCallback) ___lambda88__candidate_panel_cursor_up, self, 0);
	_tmp7_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp7_, "cursor-down", (GCallback) ___lambda89__candidate_panel_cursor_down, self, 0);
	_tmp8_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp8_, "candidate-clicked", (GCallback) ___lambda90__candidate_panel_candidate_clicked, self, 0);
	_tmp9_ = switcher_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp9_;
	panel_bind_switch_shortcut (self);
	_tmp10_ = self->priv->m_switcher_delay_time;
	if (_tmp10_ >= 0) {
		Switcher* _tmp11_;
		gint _tmp12_;
		_tmp11_ = self->priv->m_switcher;
		_tmp12_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp11_, (guint) _tmp12_);
	}
	_tmp13_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp13_;
	_tmp14_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp14_, "property-activate", (GCallback) ___lambda91__property_manager_property_activate, self, 0);
	_tmp15_ = property_panel_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->m_property_panel);
	self->priv->m_property_panel = _tmp15_;
	_tmp16_ = self->priv->m_property_panel;
	g_signal_connect_object (_tmp16_, "property-activate", (GCallback) ___lambda92__property_panel_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel*
panel_new (IBusBus* bus)
{
	return panel_construct (TYPE_PANEL, bus);
}


static void
__lambda32_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, key);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	panel_update_engines (self, _tmp3_, _vala_array_length (_tmp1_), NULL, 0);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}


static void
___lambda32__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda32_ ((Panel*) self, key);
}


static void
__lambda34_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_switcher_delay_time (self);
}


static void
___lambda34__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda34_ ((Panel*) self, key);
}


static void
__lambda35_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_system_keyboard_layout (self);
}


static void
___lambda35__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda35_ ((Panel*) self, key);
}


static void
__lambda36_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_embed_preedit_text (self);
}


static void
___lambda36__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda36_ ((Panel*) self, key);
}


static void
__lambda37_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_global_engine (self);
}


static void
___lambda37__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda37_ ((Panel*) self, key);
}


static void
__lambda38_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_use_xmodmap (self);
}


static void
___lambda38__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda38_ ((Panel*) self, key);
}


static void
__lambda39_ (Panel* self,
             const gchar* key)
{
	GList* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, _tmp0_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	panel_bind_switch_shortcut (self);
}


static void
___lambda39__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda39_ ((Panel*) self, key);
}


static void
__lambda64_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp0_, NULL, &self->priv->m_css_provider);
}


static void
___lambda64__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda64_ ((Panel*) self, key);
}


static void
__lambda65_ (Panel* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp0_, NULL, &self->priv->m_css_provider);
}


static void
___lambda65__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda65_ ((Panel*) self, key);
}


static void
__lambda66_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_show_icon_on_systray (self);
}


static void
___lambda66__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda66_ ((Panel*) self, key);
}


static void
__lambda67_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_lookup_table_orientation (self);
}


static void
___lambda67__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda67_ ((Panel*) self, key);
}


static void
__lambda68_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_show_property_panel (self);
}


static void
___lambda68__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda68_ ((Panel*) self, key);
}


static void
__lambda69_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_timeout_property_panel (self);
}


static void
___lambda69__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda69_ ((Panel*) self, key);
}


static void
__lambda70_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
}


static void
___lambda70__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda70_ ((Panel*) self, key);
}


static void
__lambda71_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_xkb_icon_rgba (self);
}


static void
___lambda71__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda71_ ((Panel*) self, key);
}


static void
__lambda72_ (Panel* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_set_property_icon_delay_time (self);
}


static void
___lambda72__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda72_ ((Panel*) self, key);
}


static void
panel_init_settings (Panel* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.general");
	_g_object_unref0 (self->priv->m_settings_general);
	self->priv->m_settings_general = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.general.hotkey");
	_g_object_unref0 (self->priv->m_settings_hotkey);
	self->priv->m_settings_hotkey = _tmp1_;
	_tmp2_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp2_;
	_tmp3_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp3_, "changed::preload-engines", (GCallback) ___lambda32__g_settings_changed, self, 0);
	_tmp4_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp4_, "changed::switcher-delay-time", (GCallback) ___lambda34__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp5_, "changed::use-system-keyboard-layout", (GCallback) ___lambda35__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp6_, "changed::embed-preedit-text", (GCallback) ___lambda36__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp7_, "changed::use-global-engine", (GCallback) ___lambda37__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp8_, "changed::use-xmodmap", (GCallback) ___lambda38__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_hotkey;
	g_signal_connect_object (_tmp9_, "changed::triggers", (GCallback) ___lambda39__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp10_, "changed::custom-font", (GCallback) ___lambda64__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp11_, "changed::use-custom-font", (GCallback) ___lambda65__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp12_, "changed::show-icon-on-systray", (GCallback) ___lambda66__g_settings_changed, self, 0);
	_tmp13_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp13_, "changed::lookup-table-orientation", (GCallback) ___lambda67__g_settings_changed, self, 0);
	_tmp14_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp14_, "changed::show", (GCallback) ___lambda68__g_settings_changed, self, 0);
	_tmp15_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp15_, "changed::timeout", (GCallback) ___lambda69__g_settings_changed, self, 0);
	_tmp16_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp16_, "changed::follow-input-cursor-when-always-shown", (GCallback) ___lambda70__g_settings_changed, self, 0);
	_tmp17_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp17_, "changed::xkb-icon-rgba", (GCallback) ___lambda71__g_settings_changed, self, 0);
	_tmp18_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp18_, "changed::property-icon-delay-time", (GCallback) ___lambda72__g_settings_changed, self, 0);
}


static void
panel_popup_menu_at_area_window (Panel* self,
                                 GtkMenu* menu,
                                 GdkRectangle* area,
                                 GdkWindow* window,
                                 GtkMenuPositionFunc func,
                                 gpointer func_target)
{
	GdkGravity rect_anchor = 0;
	GdkGravity menu_anchor = 0;
	GdkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (area != NULL);
	rect_anchor = GDK_GRAVITY_SOUTH_WEST;
	menu_anchor = GDK_GRAVITY_NORTH_WEST;
	_tmp0_ = *area;
	gtk_menu_popup_at_rect (menu, window, &_tmp0_, rect_anchor, menu_anchor, NULL);
}


static gboolean
panel_is_kde (void)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	if (g_strcmp0 (_tmp0_, "KDE") == 0) {
		result = TRUE;
		return result;
	}
	g_warning ("panel.vala:255: %s", "If you launch KDE5 on xterm, " "export XDG_CURRENT_DESKTOP=KDE before launch KDE5.");
	result = FALSE;
	return result;
}


static void
panel_popup_menu_at_pointer_window (Panel* self,
                                    GtkMenu* menu,
                                    gint x,
                                    gint y,
                                    GdkWindow* window,
                                    GtkMenuPositionFunc func,
                                    gpointer func_target)
{
	gint win_x = 0;
	gint win_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkRectangle area = {0};
	gint _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	win_x = 0;
	win_y = 0;
	gdk_window_get_origin (window, &_tmp0_, &_tmp1_);
	win_x = _tmp0_;
	win_y = _tmp1_;
	_tmp2_ = win_x;
	_tmp3_ = win_y;
	_tmp4_.x = x - _tmp2_;
	_tmp4_.y = y - _tmp3_;
	_tmp4_.width = 1;
	_tmp4_.height = 1;
	area = _tmp4_;
	_tmp5_ = area;
	panel_popup_menu_at_area_window (self, menu, &_tmp5_, window, func, func_target);
}


static void
___lambda74_ (Panel* self)
{
	Indicator* _tmp0_;
	_tmp0_ = self->priv->m_indicator;
	indicator_set_status (_tmp0_, INDICATOR_STATUS_ACTIVE);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
}


static void
____lambda74__indicator_registered_status_notifier_item (Indicator* _sender,
                                                         gpointer self)
{
	___lambda74_ ((Panel*) self);
}


static void
_indicator_position_context_menu_gtk_menu_position_func (GtkMenu* menu,
                                                         gint* x,
                                                         gint* y,
                                                         gboolean* push_in,
                                                         gpointer self)
{
	indicator_position_context_menu ((Indicator*) self, menu, x, y, push_in);
}


static void
___lambda75_ (Panel* self,
              gint x,
              gint y,
              GdkWindow* w,
              guint b,
              guint t)
{
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	Indicator* _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = panel_create_context_menu (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->m_indicator;
	panel_popup_menu_at_pointer_window (self, _tmp1_, x, y, w, _indicator_position_context_menu_gtk_menu_position_func, _tmp2_);
	_g_object_unref0 (_tmp1_);
}


static void
____lambda75__indicator_context_menu (Indicator* _sender,
                                      gint x,
                                      gint y,
                                      GdkWindow* window,
                                      guint button,
                                      guint activate_time,
                                      gpointer self)
{
	___lambda75_ ((Panel*) self, x, y, window, button, activate_time);
}


static void
_indicator_position_activate_menu_gtk_menu_position_func (GtkMenu* menu,
                                                          gint* x,
                                                          gint* y,
                                                          gboolean* push_in,
                                                          gpointer self)
{
	indicator_position_activate_menu ((Indicator*) self, menu, x, y, push_in);
}


static void
___lambda82_ (Panel* self,
              gint x,
              gint y,
              GdkWindow* w)
{
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	Indicator* _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = panel_create_activate_menu (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->m_indicator;
	panel_popup_menu_at_pointer_window (self, _tmp1_, x, y, w, _indicator_position_activate_menu_gtk_menu_position_func, _tmp2_);
	_g_object_unref0 (_tmp1_);
}


static void
____lambda82__indicator_activate (Indicator* _sender,
                                  gint x,
                                  gint y,
                                  GdkWindow* window,
                                  gpointer self)
{
	___lambda82_ ((Panel*) self, x, y, window);
}


static void
__lambda73_ (Panel* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		GDBusConnection* _tmp3_;
		Indicator* _tmp4_;
		Indicator* _tmp5_;
		Indicator* _tmp6_;
		gulong _tmp7_;
		Indicator* _tmp8_;
		gulong _tmp9_;
		Indicator* _tmp10_;
		gulong _tmp11_;
		_tmp1_ = g_bus_get_finish (res, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch12_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->m_session_bus_connection);
		self->priv->m_session_bus_connection = _tmp2_;
		_tmp3_ = self->priv->m_session_bus_connection;
		_tmp4_ = indicator_new ("ibus-ui-gtk3", _tmp3_, INDICATOR_CATEGORY_APPLICATION_STATUS);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->m_indicator);
		self->priv->m_indicator = _tmp4_;
		_tmp5_ = self->priv->m_indicator;
		indicator_set_title (_tmp5_, _ ("IBus Panel"));
		_tmp6_ = self->priv->m_indicator;
		_tmp7_ = g_signal_connect_object (_tmp6_, "registered-status-notifier-item", (GCallback) ____lambda74__indicator_registered_status_notifier_item, self, 0);
		self->priv->m_registered_status_notifier_item_id = _tmp7_;
		_tmp8_ = self->priv->m_indicator;
		_tmp9_ = g_signal_connect_object (_tmp8_, "context-menu", (GCallback) ____lambda75__indicator_context_menu, self, 0);
		self->priv->m_popup_menu_id = _tmp9_;
		_tmp10_ = self->priv->m_indicator;
		_tmp11_ = g_signal_connect_object (_tmp10_, "activate", (GCallback) ____lambda82__indicator_activate, self, 0);
		self->priv->m_activate_id = _tmp11_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally12;
	__catch12_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("panel.vala:304: Failed to get the session bus: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda73__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda73_ ((Panel*) self, source_object, res);
	g_object_unref (self);
}


static void
panel_init_indicator (Panel* self)
{
	g_return_if_fail (self != NULL);
	self->priv->m_icon_type = PANEL_ICON_TYPE_INDICATOR;
	g_bus_get (G_BUS_TYPE_SESSION, NULL, ___lambda73__gasync_ready_callback, g_object_ref (self));
}


static void
_panel_init_status_icon_menu_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	panel_init_status_icon_menu ((Panel*) self);
}


static void
panel_init_status_icon (Panel* self)
{
	GtkStatusIcon* _tmp0_;
	GtkStatusIcon* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GtkStatusIcon* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp0_;
	_tmp1_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp1_, "ibus-ui-gtk");
	_tmp2_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp2_, _ ("IBus Panel"));
	_tmp3_ = self->priv->m_status_icon;
	if (gtk_status_icon_get_size (_tmp3_) > 0) {
		panel_init_status_icon_menu (self);
	} else {
		GtkStatusIcon* _tmp4_;
		_tmp4_ = self->priv->m_status_icon;
		g_signal_connect_object ((GObject*) _tmp4_, "notify::size", (GCallback) _panel_init_status_icon_menu_g_object_notify, self, 0);
	}
}


static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Panel* self;
		self = _data6_->self;
		(_data6_->func_target_destroy_notify == NULL) ? NULL : (_data6_->func_target_destroy_notify (_data6_->func_target), NULL);
		_data6_->func = NULL;
		_data6_->func_target = NULL;
		_data6_->func_target_destroy_notify = NULL;
		_g_object_unref0 (_data6_->window);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void
__lambda84_ (Block6Data* _data6_,
             guint b,
             guint t)
{
	Panel* self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GdkRectangle _tmp2_;
	GdkWindow* _tmp3_;
	GtkMenuPositionFunc _tmp4_;
	void* _tmp4__target;
	self = _data6_->self;
	_tmp0_ = panel_create_context_menu (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data6_->area;
	_tmp3_ = _data6_->window;
	_tmp4_ = _data6_->func;
	_tmp4__target = _data6_->func_target;
	panel_popup_menu_at_area_window (self, _tmp1_, &_tmp2_, _tmp3_, _tmp4_, _tmp4__target);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda84__gtk_status_icon_popup_menu (GtkStatusIcon* _sender,
                                         guint button,
                                         guint activate_time,
                                         gpointer self)
{
	__lambda84_ (self, button, activate_time);
}


static void
__lambda85_ (Block6Data* _data6_)
{
	Panel* self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GdkRectangle _tmp2_;
	GdkWindow* _tmp3_;
	GtkMenuPositionFunc _tmp4_;
	void* _tmp4__target;
	self = _data6_->self;
	_tmp0_ = panel_create_activate_menu (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data6_->area;
	_tmp3_ = _data6_->window;
	_tmp4_ = _data6_->func;
	_tmp4__target = _data6_->func_target;
	panel_popup_menu_at_area_window (self, _tmp1_, &_tmp2_, _tmp3_, _tmp4_, _tmp4__target);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda85__gtk_status_icon_activate (GtkStatusIcon* _sender,
                                       gpointer self)
{
	__lambda85_ (self);
}


static void
panel_init_status_icon_menu (Panel* self)
{
	Block6Data* _data6_;
	GdkRectangle _tmp0_ = {0};
	GdkDisplay* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GdkX11Window* _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
	GtkOrientation orient = 0;
	GtkStatusIcon* _tmp6_;
	GdkRectangle _tmp7_ = {0};
	GtkOrientation _tmp8_ = 0;
	gint win_x = 0;
	gint win_y = 0;
	GdkWindow* _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GtkStatusIcon* _tmp16_;
	gulong _tmp17_;
	GtkStatusIcon* _tmp18_;
	gulong _tmp19_;
	GtkStatusIcon* _tmp20_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	_data6_->area = _tmp0_;
	_data6_->window = NULL;
	_data6_->func = NULL;
	_data6_->func_target = NULL;
	_data6_->func_target_destroy_notify = NULL;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = self->priv->m_status_icon;
	_tmp3_ = gdk_x11_window_lookup_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp1_) : NULL, (Window) gtk_status_icon_get_x11_window_id (_tmp2_));
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_window_get_type ()) ? ((GdkWindow*) _tmp3_) : NULL);
	_g_object_unref0 (_data6_->window);
	_data6_->window = _tmp4_;
	_tmp5_ = _data6_->window;
	if (_tmp5_ == NULL) {
		g_warning ("panel.vala:331: StatusIcon does not have GdkWindow");
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_tmp6_ = self->priv->m_status_icon;
	gtk_status_icon_get_geometry (_tmp6_, NULL, &_tmp7_, &_tmp8_);
	_data6_->area = _tmp7_;
	orient = _tmp8_;
	win_x = 0;
	win_y = 0;
	_tmp9_ = _data6_->window;
	gdk_window_get_origin (_tmp9_, &_tmp10_, &_tmp11_);
	win_x = _tmp10_;
	win_y = _tmp11_;
	_tmp12_ = _data6_->area.x;
	_tmp13_ = win_x;
	_data6_->area.x = _tmp12_ - _tmp13_;
	_tmp14_ = _data6_->area.y;
	_tmp15_ = win_y;
	_data6_->area.y = _tmp14_ - _tmp15_;
	_tmp16_ = self->priv->m_status_icon;
	_tmp17_ = g_signal_connect_data (_tmp16_, "popup-menu", (GCallback) ___lambda84__gtk_status_icon_popup_menu, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	self->priv->m_popup_menu_id = _tmp17_;
	_tmp18_ = self->priv->m_status_icon;
	_tmp19_ = g_signal_connect_data (_tmp18_, "activate", (GCallback) ___lambda85__gtk_status_icon_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	self->priv->m_activate_id = _tmp19_;
	_tmp20_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp20_, "ibus-keyboard");
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void
_panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                               gpointer self)
{
	panel_handle_engine_switch_normal ((Panel*) self, event);
}


static void
_panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func (GdkEvent* event,
                                                                                gpointer self)
{
	panel_handle_engine_switch_reverse ((Panel*) self, event);
}


static void
panel_bind_switch_shortcut (Panel* self)
{
	gchar** accelerators = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint accelerators_length1;
	gint _accelerators_size_;
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_hotkey;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "triggers");
	accelerators = _tmp2_;
	accelerators_length1 = _vala_array_length (_tmp1_);
	_accelerators_size_ = accelerators_length1;
	_tmp3_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp3_;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < _tmp4__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				KeybindingManager* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = keybinding_manager;
				_tmp7_ = accelerator;
				binding_common_keybinding_manager_bind (_tmp6_, &self->priv->m_keybindings, _tmp7_, BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, _panel_handle_engine_switch_normal_keybinding_manager_keybinding_handler_func, self, _panel_handle_engine_switch_reverse_keybinding_manager_keybinding_handler_func, self);
				_g_free0 (accelerator);
			}
		}
	}
	_g_object_unref0 (keybinding_manager);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * panel_get_engines_from_xkb:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus xkb engines
     *
     * Made ibus engines from the current XKB keymaps.
     * This returns only XKB engines whose name start with "xkb:".
     */
static GList*
panel_get_engines_from_xkb (Panel* self,
                            GList* engines)
{
	GList* result = NULL;
	gchar* layouts = NULL;
	gchar* variants = NULL;
	gchar* option = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GList* xkb_engines = NULL;
	IBusEngineDesc* us_engine = NULL;
	IBusEngineDesc* _tmp3_;
	gchar** layout_array = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint layout_array_length1;
	gint _layout_array_size_;
	gchar** variant_array = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint variant_array_length1;
	gint _variant_array_size_;
	GList* _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	xkb_layout_get_layout (&_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (layouts);
	layouts = _tmp0_;
	_g_free0 (variants);
	variants = _tmp1_;
	_g_free0 (option);
	option = _tmp2_;
	xkb_engines = NULL;
	_tmp3_ = ibus_engine_desc_new ("xkb:us::eng", "", "", "", "", "", "", "");
	g_object_ref_sink (_tmp3_);
	us_engine = _tmp3_;
	_tmp4_ = layouts;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	layout_array = _tmp6_;
	layout_array_length1 = _vala_array_length (_tmp5_);
	_layout_array_size_ = layout_array_length1;
	_tmp7_ = variants;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ",", 0);
	variant_array = _tmp9_;
	variant_array_length1 = _vala_array_length (_tmp8_);
	_variant_array_size_ = variant_array_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* layout = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* variant = NULL;
				IBusEngineDesc* current_engine = NULL;
				gint _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp24_;
				IBusEngineDesc* _tmp39_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = layout_array;
				_tmp13__length1 = layout_array_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = layout_array;
				_tmp14__length1 = layout_array_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = g_strdup (_tmp16_);
				layout = _tmp17_;
				variant = NULL;
				current_engine = NULL;
				_tmp18_ = i;
				_tmp19_ = variant_array;
				_tmp19__length1 = variant_array_length1;
				if (_tmp18_ < _tmp19__length1) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = variant_array;
					_tmp20__length1 = variant_array_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (variant);
					variant = _tmp23_;
				}
				_tmp24_ = variant;
				if (_tmp24_ == NULL) {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("");
					_g_free0 (variant);
					variant = _tmp25_;
				}
				{
					GList* engine_collection = NULL;
					GList* engine_it = NULL;
					engine_collection = engines;
					for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
						IBusEngineDesc* engine = NULL;
						engine = (IBusEngineDesc*) engine_it->data;
						{
							gchar* name = NULL;
							IBusEngineDesc* _tmp26_;
							const gchar* _tmp27_;
							gchar* _tmp28_;
							const gchar* _tmp29_;
							gboolean _tmp30_ = FALSE;
							IBusEngineDesc* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							_tmp26_ = engine;
							_tmp27_ = ibus_engine_desc_get_name (_tmp26_);
							_tmp28_ = g_strdup (_tmp27_);
							name = _tmp28_;
							_tmp29_ = name;
							if (!g_str_has_prefix (_tmp29_, "xkb:")) {
								_g_free0 (name);
								continue;
							}
							_tmp31_ = engine;
							_tmp32_ = ibus_engine_desc_get_layout (_tmp31_);
							_tmp33_ = layout;
							if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
								IBusEngineDesc* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								_tmp34_ = engine;
								_tmp35_ = ibus_engine_desc_get_layout_variant (_tmp34_);
								_tmp36_ = variant;
								_tmp30_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
							} else {
								_tmp30_ = FALSE;
							}
							if (_tmp30_) {
								IBusEngineDesc* _tmp37_;
								IBusEngineDesc* _tmp38_;
								_tmp37_ = engine;
								_tmp38_ = _g_object_ref0 (_tmp37_);
								_g_object_unref0 (current_engine);
								current_engine = _tmp38_;
								_g_free0 (name);
								break;
							}
							_g_free0 (name);
						}
					}
				}
				_tmp39_ = current_engine;
				if (_tmp39_ != NULL) {
					IBusEngineDesc* _tmp40_;
					IBusEngineDesc* _tmp41_;
					_tmp40_ = current_engine;
					_tmp41_ = _g_object_ref0 (_tmp40_);
					xkb_engines = g_list_append (xkb_engines, _tmp41_);
				} else {
					GList* _tmp42_;
					IBusEngineDesc* _tmp43_;
					GList* _tmp44_;
					_tmp42_ = xkb_engines;
					_tmp43_ = us_engine;
					_tmp44_ = g_list_find (_tmp42_, _tmp43_);
					if (_tmp44_ == NULL) {
						const gchar* _tmp45_;
						const gchar* _tmp46_;
						IBusEngineDesc* _tmp47_;
						IBusEngineDesc* _tmp48_;
						_tmp45_ = layout;
						_tmp46_ = variant;
						g_warning ("panel.vala:449: Fallback %s(%s) to us layout.", _tmp45_, _tmp46_);
						_tmp47_ = us_engine;
						_tmp48_ = _g_object_ref0 (_tmp47_);
						xkb_engines = g_list_append (xkb_engines, _tmp48_);
					}
				}
				_g_object_unref0 (current_engine);
				_g_free0 (variant);
				_g_free0 (layout);
			}
		}
	}
	_tmp49_ = xkb_engines;
	if (g_list_length (_tmp49_) == ((guint) 0)) {
		g_warning ("panel.vala:455: Not found IBus XKB engines from the session.");
	}
	result = xkb_engines;
	variant_array = (_vala_array_free (variant_array, variant_array_length1, (GDestroyNotify) g_free), NULL);
	layout_array = (_vala_array_free (layout_array, layout_array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (us_engine);
	_g_free0 (option);
	_g_free0 (variants);
	_g_free0 (layouts);
	return result;
}


/**
     * panel_get_engines_from_locale:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus im engines
     *
     * Made ibus engines from the current locale and IBus.EngineDesc.lang .
     * This returns non-XKB engines whose name does not start "xkb:".
     */
static gint
__lambda93_ (IBusEngineDesc* a,
             IBusEngineDesc* b)
{
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = ((gint) ibus_engine_desc_get_rank (b)) - ((gint) ibus_engine_desc_get_rank (a));
	return result;
}


static gint
___lambda93__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda93_ ((IBusEngineDesc*) a, (IBusEngineDesc*) b);
	return result;
}


static GList*
panel_get_engines_from_locale (Panel* self,
                               GList* engines)
{
	GList* result = NULL;
	gchar* locale = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lang = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GList* im_engines = NULL;
	GList* _tmp22_;
	GList* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = setlocale (LC_CTYPE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("C");
		_g_free0 (locale);
		locale = _tmp3_;
	}
	_tmp4_ = locale;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ".", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	lang = _tmp10_;
	im_engines = NULL;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = engines;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar* name = NULL;
				IBusEngineDesc* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				IBusEngineDesc* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_name (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				name = _tmp13_;
				_tmp14_ = name;
				if (g_str_has_prefix (_tmp14_, "xkb:")) {
					_g_free0 (name);
					continue;
				}
				_tmp16_ = engine;
				_tmp17_ = ibus_engine_desc_get_language (_tmp16_);
				_tmp18_ = lang;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					IBusEngineDesc* _tmp19_;
					_tmp19_ = engine;
					_tmp15_ = ibus_engine_desc_get_rank (_tmp19_) > ((guint) 0);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					IBusEngineDesc* _tmp20_;
					IBusEngineDesc* _tmp21_;
					_tmp20_ = engine;
					_tmp21_ = _g_object_ref0 (_tmp20_);
					im_engines = g_list_append (im_engines, _tmp21_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp22_ = im_engines;
	if (g_list_length (_tmp22_) == ((guint) 0)) {
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp23_ = lang;
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "_", 0);
		_tmp26_ = _tmp25_;
		_tmp26__length1 = _vala_array_length (_tmp24_);
		_tmp27_ = _tmp26_[0];
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (lang);
		lang = _tmp28_;
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = engines;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					gchar* name = NULL;
					IBusEngineDesc* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					gboolean _tmp33_ = FALSE;
					IBusEngineDesc* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					_tmp29_ = engine;
					_tmp30_ = ibus_engine_desc_get_name (_tmp29_);
					_tmp31_ = g_strdup (_tmp30_);
					name = _tmp31_;
					_tmp32_ = name;
					if (g_str_has_prefix (_tmp32_, "xkb:")) {
						_g_free0 (name);
						continue;
					}
					_tmp34_ = engine;
					_tmp35_ = ibus_engine_desc_get_language (_tmp34_);
					_tmp36_ = lang;
					if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
						IBusEngineDesc* _tmp37_;
						_tmp37_ = engine;
						_tmp33_ = ibus_engine_desc_get_rank (_tmp37_) > ((guint) 0);
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						IBusEngineDesc* _tmp38_;
						IBusEngineDesc* _tmp39_;
						_tmp38_ = engine;
						_tmp39_ = _g_object_ref0 (_tmp38_);
						im_engines = g_list_append (im_engines, _tmp39_);
					}
					_g_free0 (name);
				}
			}
		}
	}
	_tmp40_ = im_engines;
	if (g_list_length (_tmp40_) == ((guint) 0)) {
		result = im_engines;
		_g_free0 (lang);
		_g_free0 (locale);
		return result;
	}
	im_engines = g_list_sort (im_engines, ___lambda93__gcompare_func);
	result = im_engines;
	_g_free0 (lang);
	_g_free0 (locale);
	return result;
}


static void
_vala_array_add17 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add18 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
panel_init_engines_order (Panel* self)
{
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	GSettings* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_;
	GList* engines = NULL;
	IBusBus* _tmp11_;
	GList* _tmp12_;
	GList* xkb_engines = NULL;
	GList* _tmp13_;
	GList* _tmp14_;
	GList* im_engines = NULL;
	GList* _tmp15_;
	GList* _tmp16_;
	gchar** names = NULL;
	gchar** _tmp17_;
	gint names_length1;
	gint _names_size_;
	GList* _tmp18_;
	GList* _tmp23_;
	GSettings* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "xkb-latin-layouts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	xkb_layout_set_latin_layouts (_tmp0_, _tmp4_, _vala_array_length (_tmp2_));
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->priv->inited_engines_order;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->m_settings_general;
	_tmp8_ = _tmp7_ = g_settings_get_strv (_tmp6_, "preload-engines");
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = _vala_array_length (_tmp7_) > 0;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp10_) {
		return;
	}
	_tmp11_ = self->priv->m_bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	_tmp13_ = engines;
	_tmp14_ = panel_get_engines_from_xkb (self, _tmp13_);
	xkb_engines = _tmp14_;
	_tmp15_ = engines;
	_tmp16_ = panel_get_engines_from_locale (self, _tmp15_);
	im_engines = _tmp16_;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	names = _tmp17_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp18_ = xkb_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp18_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar** _tmp19_;
				gint _tmp19__length1;
				IBusEngineDesc* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = names;
				_tmp19__length1 = names_length1;
				_tmp20_ = engine;
				_tmp21_ = ibus_engine_desc_get_name (_tmp20_);
				_tmp22_ = g_strdup (_tmp21_);
				_vala_array_add17 (&names, &names_length1, &_names_size_, _tmp22_);
			}
		}
	}
	_tmp23_ = im_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp23_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar** _tmp24_;
				gint _tmp24__length1;
				IBusEngineDesc* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp24_ = names;
				_tmp24__length1 = names_length1;
				_tmp25_ = engine;
				_tmp26_ = ibus_engine_desc_get_name (_tmp25_);
				_tmp27_ = g_strdup (_tmp26_);
				_vala_array_add18 (&names, &names_length1, &_names_size_, _tmp27_);
			}
		}
	}
	_tmp28_ = self->priv->m_settings_general;
	_tmp29_ = names;
	_tmp29__length1 = names_length1;
	g_settings_set_strv (_tmp28_, "preload-engines", _tmp29_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	(im_engines == NULL) ? NULL : (im_engines = (_g_list_free__g_object_unref0_ (im_engines), NULL));
	(xkb_engines == NULL) ? NULL : (xkb_engines = (_g_list_free__g_object_unref0_ (xkb_engines), NULL));
	(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
}


static void
panel_set_switcher_delay_time (Panel* self)
{
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Switcher* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_switcher_delay_time = g_settings_get_int (_tmp0_, "switcher-delay-time");
	_tmp2_ = self->priv->m_switcher;
	if (_tmp2_ != NULL) {
		gint _tmp3_;
		_tmp3_ = self->priv->m_switcher_delay_time;
		_tmp1_ = _tmp3_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Switcher* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->m_switcher;
		_tmp5_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp4_, (guint) _tmp5_);
	}
}


static void
panel_set_use_system_keyboard_layout (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_use_system_keyboard_layout = g_settings_get_boolean (_tmp0_, "use-system-keyboard-layout");
}


static void
panel_set_embed_preedit_text (Panel* self)
{
	GVariant* variant = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	IBusBus* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_value (_tmp0_, "embed-preedit-text");
	variant = _tmp1_;
	_tmp2_ = variant;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (variant);
		return;
	}
	_tmp3_ = self->priv->m_bus;
	_tmp4_ = variant;
	ibus_bus_set_ibus_property (_tmp3_, "EmbedPreeditText", _tmp4_);
	_g_variant_unref0 (variant);
}


static void
panel_set_use_global_engine (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	self->priv->m_use_global_engine = g_settings_get_boolean (_tmp0_, "use-global-engine");
}


static void
panel_set_use_xmodmap (Panel* self)
{
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	xkb_layout_set_use_xmodmap (_tmp0_, g_settings_get_boolean (_tmp1_, "use-xmodmap"));
}


static void
panel_set_show_icon_on_systray (Panel* self)
{
	PanelIconType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_icon_type;
	if (_tmp0_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GtkStatusIcon* _tmp1_;
		GtkStatusIcon* _tmp2_;
		GSettings* _tmp3_;
		_tmp1_ = self->priv->m_status_icon;
		if (_tmp1_ == NULL) {
			return;
		}
		_tmp2_ = self->priv->m_status_icon;
		_tmp3_ = self->priv->m_settings_panel;
		gtk_status_icon_set_visible (_tmp2_, g_settings_get_boolean (_tmp3_, "show-icon-on-systray"));
	} else {
		PanelIconType _tmp4_;
		_tmp4_ = self->priv->m_icon_type;
		if (_tmp4_ == PANEL_ICON_TYPE_INDICATOR) {
			Indicator* _tmp5_;
			GSettings* _tmp6_;
			_tmp5_ = self->priv->m_indicator;
			if (_tmp5_ == NULL) {
				return;
			}
			_tmp6_ = self->priv->m_settings_panel;
			if (g_settings_get_boolean (_tmp6_, "show-icon-on-systray")) {
				Indicator* _tmp7_;
				_tmp7_ = self->priv->m_indicator;
				indicator_set_status (_tmp7_, INDICATOR_STATUS_ACTIVE);
			} else {
				Indicator* _tmp8_;
				_tmp8_ = self->priv->m_indicator;
				indicator_set_status (_tmp8_, INDICATOR_STATUS_PASSIVE);
			}
		}
	}
}


static void
panel_set_lookup_table_orientation (Panel* self)
{
	CandidatePanel* _tmp0_;
	CandidatePanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	_tmp2_ = self->priv->m_settings_panel;
	candidate_panel_set_vertical (_tmp1_, g_settings_get_int (_tmp2_, "lookup-table-orientation") == ((gint) IBUS_ORIENTATION_VERTICAL));
}


static void
panel_set_show_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_show (_tmp1_, g_settings_get_int (_tmp2_, "show"));
}


static void
panel_set_timeout_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_auto_hide_timeout (_tmp1_, (guint) g_settings_get_int (_tmp2_, "auto-hide-timeout"));
}


static void
panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self)
{
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	property_panel_set_follow_input_cursor_when_always_shown (_tmp1_, g_settings_get_boolean (_tmp2_, "follow-input-cursor-when-always-shown"));
}


static void
panel_set_xkb_icon_rgba (Panel* self)
{
	gchar* spec = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp2_ = {0};
	const gchar* _tmp3_;
	PanelIconType _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = g_settings_get_string (_tmp0_, "xkb-icon-rgba");
	spec = _tmp1_;
	_tmp2_.red = (gdouble) 0;
	rgba = _tmp2_;
	_tmp3_ = spec;
	if (!gdk_rgba_parse (&rgba, _tmp3_)) {
		const gchar* _tmp4_;
		GdkRGBA _tmp5_ = {0};
		GdkRGBA _tmp6_;
		_tmp4_ = spec;
		g_warning ("panel.vala:634: invalid format of xkb-icon-rgba: %s", _tmp4_);
		memset (&_tmp5_, 0, sizeof (GdkRGBA));
		_tmp5_.red = 0.0;
		_tmp5_.green = 0.0;
		_tmp5_.blue = 0.0;
		_tmp5_.alpha = 1.0;
		self->priv->m_xkb_icon_rgba = _tmp5_;
		_tmp6_ = self->priv->m_xkb_icon_rgba;
	} else {
		GdkRGBA _tmp7_;
		_tmp7_ = rgba;
		self->priv->m_xkb_icon_rgba = _tmp7_;
	}
	_tmp8_ = self->priv->m_icon_type;
	if (_tmp8_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GHashTable* _tmp9_;
		_tmp9_ = self->priv->m_xkb_icon_pixbufs;
		if (g_hash_table_size (_tmp9_) > ((guint) 0)) {
			GHashTable* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GtkStatusIcon* _tmp12_;
			_tmp10_ = self->priv->m_xkb_icon_pixbufs;
			g_hash_table_remove_all (_tmp10_);
			_tmp12_ = self->priv->m_status_icon;
			if (_tmp12_ != NULL) {
				Switcher* _tmp13_;
				_tmp13_ = self->priv->m_switcher;
				_tmp11_ = _tmp13_ != NULL;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
			}
		}
	} else {
		PanelIconType _tmp14_;
		_tmp14_ = self->priv->m_icon_type;
		if (_tmp14_ == PANEL_ICON_TYPE_INDICATOR) {
			GHashTable* _tmp15_;
			_tmp15_ = self->priv->m_xkb_icon_image;
			if (g_hash_table_size (_tmp15_) > ((guint) 0)) {
				GHashTable* _tmp16_;
				gboolean _tmp17_ = FALSE;
				Indicator* _tmp18_;
				_tmp16_ = self->priv->m_xkb_icon_image;
				g_hash_table_remove_all (_tmp16_);
				_tmp18_ = self->priv->m_indicator;
				if (_tmp18_ != NULL) {
					Switcher* _tmp19_;
					_tmp19_ = self->priv->m_switcher;
					_tmp17_ = _tmp19_ != NULL;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
				}
			}
		}
	}
	_g_free0 (spec);
}


static void
panel_set_property_icon_delay_time (Panel* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	self->priv->m_property_icon_delay_time = g_settings_get_int (_tmp0_, "property-icon-delay-time");
}


static gint
panel_compare_versions (Panel* self,
                        const gchar* version1,
                        const gchar* version2)
{
	gint result = 0;
	gchar** version1_list = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint version1_list_length1;
	gint _version1_list_size_;
	gchar** version2_list = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint version2_list_length1;
	gint _version2_list_size_;
	gint major1 = 0;
	gint minor1 = 0;
	gint micro1 = 0;
	gint major2 = 0;
	gint minor2 = 0;
	gint micro2 = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_;
	gint _tmp21_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gint _tmp28_;
	gint _tmp29_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (version1 != NULL, 0);
	g_return_val_if_fail (version2 != NULL, 0);
	_tmp1_ = _tmp0_ = g_strsplit (version1, ".", 0);
	version1_list = _tmp1_;
	version1_list_length1 = _vala_array_length (_tmp0_);
	_version1_list_size_ = version1_list_length1;
	_tmp3_ = _tmp2_ = g_strsplit (version2, ".", 0);
	version2_list = _tmp3_;
	version2_list_length1 = _vala_array_length (_tmp2_);
	_version2_list_size_ = version2_list_length1;
	if (g_strcmp0 (version1, version2) == 0) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (g_strcmp0 (version1, "") == 0) {
		result = -1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (g_strcmp0 (version2, "") == 0) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = version1_list;
	_tmp4__length1 = version1_list_length1;
	_vala_assert (_tmp4__length1 >= 3, "version1_list.length >= 3");
	_tmp5_ = version2_list;
	_tmp5__length1 = version2_list_length1;
	_vala_assert (_tmp5__length1 >= 3, "version2_list.length >= 3");
	_tmp6_ = version1_list;
	_tmp6__length1 = version1_list_length1;
	_tmp7_ = _tmp6_[0];
	major1 = atoi (_tmp7_);
	_tmp8_ = version1_list;
	_tmp8__length1 = version1_list_length1;
	_tmp9_ = _tmp8_[1];
	minor1 = atoi (_tmp9_);
	_tmp10_ = version1_list;
	_tmp10__length1 = version1_list_length1;
	_tmp11_ = _tmp10_[2];
	micro1 = atoi (_tmp11_);
	_tmp12_ = version2_list;
	_tmp12__length1 = version2_list_length1;
	_tmp13_ = _tmp12_[0];
	major2 = atoi (_tmp13_);
	_tmp14_ = version2_list;
	_tmp14__length1 = version2_list_length1;
	_tmp15_ = _tmp14_[1];
	minor2 = atoi (_tmp15_);
	_tmp16_ = version2_list;
	_tmp16__length1 = version2_list_length1;
	_tmp17_ = _tmp16_[2];
	micro2 = atoi (_tmp17_);
	_tmp20_ = major1;
	_tmp21_ = minor1;
	if (_tmp20_ == _tmp21_) {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = minor1;
		_tmp23_ = minor2;
		_tmp19_ = _tmp22_ == _tmp23_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = micro1;
		_tmp25_ = micro2;
		_tmp18_ = _tmp24_ == _tmp25_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp28_ = major1;
	_tmp29_ = major2;
	if (_tmp28_ > _tmp29_) {
		_tmp27_ = TRUE;
	} else {
		gboolean _tmp30_ = FALSE;
		gint _tmp31_;
		gint _tmp32_;
		_tmp31_ = major1;
		_tmp32_ = major2;
		if (_tmp31_ == _tmp32_) {
			gint _tmp33_;
			gint _tmp34_;
			_tmp33_ = minor1;
			_tmp34_ = minor2;
			_tmp30_ = _tmp33_ > _tmp34_;
		} else {
			_tmp30_ = FALSE;
		}
		_tmp27_ = _tmp30_;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gint _tmp37_;
		gint _tmp38_;
		_tmp37_ = major1;
		_tmp38_ = major2;
		if (_tmp37_ == _tmp38_) {
			gint _tmp39_;
			gint _tmp40_;
			_tmp39_ = minor1;
			_tmp40_ = minor2;
			_tmp36_ = _tmp39_ == _tmp40_;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			gint _tmp41_;
			gint _tmp42_;
			_tmp41_ = micro1;
			_tmp42_ = micro2;
			_tmp35_ = _tmp41_ > _tmp42_;
		} else {
			_tmp35_ = FALSE;
		}
		_tmp26_ = _tmp35_;
	}
	if (_tmp26_) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = -1;
	version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
	version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
panel_update_version_1_5_3 (Panel* self)
{
	NotifyNotification* notification = NULL;
	NotifyNotification* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!notify_is_initted ()) {
		notify_init ("ibus");
	}
	_tmp0_ = notify_notification_new (_ ("IBus Update"), _ ("Super+space is now the default hotkey."), "ibus");
	notification = _tmp0_;
	notify_notification_set_timeout (notification, 30 * 1000);
	notify_notification_set_category (notification, "hotkey");
	{
		notify_notification_show (notification, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("panel.vala:719: Notification is failed for IBus 1.5.3: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (notification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (notification);
}


static void
panel_update_version_1_5_8 (Panel* self)
{
	g_return_if_fail (self != NULL);
	self->priv->inited_engines_order = FALSE;
}


static void
panel_set_version (Panel* self)
{
	gchar* prev_version = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* current_version = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_string (_tmp0_, "version");
	prev_version = _tmp1_;
	current_version = NULL;
	_tmp2_ = prev_version;
	if (panel_compare_versions (self, _tmp2_, "1.5.3") < 0) {
		panel_update_version_1_5_3 (self);
	}
	_tmp3_ = prev_version;
	if (panel_compare_versions (self, _tmp3_, "1.5.8") < 0) {
		panel_update_version_1_5_8 (self);
	}
	_tmp4_ = g_strdup_printf ("%d.%d.%d", IBUS_MAJOR_VERSION, IBUS_MINOR_VERSION, IBUS_MICRO_VERSION);
	_g_free0 (current_version);
	current_version = _tmp4_;
	_tmp5_ = prev_version;
	_tmp6_ = current_version;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		_g_free0 (current_version);
		_g_free0 (prev_version);
		return;
	}
	_tmp7_ = self->priv->m_settings_general;
	_tmp8_ = current_version;
	g_settings_set_string (_tmp7_, "version", _tmp8_);
	_g_free0 (current_version);
	_g_free0 (prev_version);
}


void
panel_load_settings (Panel* self)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GList* _tmp8_;
	GSettings* _tmp9_;
	g_return_if_fail (self != NULL);
	panel_set_version (self);
	panel_init_engines_order (self);
	panel_set_use_system_keyboard_layout (self);
	panel_set_use_global_engine (self);
	panel_set_use_xmodmap (self);
	_tmp0_ = self->priv->m_settings_general;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "preload-engines");
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = self->priv->m_settings_general;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "engines-order");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	panel_update_engines (self, _tmp3_, _vala_array_length (_tmp1_), _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, _tmp8_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	panel_bind_switch_shortcut (self);
	panel_set_switcher_delay_time (self);
	panel_set_embed_preedit_text (self);
	_tmp9_ = self->priv->m_settings_panel;
	binding_common_set_custom_font (_tmp9_, NULL, &self->priv->m_css_provider);
	panel_set_show_icon_on_systray (self);
	panel_set_lookup_table_orientation (self);
	panel_set_show_property_panel (self);
	panel_set_timeout_property_panel (self);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
	panel_set_xkb_icon_rgba (self);
	panel_set_property_icon_delay_time (self);
}


/**
     * disconnect_signals:
     *
     * Call this API before m_panel = null so that the ref_count becomes 0
     */
void
panel_disconnect_signals (Panel* self)
{
	GObject* object = NULL;
	GtkStatusIcon* _tmp0_;
	gboolean _tmp1_;
	gulong _tmp3_;
	gulong _tmp8_;
	gulong _tmp13_;
	guint _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_status_icon;
	object = (GObject*) _tmp0_;
	_tmp1_ = self->priv->m_is_kde;
	if (_tmp1_) {
		Indicator* _tmp2_;
		_tmp2_ = self->priv->m_indicator;
		object = (GObject*) _tmp2_;
	}
	_tmp3_ = self->priv->m_popup_menu_id;
	if (_tmp3_ > ((gulong) 0)) {
		GObject* _tmp4_;
		gulong _tmp5_;
		_tmp4_ = object;
		_tmp5_ = self->priv->m_popup_menu_id;
		if (g_signal_handler_is_connected (_tmp4_, _tmp5_)) {
			GObject* _tmp6_;
			gulong _tmp7_;
			_tmp6_ = object;
			_tmp7_ = self->priv->m_popup_menu_id;
			g_signal_handler_disconnect (_tmp6_, _tmp7_);
		}
		self->priv->m_popup_menu_id = (gulong) 0;
	}
	_tmp8_ = self->priv->m_activate_id;
	if (_tmp8_ > ((gulong) 0)) {
		GObject* _tmp9_;
		gulong _tmp10_;
		_tmp9_ = object;
		_tmp10_ = self->priv->m_activate_id;
		if (g_signal_handler_is_connected (_tmp9_, _tmp10_)) {
			GObject* _tmp11_;
			gulong _tmp12_;
			_tmp11_ = object;
			_tmp12_ = self->priv->m_activate_id;
			g_signal_handler_disconnect (_tmp11_, _tmp12_);
		}
		self->priv->m_activate_id = (gulong) 0;
	}
	_tmp13_ = self->priv->m_registered_status_notifier_item_id;
	if (_tmp13_ > ((gulong) 0)) {
		GObject* _tmp14_;
		gulong _tmp15_;
		_tmp14_ = object;
		_tmp15_ = self->priv->m_registered_status_notifier_item_id;
		if (g_signal_handler_is_connected (_tmp14_, _tmp15_)) {
			GObject* _tmp16_;
			gulong _tmp17_;
			_tmp16_ = object;
			_tmp17_ = self->priv->m_registered_status_notifier_item_id;
			g_signal_handler_disconnect (_tmp16_, _tmp17_);
		}
		self->priv->m_registered_status_notifier_item_id = (gulong) 0;
	}
	_tmp18_ = self->priv->m_preload_engines_id;
	if (_tmp18_ > ((guint) 0)) {
		guint _tmp19_;
		_tmp19_ = self->priv->m_preload_engines_id;
		g_source_remove (_tmp19_);
		self->priv->m_preload_engines_id = (guint) 0;
	}
}


static void
panel_engine_contexts_insert (Panel* self,
                              IBusEngineDesc* engine)
{
	gboolean _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	if (g_hash_table_size (_tmp1_) >= ((guint) 200)) {
		GHashTable* _tmp2_;
		g_warning ("panel.vala:823: Contexts by windows are too much counted!");
		_tmp2_ = self->priv->m_engine_contexts;
		g_hash_table_remove_all (_tmp2_);
	}
	_tmp3_ = self->priv->m_engine_contexts;
	_tmp4_ = self->priv->m_current_context_path;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _g_object_ref0 (engine);
	g_hash_table_replace (_tmp3_, _tmp5_, _tmp6_);
}


static void
panel_set_engine (Panel* self,
                  IBusEngineDesc* engine)
{
	guint _tmp0_;
	IBusBus* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_property_icon_delay_time_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_property_icon_delay_time_id;
		g_source_remove (_tmp1_);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	_tmp2_ = self->priv->m_bus;
	_tmp3_ = ibus_engine_desc_get_name (engine);
	if (!ibus_bus_set_global_engine (_tmp2_, _tmp3_)) {
		const gchar* _tmp4_;
		_tmp4_ = ibus_engine_desc_get_name (engine);
		g_warning ("panel.vala:837: Switch engine to %s failed.", _tmp4_);
		return;
	}
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->m_icon_prop_key);
	self->priv->m_icon_prop_key = _tmp5_;
	_tmp6_ = self->priv->m_use_system_keyboard_layout;
	if (!_tmp6_) {
		XKBLayout* _tmp7_;
		_tmp7_ = self->priv->m_xkblayout;
		xkb_layout_set_layout (_tmp7_, engine);
	}
	panel_engine_contexts_insert (self, engine);
}


static void
panel_switch_engine (Panel* self,
                     gint i,
                     gboolean force)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	IBusEngineDesc* engine = NULL;
	IBusEngineDesc** _tmp3_;
	gint _tmp3__length1;
	IBusEngineDesc* _tmp4_;
	IBusEngineDesc* _tmp5_;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	if (i >= 0) {
		IBusEngineDesc** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->m_engines;
		_tmp1__length1 = self->priv->m_engines_length1;
		_tmp0_ = i < _tmp1__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "i >= 0 && i < m_engines.length");
	if (i == 0) {
		_tmp2_ = !force;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->m_engines;
	_tmp3__length1 = self->priv->m_engines_length1;
	_tmp4_ = _tmp3_[i];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	engine = _tmp5_;
	_tmp6_ = engine;
	panel_set_engine (self, _tmp6_);
	_g_object_unref0 (engine);
}


static void
panel_handle_engine_switch_normal (Panel* self,
                                   GdkEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	panel_handle_engine_switch (self, event, FALSE);
}


static void
panel_handle_engine_switch_reverse (Panel* self,
                                    GdkEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	panel_handle_engine_switch (self, event, TRUE);
}


static void
panel_handle_engine_switch (Panel* self,
                            GdkEvent* event,
                            gboolean reverse)
{
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	guint keyval = 0U;
	GdkEventKey* _tmp1_;
	GdkEventKey* _tmp2_;
	guint _tmp3_;
	guint modifiers = 0U;
	GdkEventKey* _tmp4_;
	GdkEventKey* _tmp5_;
	GdkModifierType _tmp6_;
	guint primary_modifiers = 0U;
	GdkEventKey* _tmp7_;
	GdkEventKey* _tmp8_;
	GdkModifierType _tmp9_;
	gboolean pressed = FALSE;
	guint _tmp10_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = (GdkEventKey *) (event);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->keyval;
	keyval = _tmp3_;
	_tmp4_ = (GdkEventKey *) (event);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->state;
	modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp6_;
	_tmp7_ = (GdkEventKey *) (event);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->state;
	primary_modifiers = (guint) keybinding_manager_get_primary_modifier ((guint) _tmp9_);
	_tmp10_ = primary_modifiers;
	pressed = keybinding_manager_primary_modifier_still_pressed (event, _tmp10_);
	if (reverse) {
		guint _tmp11_;
		_tmp11_ = modifiers;
		modifiers = _tmp11_ & (~GDK_SHIFT_MASK);
	}
	_tmp13_ = pressed;
	if (_tmp13_) {
		gint _tmp14_;
		_tmp14_ = self->priv->m_switcher_delay_time;
		_tmp12_ = _tmp14_ >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gint _tmp15_ = 0;
		gint i = 0;
		Switcher* _tmp17_;
		guint _tmp18_;
		guint _tmp19_;
		IBusEngineDesc** _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_;
		const gchar* _tmp22_;
		gint _tmp23_;
		if (reverse) {
			IBusEngineDesc** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = self->priv->m_engines;
			_tmp16__length1 = self->priv->m_engines_length1;
			_tmp15_ = _tmp16__length1 - 1;
		} else {
			_tmp15_ = 1;
		}
		i = _tmp15_;
		_tmp17_ = self->priv->m_switcher;
		_tmp18_ = keyval;
		_tmp19_ = modifiers;
		_tmp20_ = self->priv->m_engines;
		_tmp20__length1 = self->priv->m_engines_length1;
		_tmp21_ = i;
		_tmp22_ = self->priv->m_real_current_context_path;
		i = switcher_run (_tmp17_, _tmp18_, _tmp19_, event, _tmp20_, _tmp20__length1, _tmp21_, _tmp22_);
		_tmp23_ = i;
		if (_tmp23_ < 0) {
			g_debug ("panel.vala:908: switch cancelled");
		} else {
			gint _tmp24_;
			_tmp24_ = i;
			if (_tmp24_ == 0) {
				g_debug ("panel.vala:910: do not have to switch");
			} else {
				panel_switcher_focus_set_engine (self);
			}
		}
	} else {
		gint _tmp25_ = 0;
		gint i = 0;
		gint _tmp27_;
		if (reverse) {
			IBusEngineDesc** _tmp26_;
			gint _tmp26__length1;
			_tmp26_ = self->priv->m_engines;
			_tmp26__length1 = self->priv->m_engines_length1;
			_tmp25_ = _tmp26__length1 - 1;
		} else {
			_tmp25_ = 1;
		}
		i = _tmp25_;
		_tmp27_ = i;
		panel_switch_engine (self, _tmp27_, FALSE);
	}
}


static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		Panel* self;
		self = _data7_->self;
		_data7_->names = (_vala_array_free (_data7_->names, _data7_->names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void
_vala_array_add19 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean
__lambda33_ (Block7Data* _data7_)
{
	Panel* self;
	gboolean result = FALSE;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = _data7_->self;
	_tmp0_ = self->priv->m_bus;
	if (!ibus_bus_is_connected (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = _data7_->names;
	_tmp2__length1 = _data7_->names_length1;
	ibus_bus_preload_engines_async (_tmp1_, _tmp2_, -1, NULL, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean
___lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda33_ (self);
	return result;
}


static void
panel_run_preload_engines (Panel* self,
                           IBusEngineDesc** engines,
                           int engines_length1,
                           gint index)
{
	Block7Data* _data7_;
	gchar** _tmp0_;
	guint _tmp1_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	IBusEngineDesc* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data7_->names = _tmp0_;
	_data7_->names_length1 = 0;
	_data7_->_names_size_ = _data7_->names_length1;
	if (engines_length1 <= index) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp1_ = self->priv->m_preload_engines_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->m_preload_engines_id;
		g_source_remove (_tmp2_);
		self->priv->m_preload_engines_id = (guint) 0;
	}
	_tmp3_ = _data7_->names;
	_tmp3__length1 = _data7_->names_length1;
	_tmp4_ = engines[index];
	_tmp5_ = ibus_engine_desc_get_name (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	_vala_array_add19 (&_data7_->names, &_data7_->names_length1, &_data7_->_names_size_, _tmp6_);
	self->priv->m_preload_engines_id = g_timeout_add_full (G_PRIORITY_DEFAULT, PANEL_PRELOAD_ENGINES_DELAY_TIME, ___lambda33__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static gchar**
_vala_array_dup2 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void
_vala_array_add20 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add21 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc**
_vala_array_dup3 (IBusEngineDesc** self,
                  int length)
{
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc**
_vala_array_dup4 (IBusEngineDesc** self,
                  int length)
{
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void
panel_update_engines (Panel* self,
                      gchar** unowned_engine_names,
                      int unowned_engine_names_length1,
                      gchar** order_names,
                      int order_names_length1)
{
	gchar** engine_names = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint engine_names_length1;
	gint _engine_names_size_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** names = NULL;
	gchar** _tmp6_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	IBusEngineDesc** engines = NULL;
	IBusBus* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	IBusEngineDesc** _tmp22_;
	IBusEngineDesc** _tmp23_;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp24_;
	gint _tmp24__length1;
	IBusEngineDesc** _tmp33_;
	gint _tmp33__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (unowned_engine_names != NULL) ? _vala_array_dup2 (unowned_engine_names, unowned_engine_names_length1) : ((gpointer) unowned_engine_names);
	_tmp0__length1 = unowned_engine_names_length1;
	engine_names = _tmp0_;
	engine_names_length1 = _tmp0__length1;
	_engine_names_size_ = engine_names_length1;
	_tmp2_ = engine_names;
	_tmp2__length1 = engine_names_length1;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = engine_names;
		_tmp3__length1 = engine_names_length1;
		_tmp1_ = _tmp3__length1 == 0;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		gchar** _tmp5_;
		_tmp4_ = g_strdup ("xkb:us::eng");
		_tmp5_ = g_new0 (gchar*, 1 + 1);
		_tmp5_[0] = _tmp4_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp5_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	names = _tmp6_;
	names_length1 = 0;
	_names_size_ = names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = order_names;
		name_collection_length1 = order_names_length1;
		for (name_it = 0; name_it < order_names_length1; name_it = name_it + 1) {
			gchar* _tmp7_;
			gchar* name = NULL;
			_tmp7_ = g_strdup (name_collection[name_it]);
			name = _tmp7_;
			{
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp8_ = name;
				_tmp9_ = engine_names;
				_tmp9__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp9_, _tmp9__length1, _tmp8_)) {
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = names;
					_tmp10__length1 = names_length1;
					_tmp11_ = name;
					_tmp12_ = g_strdup (_tmp11_);
					_vala_array_add20 (&names, &names_length1, &_names_size_, _tmp12_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp13_ = engine_names;
	_tmp13__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp13_;
		name_collection_length1 = _tmp13__length1;
		for (name_it = 0; name_it < _tmp13__length1; name_it = name_it + 1) {
			gchar* _tmp14_;
			gchar* name = NULL;
			_tmp14_ = g_strdup (name_collection[name_it]);
			name = _tmp14_;
			{
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = name;
				_tmp16_ = names;
				_tmp16__length1 = names_length1;
				if (_vala_string_array_contains (_tmp16_, _tmp16__length1, _tmp15_)) {
					_g_free0 (name);
					continue;
				}
				_tmp17_ = names;
				_tmp17__length1 = names_length1;
				_tmp18_ = name;
				_tmp19_ = g_strdup (_tmp18_);
				_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp19_);
				_g_free0 (name);
			}
		}
	}
	_tmp20_ = self->priv->m_bus;
	_tmp21_ = names;
	_tmp21__length1 = names_length1;
	_tmp23_ = _tmp22_ = ibus_bus_get_engines_by_names (_tmp20_, _tmp21_);
	engines = _tmp23_;
	engines_length1 = _vala_array_length (_tmp22_);
	_engines_size_ = engines_length1;
	_tmp24_ = engines;
	_tmp24__length1 = engines_length1;
	if (_tmp24__length1 == 0) {
		gchar* _tmp25_;
		gchar** _tmp26_;
		GSettings* _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		IBusBus* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		IBusEngineDesc** _tmp31_;
		IBusEngineDesc** _tmp32_;
		_tmp25_ = g_strdup ("xkb:us::eng");
		_tmp26_ = g_new0 (gchar*, 1 + 1);
		_tmp26_[0] = _tmp25_;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		names = _tmp26_;
		names_length1 = 1;
		_names_size_ = names_length1;
		_tmp27_ = self->priv->m_settings_general;
		_tmp28_ = names;
		_tmp28__length1 = names_length1;
		g_settings_set_strv (_tmp27_, "preload-engines", _tmp28_);
		_tmp29_ = self->priv->m_bus;
		_tmp30_ = names;
		_tmp30__length1 = names_length1;
		_tmp32_ = _tmp31_ = ibus_bus_get_engines_by_names (_tmp29_, _tmp30_);
		engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
		engines = _tmp32_;
		engines_length1 = _vala_array_length (_tmp31_);
		_engines_size_ = engines_length1;
	}
	_tmp33_ = self->priv->m_engines;
	_tmp33__length1 = self->priv->m_engines_length1;
	if (_tmp33__length1 == 0) {
		IBusEngineDesc** _tmp34_;
		gint _tmp34__length1;
		IBusEngineDesc** _tmp35_;
		gint _tmp35__length1;
		IBusEngineDesc** _tmp36_;
		gint _tmp36__length1;
		_tmp34_ = engines;
		_tmp34__length1 = engines_length1;
		_tmp35_ = (_tmp34_ != NULL) ? _vala_array_dup3 (_tmp34_, _tmp34__length1) : ((gpointer) _tmp34_);
		_tmp35__length1 = _tmp34__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp35_;
		self->priv->m_engines_length1 = _tmp35__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
		_tmp36_ = engines;
		_tmp36__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp36_, _tmp36__length1, 1);
	} else {
		IBusEngineDesc* current_engine = NULL;
		IBusEngineDesc** _tmp37_;
		gint _tmp37__length1;
		IBusEngineDesc* _tmp38_;
		IBusEngineDesc* _tmp39_;
		IBusEngineDesc** _tmp40_;
		gint _tmp40__length1;
		IBusEngineDesc** _tmp41_;
		gint _tmp41__length1;
		gint i = 0;
		IBusEngineDesc** _tmp56_;
		gint _tmp56__length1;
		_tmp37_ = self->priv->m_engines;
		_tmp37__length1 = self->priv->m_engines_length1;
		_tmp38_ = _tmp37_[0];
		_tmp39_ = _g_object_ref0 (_tmp38_);
		current_engine = _tmp39_;
		_tmp40_ = engines;
		_tmp40__length1 = engines_length1;
		_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup4 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
		_tmp41__length1 = _tmp40__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp41_;
		self->priv->m_engines_length1 = _tmp41__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp42_ = FALSE;
			i = 0;
			_tmp42_ = TRUE;
			while (TRUE) {
				gint _tmp44_;
				IBusEngineDesc** _tmp45_;
				gint _tmp45__length1;
				IBusEngineDesc* _tmp46_;
				const gchar* _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				gint _tmp49_;
				IBusEngineDesc* _tmp50_;
				const gchar* _tmp51_;
				if (!_tmp42_) {
					gint _tmp43_;
					_tmp43_ = i;
					i = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp44_ = i;
				_tmp45_ = self->priv->m_engines;
				_tmp45__length1 = self->priv->m_engines_length1;
				if (!(_tmp44_ < _tmp45__length1)) {
					break;
				}
				_tmp46_ = current_engine;
				_tmp47_ = ibus_engine_desc_get_name (_tmp46_);
				_tmp48_ = engines;
				_tmp48__length1 = engines_length1;
				_tmp49_ = i;
				_tmp50_ = _tmp48_[_tmp49_];
				_tmp51_ = ibus_engine_desc_get_name (_tmp50_);
				if (g_strcmp0 (_tmp47_, _tmp51_) == 0) {
					gint _tmp52_;
					gint _tmp53_;
					_tmp52_ = i;
					panel_switch_engine (self, _tmp52_, FALSE);
					_tmp53_ = i;
					if (_tmp53_ != 0) {
						IBusEngineDesc** _tmp54_;
						gint _tmp54__length1;
						_tmp54_ = engines;
						_tmp54__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp54_, _tmp54__length1, 0);
					} else {
						IBusEngineDesc** _tmp55_;
						gint _tmp55__length1;
						_tmp55_ = engines;
						_tmp55__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp55_, _tmp55__length1, 1);
					}
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_tmp56_ = engines;
		_tmp56__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp56_, _tmp56__length1, 1);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}


static void
panel_context_render_string (Panel* self,
                             cairo_t* cr,
                             const gchar* symbol,
                             gint image_width,
                             gint image_height)
{
	gint lwidth = 0;
	gint lheight = 0;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp0_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_;
	gint _tmp12_;
	GdkRGBA _tmp13_;
	gdouble _tmp14_;
	GdkRGBA _tmp15_;
	gdouble _tmp16_;
	GdkRGBA _tmp17_;
	gdouble _tmp18_;
	GdkRGBA _tmp19_;
	gdouble _tmp20_;
	PangoLayout* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (symbol != NULL);
	lwidth = 0;
	lheight = 0;
	_tmp0_ = pango_font_description_from_string ("Monospace Bold 22");
	desc = _tmp0_;
	_tmp1_ = pango_cairo_create_layout (cr);
	layout = _tmp1_;
	_tmp2_ = strlen (symbol);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 3) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Monospace Bold 18");
		__vala_PangoFontDescription_free0 (desc);
		desc = _tmp4_;
	}
	_tmp5_ = layout;
	_tmp6_ = desc;
	pango_layout_set_font_description (_tmp5_, _tmp6_);
	_tmp7_ = layout;
	pango_layout_set_text (_tmp7_, symbol, -1);
	_tmp8_ = layout;
	pango_layout_get_size (_tmp8_, &_tmp9_, &_tmp10_);
	lwidth = _tmp9_;
	lheight = _tmp10_;
	_tmp11_ = lwidth;
	_tmp12_ = lheight;
	cairo_move_to (cr, (gdouble) ((image_width - (_tmp11_ / PANGO_SCALE)) / 2), (gdouble) ((image_height - (_tmp12_ / PANGO_SCALE)) / 2));
	_tmp13_ = self->priv->m_xkb_icon_rgba;
	_tmp14_ = _tmp13_.red;
	_tmp15_ = self->priv->m_xkb_icon_rgba;
	_tmp16_ = _tmp15_.green;
	_tmp17_ = self->priv->m_xkb_icon_rgba;
	_tmp18_ = _tmp17_.blue;
	_tmp19_ = self->priv->m_xkb_icon_rgba;
	_tmp20_ = _tmp19_.alpha;
	cairo_set_source_rgba (cr, _tmp14_, _tmp16_, _tmp18_, _tmp20_);
	_tmp21_ = layout;
	pango_cairo_show_layout (cr, _tmp21_);
	_g_object_unref0 (layout);
	__vala_PangoFontDescription_free0 (desc);
}


static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}


static cairo_surface_t*
panel_create_cairo_image_surface_with_string (Panel* self,
                                              const gchar* symbol,
                                              gboolean cache)
{
	cairo_surface_t* result = NULL;
	cairo_surface_t* image = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	gint width = 0;
	cairo_surface_t* _tmp7_;
	gint height = 0;
	cairo_surface_t* _tmp8_;
	gint stride = 0;
	cairo_surface_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	cairo_surface_t* _tmp17_;
	PanelIconType _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	image = NULL;
	if (cache) {
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		_tmp0_ = self->priv->m_xkb_icon_image;
		_tmp1_ = g_hash_table_lookup (_tmp0_, symbol);
		_tmp2_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp1_);
		_cairo_surface_destroy0 (image);
		image = _tmp2_;
		_tmp3_ = image;
		if (_tmp3_ != NULL) {
			result = image;
			return result;
		}
	}
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 48, 48);
	_cairo_surface_destroy0 (image);
	image = _tmp4_;
	_tmp5_ = image;
	_tmp6_ = cairo_create (_tmp5_);
	cr = _tmp6_;
	_tmp7_ = image;
	width = cairo_image_surface_get_width (_tmp7_);
	_tmp8_ = image;
	height = cairo_image_surface_get_height (_tmp8_);
	_tmp9_ = image;
	stride = cairo_image_surface_get_stride (_tmp9_);
	_tmp10_ = cr;
	cairo_set_source_rgba (_tmp10_, 0.0, 0.0, 0.0, 0.0);
	_tmp11_ = cr;
	cairo_set_operator (_tmp11_, CAIRO_OPERATOR_SOURCE);
	_tmp12_ = cr;
	cairo_paint (_tmp12_);
	_tmp13_ = cr;
	cairo_set_operator (_tmp13_, CAIRO_OPERATOR_OVER);
	_tmp14_ = cr;
	_tmp15_ = width;
	_tmp16_ = height;
	panel_context_render_string (self, _tmp14_, symbol, _tmp15_, _tmp16_);
	_tmp17_ = image;
	cairo_surface_flush (_tmp17_);
	_tmp18_ = self->priv->m_icon_type;
	if (_tmp18_ == PANEL_ICON_TYPE_INDICATOR) {
		if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
			guint* data = NULL;
			cairo_surface_t* _tmp19_;
			guchar* _tmp20_;
			gint data_length1;
			gint _data_size_;
			gint length = 0;
			gint _tmp21_;
			gint _tmp22_;
			_tmp19_ = image;
			_tmp20_ = cairo_image_surface_get_data (_tmp19_);
			data = (guint*) _tmp20_;
			data_length1 = (-1 * sizeof (guchar)) / sizeof (guint);
			_data_size_ = data_length1;
			_tmp21_ = stride;
			_tmp22_ = height;
			length = (_tmp21_ * _tmp22_) / ((gint) sizeof (guint));
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp23_ = FALSE;
					_tmp23_ = TRUE;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						guint* _tmp27_;
						gint _tmp27__length1;
						gint _tmp28_;
						guint* _tmp29_;
						gint _tmp29__length1;
						gint _tmp30_;
						guint _tmp31_;
						guint _tmp32_;
						if (!_tmp23_) {
							gint _tmp24_;
							_tmp24_ = i;
							i = _tmp24_ + 1;
						}
						_tmp23_ = FALSE;
						_tmp25_ = i;
						_tmp26_ = length;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = data;
						_tmp27__length1 = data_length1;
						_tmp28_ = i;
						_tmp29_ = data;
						_tmp29__length1 = data_length1;
						_tmp30_ = i;
						_tmp31_ = _tmp29_[_tmp30_];
						_tmp27_[_tmp28_] = GUINT_TO_BE (_tmp31_);
						_tmp32_ = _tmp27_[_tmp28_];
					}
				}
			}
		}
	}
	if (cache) {
		GHashTable* _tmp33_;
		gchar* _tmp34_;
		cairo_surface_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		_tmp33_ = self->priv->m_xkb_icon_image;
		_tmp34_ = g_strdup (symbol);
		_tmp35_ = image;
		_tmp36_ = _cairo_surface_reference0 (_tmp35_);
		g_hash_table_insert (_tmp33_, _tmp34_, _tmp36_);
	}
	result = image;
	_cairo_destroy0 (cr);
	return result;
}


static GdkPixbuf*
panel_create_icon_pixbuf_with_string (Panel* self,
                                      const gchar* symbol)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	cairo_surface_t* image = NULL;
	cairo_surface_t* _tmp4_;
	gint width = 0;
	cairo_surface_t* _tmp5_;
	gint height = 0;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GdkPixbuf* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->m_xkb_icon_pixbufs;
	_tmp1_ = g_hash_table_lookup (_tmp0_, symbol);
	_tmp2_ = _g_object_ref0 ((GdkPixbuf*) _tmp1_);
	pixbuf = _tmp2_;
	_tmp3_ = pixbuf;
	if (_tmp3_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp4_ = panel_create_cairo_image_surface_with_string (self, symbol, FALSE);
	image = _tmp4_;
	_tmp5_ = image;
	width = cairo_image_surface_get_width (_tmp5_);
	_tmp6_ = image;
	height = cairo_image_surface_get_height (_tmp6_);
	_tmp7_ = image;
	_tmp8_ = width;
	_tmp9_ = height;
	_tmp10_ = gdk_pixbuf_get_from_surface (_tmp7_, 0, 0, _tmp8_, _tmp9_);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp10_;
	_tmp11_ = self->priv->m_xkb_icon_pixbufs;
	_tmp12_ = g_strdup (symbol);
	_tmp13_ = pixbuf;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp14_);
	result = pixbuf;
	_cairo_surface_destroy0 (image);
	return result;
}


static void
__lambda77_ (Panel* self,
             GPid pid,
             gint state)
{
	GPid _tmp0_;
	_tmp0_ = self->priv->m_setup_pid;
	if (pid != _tmp0_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	g_spawn_close_pid (pid);
}


static void
___lambda77__gchild_watch_func (GPid pid,
                                gint status,
                                gpointer self)
{
	__lambda77_ ((Panel*) self, pid, status);
}


static void
panel_show_setup_dialog (Panel* self)
{
	GPid _tmp0_;
	gchar* binary = NULL;
	gchar* _tmp2_;
	GPid _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		_tmp1_ = self->priv->m_setup_pid;
		if (kill ((pid_t) _tmp1_, SIGUSR1) == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp2_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		GPid _tmp8_ = 0;
		_tmp3_ = binary;
		_tmp4_ = g_strdup (_tmp3_);
		_tmp5_ = g_strdup ("ibus-setup");
		_tmp6_ = g_new0 (gchar*, 2 + 1);
		_tmp6_[0] = _tmp4_;
		_tmp6_[1] = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp7__length1 = 2;
		g_spawn_async (NULL, _tmp7_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp8_, &_inner_error_);
		self->priv->m_setup_pid = _tmp8_;
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch14_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally14;
	__catch14_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = binary;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("panel.vala:1096: Execute %s failed! %s", _tmp9_, _tmp11_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp12_, ___lambda77__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void
panel_show_about_dialog (Panel* self)
{
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		gchar* copyright = NULL;
		gchar* _tmp4_;
		GtkAboutDialog* _tmp5_;
		const gchar* _tmp6_;
		GtkAboutDialog* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		GtkAboutDialog* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkAboutDialog* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		GtkAboutDialog* _tmp18_;
		GtkAboutDialog* _tmp19_;
		GtkAboutDialog* _tmp20_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = g_strdup ("Copyright © 2007-2015 Peng Huang\n" "Copyright © 2015 Takao Fujiwara\n" "Copyright © 2007-2015 Red Hat, Inc.\n");
		copyright = _tmp4_;
		_tmp5_ = self->priv->m_about_dialog;
		_tmp6_ = copyright;
		gtk_about_dialog_set_copyright (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp7_, "LGPL");
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_comments (_tmp8_, _ ("IBus is an intelligent input bus for Linux/Unix."));
		_tmp9_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp9_, "https://github.com/ibus/ibus/wiki");
		_tmp10_ = self->priv->m_about_dialog;
		_tmp11_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		gtk_about_dialog_set_authors (_tmp10_, _tmp13_);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->priv->m_about_dialog;
		_tmp15_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp16_ = g_new0 (gchar*, 1 + 1);
		_tmp16_[0] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp14_, _tmp17_);
		_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_translator_credits (_tmp18_, _ ("translator-credits"));
		_tmp19_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp19_, "ibus");
		_tmp20_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp20_, "ibus");
		_g_free0 (copyright);
	}
	_tmp21_ = self->priv->m_about_dialog;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp21_)) {
		GtkAboutDialog* _tmp22_;
		GtkAboutDialog* _tmp23_;
		_tmp22_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp22_);
		_tmp23_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp23_);
	} else {
		GtkAboutDialog* _tmp24_;
		_tmp24_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp24_);
	}
}


static void
___lambda76_ (Panel* self,
              GtkMenuItem* i)
{
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void
____lambda76__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda76_ ((Panel*) self, _sender);
}


static void
___lambda78_ (Panel* self,
              GtkMenuItem* i)
{
	IBusExtensionEvent* event = NULL;
	IBusExtensionEvent* _tmp0_;
	IBusExtensionEvent* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = ibus_extension_event_new ("name", "emoji", "is-enabled", TRUE, "params", "category-list", NULL);
	g_object_ref_sink (_tmp0_);
	event = _tmp0_;
	_tmp1_ = _g_object_ref0 (event);
	ibus_panel_service_panel_extension ((IBusPanelService*) self, _tmp1_);
	_g_object_unref0 (event);
}


static void
____lambda78__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda78_ ((Panel*) self, _sender);
}


static void
___lambda79_ (Panel* self,
              GtkMenuItem* i)
{
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void
____lambda79__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda79_ ((Panel*) self, _sender);
}


static void
___lambda80_ (Panel* self,
              GtkMenuItem* i)
{
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void
____lambda80__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda80_ ((Panel*) self, _sender);
}


static void
___lambda81_ (Panel* self,
              GtkMenuItem* i)
{
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void
____lambda81__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda81_ ((Panel*) self, _sender);
}


static GtkMenu*
panel_create_context_menu (Panel* self)
{
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp26_;
	GtkMenu* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkMenuItem* item = NULL;
		GtkMenu* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		GtkMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenuItem* _tmp10_;
		GtkMenuItem* _tmp11_;
		GtkMenu* _tmp12_;
		GtkMenuItem* _tmp13_;
		GtkMenu* _tmp14_;
		GtkSeparatorMenuItem* _tmp15_;
		GtkSeparatorMenuItem* _tmp16_;
		GtkMenuItem* _tmp17_;
		GtkMenuItem* _tmp18_;
		GtkMenu* _tmp19_;
		GtkMenuItem* _tmp20_;
		GtkMenuItem* _tmp21_;
		GtkMenuItem* _tmp22_;
		GtkMenu* _tmp23_;
		GtkMenuItem* _tmp24_;
		GtkMenu* _tmp25_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Preferences"));
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object (_tmp3_, "activate", (GCallback) ____lambda76__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, _tmp5_);
		_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Emoji Choice"));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object (_tmp7_, "activate", (GCallback) ____lambda78__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, _tmp9_);
		_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("About"));
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (item);
		item = _tmp10_;
		_tmp11_ = item;
		g_signal_connect_object (_tmp11_, "activate", (GCallback) ____lambda79__gtk_menu_item_activate, self, 0);
		_tmp12_ = self->priv->m_sys_menu;
		_tmp13_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->m_sys_menu;
		_tmp15_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp14_, (GtkMenuItem*) _tmp16_);
		_g_object_unref0 (_tmp16_);
		_tmp17_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Restart"));
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (item);
		item = _tmp17_;
		_tmp18_ = item;
		g_signal_connect_object (_tmp18_, "activate", (GCallback) ____lambda80__gtk_menu_item_activate, self, 0);
		_tmp19_ = self->priv->m_sys_menu;
		_tmp20_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp19_, _tmp20_);
		_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Quit"));
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (item);
		item = _tmp21_;
		_tmp22_ = item;
		g_signal_connect_object (_tmp22_, "activate", (GCallback) ____lambda81__gtk_menu_item_activate, self, 0);
		_tmp23_ = self->priv->m_sys_menu;
		_tmp24_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, _tmp24_);
		_tmp25_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp25_);
		_g_object_unref0 (item);
	}
	_tmp26_ = self->priv->m_sys_menu;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	result = _tmp27_;
	return result;
}


static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		Panel* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->e);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void
____lambda83_ (Block8Data* _data8_,
               GtkMenuItem* item)
{
	Panel* self;
	self = _data8_->self;
	g_return_if_fail (item != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				IBusEngineDesc** _tmp3_;
				gint _tmp3__length1;
				IBusEngineDesc* _tmp4_;
				IBusEngineDesc** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				IBusEngineDesc* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->m_engines;
				_tmp3__length1 = self->priv->m_engines_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = _data8_->e;
				_tmp5_ = self->priv->m_engines;
				_tmp5__length1 = self->priv->m_engines_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				if (_tmp4_ == _tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					panel_switch_engine (self, _tmp8_, FALSE);
					break;
				}
			}
		}
	}
}


static void
_____lambda83__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	____lambda83_ (self, _sender);
}


static GtkMenu*
panel_create_activate_menu (Panel* self)
{
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	PropertyManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	GtkMenu* _tmp32_;
	GtkMenu* _tmp33_;
	GtkMenu* _tmp34_;
	GtkMenu* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkMenuItem*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->m_engines;
	_tmp6__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp6_;
		engine_collection_length1 = _tmp6__length1;
		for (engine_it = 0; engine_it < _tmp6__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp7_;
			IBusEngineDesc* engine = NULL;
			_tmp7_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp7_;
			{
				Block8Data* _data8_;
				gchar* language = NULL;
				IBusEngineDesc* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* textdomain = NULL;
				IBusEngineDesc* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* transname = NULL;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				GtkMenuItem* item = NULL;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GtkMenuItem* _tmp25_;
				GtkMenuItem* _tmp26_;
				IBusEngineDesc* _tmp27_;
				IBusEngineDesc* _tmp28_;
				GtkMenuItem* _tmp29_;
				GtkMenu* _tmp30_;
				GtkMenuItem* _tmp31_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->self = g_object_ref (self);
				_tmp8_ = engine;
				_tmp9_ = ibus_engine_desc_get_language (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				language = _tmp10_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_longname (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				longname = _tmp13_;
				_tmp14_ = engine;
				_tmp15_ = ibus_engine_desc_get_textdomain (_tmp14_);
				_tmp16_ = g_strdup (_tmp15_);
				textdomain = _tmp16_;
				_tmp17_ = textdomain;
				_tmp18_ = longname;
				_tmp19_ = g_strdup (g_dgettext (_tmp17_, _tmp18_));
				transname = _tmp19_;
				_tmp20_ = language;
				_tmp21_ = ibus_get_language_name (_tmp20_);
				_tmp22_ = transname;
				_tmp23_ = g_strdup_printf ("%s - %s", _tmp21_, _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp24_);
				g_object_ref_sink (_tmp25_);
				_tmp26_ = _tmp25_;
				_g_free0 (_tmp24_);
				item = _tmp26_;
				_tmp27_ = engine;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_data8_->e = _tmp28_;
				_tmp29_ = item;
				g_signal_connect_data (_tmp29_, "activate", (GCallback) _____lambda83__gtk_menu_item_activate, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_tmp30_ = self->priv->m_ime_menu;
				_tmp31_ = item;
				gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
				_g_object_unref0 (item);
				_g_free0 (transname);
				_g_free0 (textdomain);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block8_data_unref (_data8_);
				_data8_ = NULL;
			}
		}
	}
	_tmp32_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp33_, FALSE);
	_tmp34_ = self->priv->m_ime_menu;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	result = _tmp35_;
	return result;
}


static void
panel_set_properties (Panel* self,
                      IBusPropList* props)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		gint _tmp0_;
		IBusProperty* _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		gint _tmp4_;
		IBusProperty* _tmp5_;
		gint _tmp6_;
		_tmp0_ = i;
		_tmp1_ = ibus_prop_list_get (props, (guint) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		prop = _tmp2_;
		_tmp3_ = prop;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp4_ = i;
		_tmp5_ = ibus_prop_list_get (props, (guint) _tmp4_);
		panel_set_property (self, _tmp5_, TRUE);
		_tmp6_ = i;
		i = _tmp6_ + 1;
		_g_object_unref0 (prop);
	}
}


static void
panel_set_property (Panel* self,
                    IBusProperty* prop,
                    gboolean all_update)
{
	gchar* symbol = NULL;
	IBusText* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = ibus_property_get_symbol (prop);
	_tmp1_ = ibus_text_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	symbol = _tmp2_;
	_tmp5_ = self->priv->m_icon_prop_key;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = ibus_property_get_key (prop);
		_tmp7_ = self->priv->m_icon_prop_key;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp8_;
		_tmp8_ = symbol;
		_tmp3_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp9_;
		_tmp9_ = symbol;
		panel_animate_icon (self, _tmp9_, all_update);
	}
	_g_free0 (symbol);
}


static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		Panel* self;
		self = _data9_->self;
		_g_free0 (_data9_->symbol);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean
__lambda94_ (Block9Data* _data9_)
{
	Panel* self;
	gboolean result = FALSE;
	PanelIconType _tmp0_;
	self = _data9_->self;
	self->priv->m_property_icon_delay_time_id = (guint) 0;
	_tmp0_ = self->priv->m_icon_type;
	if (_tmp0_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp1_;
		GtkStatusIcon* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp1_ = panel_create_icon_pixbuf_with_string (self, _data9_->symbol);
		pixbuf = _tmp1_;
		_tmp2_ = self->priv->m_status_icon;
		_tmp3_ = pixbuf;
		gtk_status_icon_set_from_pixbuf (_tmp2_, _tmp3_);
		_g_object_unref0 (pixbuf);
	} else {
		PanelIconType _tmp4_;
		_tmp4_ = self->priv->m_icon_type;
		if (_tmp4_ == PANEL_ICON_TYPE_INDICATOR) {
			cairo_surface_t* image = NULL;
			cairo_surface_t* _tmp5_;
			Indicator* _tmp6_;
			cairo_surface_t* _tmp7_;
			_tmp5_ = panel_create_cairo_image_surface_with_string (self, _data9_->symbol, TRUE);
			image = _tmp5_;
			_tmp6_ = self->priv->m_indicator;
			_tmp7_ = image;
			indicator_set_cairo_image_surface_full (_tmp6_, _tmp7_, "");
			_cairo_surface_destroy0 (image);
		}
	}
	result = FALSE;
	return result;
}


static gboolean
___lambda94__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda94_ (self);
	return result;
}


static void
panel_animate_icon (Panel* self,
                    const gchar* symbol,
                    gboolean all_update)
{
	Block9Data* _data9_;
	gchar* _tmp0_;
	gint _tmp1_;
	guint timeout = 0U;
	guint _tmp3_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = g_strdup (symbol);
	_g_free0 (_data9_->symbol);
	_data9_->symbol = _tmp0_;
	_tmp1_ = self->priv->m_property_icon_delay_time;
	if (_tmp1_ < 0) {
		block9_data_unref (_data9_);
		_data9_ = NULL;
		return;
	}
	timeout = (guint) 0;
	if (all_update) {
		gint _tmp2_;
		_tmp2_ = self->priv->m_property_icon_delay_time;
		timeout = (guint) _tmp2_;
	}
	_tmp3_ = self->priv->m_property_icon_delay_time_id;
	if (_tmp3_ > ((guint) 0)) {
		guint _tmp4_;
		_tmp4_ = self->priv->m_property_icon_delay_time_id;
		g_source_remove (_tmp4_);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	_tmp5_ = timeout;
	self->priv->m_property_icon_delay_time_id = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp5_, ___lambda94__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static void
panel_real_set_cursor_location (IBusPanelService* base,
                                gint x,
                                gint y,
                                gint width,
                                gint height)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_cursor_location (_tmp0_, x, y, width, height);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_set_cursor_location (_tmp1_, x, y, width, height);
}


static gboolean
panel_switcher_focus_set_engine_real (Panel* self)
{
	gboolean result = FALSE;
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = prev_context_path;
		_tmp9_ = self->priv->m_current_context_path;
		_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		IBusEngineDesc* _tmp10_;
		Switcher* _tmp11_;
		_tmp10_ = selected_engine;
		panel_set_engine (self, _tmp10_);
		_tmp11_ = self->priv->m_switcher;
		switcher_reset (_tmp11_);
		result = TRUE;
		_g_free0 (prev_context_path);
		_g_object_unref0 (selected_engine);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
	return result;
}


static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean
___lambda63_ (Panel* self)
{
	gboolean result = FALSE;
	panel_switcher_focus_set_engine_real (self);
	self->priv->m_switcher_focus_set_engine_id = (guint) -1;
	result = FALSE;
	return result;
}


static gboolean
____lambda63__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda63_ ((Panel*) self);
	return result;
}


static void
panel_switcher_focus_set_engine (Panel* self)
{
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Switcher* _tmp8_;
		_tmp8_ = self->priv->m_switcher;
		_tmp4_ = switcher_is_running (_tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GMainContext* context = NULL;
		GMainContext* _tmp9_;
		GMainContext* _tmp10_;
		gboolean _tmp11_ = FALSE;
		guint _tmp12_;
		_tmp9_ = g_main_context_default ();
		_tmp10_ = _g_main_context_ref0 (_tmp9_);
		context = _tmp10_;
		_tmp12_ = self->priv->m_switcher_focus_set_engine_id;
		if (_tmp12_ > ((guint) 0)) {
			GMainContext* _tmp13_;
			guint _tmp14_;
			GSource* _tmp15_;
			_tmp13_ = context;
			_tmp14_ = self->priv->m_switcher_focus_set_engine_id;
			_tmp15_ = g_main_context_find_source_by_id (_tmp13_, _tmp14_);
			_tmp11_ = _tmp15_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			guint _tmp16_;
			_tmp16_ = self->priv->m_switcher_focus_set_engine_id;
			g_source_remove (_tmp16_);
		}
		self->priv->m_switcher_focus_set_engine_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda63__gsource_func, g_object_ref (self), g_object_unref);
		_g_main_context_unref0 (context);
	} else {
		if (panel_switcher_focus_set_engine_real (self)) {
			GMainContext* context = NULL;
			GMainContext* _tmp17_;
			GMainContext* _tmp18_;
			gboolean _tmp19_ = FALSE;
			guint _tmp20_;
			_tmp17_ = g_main_context_default ();
			_tmp18_ = _g_main_context_ref0 (_tmp17_);
			context = _tmp18_;
			_tmp20_ = self->priv->m_switcher_focus_set_engine_id;
			if (_tmp20_ > ((guint) 0)) {
				GMainContext* _tmp21_;
				guint _tmp22_;
				GSource* _tmp23_;
				_tmp21_ = context;
				_tmp22_ = self->priv->m_switcher_focus_set_engine_id;
				_tmp23_ = g_main_context_find_source_by_id (_tmp21_, _tmp22_);
				_tmp19_ = _tmp23_ != NULL;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				guint _tmp24_;
				_tmp24_ = self->priv->m_switcher_focus_set_engine_id;
				g_source_remove (_tmp24_);
			}
			self->priv->m_switcher_focus_set_engine_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
}


static void
panel_real_focus_in (IBusPanelService* base,
                     const gchar* input_context_path)
{
	Panel * self;
	gchar* _tmp0_;
	gboolean _tmp4_;
	IBusEngineDesc* engine = NULL;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	IBusEngineDesc* _tmp7_;
	IBusEngineDesc* _tmp8_;
	IBusEngineDesc* _tmp22_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup (input_context_path);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
	if (!g_str_has_suffix (input_context_path, "InputContext_1")) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		PropertyPanel* _tmp3_;
		_tmp1_ = self->priv->m_current_context_path;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->m_real_current_context_path);
		self->priv->m_real_current_context_path = _tmp2_;
		_tmp3_ = self->priv->m_property_panel;
		property_panel_focus_in (_tmp3_);
		panel_switcher_focus_set_engine (self);
	}
	_tmp4_ = self->priv->m_use_global_engine;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->m_engine_contexts;
	_tmp6_ = g_hash_table_lookup (_tmp5_, input_context_path);
	_tmp7_ = _g_object_ref0 ((IBusEngineDesc*) _tmp6_);
	engine = _tmp7_;
	_tmp8_ = engine;
	if (_tmp8_ == NULL) {
		IBusEngineDesc* _tmp9_ = NULL;
		IBusEngineDesc** _tmp10_;
		gint _tmp10__length1;
		IBusEngineDesc* _tmp13_;
		IBusEngineDesc* _tmp14_;
		_tmp10_ = self->priv->m_engines;
		_tmp10__length1 = self->priv->m_engines_length1;
		if (_tmp10__length1 > 0) {
			IBusEngineDesc** _tmp11_;
			gint _tmp11__length1;
			IBusEngineDesc* _tmp12_;
			_tmp11_ = self->priv->m_engines;
			_tmp11__length1 = self->priv->m_engines_length1;
			_tmp12_ = _tmp11_[0];
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = NULL;
		}
		_tmp13_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (engine);
		engine = _tmp13_;
		_tmp14_ = engine;
		if (_tmp14_ == NULL) {
			_g_object_unref0 (engine);
			return;
		}
	} else {
		gboolean in_engines = FALSE;
		IBusEngineDesc** _tmp15_;
		gint _tmp15__length1;
		gboolean _tmp21_;
		in_engines = FALSE;
		_tmp15_ = self->priv->m_engines;
		_tmp15__length1 = self->priv->m_engines_length1;
		{
			IBusEngineDesc** e_collection = NULL;
			gint e_collection_length1 = 0;
			gint _e_collection_size_ = 0;
			gint e_it = 0;
			e_collection = _tmp15_;
			e_collection_length1 = _tmp15__length1;
			for (e_it = 0; e_it < _tmp15__length1; e_it = e_it + 1) {
				IBusEngineDesc* _tmp16_;
				IBusEngineDesc* e = NULL;
				_tmp16_ = _g_object_ref0 (e_collection[e_it]);
				e = _tmp16_;
				{
					IBusEngineDesc* _tmp17_;
					const gchar* _tmp18_;
					IBusEngineDesc* _tmp19_;
					const gchar* _tmp20_;
					_tmp17_ = engine;
					_tmp18_ = ibus_engine_desc_get_name (_tmp17_);
					_tmp19_ = e;
					_tmp20_ = ibus_engine_desc_get_name (_tmp19_);
					if (g_strcmp0 (_tmp18_, _tmp20_) == 0) {
						in_engines = TRUE;
						_g_object_unref0 (e);
						break;
					}
					_g_object_unref0 (e);
				}
			}
		}
		_tmp21_ = in_engines;
		if (!_tmp21_) {
			_g_object_unref0 (engine);
			return;
		}
	}
	_tmp22_ = engine;
	panel_set_engine (self, _tmp22_);
	_g_object_unref0 (engine);
}


static void
panel_real_focus_out (IBusPanelService* base,
                      const gchar* input_context_path)
{
	Panel * self;
	gchar* _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
}


static void
panel_real_destroy_context (IBusPanelService* base,
                            const gchar* input_context_path)
{
	Panel * self;
	gboolean _tmp0_;
	GHashTable* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	g_hash_table_remove (_tmp1_, input_context_path);
}


static void
panel_real_register_properties (IBusPanelService* base,
                                IBusPropList* props)
{
	Panel * self;
	PropertyManager* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	property_manager_set_properties (_tmp0_, props);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_set_properties (_tmp1_, props);
	panel_set_properties (self, props);
}


static void
panel_real_update_property (IBusPanelService* base,
                            IBusProperty* prop)
{
	Panel * self;
	PropertyManager* _tmp0_;
	PropertyPanel* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	property_manager_update_property (_tmp0_, prop);
	_tmp1_ = self->priv->m_property_panel;
	property_panel_update_property (_tmp1_, prop);
	panel_set_property (self, prop, FALSE);
}


static void
panel_real_update_preedit_text (IBusPanelService* base,
                                IBusText* text,
                                guint cursor_pos,
                                gboolean visible)
{
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	if (visible) {
		CandidatePanel* _tmp0_;
		PropertyPanel* _tmp1_;
		_tmp0_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp0_, text, cursor_pos);
		_tmp1_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp1_, text, cursor_pos);
	} else {
		CandidatePanel* _tmp2_;
		PropertyPanel* _tmp3_;
		_tmp2_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp2_, NULL, (guint) 0);
		_tmp3_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp3_, NULL, (guint) 0);
	}
}


static void
panel_real_hide_preedit_text (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void
panel_real_update_auxiliary_text (IBusPanelService* base,
                                  IBusText* text,
                                  gboolean visible)
{
	Panel * self;
	IBusText* _tmp0_ = NULL;
	CandidatePanel* _tmp1_;
	IBusText* _tmp2_ = NULL;
	PropertyPanel* _tmp3_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	if (visible) {
		_tmp0_ = text;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp1_, _tmp0_);
	if (visible) {
		_tmp2_ = text;
	} else {
		_tmp2_ = NULL;
	}
	_tmp3_ = self->priv->m_property_panel;
	property_panel_set_auxiliary_text (_tmp3_, _tmp2_);
}


static void
panel_real_hide_auxiliary_text (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void
panel_real_update_lookup_table (IBusPanelService* base,
                                IBusLookupTable* table,
                                gboolean visible)
{
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	CandidatePanel* _tmp1_;
	IBusLookupTable* _tmp2_ = NULL;
	PropertyPanel* _tmp3_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	if (visible) {
		_tmp0_ = table;
	} else {
		_tmp0_ = NULL;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp1_, _tmp0_);
	if (visible) {
		_tmp2_ = table;
	} else {
		_tmp2_ = NULL;
	}
	_tmp3_ = self->priv->m_property_panel;
	property_panel_set_lookup_table (_tmp3_, _tmp2_);
}


static void
panel_real_hide_lookup_table (IBusPanelService* base)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static void
panel_real_set_content_type (IBusPanelService* base,
                             guint purpose,
                             guint hints)
{
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_content_type (_tmp0_, purpose, hints);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static void
_vala_array_add22 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
panel_real_state_changed (IBusPanelService* base)
{
	Panel * self;
	Switcher* _tmp0_;
	PanelIconType _tmp1_;
	gchar* icon_name = NULL;
	gchar* _tmp3_;
	IBusEngineDesc* engine = NULL;
	IBusBus* _tmp4_;
	IBusEngineDesc* _tmp5_;
	IBusEngineDesc* _tmp6_;
	const gchar* _tmp14_;
	IBusEngineDesc* _tmp63_;
	gint i = 0;
	gint _tmp74_;
	gint _tmp75_;
	IBusEngineDesc** _tmp76_;
	gint _tmp76__length1;
	IBusEngineDesc** _tmp88_;
	gint _tmp88__length1;
	IBusEngineDesc* _tmp89_;
	IBusEngineDesc* _tmp90_;
	IBusEngineDesc* _tmp91_;
	gchar** names = NULL;
	gchar** _tmp92_;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp93_;
	gint _tmp93__length1;
	GSettings* _tmp99_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_switcher;
	if (switcher_is_running (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->m_icon_type;
	if (_tmp1_ == PANEL_ICON_TYPE_INDICATOR) {
		Indicator* _tmp2_;
		_tmp2_ = self->priv->m_indicator;
		if (_tmp2_ == NULL) {
			return;
		}
	}
	_tmp3_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp3_;
	_tmp4_ = self->priv->m_bus;
	_tmp5_ = ibus_bus_get_global_engine (_tmp4_);
	engine = _tmp5_;
	_tmp6_ = engine;
	if (_tmp6_ != NULL) {
		IBusEngineDesc* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		IBusEngineDesc* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = engine;
		_tmp8_ = ibus_engine_desc_get_icon (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (icon_name);
		icon_name = _tmp9_;
		_tmp10_ = engine;
		_tmp11_ = ibus_engine_desc_get_icon_prop_key (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp12_;
	} else {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("");
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp13_;
	}
	_tmp14_ = icon_name;
	if (string_get (_tmp14_, (glong) 0) == '/') {
		PanelIconType _tmp15_;
		_tmp15_ = self->priv->m_icon_type;
		if (_tmp15_ == PANEL_ICON_TYPE_STATUS_ICON) {
			GtkStatusIcon* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = self->priv->m_status_icon;
			_tmp17_ = icon_name;
			gtk_status_icon_set_from_file (_tmp16_, _tmp17_);
		} else {
			PanelIconType _tmp18_;
			_tmp18_ = self->priv->m_icon_type;
			if (_tmp18_ == PANEL_ICON_TYPE_INDICATOR) {
				Indicator* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = self->priv->m_indicator;
				_tmp20_ = icon_name;
				indicator_set_icon_full (_tmp19_, _tmp20_, "");
			}
		}
	} else {
		gchar* language = NULL;
		IBusEngineDesc* _tmp21_;
		const gchar* _tmp35_;
		language = NULL;
		_tmp21_ = engine;
		if (_tmp21_ != NULL) {
			gchar* name = NULL;
			IBusEngineDesc* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp22_ = engine;
			_tmp23_ = ibus_engine_desc_get_name (_tmp22_);
			_tmp24_ = g_strdup (_tmp23_);
			name = _tmp24_;
			_tmp26_ = name;
			_tmp27_ = strlen (_tmp26_);
			_tmp28_ = _tmp27_;
			if (_tmp28_ >= 4) {
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = name;
				_tmp30_ = string_slice (_tmp29_, (glong) 0, (glong) 4);
				_tmp31_ = _tmp30_;
				_tmp25_ = g_strcmp0 (_tmp31_, "xkb:") == 0;
				_g_free0 (_tmp31_);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				Switcher* _tmp32_;
				IBusEngineDesc* _tmp33_;
				gchar* _tmp34_;
				_tmp32_ = self->priv->m_switcher;
				_tmp33_ = engine;
				_tmp34_ = switcher_get_xkb_language (_tmp32_, _tmp33_);
				_g_free0 (language);
				language = _tmp34_;
			}
			_g_free0 (name);
		}
		_tmp35_ = language;
		if (_tmp35_ != NULL) {
			PanelIconType _tmp36_;
			_tmp36_ = self->priv->m_icon_type;
			if (_tmp36_ == PANEL_ICON_TYPE_STATUS_ICON) {
				GdkPixbuf* pixbuf = NULL;
				const gchar* _tmp37_;
				GdkPixbuf* _tmp38_;
				GtkStatusIcon* _tmp39_;
				GdkPixbuf* _tmp40_;
				_tmp37_ = language;
				_tmp38_ = panel_create_icon_pixbuf_with_string (self, _tmp37_);
				pixbuf = _tmp38_;
				_tmp39_ = self->priv->m_status_icon;
				_tmp40_ = pixbuf;
				gtk_status_icon_set_from_pixbuf (_tmp39_, _tmp40_);
				_g_object_unref0 (pixbuf);
			} else {
				PanelIconType _tmp41_;
				_tmp41_ = self->priv->m_icon_type;
				if (_tmp41_ == PANEL_ICON_TYPE_INDICATOR) {
					cairo_surface_t* image = NULL;
					const gchar* _tmp42_;
					cairo_surface_t* _tmp43_;
					Indicator* _tmp44_;
					cairo_surface_t* _tmp45_;
					_tmp42_ = language;
					_tmp43_ = panel_create_cairo_image_surface_with_string (self, _tmp42_, TRUE);
					image = _tmp43_;
					_tmp44_ = self->priv->m_indicator;
					_tmp45_ = image;
					indicator_set_cairo_image_surface_full (_tmp44_, _tmp45_, "");
					_cairo_surface_destroy0 (image);
				}
			}
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp46_;
			GtkIconTheme* _tmp47_;
			GtkIconTheme* _tmp48_;
			const gchar* _tmp49_;
			GtkIconInfo* _tmp50_;
			GtkIconInfo* _tmp51_;
			gboolean _tmp52_;
			_tmp46_ = gtk_icon_theme_get_default ();
			_tmp47_ = _g_object_ref0 (_tmp46_);
			theme = _tmp47_;
			_tmp48_ = theme;
			_tmp49_ = icon_name;
			_tmp50_ = gtk_icon_theme_lookup_icon (_tmp48_, _tmp49_, 48, 0);
			_tmp51_ = _tmp50_;
			_tmp52_ = _tmp51_ != NULL;
			_gtk_icon_info_free0 (_tmp51_);
			if (_tmp52_) {
				PanelIconType _tmp53_;
				_tmp53_ = self->priv->m_icon_type;
				if (_tmp53_ == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = self->priv->m_status_icon;
					_tmp55_ = icon_name;
					gtk_status_icon_set_from_icon_name (_tmp54_, _tmp55_);
				} else {
					PanelIconType _tmp56_;
					_tmp56_ = self->priv->m_icon_type;
					if (_tmp56_ == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp57_;
						const gchar* _tmp58_;
						_tmp57_ = self->priv->m_indicator;
						_tmp58_ = icon_name;
						indicator_set_icon_full (_tmp57_, _tmp58_, "");
					}
				}
			} else {
				PanelIconType _tmp59_;
				_tmp59_ = self->priv->m_icon_type;
				if (_tmp59_ == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp60_;
					_tmp60_ = self->priv->m_status_icon;
					gtk_status_icon_set_from_icon_name (_tmp60_, "ibus-engine");
				} else {
					PanelIconType _tmp61_;
					_tmp61_ = self->priv->m_icon_type;
					if (_tmp61_ == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp62_;
						_tmp62_ = self->priv->m_indicator;
						indicator_set_icon_full (_tmp62_, "ibus-engine", "");
					}
				}
			}
			_g_object_unref0 (theme);
		}
		_g_free0 (language);
	}
	_tmp63_ = engine;
	if (_tmp63_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp64_ = FALSE;
		i = 0;
		_tmp64_ = TRUE;
		while (TRUE) {
			gint _tmp66_;
			IBusEngineDesc** _tmp67_;
			gint _tmp67__length1;
			IBusEngineDesc** _tmp68_;
			gint _tmp68__length1;
			gint _tmp69_;
			IBusEngineDesc* _tmp70_;
			const gchar* _tmp71_;
			IBusEngineDesc* _tmp72_;
			const gchar* _tmp73_;
			if (!_tmp64_) {
				gint _tmp65_;
				_tmp65_ = i;
				i = _tmp65_ + 1;
			}
			_tmp64_ = FALSE;
			_tmp66_ = i;
			_tmp67_ = self->priv->m_engines;
			_tmp67__length1 = self->priv->m_engines_length1;
			if (!(_tmp66_ < _tmp67__length1)) {
				break;
			}
			_tmp68_ = self->priv->m_engines;
			_tmp68__length1 = self->priv->m_engines_length1;
			_tmp69_ = i;
			_tmp70_ = _tmp68_[_tmp69_];
			_tmp71_ = ibus_engine_desc_get_name (_tmp70_);
			_tmp72_ = engine;
			_tmp73_ = ibus_engine_desc_get_name (_tmp72_);
			if (g_strcmp0 (_tmp71_, _tmp73_) == 0) {
				break;
			}
		}
	}
	_tmp74_ = i;
	if (_tmp74_ == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp75_ = i;
	_tmp76_ = self->priv->m_engines;
	_tmp76__length1 = self->priv->m_engines_length1;
	if (_tmp75_ >= _tmp76__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint j = 0;
		gint _tmp77_;
		_tmp77_ = i;
		j = _tmp77_;
		{
			gboolean _tmp78_ = FALSE;
			_tmp78_ = TRUE;
			while (TRUE) {
				gint _tmp80_;
				IBusEngineDesc** _tmp81_;
				gint _tmp81__length1;
				gint _tmp82_;
				IBusEngineDesc** _tmp83_;
				gint _tmp83__length1;
				gint _tmp84_;
				IBusEngineDesc* _tmp85_;
				IBusEngineDesc* _tmp86_;
				IBusEngineDesc* _tmp87_;
				if (!_tmp78_) {
					gint _tmp79_;
					_tmp79_ = j;
					j = _tmp79_ - 1;
				}
				_tmp78_ = FALSE;
				_tmp80_ = j;
				if (!(_tmp80_ > 0)) {
					break;
				}
				_tmp81_ = self->priv->m_engines;
				_tmp81__length1 = self->priv->m_engines_length1;
				_tmp82_ = j;
				_tmp83_ = self->priv->m_engines;
				_tmp83__length1 = self->priv->m_engines_length1;
				_tmp84_ = j;
				_tmp85_ = _tmp83_[_tmp84_ - 1];
				_tmp86_ = _g_object_ref0 (_tmp85_);
				_g_object_unref0 (_tmp81_[_tmp82_]);
				_tmp81_[_tmp82_] = _tmp86_;
				_tmp87_ = _tmp81_[_tmp82_];
			}
		}
	}
	_tmp88_ = self->priv->m_engines;
	_tmp88__length1 = self->priv->m_engines_length1;
	_tmp89_ = engine;
	_tmp90_ = _g_object_ref0 (_tmp89_);
	_g_object_unref0 (_tmp88_[0]);
	_tmp88_[0] = _tmp90_;
	_tmp91_ = _tmp88_[0];
	_tmp92_ = g_new0 (gchar*, 0 + 1);
	names = _tmp92_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp93_ = self->priv->m_engines;
	_tmp93__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp93_;
		desc_collection_length1 = _tmp93__length1;
		for (desc_it = 0; desc_it < _tmp93__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp94_;
			IBusEngineDesc* desc = NULL;
			_tmp94_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp94_;
			{
				gchar** _tmp95_;
				gint _tmp95__length1;
				IBusEngineDesc* _tmp96_;
				const gchar* _tmp97_;
				gchar* _tmp98_;
				_tmp95_ = names;
				_tmp95__length1 = names_length1;
				_tmp96_ = desc;
				_tmp97_ = ibus_engine_desc_get_name (_tmp96_);
				_tmp98_ = g_strdup (_tmp97_);
				_vala_array_add22 (&names, &names_length1, &_names_size_, _tmp98_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp99_ = self->priv->m_settings_general;
	_tmp100_ = names;
	_tmp100__length1 = names_length1;
	g_settings_set_strv (_tmp99_, "engines-order", _tmp100_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static void
panel_class_init (PanelClass * klass)
{
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	((IBusPanelServiceClass *) klass)->set_cursor_location = (void (*) (IBusPanelService *, gint, gint, gint, gint)) panel_real_set_cursor_location;
	((IBusPanelServiceClass *) klass)->focus_in = (void (*) (IBusPanelService *, const gchar*)) panel_real_focus_in;
	((IBusPanelServiceClass *) klass)->focus_out = (void (*) (IBusPanelService *, const gchar*)) panel_real_focus_out;
	((IBusPanelServiceClass *) klass)->destroy_context = (void (*) (IBusPanelService *, const gchar*)) panel_real_destroy_context;
	((IBusPanelServiceClass *) klass)->register_properties = (void (*) (IBusPanelService *, IBusPropList*)) panel_real_register_properties;
	((IBusPanelServiceClass *) klass)->update_property = (void (*) (IBusPanelService *, IBusProperty*)) panel_real_update_property;
	((IBusPanelServiceClass *) klass)->update_preedit_text = (void (*) (IBusPanelService *, IBusText*, guint, gboolean)) panel_real_update_preedit_text;
	((IBusPanelServiceClass *) klass)->hide_preedit_text = (void (*) (IBusPanelService *)) panel_real_hide_preedit_text;
	((IBusPanelServiceClass *) klass)->update_auxiliary_text = (void (*) (IBusPanelService *, IBusText*, gboolean)) panel_real_update_auxiliary_text;
	((IBusPanelServiceClass *) klass)->hide_auxiliary_text = (void (*) (IBusPanelService *)) panel_real_hide_auxiliary_text;
	((IBusPanelServiceClass *) klass)->update_lookup_table = (void (*) (IBusPanelService *, IBusLookupTable*, gboolean)) panel_real_update_lookup_table;
	((IBusPanelServiceClass *) klass)->hide_lookup_table = (void (*) (IBusPanelService *)) panel_real_hide_lookup_table;
	((IBusPanelServiceClass *) klass)->set_content_type = (void (*) (IBusPanelService *, guint, guint)) panel_real_set_content_type;
	((IBusPanelServiceClass *) klass)->state_changed = (void (*) (IBusPanelService *)) panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void
panel_instance_init (Panel * self)
{
	IBusEngineDesc** _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GdkRGBA _tmp12_ = {0};
	XKBLayout* _tmp13_;
	gchar* _tmp14_;
	self->priv = PANEL_GET_PRIVATE (self);
	self->priv->m_settings_general = NULL;
	self->priv->m_settings_hotkey = NULL;
	self->priv->m_settings_panel = NULL;
	self->priv->m_icon_type = PANEL_ICON_TYPE_STATUS_ICON;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	self->priv->m_engine_contexts = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->m_real_current_context_path = _tmp5_;
	self->priv->m_use_global_engine = TRUE;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_use_system_keyboard_layout = FALSE;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	self->priv->m_xkb_icon_pixbufs = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _cairo_surface_destroy0_);
	self->priv->m_xkb_icon_image = _tmp11_;
	memset (&_tmp12_, 0, sizeof (GdkRGBA));
	_tmp12_.red = 0.0;
	_tmp12_.green = 0.0;
	_tmp12_.blue = 0.0;
	_tmp12_.alpha = 1.0;
	self->priv->m_xkb_icon_rgba = _tmp12_;
	_tmp13_ = xkb_layout_new ();
	self->priv->m_xkblayout = _tmp13_;
	self->priv->inited_engines_order = TRUE;
	_tmp14_ = g_strdup ("");
	self->priv->m_icon_prop_key = _tmp14_;
	self->priv->m_property_icon_delay_time = 500;
	self->priv->m_is_kde = panel_is_kde ();
	self->priv->m_keybindings = NULL;
}


static void
panel_finalize (GObject * obj)
{
	Panel * self;
	Indicator* _tmp0_;
	GList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	_tmp0_ = self->priv->m_indicator;
	if (_tmp0_ != NULL) {
		Indicator* _tmp1_;
		_tmp1_ = self->priv->m_indicator;
		indicator_unregister_connection (_tmp1_);
	}
	_tmp2_ = self->priv->m_keybindings;
	binding_common_unbind_switch_shortcut (BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, _tmp2_);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	self->priv->m_keybindings = NULL;
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_settings_general);
	_g_object_unref0 (self->priv->m_settings_hotkey);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_indicator);
	_g_object_unref0 (self->priv->m_session_bus_connection);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->m_engine_contexts);
	_g_free0 (self->priv->m_current_context_path);
	_g_free0 (self->priv->m_real_current_context_path);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_property_panel);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_pixbufs);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_image);
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	_g_free0 (self->priv->m_icon_prop_key);
	(self->priv->m_keybindings == NULL) ? NULL : (self->priv->m_keybindings = (_g_list_free__g_object_unref0_ (self->priv->m_keybindings), NULL));
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType
panel_get_type (void)
{
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



