// nhx3L0J/cQCO/XlRytGXqHvRrOy5ZuUvjMo6R0a6VB4xpy64rSVJ/mgcE36x/Hp3dDYXbUL3zU7rZ3+Kr5oUIvdOrqlu2y39x10CkV2kdJwWEbcwRXmuktr5i1d8A45oACGnHtu0EJ26CfNNr80UzqydHRCLVkn3Qq/zmdNnzqfYaOixl7Ouoz/Ifj1PHdjMeK5E4ooquZaEgk6aIlmX+ThD9NYyrWX5A39wIPp3BW9gBEnQkQM6nGMHoVAuJB/kF2kKFroaAJc0mNQgn0fo/MyyJyiPfKztYgFOsCuN7fqFbZ/5troBSpAIGoX/PbLKSi/pRjf686BKosF9JQITFA==
/**
** Copyright (C) 2000-2006 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.   
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
** 
** If you have comments on these patches (for example if you are the webmaster 
** and want to inform us about a fixed site that no longer needs patching) please
** contact web-compliance@opera.com
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited. 
**  Edited: see variable 6 lines down
**/

// Generic fixes (mostly)
// Menu fixes.  Credits: Andrew Gregory! http://www.scss.com.au/family/andrew/
(function(opera){
	var bjsversion='edited: March 29 2006, version: Opera 8.5x';
	
	// Utility functions containing the fixes, called from the detection parts below
	var navRestore = {}; // will hold original navigator.* values
	var shouldRestore = false;
	var hostname = location.hostname; // caching some strings for performance
	var href=location.href;
	var fixed=false; // magic fixes need only run once
	function fixOpenCube(name){
		if(fixed){return;}fixed=true;
		// OpenCube menu
		window.vxml = window.vxml||{}; // to fix semi-opera-detection
		//Some versions try to call a function q99 which is only defined in the Opera library
		document.addEventListener('load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
		// prevent the menu from trying to use CSS filters
		opera.defineMagicVariable('DQM_sub_menu_effect',  function(){return 'none';}, null);
		
		// We'll overrule their sniffing and find the correct library for Opera
		if(name.match(/dqm_script\d*\.js$/)){
			opera.defineMagicVariable('brn', function(val){ return 'ie' }, function(val){ return 'ie' });
			opera.defineMagicVariable('ie6', function(val){ return true }, function(val){ return true });
			return true;
		}else if(name.indexOf('dqm_loader.js')>-1){
			opera.defineMagicVariable('brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
			return true;
		}
	}
	
	function fixHierMenus(){
		if(fixed){return;}fixed=true;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		opera.defineMagicVariable('HM_IsMenu', function(){ return true}, function(){ return true });
		opera.defineMagicVariable('HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
		opera.postError('Opera has modified the JavaScript on '+hostname+' (HierMenus fix). See browser.js for details.');
		
	}
	
	function fixMilonicMenu(name){ 
		// overwrites opera object with variable
		window.Opera=window.opera;
		if(fixed){return;}fixed=true;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		opera.defineMagicVariable('opera', function(){ return false }, function(){});
		opera.defineMagicVariable('opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		opera.defineMagicVariable('ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		opera.defineMagicVariable( 'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		opera.defineMagicFunction( 'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		opera.defineMagicVariable('mac', function(){ return false }, function(){ });
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Milonic fix). See browser.js for details.');
	}
	
	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		opera.defineMagicVariable('PosStrt', function(){ return true }, function(){ return true });
		opera.defineMagicVariable('NavYes', function(){ return true }, function(){ return true });
		opera.defineMagicVariable('DomNav', function(){ return true }, function(){ return true });
		// Tell the script that CSS filters are not supported.
		opera.defineMagicVariable('Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  name.match(/var\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7';
			shouldRestore = true;
		}
		opera.postError('Opera has modified the JavaScript on '+hostname+' (HV_menu fix). See browser.js for details.');
	}
	
	function fixUDM(name){
		if(fixed){return;}fixed=true;
		// Some versions are Opera 7 - compatible and do user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' opera 7.5';
		shouldRestore = true;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		opera.defineMagicVariable('op5',function () { return 0; },null);
		opera.defineMagicVariable('ns6',function () { return 1; },null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (UDM fix). See browser.js for details.');
	}
	function fixCoolmenus(name){
		if(fixed){return;}fixed=true;
		// Version 4 is Opera 7 - compatible and does user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' msie 6';
		shouldRestore = true;
		opera.defineMagicVariable('bw', function(o){
			// we need to override yet some more browser detection, and disable CSS filters
			// usedom must be 0 to make frameset menus work
			o.filter=o.op7=o.op=o.usedom=0;
			o.ie=o.ie6=1;
			return o}, function(o){return o});
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Coolmenus fix). See browser.js for details.');
	}
	
	function fixSoThinkMenus(){
		if(fixed){return;}fixed=true;
		navRestore['appName'] = navigator.appName;
		navigator.appName = 'Microsoft Internet Explorer';
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent = navigator.userAgent.replace(/Opera/, 'MSIE 6.0');
		shouldRestore = true;
	}
	
	function fixTransmenus(){
		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 
		// Credits xErath and Andrew Gregory
		opera.addEventListener('BeforeScript', function(ev) {
			var js = ev.element.text;
			if (js.indexOf("TransMenu")!=-1) {
				js = js.replace(/return\s+r(\b)/,"return true$1");
				js = js.replace(/mac/g,"xpto");
				js = js.replace("el.scrollLeft", "0");
				js = js.replace("el.scrollTop", "0");
				ev.element.text = js;
				// this prevents event listenener removal and makes the menu work even after using back button:
				window.attachEvent=(function(o){ return function(t, f){ if(t!='onunload')o.call(window,t,f); } })(window.attachEvent);
				opera.removeEventListener('BeforeScript', arguments.callee, false);
				opera.postError('Opera has modified the JavaScript on '+hostname+' (TransMenu fix). See browser.js for details.');
			}
		}, false);
	}
	
	
	// Use an event listener to detect specific scripts
	opera.addEventListener( 'BeforeExternalScript', function(ev){
		var name=ev.element.src; 
		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
		name=name.toLowerCase();// toLowerCase fixes sangjatten.se
	      if ( name.indexOf('dqm_')>-1){ 
			// OpenCube menu
			if(fixOpenCube(name)){
				opera.postError('Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');
			}
			return;
	      }else if(  name.indexOf('hm_loader')>-1  ){ 
			// HierMenus menu
			// If we apply this fix to version 6.x the menu breaks.
			// HM support recommends checking that HM_BrowserVersion is not defined
			opera.addEventListener('BeforeScript', function(ev){ 
				if( ev.element.text && ! ev.element.text.match(/hm_browserversion/i) ){
					fixHierMenus(name);
				}
				opera.removeEventListener('BeforeScript', arguments.callee, false);
			}, false);
			return;
	      }else if(  name.indexOf('mmenu.js')>-1  ){ 
			// Milonic menu
			fixMilonicMenu(name);
			return;
		
	      }else if(  name.match(/menu\d*_(com|build|var|program)\.js$/)   ){ 
			// HV menu
			fixHVMenu(name);
			return;
	      }else if(  name.match(/coolmenus\d\.js$/)   ){ 
			// coolmenus menu
			fixCoolmenus(name);
			return;
	      }else if(  name.match(/udm[_-]/)  || (  name.match(/(sniffer|control)\.js$/)   )    ){ 
			// UDM menu
			opera.addEventListener('BeforeScript', function(ev){ 
				if( name.match(/udm[_-]/)  || ev.element.text.indexOf('UDM')>-1 ){
					fixUDM(name);
				}
			}, false);
			return;
	      }else if(  name.indexOf('dynapi/api/browser.js')>-1  || name.indexOf('dynlayer.js')>-1  ){
			navRestore['appName'] = navigator.appName;
			navigator.appName = 'Microsoft Internet Explorer';
			shouldRestore = true;
			opera.postError('Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');
		}else if(  name.match(/stm\d+\.js$/)  ){
			fixSoThinkMenus();
			opera.postError('Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');
		}else if( name.indexOf('transmenu')>-1 ){
			fixTransmenus();
		}else if(  name.indexOf('ar.atwola.com/file/adsWrapper.js')>-1  ){
			// Advertising script that serves broken content
			// Bug: 179615
			opera.addEventListener('BeforeScript', function(ev){ 
				opera.defineMagicVariable('adsOld', function(){return 0}, function(){return 0});
				opera.defineMagicVariable('adsOp', function(){return false}, function(){return false});
				// for..in iterations show the refresh method, crashes script
				navigator.plugins.refresh = {description:''}
				ev.element.text = ev.element.text.replace(/if \(ie5&&\(db!=null\)\)\{/g, 'if(false){');
				opera.postError('Opera has modified the JavaScript on '+hostname+' (adsWrapper fix). See browser.js for details.');
				opera.removeEventListener('BeforeScript', arguments.callee, false);
			}, false);
		}
		
		// Creating event handler to restore any changed navigator properties
		if( shouldRestore ){
			opera.addEventListener('AfterExternalScript', 
				function(ev){
					var prop;
					for(prop in navRestore) navigator[prop]=navRestore[prop];
					opera.removeEventListener('AfterExternalScript', arguments.callee, false);
				}
			, false);
		}
	}, false);

	opera.addEventListener( 'AfterScript', function(ev){
	      // AllWebMenus fix
	      // If version number is outdated, force it to use IE-compatible library
		if(  typeof ( awmBN ) != 'undefined'  && ! isNaN(  awmBN  )  &&  awmBN <498 ){ 
			if(fixed){return;}fixed=true;
			// we have a version number and the menu is too old
			// AWM loads different libraries based on numbers - number 1 is IE-compat
			opera.defineMagicVariable(  'scriptNo', function(){return 1}, function(){return 1} );
			opera.postError('Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
			return;
		}else if( typeof(lib_bwcheck)=='function' && typeof(bw) !='undefined'){
			// this looks like a FoldOutMenu
			bw.opera5=false;
			navigator.userAgent=navigator.userAgent.replace('Opera', '0pera');  // OBS! no restore.. :-(
			opera.postError('Opera has modified the JavaScript on '+hostname+' (FoldOutMenu fix). See browser.js for details.');
		}
		
	}, false);
	
	// Workarounds for specific, important sites with re-named scripts
	// IMPORTANT gotcha: here we detect by domain and do not pass the script name as an argument
	// the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
	if(  hostname.indexOf('comsec.com.au') >-1 ){ fixHierMenus();	}
	if(  hostname.indexOf('.ulead.') >-1 ){ fixMilonicMenu(); }
	if(  hostname.indexOf('westhost.com') >-1 ){ fixOpenCube('menu_settings.js'); } // 183727	
	if( hostname.indexOf('synaptics.com') >-1 ){ fixHVMenu('var.js'); } // 191364
	
	// **********                  Multi-site fixes
	
	// The Big Date getYear Fix
	// Sites that use getYear when they should use getFullYear come up with very creative results
	
	if( hostname.match(/(airfrance\.com|airfrance\.fr|airfrance\.us|sabadellatlantico\.com|hiof\.no|dancenter\.com|thestore\.adidas\.com|bnz\.co\.nz)$/) ){
		Date.prototype.getYear = Date.prototype.getFullYear;
		opera.postError('Opera has modified the JavaScript on '+hostname+' (getYear fix). See browser.js for details');	
	}
	
	if( hostname.lastIndexOf('.nl')+3==hostname.length && hostname.length>2 ){
		// several sites in the Netherlands (mainly newspapers) use the same sniffer script to block Opera.
		//Bug: 182328
		// this is a .nl site. We want to detect scripts named /Javascript/browser.js
		opera.addEventListener('BeforeExternalScript',
		function(ev){
			if(ev.element.src.match(/\/Javascript\/browser\.js$/)){
				opera.defineMagicVariable( 'bSupportedBrowser', function(){return true;}, null);
				opera.postError('Opera has modified the JavaScript on '+hostname+'. (Netherland sniffer fix) See browser.js for details');	
			}
		}
		,false);
	}else if( hostname.lastIndexOf('.tk')+3==hostname.length && hostname.length>2 ){
		// all .tk domains carry adverts that break due to popup blocking
		//Bug: 187227
		opera.addEventListener('BeforeScript', function(ev){
			ev.element.text=ev.element.text.replace('MyPopUnder.blur();', '').replace('MyPopup.focus();','')
		}, false);
		
		opera.postError('Opera has modified the JavaScript on '+hostname+'. (.tk fix) See browser.js for details');	
	}
	
	
	// **********                Site-specific fixes (more or less alphabetical order by hostname)
	if(  hostname.indexOf('aol.com') >-1 ){
		// AOL.com: hide IFRAMEs that cover login and search history
		// Bugs: 179107, 179217, 179219
		document.addEventListener('load', function(ev){ 
			var i = document.getElementById('loginLayer');if( i && i.firstChild && i.firstChild.style.zIndex==-1 ){i.firstChild.style.display='none';} 
			// search history shim
			i = document.getElementById('rs_iehack');if( i ){i.outerHTML=i.outerHTML.replace(/iframe/ig, 'div');}
			// miscalculated widths cause overlaps at bottom right part of page
			i = document.getElementById('f'); if(i){ 
				i.style.width = (i.offsetWidth*0.95)+'px';
			}
			// and related to that issue: we don't want certain paragraphs to have 100% height, causes overlap
			try{i = document.createElement('style');
			i.appendChild(document.createTextNode('html:lang(en)>body #fiC p.dot{height:auto !important}'));
			document.getElementsByTagName('head')[0].appendChild(i);}catch(e){}
		}, false);
		// prevent capturing load event listener, bug 184442
		(function(ael){ 
			window.addEventListener = function(type, func, capture){ ael.call(window, type, func, false); }
		})(window.addEventListener)
		// webmail overwritten by invisible gif, bug 188197
		if(hostname.indexOf('webmail.aol.com')>-1){
			opera.defineMagicVariable('s_ios', function(){ return true }, null);
		}
		opera.postError('Opera has modified the JavaScript on '+hostname+'. (multiple AOL fixes) See browser.js for details');
	}else if(hostname.indexOf('budget.com')>-1){ 
		//Fix for www.budget.com 
		// Problem: menu with IFRAME "shim" that covers up menus
		// Bug: 171573
		document.addEventListener('load', function(){var elm, parent; elm=document.getElementById('DivShim');if(elm){  parent = elm.parentNode; parent.removeChild(elm);parent.appendChild(  document.createElement(  'div'  )  ).id='DivShim';  }  }, false);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (budget.com menus fix).  See browser.js for details');
	}else if( hostname.indexOf('reviews.cnet.com') >-1 ){
		// CNet videos
		// Problem: document.write adds a script that depends on variables defined later
		// Bug 179484
		opera.addEventListener('BeforeScript',
		function(ev){ 
			var js=ev.element.text, problemstr='document.write(\'<script type="text/javascript" src="\'+skin+\'"></script>\');';
			if(js.indexOf( problemstr ) > -1 ){
				ev.element.text = ev.element.text.replace( problemstr,'' )+';\n'+problemstr;
			}
		}
		,false);
	}else if(hostname.indexOf('cnn.com')>-1){ 
		// Fix for CNN articles
		// Problem: "Your E-mail alert" box is not always floating right, particularly on older pages
		//  Bug: 124409
		opera.addEventListener('BeforeEvent.load', function(){
			var tableCounter = 0;
			try{
				var ni = document.createNodeIterator(document.body, NodeFilter.SHOW_TEXT, null, true), n;
				while( n=ni.nextNode() ){ 
					if( n.nodeValue.indexOf('YOUR E-MAIL ALERTS')>-1 ){ 
						while( n.parentNode && ( tableCounter<1 || n.parentNode.tagName.toLowerCase() != 'table' ) ){
							n = n.parentNode;
							if(n.tagName.toLowerCase()=='table'){ 
								tableCounter++;
							}
						}
						if( n.parentNode && n.parentNode.tagName.toLowerCase()=='table'){
							n.parentNode.setAttribute('style', "float: right; clear: right;");
							opera.removeEventListener('BeforeEvent.load', arguments.callee, false);
							return;
						}
					}
				}
			}catch(e){}
		}, false);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (CNN fix). See browser.js for details');
	}else if(hostname.indexOf('cyworld.nate.com')>-1){
		// nate.com styling is not perfect, causing malfunctioning marquee.. Bug 185443
		opera.addEventListener('BeforeEvent.load', function(){
			try{
				var m=document.getElementById('main2');  
				m.style.overflow='hidden';
				m.outerHTML=m.outerHTML.replace(/SPAN/, 'div'); 
				opera.postError('Opera has modified the source code on '+hostname+' (nate.com fix). See browser.js for details.');
			}catch(e){}
		},false);
	}else  if( hostname.indexOf('emirates.com') >-1 ){ 
		fixOpenCube('dqm_script1.js'); // 195212
	} if(  hostname.indexOf(  'huskers.com'  )>-1  ){
		// Fixing huskers.com appearing blank
		// Problem: old Milonic wraps page in hidden DIV
		// Bug: 126516
		navigator.userAgent += ' Konqueror';
		opera.postError('Opera has modified the JavaScript on '+hostname+' (huskers.com fix). See browser.js for details');
	}else if(hostname.indexOf('icq.com')>-1){
		//Bug 188651 - broken capability sniffing, document.all does not imply VBScript support
		opera.defineMagicVariable('flashVersion', function(){return function flashVersion(){return 0;} }, null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (ICQ Flash sniffing fix). See browser.js for details');
	}else if(hostname.indexOf('kayak.com')>-1){
		// kayak.com search : linebreak before CDATA escape causes problem
		opera.defineMagicVariable( 'R9HTTPXml', 
			function(o){
				o.prototype.getTagText=function (parent,item,index){
					var result = parent.getElementsByTagName(item)[index];
					if (result){	var returnText='',i=0,node;
						while(node=result.childNodes[i]){
							returnText+=node.nodeValue;
							i++;
						}
					return returnText;
					}else { 
						return ""; 
					}
				}
				return o;} 
			, null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (kayak CDATA fix). See browser.js for details.');
	}else if( hostname.indexOf('klm.com')>-1){
		// Several issues with KLM:  186815, 188413
		// First work around bug in Opera with "var arguments";
		opera.addEventListener(
		'BeforeScript',
		function (e) {
			e.element.text=e.element.text.replace('var arguments;', 'var arguments={};');
		},
		false);
		// Now prevent their sniffing and upgrade message
		opera.defineMagicFunction('checkBrowser', function(){});
		
		// Fix event listener functions to avoid capturing load events
		opera.defineMagicFunction('addEventHandler', function(a1,a2,obj,ev,fun){obj.addEventListener(ev,fun,false);});
		opera.defineMagicFunction('removeEventHandler', function(a1,a2,obj,ev,fun){ obj.removeEventListener(ev,fun,false);});
		
		document.addEventListener('load', function(){
			// padding and width, no longer a quirk - this makes sure 
			// contents in the plan&book box floats where it is supposed to
			var el;
			if(document.getElementsByTagName('head')[0]){
				el=document.getElementsByTagName('head')[0].appendChild(document.createElement('style'));
				el.appendChild(document.createTextNode('html #tool #blockright { padding-left: 0px !important }  '));
			}
		}, false);
		// Avoid IFRAME shim
		navigator.userAgent+='msie 5.0';
		opera.postError('Opera has modified the JavaScript on '+hostname+' (KLM fix). See browser.js for details');
		
	}else  if( href.indexOf('http://msdn.microsoft.com/workshop/') == 0 ) {
	// Fixing MSDN
	// Problem: very IE-centric scripting, excludes other browsers with sniffing
	// Credits: Tarquin
	opera.postError('Opera has modified the JavaScript on '+hostname+' (MSDN fix). See browser.js for details');
	opera.addEventListener(
		'BeforeScript',
		function (e) {
			var oJs = e.element.text;
			var oSr = e.element.getAttribute('src');
	
			if( oSr ) {
				//external scripts
	
				if( oSr.indexOf('common.js')>-1 ) {
					//common.js fixes
	
					//need to use getAttrbute for custom attributes - fixes the 'show me' buttons
					oJs = oJs.replace(/oImg\.SAMPLEPATH/ig,'oImg.getAttribute(\'SAMPLEPATH\')');
					oJs = oJs.replace(/oImg\.FEATURES/ig,'oImg.getAttribute(\'FEATURES\')');
	
					//remove the need for a minimum version number
					oJs = oJs.replace(/parseFloat\(oImg\.getAttribute\(\'MINVER\', 1\)\)/ig,'1');
	
					//add a warning about demonstrations possibly not working
					e.element.text = oJs.replace(/<SPAN>Show Me<\/SPAN><\/BUTTON>/ig,'<SPAN>Show Me<\/SPAN><\/BUTTON><br>[Note: Some of these demonstrations may not work in the browser you are currently using, as they may demonstrate unsupported or proprietary features, or use proprietary features or syntax as part of the demonstration code.]');
	
				} else if( oSr && oSr.match(/appliesto2\.js$/) ) {
					//appliesto2.js fixes
	
					//document.activeElement is not supported - prevents an error that halts the script
					e.element.text = oJs.replace(/oHasFocus.parentElement==oATData/g,'oHasFocus&&oHasFocus.parentElement==oATData');
	
				} else if( oSr.match(/members\.js$/) ) {
					//members.js fixes
	
					//need to use getAttrbute for custom attributes - makes the main collapsing and tab selection work
					oJs = oJs.replace(/if\(div.tabName\)\{/,'if(div.getAttribute&&div.getAttribute(\'tabName\')){');
					oJs = oJs.replace(/if\(newTab.tabName\)\{/,'if(newTab.getAttribute(\'tabName\')){');
					oJs = oJs.replace(/this\._caption\s*=\s*newTab\.tabName;/,'this._caption = newTab.getAttribute(\'tabName\');');
					oJs = oJs.replace(/function toggleExpandDataView\(\)\{/,'function toggleExpandDataView(){\nif(!oCollapso.state) { oCollapso.state = oCollapso.getAttribute(\'state\'); }');
	
					//fix invalid CSS declarations - puts the top border on the tabs
					oJs = oJs.replace(/border-top=/g,'border-top:');
	
					//CSS in dynamically generated style tags is ignored (it should not be inside a table anyway) - makes the tabs look right
					oJs = oJs.replace(/gsTabControl=gsTabControl\+([^\r\n]*(\.oMembersTable|TD|.oMTab)[^\r\n]*\{[^\r\n]*\';)/g,'foo+=$1');
					oJs = oJs.replace(/foo\+=/,'var foo = \'\';foo+=');
					e.element.text = oJs.replace(/(\.oMTabHover[^\r\n]*\}\';)/,'$1 var bar = document.createElement(\'link\');bar.setAttribute(\'rel\',\'stylesheet\');bar.setAttribute(\'type\',\'text\\\/css\');bar.setAttribute(\'href\',\'data:text\\\/css,\'+escape(foo));document.getElementsByTagName(\'head\')[0].appendChild(bar);');
	
				}
			} else if( oJs.indexOf('function InitPage') + 1 && oJs.indexOf('initTabbedMembers') + 1 ) {
				//main page scripts
	
				//remove the browser detects that block Opera from running the scripts
				oJs = oJs.replace(/\"MSIE\".*oBD.browser.*oBD.majorVer.*\).*\)/,'true)');
				e.element.text = oJs.replace(/oBD\.getsNavBar.*oBD\.platform.*\)/,'true)');
	
				//stop them serving styles to Opera that spoil the effect
				var oLink1 = document.getElementsByTagName('link')[0], oLink2 = document.getElementsByTagName('link')[1];
				if( oLink1 && oLink2 && oLink1.getAttribute('href').indexOf('op3.css') + 1 && oLink2.getAttribute('href').indexOf('down.css') + 1 ) {
					oLink1.setAttribute('href','/library/shared/common/css/ie4.css');
					oLink2.setAttribute('href','/library/shared/comments/css/ie5.css');
				}
	
			}
		},
		false
	);
	
	}else if(  hostname.indexOf(  'music.download.com'  )>-1  ){
		// Fixing audio samples
		// Problem: old overlibwms library only detects Opera7
		// Bug: 178744
		navigator.userAgent += ' Opera 7';
		opera.postError('Opera has modified the JavaScript on '+hostname+' (music.download.com fix). See browser.js for details');
	}else if( hostname.indexOf('myx.net')>-1){
		// myx.net changes name of a form element, then tries to set value using the old name
		// works in IE due to bugs in updating the form elements collections. Bug: 180876
		// Thanks to dantesoft :)
		opera.addEventListener('BeforeScript', function(e){
			e.element.text=e.element.text.replace( 'document.forms[formname].elements[inputname].name = buttonname;\n'+'                                                document.forms[formname].elements[inputname].value = buttonvalue;',
	'document.forms[formname].elements[inputname].value = buttonvalue; document.forms[formname].elements[inputname].name = buttonname;'  );
			opera.postError('Opera has modified the JavaScript on '+hostname+' (MYX PAS fix). See browser.js for details');
		}, false);
	}else if(hostname.indexOf('nbcolympics.com')>-1){
		// NBC Olympics site uses capturing load events. Bug 197145
		(function(ael){ 
			window.addEventListener = function(type, func, capture){ ael.call(window, type, func, false); }
		})(window.addEventListener)		
		opera.postError('Opera has modified the JavaScript on '+hostname+' (NBC capture fix). See browser.js for details');
	}else if( hostname.indexOf('n-gage.com') >-1 && navigator.userAgent.indexOf('Mac')>-1 ){
		// N-Gage plugin sniffing
		// Problem: does not give Flash to Mac Opera
		// Bug 181451
		opera.defineMagicVariable('g_plugin', function(){return navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin},null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (n-gage Flash sniffer fix). See browser.js for details');
	}else if(hostname.indexOf('nintendo.com')>-1){
		// nintendo.com
		// fixing alignment inheritance, bug 165592, and sniffing
		opera.addEventListener('BeforeScript', function(e){
			if( e.element.src=='http://www.nintendo.com/js/global.js'  ){ // removing forward to "old browser" page
				e.element.text=e.element.text.replace('top.location.href="/old_browser.vm";', '/*top.location.href="/old_browser.vm";*/');
				opera.removeEventListener('BeforeScript', arguments.callee, false);
			}
		},false)
		opera.addEventListener('AfterScript', function(e){ // removing align attribute
			if(document.body && document.body.childNodes[1] && document.body.childNodes[1].getAttribute('align')   ){
				document.body.childNodes[1].removeAttribute('align');
				opera.removeEventListener('AfterScript', arguments.callee, false);
			}
		}, false);
	}else if(  href=='https://www.bookryanair.com/skylights/cgi-bin/skylights.cgi'  ){
		// ryanair
		// Problem: selects are reset if an option is changed from onchange. 
		// Bug: 182268
		document.addEventListener('load', function(){
			var selects=document.getElementsByTagName('select'),i,n;
			for(i=0;n=selects[i];i++){
				if(n.name=='country' && n.onchange.toString().indexOf('this.options[(this.length - 1)].value = "other";')>-1 ){
					n.onchange=function(){}
					opera.postError('Opera has modified the JavaScript on '+hostname+' (Ryanair fix). See browser.js for details');
				}
			}
		}, false);	
	}else if(  hostname.indexOf('.scandinavian.net') >-1 ){
		// scandinavian.net
		// Problem: selects are reset if first option is removed in onchange. 
		// Bug: 180160
		document.addEventListener('load', function(){
			var selects=document.getElementsByTagName('select'),i,n;
			for(i=0;n=selects[i];i++){
				if(n.options[0] && ! n.options[0].value){n.options[0].value=n.options[0].text}
			}
		}, false);
	}else if(  hostname.indexOf('skysports.com')>-1  ){	
		document.addEventListener('load', function(){try{setFlashHeight('badgeID', 50);}catch(e){}}, false);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Skysports fix). See browser.js for details');
	}else if(  hostname.indexOf('t-mobile.')>-1 && navigator.appName=='Opera' ){
		// Fixing reload loop on T-mobile sites
		// Problem: server tries to detect screen size, and re-load with screen size values in the address but the values 
		// returned from server are hardcoded and not the detected ones, causing a reload loop if Opera identifies as itself
		// Bug: 182086
		opera.defineMagicVariable('WINDOW_WIDTH', function (e) {return window.innerWidth;},null);
		opera.defineMagicVariable('WINDOW_HEIGHT', function (e) {return window.innerHeight;},null);
		// Let's disable their redirect to a "bad browser" page while we're at it
		opera.defineMagicFunction('detection_siteEntry', function(){});
		opera.postError('Opera has modified the JavaScript on '+hostname+' (T-mobile fix). See browser.js for details');
	}else if( hostname.indexOf('united.com')>-1 || hostname.indexOf('flyted.com')>-1 || hostname.indexOf('itn.net')>-1 ){
		// Problem: hidden images do not load, so no onload event
		// Bug: 193907
		document.addEventListener('load', function(){
			var i,img;
			var isHidden = function(el){
				if(!el){ return false;}
				var elmIsHidden=((el.style && el.style.display=='none') || getComputedStyle(el).display=='none');
				return (elmIsHidden || isHidden( el.parentNode ));
			}
			for(i=document.images.length-1;img=document.images[i];i--){
				if(img.onload){
					if( isHidden( img ) ){
						img.onload();
						opera.postError('Opera has modified the JavaScript on '+hostname+' (hidden img onload fix). See browser.js for details');
						return;
					}
				}
			}
		}, false)
	}else if(  hostname.indexOf('viamichelin.com')>-1  ){
		// Fixing map selection on viamichelin.com
		// Problem: Opera reports DOM-standard-compatible values for event.button. If site thinks we are IE, it gets confused
		// Bug: 178076
		opera.defineMagicVariable('ViaM_ns', function (e) {return true;},null);
		opera.defineMagicVariable('ViaM_ie', function (e) {return false;},null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Viamichelin fix). See browser.js for details');
	}else if(  hostname.indexOf('visveg.no')>-1  ){
		// Fixing map selection on visveg.no
		// Problem: Opera reports DOM-standard-compatible values for event.button. If site thinks we are IE, it gets confused
		// Bug: 178077
		opera.defineMagicVariable('isNav6', function (e) {return true;},null);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Visveg fix). See browser.js for details');
	}else if( hostname.indexOf('walla.co.il') >-1 ){
		// Walla.co.il odd CSS styling causes display problems
		// Bugs 184398, 184399
		opera.addEventListener('BeforeEvent.load',
		function(){ if(document.documentElement){(document.documentElement.appendChild(document.createElement('style'))).appendChild(document.createTextNode(' .btn-t,.btn{display:inline !important;} .wp-0-b{width:auto !important}'));
			opera.removeEventListener('BeforeEvent.load', arguments.callee, false); 
			opera.postError('Opera has modified the JavaScript on '+hostname+' (Walla fix). See browser.js for details');}}
		,false);
	}else if(  hostname.indexOf('washingtonpost.com')>-1  ){
		//Fix for www.washingtonpost.com
		// Problem: Opera is led into wrong script branch because site thinks Opera is IE
		// Bug: 154980
		opera.defineMagicVariable('browserVersion', function(){ return 3 }, null);
		// Front page menus below other elements. Bug 193669
		document.addEventListener('load', function(){ // Find search container
			var ni = document.createNodeIterator(document.body, NodeFilter.SHOW_ELEMENT, null, true), n;
			while( n=ni.nextNode() ){ 
				if(  n.className && n.className.indexOf('wp_generic_search')>-1){break;} // found it!
			}
			var  i=0,el;
			if( ! (n && document.getElementById("wp_navcontainer")) )return; // we don't have the elements we need
			for(;el=document.getElementById("wp_navcontainer").childNodes[i];i++){ // add our event listeners
				if(el.nodeType!=1){continue;}
				el.addEventListener( 'mouseover', function(){ try{ n.style.zIndex=-1; }catch(e){} }, false );
				el.addEventListener( 'mouseout', function(){ try{ n.style.zIndex=0; }catch(e){} }, false );
			}
		}, false);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Washington Post fix). See browser.js for details');
	}else if( hostname.indexOf('.yahoo.')>-1 ){
		// fix for eternal JS loop on My Yahoo
		// This is caused by bug in Yahoo's script
		// Bug: 180917
		opera.addEventListener(
			'BeforeScript',
			function(ev){
				ev.element.text = ev.element.text.replace(/while\(eval\(o\)\)\s*\{\s*x\+=o\.style\.pixelLeft;\s*e=o\.offsetParent;\s*\}/, 'while(eval(o)){x+=o.offsetLeft;o=o.offsetParent;}');
				ev.element.text = ev.element.text.replace(/while\(eval\(o\)\)\s*\{\s*y\+=o\.style\.pixelTop;\s*o=o\.offsetParent;\s*\}/, 'while(eval(o)){y+=o.offsetTop;o=o.offsetParent;}');  },
			false
		);
		opera.postError('Opera has modified the JavaScript on '+hostname+' (Yahoo fix). See browser.js for details');
		if( hostname.indexOf('sbc.yahoo.')>-1 || hostname.indexOf('verizon.yahoo.')>-1 || hostname.indexOf('rogers.yahoo.')>-1 || hostname.indexOf('bt.yahoo.')>-1 ){
			// Yahoo ISP portal blocks Opera users with a script that detects window.opera
			delete window.opera;
			document.addEventListener('load', function(){ window.opera=opera; }, false); // Try to play nice with user JS
		}
		if( hostname.indexOf('mail.')>-1){
			// Yahoo mail compares getAttribute output to null, menus fail
			// bug 193419
			HTMLElement.prototype.getAttribute=( 
				function(originalMethod){  
					return function(attrStr){ 
						var value=originalMethod.call(this, attrStr); 
						return (value=='')?null:value;  
					}  
				} 
			)(HTMLElement.prototype.getAttribute)
			opera.postError('Opera has modified the JavaScript on '+hostname+' (Yahoo Mail fix). See browser.js for details');
		}
		if( hostname.indexOf('photos.')>-1 ){
			// Yahoo photos tries to use CSS filters
			HTMLDivElement.prototype.filters={blendTrans:{Apply:function(){}}};
			opera.postError('Opera has modified the JavaScript on '+hostname+' (Yahoo Photos fix). See browser.js for details');
		}
	}else if(location.href.indexOf('http://www.opera.com/docs/browserjs/')==0){
		document.addEventListener('load', function(){ if(document.getElementById('browserjs_status_message')){document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! The active browser.js file is '+bjsversion;} }, false);
	}
	
})(opera);
