/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;

class LC3Resolver {
    static Class jsobjectClass;
    static Class objectClass;
    static Class stringClass;
    static Class classClass;
    static Class doubleClass;
    static Class booleanClass;

    LC3Resolver() {
    }

    static Method resolveMethod(Class clazz, String string, String string2, Object[] objectArray, boolean bl) {
        HashSet hashSet = new HashSet();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (string.equals(methodArray[n].getName()) && (!bl || Modifier.isStatic(methodArray[n].getModifiers())) && LC3Resolver.isApplicable(methodArray[n].getParameterTypes(), string2, objectArray)) {
                LC3Resolver.addMethod(hashSet, methodArray[n], string2, objectArray);
            }
            ++n;
        }
        if (hashSet.size() == 1) {
            return (Method)hashSet.iterator().next();
        }
        return null;
    }

    static Constructor resolveConstructor(Class clazz, String string, Object[] objectArray, boolean bl) {
        HashSet hashSet = new HashSet();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            if ((!bl || Modifier.isStatic(constructorArray[n].getModifiers())) && LC3Resolver.isApplicable(constructorArray[n].getParameterTypes(), string, objectArray)) {
                LC3Resolver.addConstructor(hashSet, constructorArray[n], string, objectArray);
            }
            ++n;
        }
        if (hashSet.size() == 1) {
            return (Constructor)hashSet.iterator().next();
        }
        return null;
    }

    private static void addMethod(HashSet hashSet, Method method, String string, Object[] objectArray) {
        Class[] classArray = method.getParameterTypes();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            Class[] classArray2 = method2.getParameterTypes();
            int n = LC3Resolver.computePreferred(classArray, classArray2, string, objectArray);
            if (n < 0) {
                iterator.remove();
                continue;
            }
            if (n <= 0) continue;
            return;
        }
        hashSet.add(method);
    }

    private static void addConstructor(HashSet hashSet, Constructor constructor, String string, Object[] objectArray) {
        Class[] classArray = constructor.getParameterTypes();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Constructor constructor2 = (Constructor)iterator.next();
            Class[] classArray2 = constructor2.getParameterTypes();
            int n = LC3Resolver.computePreferred(classArray, classArray2, string, objectArray);
            if (n < 0) {
                iterator.remove();
                continue;
            }
            if (n <= 0) continue;
            return;
        }
        hashSet.add(constructor);
    }

    private static boolean isApplicable(Class[] classArray, String string, Object[] objectArray) {
        if (classArray.length != string.length()) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            switch (string.charAt(n)) {
                case 'u': {
                    if (classArray[n].equals(objectClass) || classArray[n].equals(stringClass)) break;
                    return false;
                }
                case 'b': {
                    if (classArray[n].equals(Boolean.TYPE) || classArray[n].equals(booleanClass) || classArray[n].equals(objectClass) || classArray[n].equals(stringClass)) break;
                    return false;
                }
                case 'n': {
                    if (classArray[n].equals(Double.TYPE) || classArray[n].equals(doubleClass) || classArray[n].equals(objectClass) || classArray[n].equals(Float.TYPE) || classArray[n].equals(Long.TYPE) || classArray[n].equals(Integer.TYPE) || classArray[n].equals(Short.TYPE) || classArray[n].equals(Byte.TYPE) || classArray[n].equals(Character.TYPE) || classArray[n].equals(stringClass)) break;
                    return false;
                }
                case 's': {
                    if (classArray[n].equals(stringClass) || classArray[n].equals(objectClass) || classArray[n].equals(Double.TYPE) || classArray[n].equals(Float.TYPE) || classArray[n].equals(Long.TYPE) || classArray[n].equals(Integer.TYPE) || classArray[n].equals(Short.TYPE) || classArray[n].equals(Byte.TYPE) || classArray[n].equals(Character.TYPE)) break;
                    return false;
                }
                case 'z': {
                    if (!classArray[n].isPrimitive()) break;
                    return false;
                }
                case 'j': {
                    if (objectArray == null || classArray[n].isInstance(objectArray[n]) || classArray[n].equals(stringClass) || classArray[n].equals(Double.TYPE) || classArray[n].equals(Float.TYPE) || classArray[n].equals(Long.TYPE) || classArray[n].equals(Integer.TYPE) || classArray[n].equals(Short.TYPE) || classArray[n].equals(Byte.TYPE) || classArray[n].equals(Character.TYPE)) break;
                    return false;
                }
                case 'a': {
                    if (objectArray == null || classArray[n].isInstance(objectArray[n]) || classArray[n].equals(stringClass)) break;
                    return false;
                }
                case 'c': {
                    if (classArray[n].equals(classClass) || classArray[n].equals(jsobjectClass) || classArray[n].equals(objectClass) || classArray[n].equals(stringClass)) break;
                    return false;
                }
                case 'A': {
                    if (classArray[n].equals(jsobjectClass) || classArray[n].equals(objectClass) || classArray[n].equals(stringClass) || classArray[n].isArray()) break;
                    return false;
                }
                case 'o': {
                    if (classArray[n].equals(jsobjectClass) || classArray[n].equals(objectClass) || classArray[n].equals(stringClass) || classArray[n].equals(Double.TYPE) || classArray[n].equals(Float.TYPE) || classArray[n].equals(Long.TYPE) || classArray[n].equals(Integer.TYPE) || classArray[n].equals(Short.TYPE) || classArray[n].equals(Byte.TYPE) || classArray[n].equals(Character.TYPE)) break;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private static int computePreferred(Class[] classArray, Class[] classArray2, String string, Object[] objectArray) {
        int[] nArray = LC3Resolver.computeWeightArray(classArray, string, objectArray);
        int[] nArray2 = LC3Resolver.computeWeightArray(classArray2, string, objectArray);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > nArray2[n]) {
                bl = true;
            } else if (nArray[n] < nArray2[n]) {
                bl2 = true;
            } else if (!(string.charAt(n) != 'a' && string.charAt(n) != 'j' || nArray[n] != 9 || nArray2[n] != 9 || classArray[n].equals(classArray2[n]))) {
                if (classArray2[n].isAssignableFrom(classArray[n])) {
                    bl = true;
                } else if (classArray[n].isAssignableFrom(classArray2[n])) {
                    bl2 = true;
                }
            }
            ++n;
        }
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        return 0;
    }

    private static int[] computeWeightArray(Class[] classArray, String string, Object[] objectArray) {
        int n = classArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = LC3Resolver.getWeight(classArray[n2], string.charAt(n2), objectArray[n2]);
            ++n2;
        }
        return nArray;
    }

    private static int getWeight(Class clazz, char c, Object object) {
        switch (c) {
            case 'u': {
                return 1;
            }
            case 'b': {
                if (clazz.equals(Boolean.TYPE)) {
                    return 4;
                }
                if (clazz.equals(booleanClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'n': {
                if (clazz.equals(Double.TYPE)) {
                    return 10;
                }
                if (clazz.equals(doubleClass)) {
                    return 9;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 8;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Byte.TYPE)) {
                    return 3;
                }
                if (clazz.equals(stringClass)) {
                    return 2;
                }
                return 1;
            }
            case 's': {
                if (clazz.equals(stringClass)) {
                    return 4;
                }
                if (clazz.equals(objectClass)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
            case 'z': {
                return 1;
            }
            case 'j': {
                if (clazz.equals(stringClass) && !(object instanceof String)) {
                    return 8;
                }
                if (clazz.equals(Double.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                if (clazz.equals(Byte.TYPE)) {
                    return 1;
                }
                return 9;
            }
            case 'a': {
                if (clazz.equals(stringClass)) {
                    return 1;
                }
                return 9;
            }
            case 'c': {
                if (clazz.equals(classClass)) {
                    return 4;
                }
                if (clazz.equals(jsobjectClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'A': {
                if (clazz.isArray()) {
                    return 4;
                }
                if (clazz.equals(jsobjectClass)) {
                    return 3;
                }
                if (clazz.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'o': {
                if (clazz.equals(jsobjectClass)) {
                    return 10;
                }
                if (clazz.equals(objectClass)) {
                    return 9;
                }
                if (clazz.equals(stringClass)) {
                    return 8;
                }
                if (clazz.equals(Double.TYPE)) {
                    return 7;
                }
                if (clazz.equals(Float.TYPE)) {
                    return 6;
                }
                if (clazz.equals(Long.TYPE)) {
                    return 5;
                }
                if (clazz.equals(Integer.TYPE)) {
                    return 4;
                }
                if (clazz.equals(Short.TYPE)) {
                    return 3;
                }
                if (clazz.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    static {
        try {
            jsobjectClass = Class.forName("netscape.javascript.JSObject");
            objectClass = Class.forName("java.lang.Object");
            stringClass = Class.forName("java.lang.String");
            classClass = Class.forName("java.lang.Class");
            doubleClass = Class.forName("java.lang.Double");
            booleanClass = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

