<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.1
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin Framework for IPS Services
|   > Module written by Matt Mecham
|   > Date started: 17 February 2003
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/


$idx = new ad_plugins();


class ad_plugins {

	var $base_url;

	function ad_plugins() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}
		
		// Make sure we're a root admin, or else!
		
		if ($MEMBER['mgroup'] != $INFO['admin_group'])
		{
			$ADMIN->error("pAoǥ\ȭ̰޲zsըϥ");
		}

		switch($IN['code'])
		{
			
			case 'ipchat':
				$this->chat_splash();
				break;
			case 'chatframe':
				$this->chat_frame();
				break;
			case 'chatsave':
				$this->chat_save();
				break;
			case 'dochat':
				$this->chat_config_save();
				break;
			default:
				exit();
				break;
		}
		
	}
	
	
	//-------------------------------------------------------------
	// CHAT SPLASH
	//--------------------------------------------------------------
	
	function chat_splash()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//---------------------------------------
		// Do we have an order number
		//---------------------------------------
		
		if ( $INFO['chat_account_no'] )
		{
			$this->chat_config();
		}
		else
		{
			$frames = "<html>
		   			 <head><title>Invision Power Board: ѳ]w</title></head>
					   <frameset rows='*,50' frameborder='yes' border='1' framespacing='0'>
					   	<frame name='chat_top'   scrolling='auto' src='http://www.invisionchat.com/?acp++acp'>
					   	<frame name='chat_bottom'  scrolling='auto' src='{$SKIN->base_url}&act=pin&code=chatframe'>
					   </frameset>
				   </html>";
				   
			print $frames;
			exit();
		}
		
	}
	
	//---------------------------------------------------------------
	
	function chat_frame()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$css  = $SKIN->get_css();
		
		$html = "<html>
				  <head>
				   <title>Invision Power Board Order Box</title>
				   $css
				  </head>
				  <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='0' bgcolor='#4C77B6'>
				  <table cellpadding=4 cellspacing=0 border=0 align='center'>
				  <form action='{$SKIN->base_url}&act=pin&code=chatsave' method='POST' target='body'>
				  <tr>
				   <td valign='middle' align='left'><b style='color:white'>Ordered IP Chat?</b></td>
				   <td valign='middle' align='left'><input type='text' size=35 name='account_no' value='JzbX...' onClick=\"this.value='';\"></td>
				   <td valign='middle' align='left'><input type='submit' value='~...'></td>
				  </tr>
				  </table>
				  </form>
				  </body>
				 </html>";
				 
		echo $html;
		
		exit();
		
	}
	
	//---------------------------------------------------------------
	
	function chat_save()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$acc_number = intval($IN['account_no']);
		
		if ( $acc_number == "" )
		{
			$ADMIN->error("pAoOĪ IP ѱbX");
		}
		
		$ADMIN->rebuild_config( array( 'chat_account_no' => $acc_number ) );
		
		$this->chat_config();
	}
	
	
	
	
	
	
	//---------------------------------------------------------------
	
	function chat_config_save()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$acc_number = intval($IN['chat_account_no']);
		
		//if ( $acc_number == "" )
		//{
		//	$ADMIN->error("Sorry, that is not a valid IP Chat account number");
		//}
		
		$new = array(   'chat_account_no'  => $acc_number,
						'chat_allow_guest' => $IN['chat_allow_guest'],
						'chat_width'       => $IN['chat_width'],
						'chat_height'      => $IN['chat_height'],
						'chat_language'    => $IN['chat_language'],
						'chat_display'     => $IN['chat_display'],
					);
					
		// Get the ID's of the groups we're emailing.
		
		$ids = array();
 		
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^sg_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$ids[] = $match[1];
 				}
 			}
 		}
 		
 		$new['chat_admin_groups'] = implode( ",", $ids );
		
		$ADMIN->rebuild_config( $new );
		
		$ADMIN->done_screen("IP ѳ]mws", "IP ѳ]m", "act=pin&code=ipchat" );
	}
	
	
	//--------------------------------------------------------------
	
	function chat_config()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ziHbUs]m";
		$ADMIN->page_title  = "IP ѳ]m";
		
		//+-------------------------------
		// SET UP SOME DEFAULTS
		//+-------------------------------
		
		$language = $INFO['chat_language'] == "" ? 'en' : $INFO['chat_language'];
		
		$larray = array( 0 => array( 'en', '^y' ),
						 1 => array( 'ar', 'ԧBy'  ),
						 2 => array( 'de', 'wy'  ),
						 3 => array( 'es', 'Zy' ),
						 4 => array( 'fr', 'ky'  ),
						 5 => array( 'hr', 'JùJȻy'),
						 6 => array( 'it', 'qjQy' ),
						 7 => array( 'iw', 'ƧBӻy'  ),
						 8 => array( 'nl', 'y'   ),
						 9 => array( 'pl', 'iy'  ),
						 10=> array( 'pt', 'y' ),
					   );
					   
		$display = array( 0 => array( 'self', '@ IPB ' ),
						  1 => array( 'new',  'suX' ),
						);
		
		
		//+-------------------------------
		// START THE FORM
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dochat' ),
												  2 => array( 'act'   , 'pin'    ),
									     )      );
									     
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"    , "60%" );
		$SKIN->td_header[] = array( "&nbsp;"    , "40%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "򥻳]m" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѫǱbXH</b><br>XN|Ҧ]tb IPB s / ѥ\C" ,
										  $SKIN->form_input( "chat_account_no", $INFO['chat_account_no'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\XȨϥβѫǡH</b><br> '_' N|nDҦϥΪ̵nJѫ" ,
										  $SKIN->form_yes_no( "chat_allow_guest", $INFO['chat_allow_guest']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѫǤؤo (e)H</b>" ,
										  $SKIN->form_input( "chat_width", $INFO['chat_width'] ? $INFO['chat_width'] : 600 )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ѫǤؤo ()H</b>" ,
										  $SKIN->form_input( "chat_height", $INFO['chat_height'] ? $INFO['chat_height'] : 350 )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>w]ѫǻyɭH</b>" ,
										  $SKIN->form_dropdown( "chat_language", $larray, $language  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Jѫǩ...H</b>" ,
										  $SKIN->form_dropdown( "chat_display", $display, $INFO['chat_display']  )
								 )      );
										 
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"    , "60%" );
		$SKIN->td_header[] = array( "&nbsp;"    , "40%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "޲zsv" );
		
		//-------------------------------
		// Break up our line of admins
		//-------------------------------
		
		$allowed = array();
		
		foreach( explode( ",", $INFO['chat_admin_groups'] ) as $i )
		{
			$allowed[ $i ] = 1;
		}
		
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups WHERE g_id <> ".$INFO['guest_group']." ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			
			$mode = $r['g_id'] == $INFO['admin_group'] ? 'green' : 'red';
		
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>\s '<span style='color:$mode'>{$r['g_title']}</span>' IP Ѻ޲zvH</b>" ,
												  $SKIN->form_yes_no( "sg_{$r['g_id']}", $allowed[ $r['g_id'] ] ? 1 : 0 )
									     	)      );
		}
		
									 
		$ADMIN->html .= $SKIN->end_form('xs]m');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	
		
		
		
		
								 
		
	
	}
	
	
	
	//-------------------------------------------------------------
	//
	// Save config. Does the hard work, so you don't have to.
	//
	//--------------------------------------------------------------
	
	function save_config( $new )
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$master = array();
		
		if ( is_array($new) )
		{
			if ( count($new) > 0 )
			{
				foreach( $new as $field )
				{
				
					// Handle special..
					
					if ($field == 'img_ext' or $field == 'avatar_ext')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/[\.\s]/", "" , $HTTP_POST_VARS[ $field ] );
						$HTTP_POST_VARS[ $field ] = preg_replace( "/,/"     , '|', $HTTP_POST_VARS[ $field ] );
					}
					else if ($field == 'coppa_address')
					{
						$HTTP_POST_VARS[ $field ] = nl2br( $HTTP_POST_VARS[ $field ] );
					}
					
					$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "&#39;", ($HTTP_POST_VARS[ $field ]) );
				
					$master[ $field ] = ($HTTP_POST_VARS[ $field ]);
				}
				
				$ADMIN->rebuild_config($master);
			}
		}
	}
	//-------------------------------------------------------------
	//
	// Common header: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_header( $formcode = "", $section = "", $extra = "" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$extra = $extra ? $extra."<br>" : $extra;
		
		$ADMIN->page_detail = $extra . "ЦbeXܧ󤧫eˬdzҿJ";
		$ADMIN->page_title  = "~]m [ $section ]";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $formcode ),
												  2 => array( 'act'   , 'pin'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "]w" );
		
	}

	//-------------------------------------------------------------
	//
	// Common footer: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_footer( $button="eXܧ" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->html .= $SKIN->end_form($button);
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}				
}


?>