<?php
/*
+--------------------------------------------------------------------------
|   IBFORUMS v1
|   ========================================
|   by Matthew Mecham and David Baxter
|   (c) 2001,2002 IBForums
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin wrapper script
|   > Script written by Matt Mecham
|   > Date started: 1st March 2002
|
+--------------------------------------------------------------------------
*/
/*-----------------------------------------------
  USER CONFIGURABLE ELEMENTS
 ------------------------------------------------*/

// Are we running this on a lycos / tripod server?
// If so, change the following to a 1.
$is_on_tripod = 0;
 
// Root path
define( 'ROOT_PATH', './' );
// Check IP address to see if they match?
// this may cause problems for users on proxies
// where the IP address changes during a session
$check_ip = 1;
// Use GZIP content encoding for fast page generation
// in the admin center?
$use_gzip = 1;
 
 
/*-----------------------------------------------
  NO USER EDITABLE SECTIONS BELOW
 ------------------------------------------------*/
 
error_reporting  (E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);
if ( $is_on_tripod != 1 )
{
	if (function_exists('ini_get'))
	{
		$safe_switch = @ini_get("safe_mode") ? 1 : 0;
	}
	else
	{
		$safe_switch = 1;
	}
}
else
{
	$safe_switch = 1;
}
define( 'SAFE_MODE_ON', $safe_switch );
if (function_exists("set_time_limit") == 1 and SAFE_MODE_ON == 0)
{
  @set_time_limit(0);
}
class Debug {
    function startTimer() {
        global $starttime;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $starttime = $mtime;
    }
    function endTimer() {
        global $starttime;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $endtime = $mtime;
        $totaltime = round (($endtime - $starttime), 5);
        return $totaltime;
    }
}
class info {
	var $vars    = "";
	var $version = '1.1';
	
	
	function info($INFO)
	{
		//global $INFO;
		$this->vars = $INFO;
	}
}
		
/*-----------------------------------------------
  Import $INFO
 ------------------------------------------------*/
 
require ROOT_PATH."conf_global.php";
$ibforums = new info($INFO);
$Debug = new Debug;
$Debug->startTimer();
/*-----------------------------------------------
  Make sure our data is reset on each invocation
 ------------------------------------------------*/
$MEMBER          = array();
$SESSION_ID      = "";
$SKIN            = "";
// Put an end to insane thoughs before they begin
$MEMBER_NAME     = "";
$MEMBER_PASSWORD = "";
$MEMBER_EMAIL    = "";
$UserName        = "";
$PassWord        = "";
/*-----------------------------------------------
  Load up our classes (compiled into one package)
 ------------------------------------------------*/
 
require ROOT_PATH."sources/functions.php";

$std     = new FUNC;
/*-----------------------------------------------
  Steralize our FORM and GET input
 ------------------------------------------------*/
$IN = $std->parse_incoming();
$IN['AD_SESS'] = $HTTP_POST_VARS['adsess'] ? $HTTP_POST_VARS['adsess'] : $HTTP_GET_VARS['adsess'];
/*-----------------------------------------------
  Import $PAGES and $CATS
 ------------------------------------------------*/
 
require ROOT_PATH."sources/Admin/admin_pages.php";
/*-----------------------------------------------
  Import Skinable elements
 ------------------------------------------------*/
 
require ROOT_PATH."sources/Admin/admin_skin.php";
$SKIN = new admin_skin();
/*-----------------------------------------------
  Import Admin Functions
 ------------------------------------------------*/
 
require ROOT_PATH."sources/Admin/admin_functions.php";
$ADMIN = new admin_functions();
/*-----------------------------------------------
  Load up our database library
 ------------------------------------------------*/
 
$INFO['sql_driver'] = !$INFO['sql_driver'] ? 'mySQL' : $INFO['sql_driver'];
$to_require = ROOT_PATH."sources/Drivers/".$INFO['sql_driver'].".php";
require ($to_require);
$DB = new db_driver;
$DB->obj['sql_database']     = $INFO['sql_database'];
$DB->obj['sql_user']         = $INFO['sql_user'];
$DB->obj['sql_pass']         = $INFO['sql_pass'];
$DB->obj['sql_host']         = $INFO['sql_host'];
$DB->obj['sql_tbl_prefix']   = $INFO['sql_tbl_prefix'];
// Get a DB connection
$DB->connect();
//------------------------------------------------
// Fix up the "show" ID's for the menu tree...
//
// show=1,4,5 holds the current ID's, clicking on a
// collapse link creates out=4 - "4" is then removed
// from the show link.
//
// Good eh?
//------------------------------------------------
if ($IN['show'] == 'none')
{
	$IN['show'] = "";
}
else if ($IN['show'] == 'all')
{
	$IN['show']     = "";
	
	foreach($CATS as $cid => $name)
	{
		$IN['show'] .= $cid.',';
	}
}
else
{
	$IN['show'] = preg_replace( "/(?:^|,)".$IN['out']."(?:,|$)/", ",", $IN['show'] );
	$IN['show'] = preg_replace( "/,,/" , "" , $IN['show'] );
	$IN['show'] = preg_replace( "/,$/" , "" , $IN['show'] );
	$IN['show'] = preg_replace( "/^,/" , "" , $IN['show'] );
}
//------------------------------------------------
// Admin.php Rules:
//
// No adsess number?
// -----------------
//
// Then we log into the admin CP
//
// Got adsess number?
// ------------------
//
// Then we check the cookie "ad_login" for a session key.
//
// If this session key matches the one stored in the admin_sessions
// table, then we check the data against the data stored in the 
// profiles table.
//
// The session key and ad_sess keys are generated each time we log in.
//
// If we don't have a valid adsess in the URL, then we ask for a log in.
//
//------------------------------------------------
$session_validated = 0;
$this_session      = array();
$validate_login = 0;
if ($IN['login'] != 'yes') {
	if ( (!$IN['adsess']) or (empty($IN['adsess'])) or (!isset($IN['adsess'])) or ($IN['adsess'] == "") )
	{
		//----------------------------------
		// No URL adsess found, lets log in.
		//----------------------------------
		
		do_login("o{޲z session ");
	}
	else
	{
		//----------------------------------
		// We have a URL adsess, lets verify...
		//----------------------------------
		
		$DB->query("SELECT * FROM ibf_admin_sessions WHERE ID='".$IN['adsess']."'");
		$row = $DB->fetch_row();
		
		if ($row['ID'] == "")
		{
			//----------------------------------
			// Fail-safe, no DB record found, lets log in..
			//----------------------------------
			
			do_login("Lko session O");
		}
		else if ($row['MEMBER_ID'] == "")
		{
		
			//----------------------------------
			// No member ID is stored, log in!
			//----------------------------------
			
			do_login("LkoĪ| id");
			
		}
		else
		{
			//----------------------------------
			// Key is good, check the member details
			//----------------------------------
			
			$DB->query("SELECT * FROM xbb_members WHERE uid='".$row['MEMBER_ID']."'");
			$MEMBER = $DB->fetch_row();
			
			if ($MEMBER['uid'] == "")
			{
			
				//----------------------------------
				// Ut-oh, no such member, log in!
				//----------------------------------
				
				do_login("Member ID invalid");
				
			}
			else
			{
				//----------------------------------
				// Member found, check passy
				//----------------------------------
				
				if ($row['SESSION_KEY'] != $MEMBER['pass'])
				{
					//----------------------------------
					// Passys don't match..
					//----------------------------------
					
					do_login("| ID L");
					
				}
				else
				{
					//----------------------------------
					// Do we have admin access?
					//----------------------------------
					
					$DB->query("SELECT * FROM ibf_groups WHERE g_id='".$MEMBER['mgroup']."'");
					
					$GROUP = $DB->fetch_row();
					
					if ($GROUP['g_access_cp'] != 1)
					{
						do_login("zSviJ޲zx");
					}
					else
					{
						$session_validated = 1;
						$this_session      = $row;
					}
				}
			}
		}
	}
}
else 
{
	//----------------------------------
	// We must have submitted the form
	// time to check some details.
	//----------------------------------
	
	if ( empty($IN['username']) )
	{
		do_login("You must enter a username before proceeding");
	}
	
	if ( empty($IN['password']) )
	{
		do_login("b~i椧ezJϥΪ̦W");
	}
	
	//----------------------------------
	// Attempt to get the details from the
	// DB
	//----------------------------------
	
	$DB->query("SELECT uname, pass, uid, mgroup FROM xbb_members WHERE LOWER(uname)='".strtolower($IN['username'])."'");
	$mem = $DB->fetch_row();
	
	if ( empty($mem['uid']) )
	{
		do_login("LkPoӨϥΪ̦W٬۲ŪOAˬdr");
	}
	
	$pass    = md5( $IN['password'] );
	
	if ($pass != $mem['pass'])
	{
		do_login("JKXPڭ̪O");
	}
	else
	{
		$DB->query("SELECT * FROM ibf_groups WHERE g_id='".$mem['mgroup']."'");
					
		$GROUP = $DB->fetch_row();
		
		if ($GROUP['g_access_cp'] != 1)
		{
			do_login("zSviJ޲zx");
		}
		else
		{
		
			//----------------------------------
			// All is good, rejoice as we set a
			// session for this user
			//----------------------------------
			
			$sess_id = md5( uniqid( microtime() ) );
			
			$db_string = $DB->compile_db_insert_string( array (
																'ID'           => $sess_id,
																'IP_ADDRESS'   => $IN['IP_ADDRESS'],
																'MEMBER_NAME'  => $mem['uname'],
																'MEMBER_ID'    => $mem['uid'],
																'SESSION_KEY'  => $pass,
																'LOCATION'     => 'index',
																'LOG_IN_TIME'  => time(),
																'RUNNING_TIME' => time(),
													  )        );
													  
			$DB->query("INSERT INTO ibf_admin_sessions (".$db_string['FIELD_NAMES'].") VALUES (".$db_string['FIELD_VALUES'].")");
		
			$IN['AD_SESS'] = $sess_id;
			
			// Print the "well done page"
			
			$ADMIN->page_title = "nJ";
			
			$ADMIN->page_detail = "aziJ޲zx";
			
			$ADMIN->html .= $SKIN->start_table("~i");
			
			$ADMIN->html .= "<tr><td id='tdrow1'><meta http-equiv='refresh' content='2; url=".$INFO['board_url']."/admin.".$INFO['php_ext']."?adsess=".$IN['AD_SESS']."'><a href='".$INFO['board_url']."/admin.".$INFO['php_ext']."?adsess=".$IN['AD_SESS']."'>( pGzQݽЫo )</a></td></tr>";
			
			$ADMIN->html .= $SKIN->end_table();
			
			$ADMIN->output();
		
		}
		
	}
		
}
//----------------------------------
// Ok, so far so good. If we have a 
// validate session, check the running
// time. if it's older than 2 hours,
// ask for a log in
//----------------------------------
if ($session_validated == 1)
{
	if ($this_session['RUNNING_TIME'] < ( time() - 60*60*2) )
	{
		$session_validated = 0;
		do_login("޲z session wgO");
	}
	
	//------------------------------
	// Are we checking IP's?
	//------------------------------
	
	else if ($check_ip == 1)
	{
		if ($this_session['IP_ADDRESS'] != $IN['IP_ADDRESS'])
		{
			$session_validated = 0;
			do_login("zثe IP }Pڭ̪O");
		}
	}
}
if ($session_validated == 1 )
{
	//------------------------------
	// If we get this far, we're good to go..
	//------------------------------
	
	$IN['AD_SESS'] = $IN['adsess'];
	
	//------------------------------
	// Lets update the sessions table:
	//------------------------------
	
	$DB->query("UPDATE ibf_admin_sessions SET RUNNING_TIME='".time()."', LOCATION='".$IN['act']."' WHERE MEMBER_ID='".$MEMBER['uid']."' AND ID='".$IN['AD_SESS']."'");
	
	do_admin_stuff();
	
}
else
{
	//------------------------------
	// Session is not validated...
	//------------------------------
	
	do_login(" - ЦAnJ");
	
}

function do_login($message="") {
	global $IN, $DB, $ADMIN, $SKIN;
	
	//-------------------------------------------------------
	// Remove all out of date sessions, like a good boy. Woof.
	//-------------------------------------------------------
	
	$cut_off_stamp = time() - 60*60*2;
	
	$DB->query("DELETE FROM ibf_admin_sessions WHERE RUNNING_TIME < $cut_off_stamp");
	
	//+------------------------------------------------------
	
	$ADMIN->page_detail = "zƺ޲zv~ন\\nJ Invision Board ޲zxC<br>ЦbUJz׾¨ϥΪ̦W٤αKX";
	
	if ($message != "")
	{
		$ADMIN->page_detail .= "<br><br><span style='color:red;font-weight:bold'>$message</span>";
	}
	
	$ADMIN->html .= "<script language='javascript'>
					  <!--
					  	if (top.location != self.location) { top.location = self.location }
					  //-->
					 </script>
					 ";
	
	$ADMIN->html .= $SKIN->start_form( array( 1 => array('login', 'yes') ) );
	
	$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
	$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
	
	$ADMIN->html .= $SKIN->start_table( "nDT{" );
	
	$ADMIN->html .= $SKIN->add_td_row( array( "޲z̦W:",
											  "<input type='text' style='width:100%' name='username' value=''>",
									 )      );
		
	$ADMIN->html .= $SKIN->add_td_row( array( "JKX:",
											  "<input type='password' style='width:100%' name='password' value=''>",
									 )      );
									 
	$ADMIN->html .= $SKIN->end_form("nJ");
	
	$ADMIN->html .= $SKIN->end_table();
		
	$ADMIN->output();
}


function do_admin_stuff() {
	global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $ibforums;
	/*----------------------------------
	  What do you want to require today?
	------------------------------------*/
	
	$choice = array(
					 "idx"      => "doframes",
					 "menu"     => "menu",
					 "index"    => "index",
					 "cat"      => "categories",
					 "forum"    => "forums",
					 "mem"      => "member",
					 'group'    => "groups",
					 'mod'      => 'moderator',
					 'op'       => 'settings',
					 'help'     => 'help',
					 'skin'     => 'skins',
					 'wrap'     => 'wrappers',
					 'style'    => 'stylesheets',
					 'image'    => 'imagemacros',
					 'sets'     => 'stylesets',
					 'templ'    => 'templates',
					 'rtempl'   => 'remote_template',
					 'lang'     => 'languages',
					 'import'   => 'skin_import',
					 'modlog'   => 'modlogs',
					 'field'   => 'profilefields',
					 'stats'   => "statistics",
					 'quickhelp' => "quickhelp",
					 'adminlog'  => "adminlogs",
					 'ips'       => 'ips',
					 'mysql'     => 'mysql',
					 'pin'       => 'plugins',
				   );
	
					
	/***************************************************/
	
	$IN['act'] = $IN['act'] == '' ? "idx" : $IN['act'];
	
	// Check to make sure the array key exits..
	if (! isset($choice[$IN['act']]) ) {
		$IN['act'] = 'idx';
	}
	
	// Require and run
	
	if ($IN['act'] == 'idx')
	{
		print $SKIN->frame_set();
		exit;
	}
	else if ($IN['act'] == 'menu')
	{
		$ADMIN->menu();
	}
	else
	{
		require ROOT_PATH."sources/Admin/ad_".$choice[$IN['act']].".php";
	}
	
}

//+-------------------------------------------------
// GLOBAL ROUTINES
//+-------------------------------------------------
function fatal_error($message="", $help="") {
	echo("$message<br><br>$help");
	exit;
}
?>
