#define IN_TP_QT_HEADER
#include "TelepathyQt/call-stream.h"

namespace Tp
{
namespace Client
{

CallStreamInterface::CallStreamInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallStreamInterface::CallStreamInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallStreamInterface::CallStreamInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

void CallStreamInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(RemoteMembersChanged(const Tp::ContactSendingStateMap&, const Tp::HandleIdentifierMap&, const Tp::UIntList&, const Tp::CallStateReason&)), NULL, NULL);
    disconnect(this, SIGNAL(LocalSendingStateChanged(uint, const Tp::CallStateReason&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}

CallStreamInterfaceMediaInterface::CallStreamInterfaceMediaInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

CallStreamInterfaceMediaInterface::CallStreamInterfaceMediaInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

CallStreamInterfaceMediaInterface::CallStreamInterfaceMediaInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

CallStreamInterfaceMediaInterface::CallStreamInterfaceMediaInterface(const Tp::Client::CallStreamInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

CallStreamInterfaceMediaInterface::CallStreamInterfaceMediaInterface(const Tp::Client::CallStreamInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void CallStreamInterfaceMediaInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(SendingStateChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(ReceivingStateChanged(uint)), NULL, NULL);
    disconnect(this, SIGNAL(LocalCandidatesAdded(const Tp::CandidateList&)), NULL, NULL);
    disconnect(this, SIGNAL(LocalCredentialsChanged(const QString&, const QString&)), NULL, NULL);
    disconnect(this, SIGNAL(RelayInfoChanged(const Tp::StringVariantMapList&)), NULL, NULL);
    disconnect(this, SIGNAL(STUNServersChanged(const Tp::SocketAddressIPList&)), NULL, NULL);
    disconnect(this, SIGNAL(ServerInfoRetrieved()), NULL, NULL);
    disconnect(this, SIGNAL(EndpointsChanged(const Tp::ObjectPathList&, const Tp::ObjectPathList&)), NULL, NULL);
    disconnect(this, SIGNAL(ICERestartRequested()), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
