/************************************************************************/
/*									*/
/*  Identifies RTF control words					*/
/*									*/
/************************************************************************/

typedef enum RtfTag
    {
				/****************************************/
				/*  Document group.			*/
				/****************************************/
    RTFidPN,
				/****************************************/
				/*  Groups inside the document.		*/
				/****************************************/
    RTFidF,
				/****************************************/
				/*  Font number.			*/
				/****************************************/
    RTFidUC,
				/****************************************/
				/*  Document properties.		*/
				/****************************************/

				/****************************************/
				/*  Revision marks for paragraph	*/
				/*  numbers.				*/
				/****************************************/
				/****************************************/
				/*  Multilevel Lists.			*/
				/****************************************/
    RTFidPNSECLVL,

				/****************************************/
				/*  Character Formatting Properties	*/
				/****************************************/
    RTFidULNONE,
    RTFidV,

				/****************************************/
				/*  Pictures				*/
				/****************************************/
    RTFidDO,
				/****************************************/
				/*  Pictures, objects			*/
				/****************************************/
    RTFidOBJCLASS,
    RTFidOBJNAME,
    RTFidOBJDATA,

				/****************************************/
				/*  Table definitions			*/
				/****************************************/

				/****************************************/
				/*  Bullets and Numbering.		*/
				/*  (No destinations)			*/
				/****************************************/
    RTFidPNHANG,
    RTFidPNULNONE,

				/****************************************/
				/*  Fields, Bookmarks.			*/
				/****************************************/
    RTFidFIELD,

    RTFidBKMKSTART,
    RTFidBKMKEND,
				/****************************************/
				/*  Index entries.			*/
				/*  Table of contents entries.		*/
				/****************************************/

				/****************************************/
				/*  Associated Character Properties	*/
				/****************************************/

				/****************************************/
				/*  About bullet numbering.		*/
				/****************************************/
    RTFidPNTXTA,
    RTFidPNTXTB,
				/****************************************/
				/*  Groups inside the 'info' group.	*/
				/****************************************/
    RTFidOPERATOR,
    RTFidVERSION,
    RTFidEDMINS,
    RTFidNOFPAGES,
    RTFidNOFWORDS,
    RTFidNOFCHARS,
    RTFidNOFCHARSWS,
    RTFidVERN,
				/****************************************/
				/*  Fields in dates and times.		*/
				/****************************************/
    RTFidHR,
    RTFidMIN,
    RTFidSEC,
    RTFidDY,
    RTFidMO,
    RTFidYR,
				/****************************************/
				/*  Unknown				*/
				/****************************************/

    RTFid_NOT_SUPPORTED,

    RTFid__COUNT

    } RtfTag;

