#include <cgreen/cgreen.h>
#include "../assert_octave.h"
#include <octave/oct.h>
#include "../../Cost_spikespec_event_fcn.h"

using namespace cgreen;

double data_spikespec [] = {1, 22, 3, 44, 5, 66, 7, 88, 9, 10};

Ensure (transform_works_like_in_TISEAN_when_inter_true)
{
  double TISEAN_result [] = {1, 23, 26, 70, 75, 141, 148, 236, 245, 255};
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_spikespec, sizeof (data_spikespec));
  Cost_spikespec_event_fcn cost_f (&mat);

  // Perform test
  cost_f.cost_transform ();
  Matrix TS_res (10,1);
  memcpy (TS_res.fortran_vec (), TISEAN_result, sizeof (TISEAN_result));

  assert_matrix_equal_with_tol (mat, TS_res, 0);
}

Ensure (transform_works_like_in_TISEAN_when_inter_false)
{
  double TISEAN_result [] = {1, 3, 5, 7, 9, 10, 22, 44, 66, 88};
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_spikespec, sizeof (data_spikespec));
  Cost_spikespec_event_fcn cost_f (&mat, false);

  // Perform test
  cost_f.cost_transform ();
  Matrix TS_res (10,1);
  memcpy (TS_res.fortran_vec (), TISEAN_result, sizeof (TISEAN_result));

  assert_matrix_equal_with_tol (mat, TS_res, 0);
}

Ensure (cost_inverse_returns_same_matrix_as_input_matrix)
{
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_spikespec, sizeof (data_spikespec));
  Cost_spikespec_event_fcn cost_f (&mat);

  Matrix mat_original (mat);
  // Perform test
  cost_f.cost_transform ();
  Matrix inverse = cost_f.cost_inverse ();

  assert_matrix_equal_with_tol (inverse, mat_original, 0);
}

Ensure (default_values_for_parameters_are_same_as_TISEAN)
{

}

TestSuite *cost_spikespec_event_tests ()
{
  TestSuite *suite = create_test_suite ();
  add_test (suite, transform_works_like_in_TISEAN_when_inter_true);
  add_test (suite, transform_works_like_in_TISEAN_when_inter_false);
  add_test (suite, cost_inverse_returns_same_matrix_as_input_matrix);
  add_test (suite, default_values_for_parameters_are_same_as_TISEAN);
  return suite;
}
