; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 -global-isel=0 < %s | FileCheck -enable-var-scope --check-prefixes=GCN,SDAG %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx950 -global-isel=1 -global-isel-abort=2 -verify-machineinstrs < %s | FileCheck -enable-var-scope --check-prefixes=GCN,GISEL %s

declare <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.f16(<8 x half>, <8 x half>, <4 x float>, i32 immarg, i32 immarg, i32 immarg)
declare <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half>, <8 x half>, <16 x float>, i32 immarg, i32 immarg, i32 immarg)

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.f32.16x16x32.f16
; --------------------------------------------------------------------

define <4 x float> @test_mfma_f32_16x16x32_f16(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_16x16x32_f16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.f16(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2, i32 0, i32 0, i32 0)
  ret <4 x float> %result
}

define <4 x float> @test_mfma_f32_16x16x32_f16__flags(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_16x16x32_f16__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.f16(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2, i32 1, i32 1, i32 1)
  ret <4 x float> %result
}

define amdgpu_kernel void @test_mfma_f32_16x16x32_f16_no_agpr__vgprcd(ptr addrspace(1) %out, <8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2) #0 {
; SDAG-LABEL: test_mfma_f32_16x16x32_f16_no_agpr__vgprcd:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; SDAG-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s0
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s1
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s2
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s3
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3]
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_16x16x32_f16_no_agpr__vgprcd:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GISEL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s0
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s1
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s2
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s3
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3]
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 6
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[6:7]
; GISEL-NEXT:    s_endpgm
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.f16(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2, i32 0, i32 0, i32 0)
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_16x16x32_f16_no_agpr__vgprcd__flags(ptr addrspace(1) %out, <8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2) #0 {
; SDAG-LABEL: test_mfma_f32_16x16x32_f16_no_agpr__vgprcd__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; SDAG-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s0
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s1
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s2
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s3
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:3 abid:2 blgp:1
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_16x16x32_f16_no_agpr__vgprcd__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GISEL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s0
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s1
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s2
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s3
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_f32_16x16x32_f16 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:3 abid:2 blgp:1
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 6
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[6:7]
; GISEL-NEXT:    s_endpgm
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.f16(<8 x half> %arg0, <8 x half> %arg1, <4 x float> %arg2, i32 3, i32 2, i32 1)
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.f32.32x32x16.f16
; --------------------------------------------------------------------

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2) #1 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b64_e32 v[12:13], 48
; SDAG-NEXT:    v_mov_b64_e32 v[14:15], 32
; SDAG-NEXT:    v_mov_b64_e32 v[16:17], 16
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    v_mov_b64_e32 v[18:19], 0
; SDAG-NEXT:    v_mov_b32_e32 v8, s16
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15]
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    v_mov_b32_e32 v9, s17
; SDAG-NEXT:    v_mov_b32_e32 v10, s18
; SDAG-NEXT:    v_mov_b32_e32 v11, s19
; SDAG-NEXT:    s_nop 4
; SDAG-NEXT:    global_store_dwordx4 v[12:13], a[28:31], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], a[24:27], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[16:17], a[20:23], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[18:19], a[16:19], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], v[8:11], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v[18:19], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v[16:17], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], 0
; GISEL-NEXT:    v_mov_b64_e32 v[26:27], 48
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], 16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[22:23]
; GISEL-NEXT:    v_mov_b64_e32 v[24:25], 32
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    s_nop 4
; GISEL-NEXT:    global_store_dwordx4 v[20:21], a[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], a[20:23], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], a[24:27], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], a[28:31], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[20:21], v[8:11], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], v[12:15], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], v[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], v[0:3], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x float> %result, ptr addrspace(1) null
  store volatile <16 x float> %arg2, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16__flags(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2) #1 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b64_e32 v[12:13], 48
; SDAG-NEXT:    v_mov_b64_e32 v[14:15], 32
; SDAG-NEXT:    v_mov_b64_e32 v[16:17], 16
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    v_mov_b64_e32 v[18:19], 0
; SDAG-NEXT:    v_mov_b32_e32 v8, s16
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:2 abid:3 blgp:1
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    v_mov_b32_e32 v9, s17
; SDAG-NEXT:    v_mov_b32_e32 v10, s18
; SDAG-NEXT:    v_mov_b32_e32 v11, s19
; SDAG-NEXT:    s_nop 4
; SDAG-NEXT:    global_store_dwordx4 v[12:13], a[28:31], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], a[24:27], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[16:17], a[20:23], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[18:19], a[16:19], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], v[8:11], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v[18:19], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v[16:17], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], 0
; GISEL-NEXT:    v_mov_b64_e32 v[26:27], 48
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], 16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:2 abid:3 blgp:1
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[22:23]
; GISEL-NEXT:    v_mov_b64_e32 v[24:25], 32
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    s_nop 4
; GISEL-NEXT:    global_store_dwordx4 v[20:21], a[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], a[20:23], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], a[24:27], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], a[28:31], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[20:21], v[8:11], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], v[12:15], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], v[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], v[0:3], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 2, i32 3, i32 1)
  store volatile <16 x float> %result, ptr addrspace(1) null
  store volatile <16 x float> %arg2, ptr addrspace(1) null
  ret void
}

define <16 x float> @test_mfma_f32_32x32x16_f16__mac(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_32x32x16_f16__mac:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  ret <16 x float> %result
}

define <16 x float> @test_mfma_f32_32x32x16_f16__mac__flags(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_32x32x16_f16__mac__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 1, i32 1, i32 1)
  ret <16 x float> %result
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16__vgprcd(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16__vgprcd:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    v_mov_b32_e32 v12, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a31, s23
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a30, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a29, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a28, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a27, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a26, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a25, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a24, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a23, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a22, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a21, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a20, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a19, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a18, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a17, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a16, s8
; SDAG-NEXT:    v_mov_b32_e32 v8, s20
; SDAG-NEXT:    v_mov_b32_e32 v9, s21
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[16:31]
; SDAG-NEXT:    v_mov_b32_e32 v10, s22
; SDAG-NEXT:    v_mov_b32_e32 v11, s23
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[8:11], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[12:15], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[4:7], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16__vgprcd:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    v_mov_b32_e32 v24, 0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], s[22:23]
; GISEL-NEXT:    global_store_dwordx4 v24, v[8:11], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[12:15], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[16:19], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[20:23], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[16:19], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[20:23], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[24:27], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[28:31], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x float> %arg2, ptr addrspace(1) %out
  store volatile <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16__vgprcd__flags(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16__vgprcd__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    v_mov_b32_e32 v12, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a31, s23
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a30, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a29, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a28, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a27, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a26, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a25, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a24, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a23, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a22, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a21, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a20, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a19, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a18, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a17, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a16, s8
; SDAG-NEXT:    v_mov_b32_e32 v8, s20
; SDAG-NEXT:    v_mov_b32_e32 v9, s21
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[16:31] cbsz:1 abid:2 blgp:3
; SDAG-NEXT:    v_mov_b32_e32 v10, s22
; SDAG-NEXT:    v_mov_b32_e32 v11, s23
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[8:11], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[12:15], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v12, a[4:7], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16__vgprcd__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    v_mov_b32_e32 v24, 0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:1 abid:2 blgp:3
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], s[22:23]
; GISEL-NEXT:    global_store_dwordx4 v24, v[8:11], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[12:15], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[16:19], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[20:23], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[16:19], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[20:23], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[24:27], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[28:31], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 1, i32 2, i32 3)
  store volatile <16 x float> %arg2, ptr addrspace(1) %out
  store volatile <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16__vgprcd_mac(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16__vgprcd_mac:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15]
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    s_nop 2
; SDAG-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; SDAG-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; SDAG-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; SDAG-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16__vgprcd_mac:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 7
; GISEL-NEXT:    s_nop 2
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GISEL-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GISEL-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GISEL-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 0, i32 0, i32 0)
  store <16 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_32x32x16_f16__vgprcd_mac_flags(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_f32_32x32x16_f16__vgprcd_mac_flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; SDAG-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; SDAG-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:3 abid:2 blgp:1
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    s_nop 2
; SDAG-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; SDAG-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; SDAG-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; SDAG-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_f32_32x32x16_f16__vgprcd_mac_flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_f32_32x32x16_f16 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:3 abid:2 blgp:1
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 7
; GISEL-NEXT:    s_nop 2
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GISEL-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GISEL-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GISEL-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GISEL-NEXT:    s_endpgm
  %result = call <16 x float> @llvm.amdgcn.mfma.f32.32x32x16.f16(<8 x half> %arg0, <8 x half> %arg1, <16 x float> %arg2, i32 3, i32 2, i32 1)
  store <16 x float> %result, ptr addrspace(1) %out
  ret void
}

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.i32.16x16x64.i8
; --------------------------------------------------------------------

declare <4 x i32> @llvm.amdgcn.mfma.i32.16x16x64.i8(<4 x i32>, <4 x i32>, <4 x i32>, i32 immarg, i32 immarg, i32 immarg)

define <4 x i32> @test_mfma_i32_16x16x64_i8(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2) {
; GCN-LABEL: test_mfma_i32_16x16x64_i8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i32> @llvm.amdgcn.mfma.i32.16x16x64.i8(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2, i32 0, i32 0, i32 0)
  ret <4 x i32> %result
}

define <4 x i32> @test_mfma_i32_16x16x64_i8__flags(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2) {
; GCN-LABEL: test_mfma_i32_16x16x64_i8__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i32> @llvm.amdgcn.mfma.i32.16x16x64.i8(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2, i32 1, i32 1, i32 1)
  ret <4 x i32> %result
}

define amdgpu_kernel void @test_mfma_i32_16x16x64_i8_no_agpr__vgprcd(ptr addrspace(1) %out, <4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2) #0 {
; SDAG-LABEL: test_mfma_i32_16x16x64_i8_no_agpr__vgprcd:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; SDAG-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    v_mov_b32_e32 v4, s12
; SDAG-NEXT:    v_mov_b32_e32 v5, s13
; SDAG-NEXT:    v_mov_b32_e32 v6, s14
; SDAG-NEXT:    v_mov_b32_e32 v7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s0
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s1
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s2
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s3
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3]
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_16x16x64_i8_no_agpr__vgprcd:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GISEL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s0
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s1
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s2
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s3
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3]
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 6
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[6:7]
; GISEL-NEXT:    s_endpgm
  %result = call <4 x i32> @llvm.amdgcn.mfma.i32.16x16x64.i8(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2, i32 0, i32 0, i32 0)
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_i32_16x16x64_i8_no_agpr__vgprcd__flags(ptr addrspace(1) %out, <4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2) #0 {
; SDAG-LABEL: test_mfma_i32_16x16x64_i8_no_agpr__vgprcd__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; SDAG-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    v_mov_b32_e32 v4, s12
; SDAG-NEXT:    v_mov_b32_e32 v5, s13
; SDAG-NEXT:    v_mov_b32_e32 v6, s14
; SDAG-NEXT:    v_mov_b32_e32 v7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s0
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s1
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s2
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s3
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:3 abid:2 blgp:1
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_16x16x64_i8_no_agpr__vgprcd__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GISEL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s0
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s1
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s2
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s3
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_i32_16x16x64_i8 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:3 abid:2 blgp:1
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 6
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[6:7]
; GISEL-NEXT:    s_endpgm
  %result = call <4 x i32> @llvm.amdgcn.mfma.i32.16x16x64.i8(<4 x i32> %arg0, <4 x i32> %arg1, <4 x i32> %arg2, i32 3, i32 2, i32 1)
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.i32.32x32x32.i8
; --------------------------------------------------------------------

declare <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32>, <4 x i32>, <16 x i32>, i32 immarg, i32 immarg, i32 immarg)

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2) #1 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b64_e32 v[8:9], 48
; SDAG-NEXT:    v_mov_b64_e32 v[10:11], 32
; SDAG-NEXT:    v_mov_b64_e32 v[12:13], 16
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s24
; SDAG-NEXT:    v_mov_b32_e32 v1, s25
; SDAG-NEXT:    v_mov_b32_e32 v2, s26
; SDAG-NEXT:    v_mov_b32_e32 v3, s27
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b32_e32 v4, s28
; SDAG-NEXT:    v_mov_b32_e32 v5, s29
; SDAG-NEXT:    v_mov_b32_e32 v6, s30
; SDAG-NEXT:    v_mov_b32_e32 v7, s31
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    v_mov_b64_e32 v[14:15], 0
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15]
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v[8:9], a[28:31], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[10:11], a[24:27], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[12:13], a[20:23], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], a[16:19], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[10:11], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v[14:15], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], 0
; GISEL-NEXT:    v_mov_b64_e32 v[26:27], 48
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], 16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[22:23]
; GISEL-NEXT:    v_mov_b64_e32 v[24:25], 32
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    s_nop 4
; GISEL-NEXT:    global_store_dwordx4 v[20:21], a[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], a[20:23], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], a[24:27], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], a[28:31], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[20:21], v[8:11], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], v[12:15], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], v[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], v[0:3], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x i32> %result, ptr addrspace(1) null
  store volatile <16 x i32> %arg2, ptr addrspace(1) null
  ret void
}

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8__flags(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2) #1 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b64_e32 v[8:9], 48
; SDAG-NEXT:    v_mov_b64_e32 v[10:11], 32
; SDAG-NEXT:    v_mov_b64_e32 v[12:13], 16
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s24
; SDAG-NEXT:    v_mov_b32_e32 v1, s25
; SDAG-NEXT:    v_mov_b32_e32 v2, s26
; SDAG-NEXT:    v_mov_b32_e32 v3, s27
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_mov_b32_e32 v4, s28
; SDAG-NEXT:    v_mov_b32_e32 v5, s29
; SDAG-NEXT:    v_mov_b32_e32 v6, s30
; SDAG-NEXT:    v_mov_b32_e32 v7, s31
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    v_mov_b64_e32 v[14:15], 0
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:2 abid:3 blgp:1
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    global_store_dwordx4 v[8:9], a[28:31], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[10:11], a[24:27], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[12:13], a[20:23], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[14:15], a[16:19], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v[10:11], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    global_store_dwordx4 v[8:9], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v[14:15], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v[12:13], v[0:3], off sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], 0
; GISEL-NEXT:    v_mov_b64_e32 v[26:27], 48
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], 16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:2 abid:3 blgp:1
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[22:23]
; GISEL-NEXT:    v_mov_b64_e32 v[24:25], 32
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    s_nop 4
; GISEL-NEXT:    global_store_dwordx4 v[20:21], a[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], a[20:23], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], a[24:27], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], a[28:31], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[20:21], v[8:11], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[22:23], v[12:15], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[24:25], v[16:19], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v[26:27], v[0:3], off sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 2, i32 3, i32 1)
  store volatile <16 x i32> %result, ptr addrspace(1) null
  store volatile <16 x i32> %arg2, ptr addrspace(1) null
  ret void
}

define <16 x i32> @test_mfma_i32_32x32x32_i8__mac(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2) {
; GCN-LABEL: test_mfma_i32_32x32x32_i8__mac:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 0, i32 0, i32 0)
  ret <16 x i32> %result
}

define <16 x i32> @test_mfma_i32_32x32x32_i8__mac__flags(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2) {
; GCN-LABEL: test_mfma_i32_32x32x32_i8__mac__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    v_accvgpr_write_b32 a4, v12
; GCN-NEXT:    v_accvgpr_write_b32 a5, v13
; GCN-NEXT:    v_accvgpr_write_b32 a6, v14
; GCN-NEXT:    v_accvgpr_write_b32 a7, v15
; GCN-NEXT:    v_accvgpr_write_b32 a8, v16
; GCN-NEXT:    v_accvgpr_write_b32 a9, v17
; GCN-NEXT:    v_accvgpr_write_b32 a10, v18
; GCN-NEXT:    v_accvgpr_write_b32 a11, v19
; GCN-NEXT:    v_accvgpr_write_b32 a12, v20
; GCN-NEXT:    v_accvgpr_write_b32 a13, v21
; GCN-NEXT:    v_accvgpr_write_b32 a14, v22
; GCN-NEXT:    v_accvgpr_write_b32 a15, v23
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    s_nop 3
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    v_accvgpr_read_b32 v4, a4
; GCN-NEXT:    v_accvgpr_read_b32 v5, a5
; GCN-NEXT:    v_accvgpr_read_b32 v6, a6
; GCN-NEXT:    v_accvgpr_read_b32 v7, a7
; GCN-NEXT:    v_accvgpr_read_b32 v8, a8
; GCN-NEXT:    v_accvgpr_read_b32 v9, a9
; GCN-NEXT:    v_accvgpr_read_b32 v10, a10
; GCN-NEXT:    v_accvgpr_read_b32 v11, a11
; GCN-NEXT:    v_accvgpr_read_b32 v12, a12
; GCN-NEXT:    v_accvgpr_read_b32 v13, a13
; GCN-NEXT:    v_accvgpr_read_b32 v14, a14
; GCN-NEXT:    v_accvgpr_read_b32 v15, a15
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 1, i32 1, i32 1)
  ret <16 x i32> %result
}

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8__vgprcd(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8__vgprcd:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[20:27], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b32_e32 v4, s24
; SDAG-NEXT:    v_mov_b32_e32 v5, s25
; SDAG-NEXT:    v_mov_b32_e32 v6, s26
; SDAG-NEXT:    v_mov_b32_e32 v7, s27
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_accvgpr_write_b32 a31, s23
; SDAG-NEXT:    v_accvgpr_write_b32 a30, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a29, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a28, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a27, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a26, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a25, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a24, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a23, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a22, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a21, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a20, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a19, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a18, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a17, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a16, s8
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[16:31]
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[8:11], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[12:15], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[4:7], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8__vgprcd:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    v_mov_b32_e32 v24, 0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], s[22:23]
; GISEL-NEXT:    global_store_dwordx4 v24, v[8:11], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[12:15], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[16:19], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[20:23], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[16:19], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[20:23], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[24:27], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[28:31], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 0, i32 0, i32 0)
  store volatile <16 x i32> %arg2, ptr addrspace(1) %out
  store volatile <16 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8__vgprcd__flags(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8__vgprcd__flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[20:27], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    v_mov_b32_e32 v8, 0
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b32_e32 v4, s24
; SDAG-NEXT:    v_mov_b32_e32 v5, s25
; SDAG-NEXT:    v_mov_b32_e32 v6, s26
; SDAG-NEXT:    v_mov_b32_e32 v7, s27
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_accvgpr_write_b32 a31, s23
; SDAG-NEXT:    v_accvgpr_write_b32 a30, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a29, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a28, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a27, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a26, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a25, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a24, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a23, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a22, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a21, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a20, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a19, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a18, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a17, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a16, s8
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[16:31] cbsz:1 abid:2 blgp:3
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s16
; SDAG-NEXT:    v_mov_b32_e32 v1, s17
; SDAG-NEXT:    v_mov_b32_e32 v2, s18
; SDAG-NEXT:    v_mov_b32_e32 v3, s19
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s12
; SDAG-NEXT:    v_mov_b32_e32 v1, s13
; SDAG-NEXT:    v_mov_b32_e32 v2, s14
; SDAG-NEXT:    v_mov_b32_e32 v3, s15
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_nop 0
; SDAG-NEXT:    v_mov_b32_e32 v0, s8
; SDAG-NEXT:    v_mov_b32_e32 v1, s9
; SDAG-NEXT:    v_mov_b32_e32 v2, s10
; SDAG-NEXT:    v_mov_b32_e32 v3, s11
; SDAG-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[8:11], s[0:1] offset:32 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[12:15], s[0:1] offset:48 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[0:3], s[0:1] sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    global_store_dwordx4 v8, a[4:7], s[0:1] offset:16 sc0 sc1
; SDAG-NEXT:    s_waitcnt vmcnt(0)
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8__vgprcd__flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    v_mov_b32_e32 v24, 0
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    v_mov_b64_e32 v[8:9], s[8:9]
; GISEL-NEXT:    v_mov_b64_e32 v[10:11], s[10:11]
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[16:31], v[0:3], v[4:7], a[0:15] cbsz:1 abid:2 blgp:3
; GISEL-NEXT:    v_mov_b64_e32 v[12:13], s[12:13]
; GISEL-NEXT:    v_mov_b64_e32 v[16:17], s[16:17]
; GISEL-NEXT:    v_mov_b64_e32 v[20:21], s[20:21]
; GISEL-NEXT:    v_mov_b64_e32 v[14:15], s[14:15]
; GISEL-NEXT:    v_mov_b64_e32 v[18:19], s[18:19]
; GISEL-NEXT:    v_mov_b64_e32 v[22:23], s[22:23]
; GISEL-NEXT:    global_store_dwordx4 v24, v[8:11], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[12:15], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[16:19], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, v[20:23], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[16:19], s[0:1] sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[20:23], s[0:1] offset:16 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[24:27], s[0:1] offset:32 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    global_store_dwordx4 v24, a[28:31], s[0:1] offset:48 sc0 sc1
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 1, i32 2, i32 3)
  store volatile <16 x i32> %arg2, ptr addrspace(1) %out
  store volatile <16 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8__vgprcd_mac(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8__vgprcd_mac:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[20:27], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b32_e32 v4, s24
; SDAG-NEXT:    v_mov_b32_e32 v5, s25
; SDAG-NEXT:    v_mov_b32_e32 v6, s26
; SDAG-NEXT:    v_mov_b32_e32 v7, s27
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15]
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    s_nop 2
; SDAG-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; SDAG-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; SDAG-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; SDAG-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8__vgprcd_mac:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15]
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 7
; GISEL-NEXT:    s_nop 2
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GISEL-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GISEL-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GISEL-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 0, i32 0, i32 0)
  store <16 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_i32_32x32x32_i8__vgprcd_mac_flags(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, ptr addrspace(1) %out) #0 {
; SDAG-LABEL: test_mfma_i32_32x32x32_i8__vgprcd_mac_flags:
; SDAG:       ; %bb.0:
; SDAG-NEXT:    s_load_dwordx8 s[20:27], s[4:5], 0x24
; SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_mov_b32_e32 v0, s20
; SDAG-NEXT:    v_mov_b32_e32 v1, s21
; SDAG-NEXT:    v_mov_b32_e32 v2, s22
; SDAG-NEXT:    v_mov_b32_e32 v3, s23
; SDAG-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; SDAG-NEXT:    v_mov_b32_e32 v4, s24
; SDAG-NEXT:    v_mov_b32_e32 v5, s25
; SDAG-NEXT:    v_mov_b32_e32 v6, s26
; SDAG-NEXT:    v_mov_b32_e32 v7, s27
; SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-NEXT:    v_accvgpr_write_b32 a0, s8
; SDAG-NEXT:    v_accvgpr_write_b32 a1, s9
; SDAG-NEXT:    v_accvgpr_write_b32 a2, s10
; SDAG-NEXT:    v_accvgpr_write_b32 a3, s11
; SDAG-NEXT:    v_accvgpr_write_b32 a4, s12
; SDAG-NEXT:    v_accvgpr_write_b32 a5, s13
; SDAG-NEXT:    v_accvgpr_write_b32 a6, s14
; SDAG-NEXT:    v_accvgpr_write_b32 a7, s15
; SDAG-NEXT:    v_accvgpr_write_b32 a8, s16
; SDAG-NEXT:    v_accvgpr_write_b32 a9, s17
; SDAG-NEXT:    v_accvgpr_write_b32 a10, s18
; SDAG-NEXT:    v_accvgpr_write_b32 a11, s19
; SDAG-NEXT:    v_accvgpr_write_b32 a12, s20
; SDAG-NEXT:    v_accvgpr_write_b32 a13, s21
; SDAG-NEXT:    v_accvgpr_write_b32 a14, s22
; SDAG-NEXT:    v_accvgpr_write_b32 a15, s23
; SDAG-NEXT:    s_nop 1
; SDAG-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:3 abid:2 blgp:1
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_nop 7
; SDAG-NEXT:    s_nop 2
; SDAG-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; SDAG-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; SDAG-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; SDAG-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: test_mfma_i32_32x32x32_i8__vgprcd_mac_flags:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0x24
; GISEL-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xa4
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[24:25]
; GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[26:27]
; GISEL-NEXT:    v_mov_b64_e32 v[4:5], s[28:29]
; GISEL-NEXT:    v_accvgpr_write_b32 a0, s8
; GISEL-NEXT:    v_mov_b64_e32 v[6:7], s[30:31]
; GISEL-NEXT:    v_accvgpr_write_b32 a1, s9
; GISEL-NEXT:    v_accvgpr_write_b32 a2, s10
; GISEL-NEXT:    v_accvgpr_write_b32 a3, s11
; GISEL-NEXT:    v_accvgpr_write_b32 a4, s12
; GISEL-NEXT:    v_accvgpr_write_b32 a5, s13
; GISEL-NEXT:    v_accvgpr_write_b32 a6, s14
; GISEL-NEXT:    v_accvgpr_write_b32 a7, s15
; GISEL-NEXT:    v_accvgpr_write_b32 a8, s16
; GISEL-NEXT:    v_accvgpr_write_b32 a9, s17
; GISEL-NEXT:    v_accvgpr_write_b32 a10, s18
; GISEL-NEXT:    v_accvgpr_write_b32 a11, s19
; GISEL-NEXT:    v_accvgpr_write_b32 a12, s20
; GISEL-NEXT:    v_accvgpr_write_b32 a13, s21
; GISEL-NEXT:    v_accvgpr_write_b32 a14, s22
; GISEL-NEXT:    v_accvgpr_write_b32 a15, s23
; GISEL-NEXT:    s_nop 1
; GISEL-NEXT:    v_mfma_i32_32x32x32_i8 a[0:15], v[0:3], v[4:7], a[0:15] cbsz:3 abid:2 blgp:1
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_nop 7
; GISEL-NEXT:    s_nop 2
; GISEL-NEXT:    global_store_dwordx4 v0, a[0:3], s[0:1]
; GISEL-NEXT:    global_store_dwordx4 v0, a[4:7], s[0:1] offset:16
; GISEL-NEXT:    global_store_dwordx4 v0, a[8:11], s[0:1] offset:32
; GISEL-NEXT:    global_store_dwordx4 v0, a[12:15], s[0:1] offset:48
; GISEL-NEXT:    s_endpgm
  %result = call <16 x i32> @llvm.amdgcn.mfma.i32.32x32x32.i8(<4 x i32> %arg0, <4 x i32> %arg1, <16 x i32> %arg2, i32 3, i32 2, i32 1)
  store <16 x i32> %result, ptr addrspace(1) %out
  ret void
}

; --------------------------------------------------------------------
; llvm.amdgcn.mfma.f32.16x16x32.bf16
; --------------------------------------------------------------------

declare <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.bf16(<8 x bfloat>, <8 x bfloat>, <4 x float>, i32 immarg, i32 immarg, i32 immarg)

define <4 x float> @test_mfma_f32_16x16x32_bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_16x16x32_bf16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_bf16 a[0:3], v[0:3], v[4:7], a[0:3]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2, i32 0, i32 0, i32 0)
  ret <4 x float> %result
}

define <4 x float> @test_mfma_f32_16x16x32_bf16__flags(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2) {
; GCN-LABEL: test_mfma_f32_16x16x32_bf16__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_accvgpr_write_b32 a0, v8
; GCN-NEXT:    v_accvgpr_write_b32 a1, v9
; GCN-NEXT:    v_accvgpr_write_b32 a2, v10
; GCN-NEXT:    v_accvgpr_write_b32 a3, v11
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_bf16 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:1 abid:1 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    v_accvgpr_read_b32 v0, a0
; GCN-NEXT:    v_accvgpr_read_b32 v1, a1
; GCN-NEXT:    v_accvgpr_read_b32 v2, a2
; GCN-NEXT:    v_accvgpr_read_b32 v3, a3
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2, i32 1, i32 1, i32 1)
  ret <4 x float> %result
}

define amdgpu_kernel void @test_mfma_f32_16x16x32_bf16_no_agpr__vgprcd(ptr addrspace(1) %out, <8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2) #0 {
; GCN-LABEL: test_mfma_f32_16x16x32_bf16_no_agpr__vgprcd:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GCN-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s0
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s1
; GCN-NEXT:    v_accvgpr_write_b32 a2, s2
; GCN-NEXT:    v_accvgpr_write_b32 a3, s3
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_bf16 a[0:3], v[0:3], v[4:7], a[0:3]
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; GCN-NEXT:    s_endpgm
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2, i32 0, i32 0, i32 0)
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_mfma_f32_16x16x32_bf16_no_agpr__vgprcd__flags(ptr addrspace(1) %out, <8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2) #0 {
; GCN-LABEL: test_mfma_f32_16x16x32_bf16_no_agpr__vgprcd__flags:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x34
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x54
; GCN-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b64_e32 v[0:1], s[8:9]
; GCN-NEXT:    v_mov_b64_e32 v[2:3], s[10:11]
; GCN-NEXT:    v_mov_b64_e32 v[4:5], s[12:13]
; GCN-NEXT:    v_accvgpr_write_b32 a0, s0
; GCN-NEXT:    v_mov_b64_e32 v[6:7], s[14:15]
; GCN-NEXT:    v_accvgpr_write_b32 a1, s1
; GCN-NEXT:    v_accvgpr_write_b32 a2, s2
; GCN-NEXT:    v_accvgpr_write_b32 a3, s3
; GCN-NEXT:    s_nop 1
; GCN-NEXT:    v_mfma_f32_16x16x32_bf16 a[0:3], v[0:3], v[4:7], a[0:3] cbsz:3 abid:2 blgp:1
; GCN-NEXT:    s_nop 7
; GCN-NEXT:    global_store_dwordx4 v8, a[0:3], s[6:7]
; GCN-NEXT:    s_endpgm
  %result = call <4 x float> @llvm.amdgcn.mfma.f32.16x16x32.bf16(<8 x bfloat> %arg0, <8 x bfloat> %arg1, <4 x float> %arg2, i32 3, i32 2, i32 1)
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { "amdgpu-flat-work-group-size"="512,512" }
attributes #1 = { "amdgpu-flat-work-group-size"="1,64" }
