%%
%% This is file `amnestyreport.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% amnestyreport.dtx  (with options: `class')
%% 
%% IMPORTANT NOTICE:
%% 
%% For the copyright see the source file.
%% 
%% Any modified versions of this file must be renamed
%% with new filenames distinct from amnestyreport.cls.
%% 
%% For distribution of the original source see the terms
%% for copying and modification in the file amnestyreport.dtx.
%% 
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{amnestyreport}
[2024/01/12 v1.2 Typesetting articles for Amnesty International]
\DeclareOption{a4paper}{\PassOptionsToPackage{\CurrentOption}{geometry}}
\DeclareOption{letterpaper}{\PassOptionsToPackage{\CurrentOption}{geometry}}
\newif\ifamnesty@fonts
\amnesty@fontstrue
\DeclareOption{amnestyfonts}{\amnesty@fontstrue}
\DeclareOption{freefonts}{\amnesty@fontsfalse}
\newif\ifamnesty@logo
\amnesty@logotrue
\DeclareOption{logo}{\amnesty@logotrue}
\DeclareOption{nologo}{\amnesty@logofalse}
\ExecuteOptions{a4paper,amnestyfonts}
\ProcessOptions\relax
\IfFileExists{Amnesty_logo.png}{}{\amnesty@logofalse}
\LoadClass{article}
\RequirePackage[top=1.02in, bottom=1.38in,
left=1.26in, right=1.26in, footskip=40pt]{geometry}
\usepackage[none]{hyphenat}
\RequirePackage[colorlinks=false]{hyperref}
\def\UrlFont{}
\def\sectionautorefname{Section}
\def\subsectionautorefname{Section}
\def\subsubsectionautorefname{Section}
\RequirePackage{graphicx}
\RequirePackage[backend=bibtex]{biblatex}
\RequirePackage{xparse}
\NewDocumentCommand{\citep}{oom}{%
  \IfNoValueTF{#2}{%
    \IfNoValueTF{#1}{\footfullcite{#3}}{\footfullcite[][#1]{#3}}}{%
    \footfullcite[#1][#2]{#3}}}
\let\citet\citep
\RequirePackage{placeins}
\RequirePackage{framed}
\RequirePackage[rightcaption]{sidecap}
\def\SC@figure@vpos{t}
\RequirePackage{fontspec}
\ifamnesty@fonts
  \ClassInfo{amnestyreport}{Using Amnesty International fonts}
  \setmainfont{AmnestyTradeGothic-Light.ttf}[
  BoldFont=AmnestyTradeGothic-Bd2.ttf,
  ItalicFont=AmnestyTradeGothic-LightObl.ttf,
  BoldItalicFont=AmnestyTradeGothic-Bd2Obl.ttf]

  \newfontfamily\condensed{AmnestyTradeGothic-Cn18.ttf}[
  BoldFont=AmnestyTradeGothic-BdCn20.ttf,
  ItalicFont=AmnestyTradeGothic-Cn18Obl.ttf,
  BoldItalicFont=AmnestyTradeGothic-BdCn20Ob.ttf]
\else
  \ClassInfo{amnestyreport}{Using free fonts}
  \setmainfont{texgyreadventor-regular.otf}[
  BoldFont=texgyreadventor-bold.otf,
  ItalicFont=texgyreadventor-italic.otf,
  BoldItalicFont=texgyreadventor-bolditalic.otf]

  \newfontfamily\condensed{QTHelvetCnd-Light.otf}[
  BoldFont=QTHelvetCnd.otf,
  ItalicFont=QTHelvetCnd-Light.otf,
  BoldItalicFont=QTHelvetCnd.otf]
\fi
\setmonofont[StylisticSet={1,2,3}]{Inconsolatazi4-Regular.otf}[
  BoldFont=Inconsolatazi4-Bold.otf]
\RequirePackage{fontawesome5}
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@ixpt\@xipt%
   \abovedisplayskip 8\p@ \@plus4\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 5\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\renewcommand\small{%
   \@setfontsize\small\@viiipt\@ixpt%
   \abovedisplayskip 5\p@ \@plus2\p@ \@minus2\p@
   \abovedisplayshortskip \z@ \@plus1\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\renewcommand\footnotesize{%
   \@setfontsize\footnotesize\@viipt\@viiipt
   \abovedisplayskip 4\p@ \@plus2\p@ \@minus2\p@
   \abovedisplayshortskip \z@ \@plus1\p@
   \belowdisplayshortskip 2.5\p@ \@plus\p@ \@minus\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\renewcommand\scriptsize{\@setfontsize\scriptsize\@vipt\@viipt}
\renewcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\renewcommand\large{\@setfontsize\large\@xpt\@xiipt}
\renewcommand\Large{\@setfontsize\Large\@xipt{13}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xiipt{14}}
\renewcommand\huge{\@setfontsize\huge\@xivpt{18}}
\renewcommand\Huge{\@setfontsize\Huge\@xviipt{22}}
\setlength\parskip{6pt}
\setlength\parindent\z@
\RequirePackage{xcolor}
\definecolor{AmnestyYellow}{RGB/cmyk}{255,255,0/0,0,1,0}
\definecolor{AmnestyGray1}{RGB/cmyk}{228,228,228/0,0,0,15}
\definecolor{AmnestyGray2}{RGB/cmyk}{178,178,178/0,0,0,32}
\definecolor{AmnestyGray3}{RGB/cmyk}{118,118,118/0,0,0,64}
\definecolor{AmnestyGray4}{RGB/cmyk}{82,82,82/0,0,0,79}
\definecolor{AmnestyGray4}{RGB/cmyk}{37,37,37/0,0,0,97}
\RequirePackage{soul}
\sethlcolor{AmnestyYellow}
\newcommand\titleimage[1]{\def\@titleimage{#1}}
\titleimage{}
\newcommand\titleimagecaption[1]{\def\@titleimagecaption{#1}}
\titleimagecaption{}
\newcommand\subtitle[1]{\def\@subtitle{#1}}
\subtitle{}
\newcommand\copyrightyear[1]{\def\@copyrightyear{#1}}
\copyrightyear{\the\year}
\newcommand\firstpublicationyear[1]{\def\@firstpublicationyear{#1}}
\firstpublicationyear{\@copyrightyear}
\newcommand\reportyear[1]{\def\@reportyear{#1}}
\reportyear{\@copyrightyear}
\newcommand\reportmonth[1]{\def\@reportmonth{#1}}
\reportmonth{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi}
\newcommand\reportindex[1]{\def\@reportindex{#1}}
\reportindex{XXXX XX/XX/XXX}
\newcommand\blurb[1]{\def\@blurb{#1}}
\blurb{}
\newcommand\frontmatter{%
  \pagenumbering{arabic}%
  \pagestyle{empty}}
\renewcommand{\maketitle}{%
  \newgeometry{top=0.55in, bottom=1.18in,
    left=0.55in, right=0.55in, footskip=20pt}%
  \pagestyle{titlepage}%
    \ifx\@titleimage\@empty
    \ClassWarningNoLine{amnestyreport}{You did not define the title
      image}%
    \else
    \includegraphics[width=18.17cm]{\@titleimage}\par
    \fi
    \ifx\@title\@empty\else
    {\condensed\bfseries\fontsize{48pt}{48pt}\selectfont
      \hl{\MakeUppercase{\@title}}\par}%
    \fi
    \ifx\@subtitle\@empty\else
    {\condensed\fontsize{22pt}{22pt}\selectfont
      \MakeUppercase{\@subtitle}\par}%
    \fi
    \clearpage
      \thispagestyle{backtitlepage}%
    {\condensed\bfseries\fontsize{22pt}{22pt}\selectfont
      \hl{Amnesty International is a movement of 10 million people
 which mobilizes the humanity in everyone and campaigns
 for change so we can all enjoy our human rights. Our vision
 is of a world where those in power keep their promises,
 respect international law and are held to account. We are
 independent of any government, political ideology, economic
 interest or religion and are funded mainly by our  membership
 and individual donations. We believe that acting in solidarity
 and compassion with people everywhere can change our
 societies for the better.}\par}
\vfill
\parbox[t]{0.48\textwidth}{\condensed\footnotesize
  \textcopyright~Amnesty International~\@copyrightyear

Except where otherwise noted, content in this document is licensed
under a Creative Commons (attribution, non-commercial, no derivatives,
international 4.0) licence.
\url{https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode}.

For more information please visit the permissions page on our website:
\href{https://www.amnesty.org}{www.amnesty.org}.

Where material is attributed to a copyright owner other than Amnesty International this
material is not subject to the Creative Commons licence.

First published in \@firstpublicationyear\\
by Amnesty International Ltd\\
Peter Benenson House, 1 Easton Street\\
London WC1X 0DW, UK}\hfill
\parbox[t]{0.48\textwidth}{\condensed\footnotesize
  \ifx\@titleimagecaption\@empty\else
  $\leftarrow$\faEye[regular] \raggedright\itshape\textbf{Cover photo:} \@titleimagecaption\fi}
\restoregeometry
\pagestyle{empty}}

\newcommand\mainmatter{\cleardoublepage
  \pagestyle{main}%
}
\def\amnesty@logo@graphics{%
  \ifamnesty@logo
    \includegraphics[height=0.5in]{Amnesty_logo}%
  \else
    \rule{0pt}{0.5in}%
  \fi}
\RequirePackage{fancyhdr}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\fancypagestyle{titlepage}{%
  \fancyhf{}%
  \fancyfoot[R]{\raisebox{-\height}{\amnesty@logo@graphics}}%
}
\fancypagestyle{backtitlepage}{%
  \fancyhf{}%
  \fancyfoot[L]{\bfseries Index: \@reportindex\\
    Original language: English\\
    \large\href{https://amnesty.org}{amnesty.org}}%
  \fancyfoot[R]{\raisebox{-\height}{\amnesty@logo@graphics}}%
}
\fancypagestyle{main}{%
  \fancyhf{}%
  \fancyfoot[L]{\condensed\footnotesize\textbf{\MakeUppercase{\@title}}\par
    \ifx\@subtitle\@empty\else\condensed\MakeUppercase{\@subtitle}\par\fi
    Amnesty International
  }%
  \fancyfoot[R]{\normalsize\normalfont\thepage\hspace{1in}}%
}
\fancypagestyle{backcoverpage}{%
  \fancyhf{}%
  \fancyfoot[L]{\normalsize\normalfont
      INDEX: \mbox{\@reportindex}\\
    \MakeUppercase{\@reportmonth~\@reportyear}\\
    LANGUAGE: ENGLISH\\
    \LARGE\bfseries\href{https://amnesty.org}{amnesty.org}}%
  \fancyfoot[R]{\raisebox{-\height}{\amnesty@logo@graphics}\hspace{1in}}%
}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {.5ex \@plus.2ex}%
                                   {\condensed\fontsize{45pt}{45pt}\selectfont\bfseries\raggedright\MakeUppercase}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {0.5ex \@plus .2ex}%
                                     {\condensed\fontsize{21pt}{21pt}\selectfont\bfseries\raggedright\MakeUppercase}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {0.5ex \@plus .2ex}%
                                     {\condensed\fontsize{16pt}{16pt}\selectfont\bfseries\raggedright\MakeUppercase}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {1sp}%
                                    {\condensed\fontsize{11pt}{11pt}\selectfont\bfseries\raggedright\MakeUppercase}}
\renewcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \def\numberline##1{##1~}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \condensed\fontsize{11pt}{11pt}\selectfont\bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      \MakeUppercase{#1}\nobreak\hfil
      \nobreak\hb@xt@\@pnumwidth{\hss #2%
                                 \kern-\p@\kern\p@}\par
    \endgroup
  \fi}
\renewcommand*\l@subsection[2]{%
  \ifnum \c@tocdepth >1
    \addvspace{0.5em \@plus\p@}%
    \setlength\@tempdima{2em}%
    \begingroup
      \def\numberline##1{##1~}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \condensed\fontsize{10pt}{10pt}\selectfont
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      \MakeUppercase{#1}\nobreak\hfil
      \nobreak\hb@xt@\@pnumwidth{\hss #2%
                                 \kern-\p@\kern\p@}\par
    \endgroup
  \fi}
\renewcommand*\l@subsubsection[2]{%
  \ifnum \c@tocdepth >2
    \addvspace{0.5em \@plus\p@}%
    \setlength\@tempdima{2.5em}%
    \begingroup
      \def\numberline##1{##1~}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \condensed\fontsize{9pt}{9pt}\selectfont
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      \MakeUppercase{#1}\nobreak\hfil
      \nobreak\hb@xt@\@pnumwidth{\hss #2%
                                 \kern-\p@\kern\p@}\par
    \endgroup
  \fi}
\RequirePackage[font=it]{caption}
\DeclareCaptionLabelFormat{table}{$\downarrow$\faEye[regular]\itshape~
  #1 #2}
\DeclareCaptionLabelFormat{figure}{$\uparrow$\faEye[regular]\itshape~
  #1 #2}
\DeclareCaptionLabelFormat{side}{$\leftarrow$\faEye[regular]\itshape~
  #1 #2}
\captionsetup[table]{labelformat=table}
\captionsetup[figure]{labelformat=figure}
\captionsetup[SCfigure]{labelformat=side}
\captionsetup[SCtable]{labelformat=side}
\def\fps@figure{hb}
\def\fps@table{hb}
\def\fps@SCfigure{hb}
\def\fps@SCtable{hb}
\let\table@AI@Orig\table
\let\endtable@AI@Orig\endtable
\def\sideTableCaptions{%
  \def\table{\SCtable[50]}%
  \def\endtable{\endSCtable}}
\def\normalTableCaptions{%
  \def\table{\table@AI@Orig}%
  \def\endtable{\endtable@AI@Orig}}
\newif\if@AI@sideFigures
\@AI@sideFiguresfalse
\let\figure@AI@Orig\figure
\let\endfigure@AI@Orig\endfigure
\def\sideFigureCaptions{%
  \@AI@sideFigurestrue
  \def\figure{\SCfigure[50]}%
  \def\endfigure{\endSCfigure}}
\def\normalFigureCaptions{%
  \@AI@sideFiguresfalse
  \def\figure{\figure@AI@Orig}%
  \def\endfigure{\endfigure@AI@Orig}}
\renewcommand\@makefntext[1]{%
  \raggedright\parindent\z@\hangindent2em%
  \noindent
    \@makefnmark\,#1}
\newcommand\backmatter{%
  \cleardoublepage
  \thispagestyle{empty}%
  \setbox\@tempboxa\vbox{\hsize=5in\condensed\fontsize{40pt}{40pt}\selectfont\bfseries
  AMNESTY INTERNATIONAL
  IS A GLOBAL MOVEMENT
  FOR HUMAN RIGHTS.
  WHEN INJUSTICE HAPPENS
  TO ONE PERSON, IT
  MATTERS TO US ALL.}%
\textcolor{AmnestyYellow}{\rule{10pt}{\ht\@tempboxa}}\hspace{5pt}\box\@tempboxa
\vfill

\parbox[t]{0.45\textwidth}{\setlength{\parskip}{6pt}%
  \condensed\fontsize{16pt}{16pt}\selectfont
  CONTACT US

\normalsize\normalfont
\faEnvelope~\href{mailto:info@amnesty.org}{info@amnesty.org}

\faPhone*~+44 (0)20 7413 5500}\hspace{0.05\textwidth}%
\parbox[t]{0.45\textwidth}{\setlength{\parskip}{6pt}%
  \condensed\fontsize{16pt}{16pt}\selectfont
  JOIN THE CONVERSATION

\normalsize\normalfont
\faFacebook~\href{https://www.facebook.com/AmnestyGlobal}{www.facebook.com/AmnestyGlobal}

\faTwitter~@Amnesty}\clearpage
\thispagestyle{backcoverpage}%
{\condensed\fontsize{28pt}{28pt}\bfseries\hl{\MakeUppercase{\@title}}\par}%
\ifx\@subtitle\@empty\else
{\condensed\fontsize{16pt}{16pt}\MakeUppercase{\@subtitle}\par}%
\fi
\bigskip
\@blurb
}

\RequirePackage{longtable, booktabs}
\newdimen\@tempdimAI
\newenvironment{AmnestyGlossary}[1][5em]{%
  \clearpage
  \section*{Glossary}
  \bgroup
  \setlength\extrarowheight{1pt}%
  \rowcolors{1}{AmnestyGray1}{white}%
  \setlength\@tempdimAI{\textwidth}%
  \addtolength\@tempdimAI{-2\tabcolsep}%
  \addtolength\@tempdimAI{-#1}%
  \begin{longtable}{p{#1}<{\raggedright}p{\@tempdimAI}<{\raggedright}}}{%
    \end{longtable}\egroup}
\renewenvironment{quote}{%
  \def\FrameCommand{\vrule width 6pt \hspace{10pt}}%
  \MakeFramed {\advance\hsize-\width \FrameRestore}%
  \vskip0pt\Huge\bfseries\condensed\raggedright\strut\relax}%
{\strut\vskip5pt\endMakeFramed}
\def\attribution#1{\par\normalfont\mdseries\normalsize\raggedright #1}
\def\tightlist{%
  \setlength{\itemsep}{0pt}\setlength{\parskip}{0pt}}
\normalsize\normalfont\raggedright
\frontmatter
\endinput
%%
%% End of file `amnestyreport.cls'.
