---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, titres, partie, page, redéfinition
---

# Comment modifier la page titre d'une partie ?

Il est possible de modifier la commande `\part`. 
Voici ici un exemple pour que cette commande accepte un argument de plus, 
permettant d'insérer quelque-chose entre le titre de la partie et la fin de la page.

```{noedit}
\makeatletter
\def\@part[#1]#2#3{%
   \ifnum \c@secnumdepth >-2\relax
     \refstepcounter{part}%
     \addcontentsline{toc}{part}
                     {\thepart \hspace {1em}#1}%
   \else
     \addcontentsline{toc}{part}{#1}%
   \fi
   \markboth{}{}{%
   \centering \vfill
   \interlinepenalty \@M \normalfont
   \ifnum \c@secnumdepth >-2\relax
     \Huge \bfseries \partname ~\thepart \par
     \vskip 20\p@
   \fi
   \Huge \bfseries #2
   \par}%
   {\centering
   \vfill #3 \vfill}%
   \@endpart}
\makeatother
```

Le titre sera alors placé dans le premier tiers de la page, 
le deuxième argument occupant le reste de la page. 
Cette nouvelle commande s'utilise alors ainsi :

```{noedit}
\part[titre court]{un titre long pour la page}{ce qu'on veut inclure,% 
      par exemple un résumé, une image\dots}
```

Notez que cette nouvelle définition de `\part` introduit des incompatibilités 
avec l'extension <ctanpkg:minitoc>. Pour remédier à cela, 
il est préférable d'utiliser l'extension <ctanpkg:epigraph> 
évoquée dans la question "[](ajouter_une_epigraphe)".