# bib2qr

[![License](https://img.shields.io/ctan/l/bib2qr?color=blue)](https://www.latex-project.org/lppl/lppl-1-3c.txt)
[![Latest release](https://img.shields.io/gitea/v/release/Cs137/bib2qr?gitea_url=https%3A%2F%2Fcodeberg.org%2F)](https://codeberg.org/Cs137/bib2qr/releases/latest)
[![CTAN](https://img.shields.io/ctan/v/bib2qr.svg)](https://ctan.org/pkg/bib2qr)

A LaTeX package for citing BibTeX entries with QR codes.

The `bib2qr` package provides functionality to cite BibTeX entries with QR codes
for easy sharing and referencing. The target of the QR code is the entry's DOI,
or URL if no DOI exists. A citation generated via `\qrfullcite`, which is part
of `bib2qr`, might look as follows:

[![Example output generated with `\qrfullcite`](https://codeberg.org/Cs137/bib2qr/media/branch/main/example/qrfullcite_example.png "Example output generated with qrfullcite")](https://codeberg.org/Cs137/bib2qr/media/branch/main/example/qrfullcite_example.png)


## Installation

Skip this section, if `bib2qr` is already provided in your TeX distribution.
You should be able to install it [from the CTAN](https://www.ctan.org/pkg/bib2qr)
via your distribution's utility (e.g. the TeX Live Utility).

### Manual installation

You can get the package's source code from the
[project repository on Codeberg](https://codeberg.org/Cs137/bib2qr).
The repository contains a build script, which allows you to build the required
files for the `bib2qr` package and copy them into your _TeX Directory Structure_
(TDS) using `l3build`. Ensure that `l3build` is installed on your system and run
it from the repository's root directory as follows:

```bash
l3build install --full
```

The `--full` option ensures that all necessary files are built and installed.

If you do not want to install the package into your TDS, but use it in a
particular LaTeX project, follow the steps listed below.

1. unpack `bib2qr.sty` from the `bib2qr.dtx` file
    - using `l3build` and the `build.lua` script: `l3build unpack`, __or__
    - directly via the installer file: `pdflatex bib2qr.ins`
2. copy the extracted `bib2qr.sty` file into the same directory as your LaTeX sources.


## Usage

Please consult the [package documentation](http://mirrors.ctan.org/macros/latex/contrib/bib2qr/bib2qr.pdf)
for detailed usage information.

If you have any questions or need assistance, feel free to
[open an issue on the repository](https://codeberg.org/Cs137/bib2qr/issues).


## Changes

All notable changes to this project are documented in the file
[`CHANGELOG.md`](https://codeberg.org/Cs137/bib2qr/src/branch/main/CHANGELOG.md).


## Contributing

Contributions to the `bib2qr` package are very welcomed. Feel free to submit a
pull request, if you would like to contribute to the project. In case you are
unfamiliar with the process, consult the
[forgejo documentation](https://forgejo.org/docs/latest/user/pull-requests-and-git-flow/)
and follow the steps using this repository instead of the `example` repository.

Create your [pull request (PR)](https://codeberg.org/Cs137/bib2qr/pulls) to
inform that you start working on a contribution. Provide a clear description
of your envisaged changes and the motivation behind them, prefix the PR's title
with ``WIP: `` until your changes are finalised.

All kind of contributions are appreciated, whether they are
bug fixes, new features, or improvements to the documentation.


### Contributors

- [Christian Schreinemachers](https://codeberg.org/Cs137)
- [Markus Kohm](https://codeberg.org/komascript)


---

This package was created and is maintained by Christian Schreinemachers, (C) 2024.

