/*
 * Copyright (C) 2016 Christian Mollekopf <chrigi_1@fastmail.fm>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) version 3, or any
 * later version accepted by the membership of KDE e.V. (or its
 * successor approved by the membership of KDE e.V.), which shall
 * act as a proxy defined in Section 6 of version 3 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "sink_export.h"
#include <QByteArray>
#include <QDebug>
#include <QMutex>
#include <functional>
#include <memory>

#include "domaintypeadaptorfactoryinterface.h"
#include "applicationdomaintype.h"
#include "log.h"

namespace Sink {

/**
 */
class SINK_EXPORT AdaptorFactoryRegistry
{
public:
    static AdaptorFactoryRegistry &instance();

    template <class DomainType, class Factory>
    void registerFactory(const QByteArray &resource)
    {
        registerFactory(resource, std::make_shared<Factory>(), ApplicationDomain::getTypeName<DomainType>());
    }

    template <class DomainType>
    std::shared_ptr<DomainTypeAdaptorFactoryInterface> getFactory(const QByteArray &resource)
    {
        return getFactory(resource, ApplicationDomain::getTypeName<DomainType>());
    }

    std::shared_ptr<DomainTypeAdaptorFactoryInterface> getFactory(const QByteArray &resource, const QByteArray &typeName);

    QMap<QByteArray, DomainTypeAdaptorFactoryInterface::Ptr> getFactories(const QByteArray &resource);

private:
    AdaptorFactoryRegistry();
    void registerFactory(const QByteArray &resource, const std::shared_ptr<void> &instance, const QByteArray typeName);

    QHash<QByteArray, std::shared_ptr<void>> mRegistry;
    QMultiHash<QByteArray, QByteArray> mTypes;
    static QMutex sMutex;
};
}
