<?php
/**
 * The IMP_Filter:: class contains all functions related to handling
 * filtering messages in IMP.
 *
 * For full use, the following Horde API calls should be defined
 * (These API methods are not defined in IMP):
 *   mail/applyFilters
 *   mail/canApplyFilters
 *   mail/showFilters
 *   mail/blacklistFrom
 *   mail/showBlacklist
 *   mail/whitelistFrom
 *   mail/showWhitelist
 *
 * $Horde: imp/lib/Filter.php,v 1.51 2003/08/08 22:57:28 jan Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.51 $
 * @since   IMP 4.0
 * @package imp
 */
class IMP_Filter {

    /**
     * Runs the filters.
     *
     * @access public
     */
    function filter()
    {
        global $imp, $registry;

        if ($imp['filteravail']) {
            $params = array('imap' => $imp['stream'], 'mailbox' => IMP::serverString('INBOX'));
            $registry->call('mail/applyFilters', array($params));
        }
    }

    /**
     * Adds the From address from the message(s) to the blacklist and
     * redirects to the blacklist page.
     *
     * @access public
     *
     * @param array $indices  An array of message indices to blacklist.
     */
    function blacklistMessage($indices)
    {
        IMP_Filter::_processBWlist($indices, _("your blacklist"), 'blacklistFrom', 'showBlacklist');
    }

    /**
     * Adds the From address from the message(s) to the whitelist and
     * redirects to the whitelist page.
     *
     * @access public
     *
     * @param array $indices  An array of message indices to whitelist.
     */
    function whitelistMessage($indices)
    {
        IMP_Filter::_processBWlist($indices, _("your whitelist"), 'whitelistFrom', 'showWhitelist');
    }

    /**
     * Internal function to handle adding addresses to [black|white]list.
     *
     * @access private
     */
    function _processBWlist($indices, $descrip, $reg1, $reg2)
    {
        global $notification, $registry;

        require_once IMP_BASE . '/lib/Headers.php';

        /* Get the list of from addresses. */
        $addr = array();
        foreach ($indices as $msg) {
            $imp_headers = &new IMP_Headers($msg);
            $from = $imp_headers->getFromAddress();
            $notification->push(sprintf(_("The address \"%s\" has been added to %s."), $from, $descrip));
            $addr[] = $from;
        }

        $registry->call('mail/' . $reg1, array($addr));

        /* Redirect to filter management page. */
        if ($registry->hasMethod('mail/' . $reg2)) {
            header('Location: ' . Horde::url($registry->link('mail/' . $reg2), true));
            exit;
        }
    }

}
