<?php
/**
 * $Horde: imp/identities.php,v 2.54 2003/08/01 21:01:35 slusarz Exp $
 *
 * Copyright 2001-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function _returnToPrefs()
{
    $url = Horde::applicationUrl('prefs.php', true);
    header('Location: ' . Horde::addParameter($url, 'group', 'personal'));
    exit;
}

define('IMP_BASE', dirname(__FILE__));
$authentication = OP_HALFOPEN;
require_once IMP_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Identity.php';

$identity = &Identity::singleton(array('imp', 'imp'));
$to_edit = null;

// redirect user if not allowed to change anything
if ($identity->isLocked()) {
    _returnToPrefs();
}

$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (Horde::getPost('edit')) {
        $actionID = 'ident_edit';
    } elseif (Horde::getPost('save')) {
        $actionID = 'ident_save';
    } elseif (Horde::getPost('delete')) {
        $actionID = 'ident_delete';
    } elseif (Horde::getPost('back')) {
        _returnToPrefs();
    }
}

if (is_null($actionID) && $prefs->isLocked('default_identity')) {
    $actionID = 'ident_edit';
    $_POST['identity'] = $identity->getDefault();
}

/* Run through the action handlers */
switch ($actionID) {
case 'ident_edit':
    $to_edit = Horde::getFormData('identity');
    break;

case 'ident_save':
    require_once HORDE_BASE . '/lib/Array.php';

    if (($edit_identity = Horde::getFormData('edit_identity')) == null) {
        $edit_identity = $identity->add();
    }
    $old_default = $identity->getDefault();
    $identity->setDefault($edit_identity);

    if (($id = Horde::getFormData('id'))) {
        $identity->setValue('id', $id);
    } else {
        $identity->setValue('id', _("Unnamed"));
        $id = _("Unnamed");
    }

    /* RFC 2822 [3.2.5] does not allow the '\' character to be used in
       the personal portion of an e-mail string. */
    $fullname = Horde::getFormData('fullname');
    if (strpos($fullname, '\\') === false) {
        $identity->setValue('fullname', $fullname);
    } else {
        $notification->push(_("You can not have the '\\' character in your full name."), 'horde.warning');
        break;
    }

    $identity->setValue('from_addr', Horde::getFormData('from_addr'));
    $identity->setValue('replyto_addr', Horde::getFormData('replyto_addr'));

    foreach (array('alias_addr', 'tieto_addr') as $val) {
        $data = Horde::getFormData($val);
        $data = trim($data);
        $data = (empty($data)) ? array() : Horde_Array::prepareAddressList(preg_split("/\s+/", $data));
        $identity->setValue($val, $data);
    }

    $identity->setValue('signature', Horde::getFormData('signature'));
    $identity->setValue('sig_dashes', Horde::getFormData('sig_dashes', 0));
    $identity->setValue('sig_first', Horde::getFormData('sig_first', 0));

    $identity->setValue('save_sent_mail', Horde::getFormData('save_sent_mail', 0));
    $sent_mail_folder = Horde::getFormData('sent_mail');
    $sent_mail_new = String::convertCharset(Horde::getFormData('sent_mail_new'), NLS::getCharset(), 'UTF7-IMAP');
    $sent_mail_default = $prefs->getValue('sent_mail_folder');
    if ($conf['user']['allow_folders'] &&
        !$prefs->isLocked('sent_mail_folder')) {
        if (empty($sent_mail_folder) && !empty($sent_mail_new)) {
            $sent_mail_folder = $sent_mail_new;
        } elseif (($sent_mail_folder == '-1') && !empty($sent_mail_default)) {
            $sent_mail_folder = $sent_mail_default;
        }
        $sent_mail_folder = IMP::stripPreambleString($sent_mail_folder);
        if (!empty($sent_mail_folder)) {
            include_once IMP_BASE . '/lib/Folder.php';
            $imp_folder = &IMP_Folder::singleton();
            if (!$imp_folder->exists($imp['stream'], IMP::addPreambleString($sent_mail_folder))) {
                $imp_folder->create($imp['stream'], IMP::addPreambleString($sent_mail_folder), $prefs->getValue('subscribe'));
                unset($imp['imaptree']);
            }
        }
        $identity->setValue('sent_mail_folder', $sent_mail_folder);
    }

    $identity->setValue('private_key', Horde::getFormData('private_key'));
    $identity->setValue('private_key_type', Horde::getFormData('private_key_type'));

    $identity->setDefault($old_default);
    $identity->save();

    if ($prefs->isLocked('default_identity')) {
        $to_edit = Horde::getFormData('identity');
    }

    $notification->push(sprintf(_("The identity \"%s\" has been saved."), $id), 'horde.success');
    break;

case 'ident_delete':
    $to_delete = Horde::getFormData('identity');
    if ($to_delete != -1) {
        $deleted_identity = $identity->delete($to_delete);
        $notification->push(sprintf(_("The identity \"%s\" has been deleted."), $deleted_identity[0]['id']), 'horde.success');
    } else {
        $notification->push(_("You must select an identity to be deleted."), 'horde.warning');
    }
    break;

}

$title = _("Identities");
$js_onLoad = null;
$identities = $identity->getAll('id');

require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
require IMP_TEMPLATES . '/identities/javascript.inc';
require IMP_TEMPLATES . '/identities/manage.inc';
require IMP_TEMPLATES . '/common-footer.inc';
