/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLRADIOBUTTON_H
#define KLRADIOBUTTON_H

#include "klwidgetbase.h"
#include "qradiobt.h"

/**
* RadioButton object
*
* Note: It has initialy a weight of 1. 
*       YOU MUST construct a KRadioManager beforce creating
*       such an object. Otherwise it just will crash.
*       You must not use the KRadioManager.
*/
class KLRadioButton : public QRadioButton, public KLWidgetBase {
  Q_OBJECT
public:
  KLRadioButton(const char *,class KRadioManager *rm = 0,long id=-1);
  void setText(const char *); 
  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);
  KLWDIGET_DELEGATES(KLRadioButton,QRadioButton);
};

/**
* Does exclusive managment with (radio-)buttons
*
* Its nealry the same as QButtonGroup, it just does not
* display a frame or a border. (And the buttons can't/have not
* to be childs of this class)
*
* This class is usefull with the KLayoutEngine.
*
* @see QButtonGroup
*/

class KRadioManager : public QObject {
  Q_OBJECT
public:
  void insert(QRadioButton *,long id = -1);
  void remove(QRadioButton *);
  QRadioButton *find(long id);

  KRadioManager &operator<<(QRadioButton*);

  KRadioManager();
  ~KRadioManager();

  /**
  * Checks the specified radiobutton
  * (And unchecks all others)
  *
  * @see checked()
  */
  void setChecked(QRadioButton *button);
  void setChecked(long id);

  /**
  * Returns the ID of the actual checked radiobutton
  */
  ulong checked();

signals:
  void pressed(int id);
  void released(int id);
  void clicked(int id);

protected slots:
  void buttonPressed();
  void buttonReleased();
  void buttonClicked();

private:
  struct KRMButton {
    QRadioButton *button;
    long id;
  };
  ulong a_checked;
  QList<KRMButton> buttons;
  class KRMButton *find(QRadioButton *);
};

#endif 



