#ifndef __PROPWIDGET_H_
#define __PROPWIDGET_H_

#include <kapp.h>
#include <klocale.h>
#include <kcolordlg.h>
#include <kfontdialog.h>
#include <kfiledialog.h>
//#include <qsplitter.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qdialog.h>
#include <qbitmap.h>
#include "resource.h"
#include "defines.h"

#define PIXMAP_FOLDER  "/opt/kde/share/icons/mini/folder.xpm"

class EditWidget;
class anItem;

class PropWidget : public QWidget
{
  Q_OBJECT
  public:
    PropWidget( EditWidget **ew, QWidget *parent=0, const char *name=0 );
    void refillList( );
    void ClearList( );

  protected:
    void resizeEvent( QResizeEvent * );
    int addFolder( const char *name );
    void addItem( QListViewItem *par, const char *prop, const char *value);

  private:
    QListView *lview;
    QComboBox *cbox;
    EditWidget **editwidget;
    int lviNr;
    QListViewItem *lvis[16];
    bool openStats[16];

  public slots:
    void doubleClicked( QListViewItem *item );
    void cbox_activated( int nr );
};


class dlgChangeItem : public QDialog
{
  Q_OBJECT
  public:
    dlgChangeItem(QWidget *parent, anItem *item, QString pr, QString val);
    QString getVal() { if (ledit) return QString(ledit->text()); else return QString();}
    int getPropNr() { return propnr; }

  protected:
    QLineEdit *ledit;
    int propnr;
    int allowed;

  public slots:
    void browseclicked();
};

#endif // __PROPWIDGET_H_








