<?xml version='1.0' encoding='UTF-8'?><!-- -*- indent-tabs-mode: nil -*- -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:yelp="http://www.gnome.org/yelp/ns"
                xmlns="http://www.w3.org/1999/xhtml"
                extension-element-prefixes="yelp"
                version="1.0">

<xsl:import href="/opt/gnome/share/yelp-xsl/xslt/gettext/gettext.xsl"/>
<xsl:import href="/opt/gnome/share/yelp-xsl/xslt/common/color.xsl"/>
<xsl:import href="/opt/gnome/share/yelp-xsl/xslt/common/icons.xsl"/>
<xsl:import href="/opt/gnome/share/yelp-xsl/xslt/common/html.xsl"/>
<xsl:include href="yelp-common.xsl"/>

<xsl:param name="html.basename" select="'//index'"/>

<xsl:param name="linktrail" select="''"/>

<xsl:template mode="html.title.mode" match="Man">
  <xsl:value-of select="header/title"/>
</xsl:template>

<xsl:template mode="html.body.mode" match="Man">
  <xsl:apply-templates select="header"/>
  <xsl:apply-templates select="section"/>
</xsl:template>

<!-- ======================================================================= -->

<xsl:template match="header">
  <div class="hgroup">
    <h1 class="title">
      <xsl:value-of select="title"/>
      <xsl:text> (</xsl:text>
      <xsl:value-of select="section"/>
      <xsl:text>)</xsl:text>
    </h1>
    <h3 style="text-align: right;">
      <xsl:value-of select="collection"/>
    </h3>
    <xsl:if test="@version or @date">
      <p style="text-align: right">
        <xsl:if test="@version">
          Version: <xsl:value-of select="@version"/>
        </xsl:if>
        <xsl:if test="@version and @date"><br/></xsl:if>
        <xsl:if test="@date">
          Date: <xsl:value-of select="@date"/>
        </xsl:if>
      </p>
    </xsl:if>
  </div>
</xsl:template>

<xsl:template match="br">
  <br/>
</xsl:template>

<xsl:template match="section">
  <div class="section" style="padding-top: 1em;">
    <h2>
      <xsl:value-of select="title"/>
    </h2>

    <div class="section-contents" style="font-family: monospace;">
      <xsl:apply-templates select="sheet"/>
    </div>
  </div>
</xsl:template>

<xsl:template match="sheet">
  <xsl:element name="div">
    <xsl:attribute name="style">
      margin-bottom: 0px;
      margin-top: <xsl:value-of select="@jump"/>em;
    </xsl:attribute>
    <p><xsl:apply-templates select="span|br"/></p>
  </xsl:element>
</xsl:template>

<xsl:template match="span">
  <xsl:element name="span">
    <xsl:choose>
      <xsl:when test="@class = 'B'">
        <xsl:attribute name="style">
          font-weight: 700;
        </xsl:attribute>
      </xsl:when>
      <xsl:when test="@class = 'I'">
        <xsl:attribute name="style">
          font-style: italic;
        </xsl:attribute>
      </xsl:when>
    </xsl:choose>

    <xsl:value-of select="."/>
  </xsl:element>
</xsl:template>

</xsl:stylesheet>
