/* valageniescanner.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#ifndef __VALA_VALAGENIESCANNER_H__
#define __VALA_VALAGENIESCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valagenietokentype.h>
#include <vala/valasourcefile.h>
#include <vala/valasourcelocation.h>

G_BEGIN_DECLS


#define VALA_GENIE_TYPE_SCANNER (vala_genie_scanner_get_type ())
#define VALA_GENIE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScanner))
#define VALA_GENIE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))
#define VALA_GENIE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))

typedef struct _ValaGenieScanner ValaGenieScanner;
typedef struct _ValaGenieScannerClass ValaGenieScannerClass;
typedef struct _ValaGenieScannerPrivate ValaGenieScannerPrivate;
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

/**
 * Lexical scanner for Genie source files.
 */
struct _ValaGenieScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGenieScannerPrivate * priv;
};

struct _ValaGenieScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGenieScanner *self);
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};


ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file);
ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file);
ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
char* vala_genie_scanner_pop_comment (ValaGenieScanner* self);
ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self);
gint vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self);
void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value);
GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_genie_value_get_scanner (const GValue* value);
void vala_genie_value_set_scanner (GValue* value, gpointer v_object);
GType vala_genie_scanner_get_type (void);
gpointer vala_genie_scanner_ref (gpointer instance);
void vala_genie_scanner_unref (gpointer instance);


G_END_DECLS

#endif
