/* valamethodtype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valamethodtype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>




struct _ValaMethodTypePrivate {
	ValaMethod* _method_symbol;
};

#define VALA_METHOD_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_TYPE, ValaMethodTypePrivate))
enum  {
	VALA_METHOD_TYPE_DUMMY_PROPERTY
};
static gboolean vala_method_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base);
static GeeList* vala_method_type_real_get_parameters (ValaDataType* base);
static ValaDataType* vala_method_type_real_copy (ValaDataType* base);
static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static char* vala_method_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static char* vala_method_type_real_get_cname (ValaDataType* base);
static ValaSymbol* vala_method_type_real_get_member (ValaDataType* base, const char* member_name);
static gpointer vala_method_type_parent_class = NULL;
static void vala_method_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaMethodType* vala_method_type_construct (GType object_type, ValaMethod* method_symbol) {
	ValaMethodType* self;
	g_return_val_if_fail (method_symbol != NULL, NULL);
	self = (ValaMethodType*) g_type_create_instance (object_type);
	vala_method_type_set_method_symbol (self, method_symbol);
	return self;
}


ValaMethodType* vala_method_type_new (ValaMethod* method_symbol) {
	return vala_method_type_construct (VALA_TYPE_METHOD_TYPE, method_symbol);
}


static gboolean vala_method_type_real_is_invokable (ValaDataType* base) {
	ValaMethodType * self;
	self = (ValaMethodType*) base;
	return TRUE;
}


static ValaDataType* vala_method_type_real_get_return_type (ValaDataType* base) {
	ValaMethodType * self;
	ValaDataType* _tmp0;
	self = (ValaMethodType*) base;
	_tmp0 = NULL;
	return (_tmp0 = vala_method_get_return_type (self->priv->_method_symbol), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
}


static GeeList* vala_method_type_real_get_parameters (ValaDataType* base) {
	ValaMethodType * self;
	self = (ValaMethodType*) base;
	return vala_method_get_parameters (self->priv->_method_symbol);
}


static ValaDataType* vala_method_type_real_copy (ValaDataType* base) {
	ValaMethodType * self;
	self = (ValaMethodType*) base;
	return (ValaDataType*) vala_method_type_new (self->priv->_method_symbol);
}


static gboolean vala_method_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaMethodType * self;
	ValaDelegateType* _tmp1;
	ValaDataType* _tmp0;
	ValaDelegateType* dt;
	gboolean _tmp3;
	self = (ValaMethodType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	dt = (_tmp1 = (_tmp0 = target_type, VALA_IS_DELEGATE_TYPE (_tmp0) ? ((ValaDelegateType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (dt == NULL) {
		gboolean _tmp2;
		/* method types incompatible to anything but delegates*/
		return (_tmp2 = FALSE, (dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL)), _tmp2);
	}
	return (_tmp3 = vala_delegate_matches_method (vala_delegate_type_get_delegate_symbol (dt), self->priv->_method_symbol), (dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL)), _tmp3);
}


static char* vala_method_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaMethodType * self;
	self = (ValaMethodType*) base;
	return vala_symbol_get_full_name ((ValaSymbol*) self->priv->_method_symbol);
}


static char* vala_method_type_real_get_cname (ValaDataType* base) {
	ValaMethodType * self;
	self = (ValaMethodType*) base;
	return g_strdup ("gpointer");
}


static ValaSymbol* vala_method_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaMethodType * self;
	gboolean _tmp0;
	self = (ValaMethodType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_method_get_coroutine (self->priv->_method_symbol)) {
		_tmp0 = _vala_strcmp0 (member_name, "begin") == 0;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaSymbol* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = (ValaSymbol*) self->priv->_method_symbol, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	}
	return NULL;
}


ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_method_symbol;
}


void vala_method_type_set_method_symbol (ValaMethodType* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_method_symbol == NULL) ? NULL : (self->priv->_method_symbol = (vala_code_node_unref (self->priv->_method_symbol), NULL)), _tmp2);
}


static void vala_method_type_class_init (ValaMethodTypeClass * klass) {
	vala_method_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_method_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_method_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_method_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_method_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_method_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_method_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_method_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_method_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_method_type_real_get_member;
}


static void vala_method_type_instance_init (ValaMethodType * self) {
	self->priv = VALA_METHOD_TYPE_GET_PRIVATE (self);
}


static void vala_method_type_finalize (ValaCodeNode* obj) {
	ValaMethodType * self;
	self = VALA_METHOD_TYPE (obj);
	(self->priv->_method_symbol == NULL) ? NULL : (self->priv->_method_symbol = (vala_code_node_unref (self->priv->_method_symbol), NULL));
	VALA_CODE_NODE_CLASS (vala_method_type_parent_class)->finalize (obj);
}


GType vala_method_type_get_type (void) {
	static GType vala_method_type_type_id = 0;
	if (vala_method_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodType), 0, (GInstanceInitFunc) vala_method_type_instance_init, NULL };
		vala_method_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaMethodType", &g_define_type_info, 0);
	}
	return vala_method_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




