/* valagenietokentype.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#ifndef __VALA_VALAGENIETOKENTYPE_H__
#define __VALA_VALAGENIETOKENTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define VALA_GENIE_TYPE_TOKEN_TYPE (vala_genie_token_type_get_type ())

typedef enum  {
	VALA_GENIE_TOKEN_TYPE_NONE,
	VALA_GENIE_TOKEN_TYPE_ABSTRACT,
	VALA_GENIE_TOKEN_TYPE_ARRAY,
	VALA_GENIE_TOKEN_TYPE_AS,
	VALA_GENIE_TOKEN_TYPE_ASSERT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB,
	VALA_GENIE_TOKEN_TYPE_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_BREAK,
	VALA_GENIE_TOKEN_TYPE_CARRET,
	VALA_GENIE_TOKEN_TYPE_CASE,
	VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLASS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS,
	VALA_GENIE_TOKEN_TYPE_COLON,
	VALA_GENIE_TOKEN_TYPE_COMMA,
	VALA_GENIE_TOKEN_TYPE_CONST,
	VALA_GENIE_TOKEN_TYPE_CONSTRUCT,
	VALA_GENIE_TOKEN_TYPE_CONTINUE,
	VALA_GENIE_TOKEN_TYPE_DEDENT,
	VALA_GENIE_TOKEN_TYPE_DEF,
	VALA_GENIE_TOKEN_TYPE_DEFAULT,
	VALA_GENIE_TOKEN_TYPE_DELEGATE,
	VALA_GENIE_TOKEN_TYPE_DELETE,
	VALA_GENIE_TOKEN_TYPE_DICT,
	VALA_GENIE_TOKEN_TYPE_DIV,
	VALA_GENIE_TOKEN_TYPE_DO,
	VALA_GENIE_TOKEN_TYPE_DOT,
	VALA_GENIE_TOKEN_TYPE_DOWNTO,
	VALA_GENIE_TOKEN_TYPE_DYNAMIC,
	VALA_GENIE_TOKEN_TYPE_ELLIPSIS,
	VALA_GENIE_TOKEN_TYPE_ELSE,
	VALA_GENIE_TOKEN_TYPE_ENUM,
	VALA_GENIE_TOKEN_TYPE_ENSURES,
	VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN,
	VALA_GENIE_TOKEN_TYPE_EOF,
	VALA_GENIE_TOKEN_TYPE_EOL,
	VALA_GENIE_TOKEN_TYPE_EVENT,
	VALA_GENIE_TOKEN_TYPE_EXCEPT,
	VALA_GENIE_TOKEN_TYPE_EXTERN,
	VALA_GENIE_TOKEN_TYPE_FALSE,
	VALA_GENIE_TOKEN_TYPE_FINAL,
	VALA_GENIE_TOKEN_TYPE_FINALLY,
	VALA_GENIE_TOKEN_TYPE_FOR,
	VALA_GENIE_TOKEN_TYPE_FOREACH,
	VALA_GENIE_TOKEN_TYPE_GET,
	VALA_GENIE_TOKEN_TYPE_HASH,
	VALA_GENIE_TOKEN_TYPE_IDENTIFIER,
	VALA_GENIE_TOKEN_TYPE_IF,
	VALA_GENIE_TOKEN_TYPE_IMPLEMENTS,
	VALA_GENIE_TOKEN_TYPE_IN,
	VALA_GENIE_TOKEN_TYPE_INDENT,
	VALA_GENIE_TOKEN_TYPE_INIT,
	VALA_GENIE_TOKEN_TYPE_INLINE,
	VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_INTERFACE,
	VALA_GENIE_TOKEN_TYPE_INTERR,
	VALA_GENIE_TOKEN_TYPE_IS,
	VALA_GENIE_TOKEN_TYPE_ISA,
	VALA_GENIE_TOKEN_TYPE_LAMBDA,
	VALA_GENIE_TOKEN_TYPE_LIST,
	VALA_GENIE_TOKEN_TYPE_LOCK,
	VALA_GENIE_TOKEN_TYPE_MINUS,
	VALA_GENIE_TOKEN_TYPE_NAMESPACE,
	VALA_GENIE_TOKEN_TYPE_NEW,
	VALA_GENIE_TOKEN_TYPE_NULL,
	VALA_GENIE_TOKEN_TYPE_OF,
	VALA_GENIE_TOKEN_TYPE_OUT,
	VALA_GENIE_TOKEN_TYPE_OP_AND,
	VALA_GENIE_TOKEN_TYPE_OP_DEC,
	VALA_GENIE_TOKEN_TYPE_OP_EQ,
	VALA_GENIE_TOKEN_TYPE_OP_GE,
	VALA_GENIE_TOKEN_TYPE_OP_GT,
	VALA_GENIE_TOKEN_TYPE_OP_INC,
	VALA_GENIE_TOKEN_TYPE_OP_LE,
	VALA_GENIE_TOKEN_TYPE_OP_LT,
	VALA_GENIE_TOKEN_TYPE_OP_NE,
	VALA_GENIE_TOKEN_TYPE_OP_NEG,
	VALA_GENIE_TOKEN_TYPE_OP_OR,
	VALA_GENIE_TOKEN_TYPE_OP_PTR,
	VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACE,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET,
	VALA_GENIE_TOKEN_TYPE_OPEN_PARENS,
	VALA_GENIE_TOKEN_TYPE_OVERRIDE,
	VALA_GENIE_TOKEN_TYPE_PASS,
	VALA_GENIE_TOKEN_TYPE_PERCENT,
	VALA_GENIE_TOKEN_TYPE_PLUS,
	VALA_GENIE_TOKEN_TYPE_PRINT,
	VALA_GENIE_TOKEN_TYPE_PRIVATE,
	VALA_GENIE_TOKEN_TYPE_PROP,
	VALA_GENIE_TOKEN_TYPE_PROTECTED,
	VALA_GENIE_TOKEN_TYPE_PUBLIC,
	VALA_GENIE_TOKEN_TYPE_RAISE,
	VALA_GENIE_TOKEN_TYPE_RAISES,
	VALA_GENIE_TOKEN_TYPE_REAL_LITERAL,
	VALA_GENIE_TOKEN_TYPE_READONLY,
	VALA_GENIE_TOKEN_TYPE_REF,
	VALA_GENIE_TOKEN_TYPE_REQUIRES,
	VALA_GENIE_TOKEN_TYPE_RETURN,
	VALA_GENIE_TOKEN_TYPE_SEMICOLON,
	VALA_GENIE_TOKEN_TYPE_SET,
	VALA_GENIE_TOKEN_TYPE_SIZEOF,
	VALA_GENIE_TOKEN_TYPE_STAR,
	VALA_GENIE_TOKEN_TYPE_STATIC,
	VALA_GENIE_TOKEN_TYPE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_STRUCT,
	VALA_GENIE_TOKEN_TYPE_SUPER,
	VALA_GENIE_TOKEN_TYPE_THIS,
	VALA_GENIE_TOKEN_TYPE_TILDE,
	VALA_GENIE_TOKEN_TYPE_TO,
	VALA_GENIE_TOKEN_TYPE_TRUE,
	VALA_GENIE_TOKEN_TYPE_TRY,
	VALA_GENIE_TOKEN_TYPE_TYPEOF,
	VALA_GENIE_TOKEN_TYPE_USES,
	VALA_GENIE_TOKEN_TYPE_VAR,
	VALA_GENIE_TOKEN_TYPE_VIRTUAL,
	VALA_GENIE_TOKEN_TYPE_VOID,
	VALA_GENIE_TOKEN_TYPE_VOLATILE,
	VALA_GENIE_TOKEN_TYPE_WEAK,
	VALA_GENIE_TOKEN_TYPE_WHEN,
	VALA_GENIE_TOKEN_TYPE_WHILE,
	VALA_GENIE_TOKEN_TYPE_WRITEONLY
} ValaGenieTokenType;


const char* vala_genie_token_type_to_string (ValaGenieTokenType self);
GType vala_genie_token_type_get_type (void);


G_END_DECLS

#endif
