/* valadeletestatement.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadeletestatement.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valapointertype.h>
#include <vala/valareport.h>




struct _ValaDeleteStatementPrivate {
	ValaExpression* _expression;
};

#define VALA_DELETE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementPrivate))
enum  {
	VALA_DELETE_STATEMENT_DUMMY_PROPERTY
};
static void vala_delete_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_delete_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_delete_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_delete_statement_parent_class = NULL;
static ValaStatementIface* vala_delete_statement_vala_statement_parent_iface = NULL;
static void vala_delete_statement_finalize (ValaCodeNode* obj);



ValaDeleteStatement* vala_delete_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference) {
	ValaDeleteStatement* self;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaDeleteStatement*) g_type_create_instance (object_type);
	vala_delete_statement_set_expression (self, expression);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaDeleteStatement* vala_delete_statement_new (ValaExpression* expression, ValaSourceReference* source_reference) {
	return vala_delete_statement_construct (VALA_TYPE_DELETE_STATEMENT, expression, source_reference);
}


static void vala_delete_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeleteStatement * self;
	self = (ValaDeleteStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delete_statement (visitor, self);
}


static void vala_delete_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeleteStatement * self;
	self = (ValaDeleteStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) self->priv->_expression, visitor);
}


static gboolean vala_delete_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDeleteStatement * self;
	self = (ValaDeleteStatement*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (!vala_code_node_check ((ValaCodeNode*) self->priv->_expression, analyzer)) {
		/* if there was an error in the inner expression, skip this check*/
		return FALSE;
	}
	if (!VALA_IS_POINTER_TYPE (vala_expression_get_value_type (self->priv->_expression))) {
		char* _tmp3;
		char* _tmp2;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp3 = g_strdup_printf ("delete operator not supported for `%s'", _tmp2 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (self->priv->_expression))));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
	}
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


ValaExpression* vala_delete_statement_get_expression (ValaDeleteStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_expression;
}


void vala_delete_statement_set_expression (ValaDeleteStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_expression == NULL) ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL)), _tmp2);
}


static void vala_delete_statement_class_init (ValaDeleteStatementClass * klass) {
	vala_delete_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_delete_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDeleteStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_delete_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_delete_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_delete_statement_real_check;
}


static void vala_delete_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_delete_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_delete_statement_instance_init (ValaDeleteStatement * self) {
	self->priv = VALA_DELETE_STATEMENT_GET_PRIVATE (self);
}


static void vala_delete_statement_finalize (ValaCodeNode* obj) {
	ValaDeleteStatement * self;
	self = VALA_DELETE_STATEMENT (obj);
	(self->priv->_expression == NULL) ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL));
	VALA_CODE_NODE_CLASS (vala_delete_statement_parent_class)->finalize (obj);
}


GType vala_delete_statement_get_type (void) {
	static GType vala_delete_statement_type_id = 0;
	if (vala_delete_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDeleteStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delete_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDeleteStatement), 0, (GInstanceInitFunc) vala_delete_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_delete_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_delete_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDeleteStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_delete_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_delete_statement_type_id;
}




