/* valacodevisitor.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALACODEVISITOR_H__
#define __VALA_VALACODEVISITOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;
typedef struct _ValaParamSpecCodeVisitor ValaParamSpecCodeVisitor;

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

struct _ValaParamSpecCodeVisitor {
	GParamSpec parent_instance;
};


void vala_code_visitor_visit_source_file (ValaCodeVisitor* self, ValaSourceFile* source_file);
void vala_code_visitor_visit_namespace (ValaCodeVisitor* self, ValaNamespace* ns);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
void vala_code_visitor_visit_struct (ValaCodeVisitor* self, ValaStruct* st);
void vala_code_visitor_visit_interface (ValaCodeVisitor* self, ValaInterface* iface);
void vala_code_visitor_visit_enum (ValaCodeVisitor* self, ValaEnum* en);
void vala_code_visitor_visit_enum_value (ValaCodeVisitor* self, ValaEnumValue* ev);
void vala_code_visitor_visit_error_domain (ValaCodeVisitor* self, ValaErrorDomain* edomain);
void vala_code_visitor_visit_error_code (ValaCodeVisitor* self, ValaErrorCode* ecode);
void vala_code_visitor_visit_delegate (ValaCodeVisitor* self, ValaDelegate* d);
void vala_code_visitor_visit_member (ValaCodeVisitor* self, ValaMember* m);
void vala_code_visitor_visit_constant (ValaCodeVisitor* self, ValaConstant* c);
void vala_code_visitor_visit_field (ValaCodeVisitor* self, ValaField* f);
void vala_code_visitor_visit_method (ValaCodeVisitor* self, ValaMethod* m);
void vala_code_visitor_visit_creation_method (ValaCodeVisitor* self, ValaCreationMethod* m);
void vala_code_visitor_visit_formal_parameter (ValaCodeVisitor* self, ValaFormalParameter* p);
void vala_code_visitor_visit_property (ValaCodeVisitor* self, ValaProperty* prop);
void vala_code_visitor_visit_property_accessor (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
void vala_code_visitor_visit_signal (ValaCodeVisitor* self, ValaSignal* sig);
void vala_code_visitor_visit_constructor (ValaCodeVisitor* self, ValaConstructor* c);
void vala_code_visitor_visit_destructor (ValaCodeVisitor* self, ValaDestructor* d);
void vala_code_visitor_visit_type_parameter (ValaCodeVisitor* self, ValaTypeParameter* p);
void vala_code_visitor_visit_using_directive (ValaCodeVisitor* self, ValaUsingDirective* ns);
void vala_code_visitor_visit_data_type (ValaCodeVisitor* self, ValaDataType* type);
void vala_code_visitor_visit_block (ValaCodeVisitor* self, ValaBlock* b);
void vala_code_visitor_visit_empty_statement (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
void vala_code_visitor_visit_declaration_statement (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
void vala_code_visitor_visit_local_variable (ValaCodeVisitor* self, ValaLocalVariable* local);
void vala_code_visitor_visit_initializer_list (ValaCodeVisitor* self, ValaInitializerList* list);
void vala_code_visitor_visit_expression_statement (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
void vala_code_visitor_visit_if_statement (ValaCodeVisitor* self, ValaIfStatement* stmt);
void vala_code_visitor_visit_switch_statement (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
void vala_code_visitor_visit_switch_section (ValaCodeVisitor* self, ValaSwitchSection* section);
void vala_code_visitor_visit_switch_label (ValaCodeVisitor* self, ValaSwitchLabel* label);
void vala_code_visitor_visit_while_statement (ValaCodeVisitor* self, ValaWhileStatement* stmt);
void vala_code_visitor_visit_do_statement (ValaCodeVisitor* self, ValaDoStatement* stmt);
void vala_code_visitor_visit_for_statement (ValaCodeVisitor* self, ValaForStatement* stmt);
void vala_code_visitor_visit_foreach_statement (ValaCodeVisitor* self, ValaForeachStatement* stmt);
void vala_code_visitor_visit_break_statement (ValaCodeVisitor* self, ValaBreakStatement* stmt);
void vala_code_visitor_visit_continue_statement (ValaCodeVisitor* self, ValaContinueStatement* stmt);
void vala_code_visitor_visit_return_statement (ValaCodeVisitor* self, ValaReturnStatement* stmt);
void vala_code_visitor_visit_yield_statement (ValaCodeVisitor* self, ValaYieldStatement* y);
void vala_code_visitor_visit_throw_statement (ValaCodeVisitor* self, ValaThrowStatement* stmt);
void vala_code_visitor_visit_try_statement (ValaCodeVisitor* self, ValaTryStatement* stmt);
void vala_code_visitor_visit_catch_clause (ValaCodeVisitor* self, ValaCatchClause* clause);
void vala_code_visitor_visit_lock_statement (ValaCodeVisitor* self, ValaLockStatement* stmt);
void vala_code_visitor_visit_delete_statement (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
void vala_code_visitor_visit_array_creation_expression (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
void vala_code_visitor_visit_boolean_literal (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
void vala_code_visitor_visit_character_literal (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
void vala_code_visitor_visit_integer_literal (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
void vala_code_visitor_visit_real_literal (ValaCodeVisitor* self, ValaRealLiteral* lit);
void vala_code_visitor_visit_string_literal (ValaCodeVisitor* self, ValaStringLiteral* lit);
void vala_code_visitor_visit_null_literal (ValaCodeVisitor* self, ValaNullLiteral* lit);
void vala_code_visitor_visit_member_access (ValaCodeVisitor* self, ValaMemberAccess* expr);
void vala_code_visitor_visit_method_call (ValaCodeVisitor* self, ValaMethodCall* expr);
void vala_code_visitor_visit_element_access (ValaCodeVisitor* self, ValaElementAccess* expr);
void vala_code_visitor_visit_base_access (ValaCodeVisitor* self, ValaBaseAccess* expr);
void vala_code_visitor_visit_postfix_expression (ValaCodeVisitor* self, ValaPostfixExpression* expr);
void vala_code_visitor_visit_object_creation_expression (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
void vala_code_visitor_visit_sizeof_expression (ValaCodeVisitor* self, ValaSizeofExpression* expr);
void vala_code_visitor_visit_typeof_expression (ValaCodeVisitor* self, ValaTypeofExpression* expr);
void vala_code_visitor_visit_unary_expression (ValaCodeVisitor* self, ValaUnaryExpression* expr);
void vala_code_visitor_visit_cast_expression (ValaCodeVisitor* self, ValaCastExpression* expr);
void vala_code_visitor_visit_pointer_indirection (ValaCodeVisitor* self, ValaPointerIndirection* expr);
void vala_code_visitor_visit_addressof_expression (ValaCodeVisitor* self, ValaAddressofExpression* expr);
void vala_code_visitor_visit_reference_transfer_expression (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
void vala_code_visitor_visit_binary_expression (ValaCodeVisitor* self, ValaBinaryExpression* expr);
void vala_code_visitor_visit_type_check (ValaCodeVisitor* self, ValaTypeCheck* expr);
void vala_code_visitor_visit_conditional_expression (ValaCodeVisitor* self, ValaConditionalExpression* expr);
void vala_code_visitor_visit_lambda_expression (ValaCodeVisitor* self, ValaLambdaExpression* expr);
void vala_code_visitor_visit_assignment (ValaCodeVisitor* self, ValaAssignment* a);
void vala_code_visitor_visit_end_full_expression (ValaCodeVisitor* self, ValaExpression* expr);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_code_visitor (const GValue* value);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
GType vala_code_visitor_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);


G_END_DECLS

#endif
