/* valadbusmodule.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valadbusmodule.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valastruct.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valatypesymbol.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valaobjecttype.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <gobject/valaccodebasemodule.h>

typedef struct _ValaDBusModuleBasicTypeInfo ValaDBusModuleBasicTypeInfo;

#define VALA_DBUS_MODULE_TYPE_BASIC_TYPE_INFO (vala_dbus_module_basic_type_info_get_type ())

struct _ValaDBusModuleBasicTypeInfo {
	const char* signature;
	const char* type_name;
	const char* cname;
	const char* gtype;
	const char* get_value_function;
	const char* set_value_function;
};



enum  {
	VALA_DBUS_MODULE_DUMMY_PROPERTY
};
static gboolean vala_dbus_module_get_basic_type_info (ValaDBusModule* self, const char* signature, ValaDBusModuleBasicTypeInfo* basic_type);
static ValaCCodeExpression* vala_dbus_module_get_array_length (ValaDBusModule* self, ValaCCodeExpression* expr, gint dim);
static ValaCCodeExpression* vala_dbus_module_read_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr);
static ValaCCodeExpression* vala_dbus_module_read_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_module_read_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, const char* temp_name, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_dbus_module_read_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr);
static ValaCCodeExpression* vala_dbus_module_read_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr);
static ValaCCodeExpression* vala_dbus_module_read_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr);
static void vala_dbus_module_write_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_module_write_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr);
static void vala_dbus_module_write_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr, ValaCCodeExpression* array_iter_expr);
static void vala_dbus_module_write_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr, ValaCCodeExpression* struct_expr);
static void vala_dbus_module_write_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_module_write_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* hash_table_expr);
static ValaDBusModuleBasicTypeInfo* vala_dbus_module_basic_type_info_dup (const ValaDBusModuleBasicTypeInfo* self);
static void vala_dbus_module_basic_type_info_free (ValaDBusModuleBasicTypeInfo* self);
static GType vala_dbus_module_basic_type_info_get_type (void);
static gpointer vala_dbus_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);

static const ValaDBusModuleBasicTypeInfo VALA_DBUS_MODULE_basic_types[] = {{"y", "BYTE", "guint8", "G_TYPE_UCHAR", "g_value_get_uchar", "g_value_set_uchar"}, {"b", "BOOLEAN", "dbus_bool_t", "G_TYPE_BOOLEAN", "g_value_get_boolean", "g_value_set_boolean"}, {"n", "INT16", "dbus_int16_t", "G_TYPE_INT", NULL, "g_value_set_int"}, {"q", "UINT16", "dbus_uint16_t", "G_TYPE_UINT", NULL, "g_value_set_uint"}, {"i", "INT32", "dbus_int32_t", "G_TYPE_INT", "g_value_get_int", "g_value_set_int"}, {"u", "UINT32", "dbus_uint32_t", "G_TYPE_UINT", "g_value_get_uint", "g_value_set_uint"}, {"x", "INT64", "dbus_int64_t", "G_TYPE_INT64", "g_value_get_int64", "g_value_set_int64"}, {"t", "UINT64", "dbus_uint64_t", "G_TYPE_UINT64", "g_value_get_uint64", "g_value_set_uint64"}, {"d", "DOUBLE", "double", "G_TYPE_DOUBLE", "g_value_get_double", "g_value_set_double"}, {"s", "STRING", "const char*", "G_TYPE_STRING", "g_value_get_string", "g_value_take_string"}, {"o", "OBJECT_PATH", "const char*", "G_TYPE_STRING", NULL, "g_value_take_string"}, {"g", "SIGNATURE", "const char*", "G_TYPE_STRING", NULL, "g_value_take_string"}};


ValaDBusModule* vala_dbus_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusModule*) vala_gasync_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_module_construct (VALA_TYPE_DBUS_MODULE, codegen, next);
}


static gboolean vala_dbus_module_get_basic_type_info (ValaDBusModule* self, const char* signature, ValaDBusModuleBasicTypeInfo* basic_type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	{
		ValaDBusModuleBasicTypeInfo* info_collection;
		int info_collection_length1;
		int info_it;
		info_collection = VALA_DBUS_MODULE_basic_types;
		info_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (info_it = 0; info_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); info_it = info_it + 1) {
			ValaDBusModuleBasicTypeInfo info;
			info = info_collection[info_it];
			{
				if (_vala_strcmp0 (info.signature, signature) == 0) {
					(*basic_type) = info;
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}


static ValaCCodeExpression* vala_dbus_module_get_array_length (ValaDBusModule* self, ValaCCodeExpression* expr, gint dim) {
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeExpression* _tmp0;
	ValaCCodeIdentifier* id;
	ValaCCodeMemberAccess* _tmp3;
	ValaCCodeExpression* _tmp2;
	ValaCCodeMemberAccess* ma;
	ValaCCodeExpression* _tmp10;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	id = (_tmp1 = (_tmp0 = expr, VALA_IS_CCODE_IDENTIFIER (_tmp0) ? ((ValaCCodeIdentifier*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	ma = (_tmp3 = (_tmp2 = expr, VALA_IS_CCODE_MEMBER_ACCESS (_tmp2) ? ((ValaCCodeMemberAccess*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3));
	if (id != NULL) {
		char* _tmp4;
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* _tmp6;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_tmp6 = NULL;
		return (_tmp6 = (_tmp5 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp4 = g_strdup_printf ("%s_length%d", vala_ccode_identifier_get_name (id), dim)), _tmp4 = (g_free (_tmp4), NULL), _tmp5), (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp6);
	} else {
		if (ma != NULL) {
			char* _tmp7;
			ValaCCodeExpression* _tmp8;
			ValaCCodeExpression* _tmp9;
			_tmp7 = NULL;
			_tmp8 = NULL;
			_tmp9 = NULL;
			return (_tmp9 = (_tmp8 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (vala_ccode_member_access_get_inner (ma), _tmp7 = g_strdup_printf ("%s_length%d", vala_ccode_member_access_get_member_name (ma), dim)), _tmp7 = (g_free (_tmp7), NULL), _tmp8), (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp9);
		}
	}
	_tmp10 = NULL;
	return (_tmp10 = NULL, (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp10);
}


static ValaCCodeExpression* vala_dbus_module_read_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeUnaryExpression* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeExpressionStatement* _tmp6;
	ValaCCodeIdentifier* temp_result;
	gboolean _tmp7;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ((*basic_type).cname);
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (temp_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp1 = NULL;
	_tmp2 = NULL;
	iter_call = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("dbus_message_iter_get_basic"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (temp_name)))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp6 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	temp_result = vala_ccode_identifier_new (temp_name);
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	if (_vala_strcmp0 ((*basic_type).signature, "s") == 0) {
		_tmp8 = TRUE;
	} else {
		_tmp8 = _vala_strcmp0 ((*basic_type).signature, "o") == 0;
	}
	if (_tmp8) {
		_tmp7 = TRUE;
	} else {
		_tmp7 = _vala_strcmp0 ((*basic_type).signature, "g") == 0;
	}
	if (_tmp7) {
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeFunctionCall* _tmp10;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeExpression* _tmp11;
		_tmp9 = NULL;
		_tmp10 = NULL;
		dup_call = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("g_strdup"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) temp_result);
		_tmp11 = NULL;
		return (_tmp11 = (ValaCCodeExpression*) dup_call, temp_name = (g_free (temp_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (temp_result == NULL) ? NULL : (temp_result = (vala_ccode_node_unref (temp_result), NULL)), _tmp11);
	} else {
		ValaCCodeExpression* _tmp12;
		_tmp12 = NULL;
		return (_tmp12 = (ValaCCodeExpression*) temp_result, temp_name = (g_free (temp_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp12);
	}
	temp_name = (g_free (temp_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(temp_result == NULL) ? NULL : (temp_result = (vala_ccode_node_unref (temp_result), NULL));
}


static ValaCCodeExpression* vala_dbus_module_read_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* temp_name;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* new_call;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	ValaCCodeConstant* _tmp4;
	char* _tmp5;
	ValaCCodeDeclaration* _tmp6;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeVariableDeclarator* _tmp11;
	ValaCCodeConstant* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeConstant* _tmp14;
	char* _tmp13;
	ValaCCodeExpression* _tmp23;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0 = NULL;
	_tmp1 = NULL;
	new_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_new"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	/* add one extra element for NULL-termination*/
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("5")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	_tmp6 = NULL;
	cdecl_ = (_tmp6 = vala_ccode_declaration_new (_tmp5 = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp5 = (g_free (_tmp5), NULL), _tmp6);
	_tmp7 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new (temp_name, (ValaCCodeExpression*) new_call)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp8 = NULL;
	cdecl_ = (_tmp8 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp8);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new (_tmp9 = g_strconcat (temp_name, "_length", NULL), (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("0")))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp12 = NULL;
	cdecl_ = (_tmp12 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp12);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new (_tmp13 = g_strconcat (temp_name, "_size", NULL), (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("4")))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp13 = (g_free (_tmp13), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	vala_dbus_module_read_array_dim (self, fragment, array_type, 1, temp_name, iter_expr, expr);
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		char* _tmp16;
		ValaCCodeIdentifier* _tmp17;
		ValaCCodeIdentifier* length;
		ValaCCodeIdentifier* _tmp18;
		ValaCCodeElementAccess* _tmp19;
		ValaCCodeElementAccess* element_access;
		ValaCCodeExpressionStatement* _tmp22;
		ValaCCodeAssignment* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		/* NULL terminate array*/
		_tmp16 = NULL;
		_tmp17 = NULL;
		length = (_tmp17 = vala_ccode_identifier_new (_tmp16 = g_strconcat (temp_name, "_length", NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
		_tmp18 = NULL;
		_tmp19 = NULL;
		element_access = (_tmp19 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) length), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_assignment_new ((ValaCCodeExpression*) element_access, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		(length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL));
		(element_access == NULL) ? NULL : (element_access = (vala_ccode_node_unref (element_access), NULL));
	}
	_tmp23 = NULL;
	return (_tmp23 = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), (new_call == NULL) ? NULL : (new_call = (vala_ccode_node_unref (new_call), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp23);
}


static void vala_dbus_module_read_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, const char* temp_name, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* subiter_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeConstant* _tmp1;
	char* _tmp0;
	ValaCCodeDeclaration* _tmp3;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp7;
	ValaCCodeUnaryExpression* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeUnaryExpression* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeBlock* cforblock;
	ValaCCodeFragment* cforfragment;
	ValaCCodeForStatement* cfor;
	ValaCCodeUnaryExpression* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	char* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (temp_name != NULL);
	g_return_if_fail (iter_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ("int");
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new (_tmp0 = g_strdup_printf ("%s_length%d", temp_name, dim), (ValaCCodeExpression*) (_tmp1 = vala_ccode_constant_new ("0")))));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp0 = (g_free (_tmp0), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	cdecl_ = (_tmp3 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp3);
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp4 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp5 = NULL;
	_tmp6 = NULL;
	iter_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp10 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp12 = NULL;
	_tmp11 = NULL;
	iter_call = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp12);
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	cforblock = vala_ccode_block_new ();
	cforfragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cforblock, (ValaCCodeNode*) cforfragment);
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) iter_call, (ValaCCodeStatement*) cforblock);
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp17 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = g_strdup_printf ("%s_length%d", temp_name, dim))))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp15 = (g_free (_tmp15), NULL);
	if (dim < vala_array_type_get_rank (array_type)) {
		ValaCCodeIdentifier* _tmp18;
		ValaCCodeFunctionCall* _tmp20;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeUnaryExpression* _tmp22;
		ValaCCodeIdentifier* _tmp21;
		ValaCCodeExpressionStatement* _tmp23;
		_tmp18 = NULL;
		vala_dbus_module_read_array_dim (self, cforfragment, array_type, dim + 1, temp_name, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (subiter_name)), expr);
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		_tmp20 = NULL;
		_tmp19 = NULL;
		iter_call = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dbus_message_iter_next"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp20);
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (subiter_name)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		_tmp23 = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	} else {
		ValaCCodeIdentifier* _tmp27;
		char* _tmp26;
		ValaCCodeIdentifier* _tmp25;
		char* _tmp24;
		ValaCCodeBinaryExpression* _tmp28;
		ValaCCodeBinaryExpression* size_check;
		ValaCCodeBlock* renew_block;
		ValaCCodeIdentifier* _tmp31;
		char* _tmp30;
		ValaCCodeConstant* _tmp29;
		ValaCCodeBinaryExpression* _tmp32;
		ValaCCodeBinaryExpression* new_size;
		ValaCCodeExpressionStatement* _tmp36;
		ValaCCodeAssignment* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		char* _tmp33;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* renew_call;
		ValaCCodeIdentifier* _tmp40;
		char* _tmp39;
		ValaCCodeIdentifier* _tmp41;
		ValaCCodeBinaryExpression* _tmp45;
		ValaCCodeConstant* _tmp44;
		ValaCCodeIdentifier* _tmp43;
		char* _tmp42;
		ValaCCodeAssignment* _tmp47;
		ValaCCodeIdentifier* _tmp46;
		ValaCCodeExpressionStatement* _tmp48;
		ValaCCodeExpressionStatement* renew_stmt;
		ValaCCodeIfStatement* cif;
		ValaCCodeUnaryExpression* _tmp52;
		ValaCCodeIdentifier* _tmp51;
		char* _tmp50;
		ValaCCodeIdentifier* _tmp49;
		ValaCCodeElementAccess* _tmp53;
		ValaCCodeElementAccess* element_access;
		ValaCCodeIdentifier* _tmp54;
		ValaCCodeExpression* _tmp55;
		ValaCCodeExpression* element_expr;
		ValaCCodeExpressionStatement* _tmp57;
		ValaCCodeAssignment* _tmp56;
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp28 = NULL;
		size_check = (_tmp28 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new (_tmp24 = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (_tmp26 = g_strconcat (temp_name, "_length", NULL)))), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp26 = (g_free (_tmp26), NULL), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), _tmp24 = (g_free (_tmp24), NULL), _tmp28);
		renew_block = vala_ccode_block_new ();
		/* tmp_size = (2 * tmp_size);*/
		_tmp31 = NULL;
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp32 = NULL;
		new_size = (_tmp32 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp29 = vala_ccode_constant_new ("2")), (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (_tmp30 = g_strconcat (temp_name, "_size", NULL)))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp30 = (g_free (_tmp30), NULL), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp32);
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		vala_ccode_block_add_statement (renew_block, (ValaCCodeNode*) (_tmp36 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		_tmp33 = (g_free (_tmp33), NULL);
		_tmp37 = NULL;
		_tmp38 = NULL;
		renew_call = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_renew"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
		_tmp40 = NULL;
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		_tmp39 = (g_free (_tmp39), NULL);
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new (temp_name)));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		/* add one extra element for NULL-termination*/
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		_tmp42 = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (_tmp42 = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("1")))));
		(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
		(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
		_tmp42 = (g_free (_tmp42), NULL);
		_tmp47 = NULL;
		_tmp46 = NULL;
		_tmp48 = NULL;
		renew_stmt = (_tmp48 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) renew_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)), (_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)), _tmp48);
		vala_ccode_block_add_statement (renew_block, (ValaCCodeNode*) renew_stmt);
		cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) size_check, (ValaCCodeStatement*) renew_block, NULL);
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) cif);
		_tmp52 = NULL;
		_tmp51 = NULL;
		_tmp50 = NULL;
		_tmp49 = NULL;
		_tmp53 = NULL;
		element_access = (_tmp53 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) (_tmp52 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new (_tmp50 = g_strconcat (temp_name, "_length", NULL)))))), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), (_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)), _tmp50 = (g_free (_tmp50), NULL), (_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)), _tmp53);
		_tmp54 = NULL;
		_tmp55 = NULL;
		element_expr = (_tmp55 = vala_dbus_module_read_expression (self, cforfragment, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new (subiter_name)), NULL), (_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)), _tmp55);
		_tmp57 = NULL;
		_tmp56 = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp57 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_assignment_new ((ValaCCodeExpression*) element_access, element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
		(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
		(size_check == NULL) ? NULL : (size_check = (vala_ccode_node_unref (size_check), NULL));
		(renew_block == NULL) ? NULL : (renew_block = (vala_ccode_node_unref (renew_block), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(renew_call == NULL) ? NULL : (renew_call = (vala_ccode_node_unref (renew_call), NULL));
		(renew_stmt == NULL) ? NULL : (renew_stmt = (vala_ccode_node_unref (renew_stmt), NULL));
		(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		(element_access == NULL) ? NULL : (element_access = (vala_ccode_node_unref (element_access), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
	}
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cfor);
	if (expr != NULL) {
		ValaCCodeExpressionStatement* _tmp62;
		ValaCCodeAssignment* _tmp61;
		ValaCCodeIdentifier* _tmp60;
		char* _tmp59;
		ValaCCodeExpression* _tmp58;
		_tmp62 = NULL;
		_tmp61 = NULL;
		_tmp60 = NULL;
		_tmp59 = NULL;
		_tmp58 = NULL;
		vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_assignment_new (_tmp58 = vala_dbus_module_get_array_length (self, expr, dim), (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new (_tmp59 = g_strdup_printf ("%s_length%d", temp_name, dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
		(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
		(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		_tmp59 = (g_free (_tmp59), NULL);
		(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	}
	subiter_name = (g_free (subiter_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(cforblock == NULL) ? NULL : (cforblock = (vala_ccode_node_unref (cforblock), NULL));
	(cforfragment == NULL) ? NULL : (cforfragment = (vala_ccode_node_unref (cforfragment), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static ValaCCodeExpression* vala_dbus_module_read_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeDeclaration* _tmp3;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp7;
	ValaCCodeUnaryExpression* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeExpression* _tmp23;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new (temp_name, NULL)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	cdecl_ = (_tmp3 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp3);
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp4 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp5 = NULL;
	_tmp6 = NULL;
	iter_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp10 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	{
		GeeList* _tmp11;
		GeeIterator* _tmp12;
		GeeIterator* _f_it;
		_tmp11 = NULL;
		_tmp12 = NULL;
		_f_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_struct_get_fields (st))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			ValaCCodeMemberAccess* _tmp16;
			char* _tmp15;
			ValaCCodeIdentifier* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeExpression* _tmp17;
			ValaCCodeExpression* field_expr;
			ValaCCodeExpressionStatement* _tmp22;
			ValaCCodeAssignment* _tmp21;
			ValaCCodeMemberAccess* _tmp20;
			char* _tmp19;
			ValaCCodeIdentifier* _tmp18;
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				continue;
			}
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp17 = NULL;
			field_expr = (_tmp17 = vala_dbus_module_read_expression (self, fragment, vala_field_get_field_type (f), (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) (_tmp16 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (temp_name)), _tmp15 = vala_field_get_cname (f), FALSE))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp15 = (g_free (_tmp15), NULL), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp17);
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			_tmp19 = NULL;
			_tmp18 = NULL;
			vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (temp_name)), _tmp19 = vala_field_get_cname (f), FALSE)), field_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			_tmp19 = (g_free (_tmp19), NULL);
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			(field_expr == NULL) ? NULL : (field_expr = (vala_ccode_node_unref (field_expr), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	_tmp23 = NULL;
	return (_tmp23 = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp23);
}


static ValaCCodeExpression* vala_dbus_module_read_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeVariableDeclarator* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp6;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeExpressionStatement* _tmp9;
	ValaCCodeIfStatement* clastif;
	ValaCCodeExpression* _tmp32;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	/* 0-initialize struct with struct initializer { 0 }*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0 = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("0")));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	cdecl_ = vala_ccode_declaration_new ("GValue");
	_tmp1 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp1 = vala_ccode_variable_declarator_new (temp_name, (ValaCCodeExpression*) cvalinit)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp2 = NULL;
	cdecl_ = (_tmp2 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp3 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp4 = NULL;
	_tmp5 = NULL;
	iter_call = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp9 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp9 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	clastif = NULL;
	{
		ValaDBusModuleBasicTypeInfo* basic_type_collection;
		int basic_type_collection_length1;
		int basic_type_it;
		basic_type_collection = VALA_DBUS_MODULE_basic_types;
		basic_type_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (basic_type_it = 0; basic_type_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); basic_type_it = basic_type_it + 1) {
			ValaDBusModuleBasicTypeInfo basic_type;
			basic_type = basic_type_collection[basic_type_it];
			{
				ValaCCodeIdentifier* _tmp10;
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeFunctionCall* type_call;
				ValaCCodeUnaryExpression* _tmp13;
				ValaCCodeIdentifier* _tmp12;
				ValaCCodeIdentifier* _tmp15;
				char* _tmp14;
				ValaCCodeBinaryExpression* _tmp16;
				ValaCCodeBinaryExpression* type_check;
				ValaCCodeBlock* type_block;
				ValaCCodeFragment* type_fragment;
				ValaCCodeIdentifier* _tmp17;
				ValaCCodeExpression* _tmp18;
				ValaCCodeExpression* result;
				ValaCCodeIdentifier* _tmp19;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeFunctionCall* value_init;
				ValaCCodeUnaryExpression* _tmp22;
				ValaCCodeIdentifier* _tmp21;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeExpressionStatement* _tmp24;
				ValaCCodeIdentifier* _tmp25;
				ValaCCodeFunctionCall* _tmp26;
				ValaCCodeFunctionCall* value_set;
				ValaCCodeUnaryExpression* _tmp28;
				ValaCCodeIdentifier* _tmp27;
				ValaCCodeExpressionStatement* _tmp29;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp31;
				ValaCCodeIfStatement* _tmp30;
				_tmp10 = NULL;
				_tmp11 = NULL;
				type_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
				_tmp13 = NULL;
				_tmp12 = NULL;
				vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (subiter_name)))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp16 = NULL;
				type_check = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) type_call, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = g_strconcat ("DBUS_TYPE_", basic_type.type_name, NULL)))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp16);
				type_block = vala_ccode_block_new ();
				type_fragment = vala_ccode_fragment_new ();
				vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) type_fragment);
				_tmp17 = NULL;
				_tmp18 = NULL;
				result = (_tmp18 = vala_dbus_module_read_basic (self, type_fragment, &basic_type, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (subiter_name))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp18);
				_tmp19 = NULL;
				_tmp20 = NULL;
				value_init = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("g_value_init"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
				_tmp22 = NULL;
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (value_init, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (temp_name)))));
				(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				_tmp23 = NULL;
				vala_ccode_function_call_add_argument (value_init, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (basic_type.gtype)));
				(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
				_tmp24 = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp24 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) value_init)));
				(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
				_tmp25 = NULL;
				_tmp26 = NULL;
				value_set = (_tmp26 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new (basic_type.set_value_function))), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), _tmp26);
				_tmp28 = NULL;
				_tmp27 = NULL;
				vala_ccode_function_call_add_argument (value_set, (ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (temp_name)))));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
				vala_ccode_function_call_add_argument (value_set, result);
				_tmp29 = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) value_set)));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) type_check, (ValaCCodeStatement*) type_block, NULL);
				if (clastif == NULL) {
					vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cif);
				} else {
					vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
				}
				_tmp31 = NULL;
				_tmp30 = NULL;
				clastif = (_tmp31 = (_tmp30 = cif, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp31);
				(type_call == NULL) ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL));
				(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
				(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
				(type_fragment == NULL) ? NULL : (type_fragment = (vala_ccode_node_unref (type_fragment), NULL));
				(result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL));
				(value_init == NULL) ? NULL : (value_init = (vala_ccode_node_unref (value_init), NULL));
				(value_set == NULL) ? NULL : (value_set = (vala_ccode_node_unref (value_set), NULL));
				(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
			}
		}
	}
	_tmp32 = NULL;
	return (_tmp32 = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), (cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp32);
}


static ValaCCodeExpression* vala_dbus_module_read_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	char* entryiter_name;
	GeeList* type_args;
	ValaDataType* key_type;
	ValaDataType* value_type;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeDeclaration* _tmp3;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* hash_table_new;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp20;
	ValaCCodeUnaryExpression* _tmp22;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeUnaryExpression* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeBlock* cwhileblock;
	ValaCCodeFragment* cwhilefragment;
	ValaCCodeWhileStatement* cwhile;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeUnaryExpression* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeUnaryExpression* _tmp33;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeDeclaration* _tmp36;
	char* _tmp35;
	ValaCCodeVariableDeclarator* _tmp37;
	ValaCCodeDeclaration* _tmp39;
	char* _tmp38;
	ValaCCodeVariableDeclarator* _tmp40;
	ValaCCodeIdentifier* _tmp41;
	ValaCCodeExpression* _tmp42;
	ValaCCodeExpression* key_expr;
	ValaCCodeExpressionStatement* _tmp45;
	ValaCCodeAssignment* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeExpression* _tmp47;
	ValaCCodeExpression* value_expr;
	ValaCCodeExpressionStatement* _tmp50;
	ValaCCodeAssignment* _tmp49;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeFunctionCall* _tmp52;
	ValaCCodeFunctionCall* hash_table_insert;
	ValaCCodeIdentifier* _tmp53;
	ValaCCodeExpression* _tmp55;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeExpression* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeExpressionStatement* _tmp58;
	ValaCCodeFunctionCall* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeUnaryExpression* _tmp62;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeExpressionStatement* _tmp63;
	ValaCCodeExpression* _tmp64;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	entryiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	type_args = vala_data_type_get_type_arguments ((ValaDataType*) type);
	g_assert (gee_collection_get_size ((GeeCollection*) type_args) == 2);
	key_type = (ValaDataType*) gee_list_get (type_args, 0);
	value_type = (ValaDataType*) gee_list_get (type_args, 1);
	cdecl_ = vala_ccode_declaration_new ("GHashTable*");
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (temp_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	cdecl_ = (_tmp3 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp3);
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp4 = vala_ccode_variable_declarator_new (entryiter_name, NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp5 = NULL;
	_tmp6 = NULL;
	hash_table_new = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("g_hash_table_new_full"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	if (vala_data_type_get_data_type (key_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp7;
		ValaCCodeIdentifier* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_str_hash")));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("g_str_equal")));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	} else {
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp10;
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("g_direct_hash")));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_direct_equal")));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	}
	if (vala_data_type_get_data_type (key_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp11;
		_tmp11 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_free")));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	} else {
		ValaCCodeIdentifier* _tmp12;
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("NULL")));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	}
	if (vala_data_type_get_data_type (value_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp13;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_free")));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	} else {
		ValaCCodeIdentifier* _tmp14;
		_tmp14 = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("NULL")));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	}
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) hash_table_new, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp18 = NULL;
	_tmp19 = NULL;
	iter_call = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp20 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp23 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	iter_call = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp25);
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp27 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	cwhileblock = vala_ccode_block_new ();
	cwhilefragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cwhileblock, (ValaCCodeNode*) cwhilefragment);
	cwhile = vala_ccode_while_statement_new ((ValaCCodeExpression*) iter_call, (ValaCCodeStatement*) cwhileblock);
	_tmp29 = NULL;
	_tmp28 = NULL;
	iter_call = (_tmp29 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp29);
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp31 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp34 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	_tmp36 = NULL;
	_tmp35 = NULL;
	cdecl_ = (_tmp36 = vala_ccode_declaration_new (_tmp35 = vala_data_type_get_cname (key_type)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp36);
	_tmp35 = (g_free (_tmp35), NULL);
	_tmp37 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp37 = vala_ccode_variable_declarator_new ("_key", NULL)));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) cdecl_);
	_tmp39 = NULL;
	_tmp38 = NULL;
	cdecl_ = (_tmp39 = vala_ccode_declaration_new (_tmp38 = vala_data_type_get_cname (value_type)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp39);
	_tmp38 = (g_free (_tmp38), NULL);
	_tmp40 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp40 = vala_ccode_variable_declarator_new ("_value", NULL)));
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) cdecl_);
	_tmp41 = NULL;
	_tmp42 = NULL;
	key_expr = (_tmp42 = vala_dbus_module_read_expression (self, cwhilefragment, key_type, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new (entryiter_name)), NULL), (_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)), _tmp42);
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp45 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new ("_key")), key_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp46 = NULL;
	_tmp47 = NULL;
	value_expr = (_tmp47 = vala_dbus_module_read_expression (self, cwhilefragment, value_type, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new (entryiter_name)), NULL), (_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)), _tmp47);
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp50 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("_value")), value_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	_tmp51 = NULL;
	_tmp52 = NULL;
	hash_table_insert = (_tmp52 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("g_hash_table_insert"))), (_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)), _tmp52);
	_tmp53 = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, (ValaCCodeExpression*) (_tmp53 = vala_ccode_identifier_new (temp_name)));
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	_tmp55 = NULL;
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, _tmp55 = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("_key")), key_type));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, _tmp57 = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("_value")), value_type));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp58 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp58 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) hash_table_insert)));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	_tmp60 = NULL;
	_tmp59 = NULL;
	iter_call = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("dbus_message_iter_next"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp60);
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	_tmp62 = NULL;
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp62 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	_tmp63 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp63 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cwhile);
	_tmp64 = NULL;
	return (_tmp64 = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), entryiter_name = (g_free (entryiter_name), NULL), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), (key_type == NULL) ? NULL : (key_type = (vala_code_node_unref (key_type), NULL)), (value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (hash_table_new == NULL) ? NULL : (hash_table_new = (vala_ccode_node_unref (hash_table_new), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (cwhileblock == NULL) ? NULL : (cwhileblock = (vala_ccode_node_unref (cwhileblock), NULL)), (cwhilefragment == NULL) ? NULL : (cwhilefragment = (vala_ccode_node_unref (cwhilefragment), NULL)), (cwhile == NULL) ? NULL : (cwhile = (vala_ccode_node_unref (cwhile), NULL)), (key_expr == NULL) ? NULL : (key_expr = (vala_ccode_node_unref (key_expr), NULL)), (value_expr == NULL) ? NULL : (value_expr = (vala_ccode_node_unref (value_expr), NULL)), (hash_table_insert == NULL) ? NULL : (hash_table_insert = (vala_ccode_node_unref (hash_table_insert), NULL)), _tmp64);
}


ValaCCodeExpression* vala_dbus_module_read_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	ValaDBusModuleBasicTypeInfo basic_type = {0};
	ValaCCodeExpression* result;
	char* _tmp0;
	gboolean _tmp1;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeFunctionCall* _tmp25;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp26;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeExpression* _tmp28;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	result = NULL;
	_tmp0 = NULL;
	if ((_tmp1 = vala_dbus_module_get_basic_type_info (self, _tmp0 = vala_data_type_get_type_signature (type), &basic_type), _tmp0 = (g_free (_tmp0), NULL), _tmp1)) {
		ValaCCodeExpression* _tmp2;
		_tmp2 = NULL;
		result = (_tmp2 = vala_dbus_module_read_basic (self, fragment, &basic_type, iter_expr), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp2);
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaCCodeExpression* _tmp3;
			_tmp3 = NULL;
			result = (_tmp3 = vala_dbus_module_read_array (self, fragment, VALA_ARRAY_TYPE (type), iter_expr, expr), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp3);
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				ValaStruct* _tmp4;
				ValaStruct* st;
				char* _tmp5;
				gboolean _tmp6;
				_tmp4 = NULL;
				st = (_tmp4 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
				_tmp5 = NULL;
				if ((_tmp6 = _vala_strcmp0 (_tmp5 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.Value") == 0, _tmp5 = (g_free (_tmp5), NULL), _tmp6)) {
					ValaCCodeExpression* _tmp7;
					_tmp7 = NULL;
					result = (_tmp7 = vala_dbus_module_read_value (self, fragment, iter_expr), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp7);
				} else {
					ValaCCodeExpression* _tmp8;
					_tmp8 = NULL;
					result = (_tmp8 = vala_dbus_module_read_struct (self, fragment, st, iter_expr), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp8);
				}
				if (vala_data_type_get_nullable (type)) {
					ValaCCodeIdentifier* _tmp9;
					ValaCCodeFunctionCall* _tmp10;
					ValaCCodeFunctionCall* csizeof;
					ValaCCodeIdentifier* _tmp12;
					char* _tmp11;
					ValaCCodeIdentifier* _tmp13;
					ValaCCodeFunctionCall* _tmp14;
					ValaCCodeFunctionCall* cdup;
					ValaCCodeUnaryExpression* _tmp15;
					ValaCCodeExpression* _tmp17;
					ValaCCodeExpression* _tmp16;
					_tmp9 = NULL;
					_tmp10 = NULL;
					csizeof = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("sizeof"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
					_tmp12 = NULL;
					_tmp11 = NULL;
					vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
					(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
					_tmp11 = (g_free (_tmp11), NULL);
					_tmp13 = NULL;
					_tmp14 = NULL;
					cdup = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_memdup"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
					_tmp15 = NULL;
					vala_ccode_function_call_add_argument (cdup, (ValaCCodeExpression*) (_tmp15 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, result)));
					(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
					vala_ccode_function_call_add_argument (cdup, (ValaCCodeExpression*) csizeof);
					_tmp17 = NULL;
					_tmp16 = NULL;
					result = (_tmp17 = (_tmp16 = (ValaCCodeExpression*) cdup, (_tmp16 == NULL) ? NULL : vala_ccode_node_ref (_tmp16)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp17);
					(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
					(cdup == NULL) ? NULL : (cdup = (vala_ccode_node_unref (cdup), NULL));
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			} else {
				if (VALA_IS_OBJECT_TYPE (type)) {
					char* _tmp18;
					gboolean _tmp19;
					_tmp18 = NULL;
					if ((_tmp19 = _vala_strcmp0 (_tmp18 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.HashTable") == 0, _tmp18 = (g_free (_tmp18), NULL), _tmp19)) {
						ValaCCodeExpression* _tmp20;
						_tmp20 = NULL;
						result = (_tmp20 = vala_dbus_module_read_hash_table (self, fragment, VALA_OBJECT_TYPE (type), iter_expr), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp20);
					}
				} else {
					char* _tmp22;
					char* _tmp21;
					ValaCCodeExpression* _tmp23;
					_tmp22 = NULL;
					_tmp21 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp22 = g_strdup_printf ("D-Bus deserialization of type `%s' is not supported", _tmp21 = vala_code_node_to_string ((ValaCodeNode*) type)));
					_tmp22 = (g_free (_tmp22), NULL);
					_tmp21 = (g_free (_tmp21), NULL);
					_tmp23 = NULL;
					return (_tmp23 = NULL, (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp23);
				}
			}
		}
	}
	_tmp24 = NULL;
	_tmp25 = NULL;
	iter_call = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("dbus_message_iter_next"))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp25);
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp27 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	return (_tmp28 = result, (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp28);
}


static void vala_dbus_module_write_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* temp_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeExpressionStatement* _tmp3;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp6;
	ValaCCodeIdentifier* _tmp8;
	char* _tmp7;
	ValaCCodeUnaryExpression* _tmp10;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeExpressionStatement* _tmp11;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ((*basic_type).cname);
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (temp_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp3 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new (temp_name)), expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp4 = NULL;
	_tmp5 = NULL;
	iter_call = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("dbus_message_iter_append_basic"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strconcat ("DBUS_TYPE_", (*basic_type).type_name, NULL))));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (temp_name)))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp11 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp11 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	temp_name = (g_free (temp_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static void vala_dbus_module_write_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr) {
	char* array_iter_name;
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeExpressionStatement* _tmp5;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (array_expr != NULL);
	array_iter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new (_tmp0 = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new (array_iter_name, NULL)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp5 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (array_iter_name)), array_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp6 = NULL;
	vala_dbus_module_write_array_dim (self, fragment, array_type, 1, iter_expr, array_expr, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (array_iter_name)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	array_iter_name = (g_free (array_iter_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
}


static void vala_dbus_module_write_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr, ValaCCodeExpression* array_iter_expr) {
	char* subiter_name;
	char* index_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeConstant* _tmp10;
	char* _tmp9;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeBlock* cforblock;
	ValaCCodeFragment* cforfragment;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeExpression* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeForStatement* _tmp17;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp20;
	ValaCCodeConstant* _tmp19;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeUnaryExpression* _tmp22;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeUnaryExpression* _tmp28;
	ValaCCodeUnaryExpression* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp31;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (array_expr != NULL);
	g_return_if_fail (array_iter_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	index_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new (index_name, NULL)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	_tmp4 = NULL;
	iter_call = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("DBUS_TYPE_ARRAY")));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new (_tmp9 = g_strdup_printf ("\"%s%s\"", _tmp7 = g_strnfill ((gulong) (vala_array_type_get_rank (array_type) - dim), 'a'), _tmp8 = vala_data_type_get_type_signature (vala_array_type_get_element_type (array_type))))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	_tmp8 = (g_free (_tmp8), NULL);
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp13 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	cforblock = vala_ccode_block_new ();
	cforfragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cforblock, (ValaCCodeNode*) cforfragment);
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp17 = NULL;
	cfor = (_tmp17 = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (index_name)), _tmp15 = vala_dbus_module_get_array_length (self, array_expr, dim))), (ValaCCodeStatement*) cforblock), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp17);
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (index_name)), (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (index_name)))));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	if (dim < vala_array_type_get_rank (array_type)) {
		ValaCCodeIdentifier* _tmp23;
		_tmp23 = NULL;
		vala_dbus_module_write_array_dim (self, cforfragment, array_type, dim + 1, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (subiter_name)), array_expr, array_iter_expr);
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	} else {
		ValaCCodeUnaryExpression* element_expr;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeUnaryExpression* array_iter_incr;
		ValaCCodeExpressionStatement* _tmp25;
		element_expr = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, array_iter_expr);
		_tmp24 = NULL;
		vala_dbus_module_write_expression (self, cforfragment, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) element_expr);
		(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
		array_iter_incr = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, array_iter_expr);
		_tmp25 = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) array_iter_incr)));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
		(array_iter_incr == NULL) ? NULL : (array_iter_incr = (vala_ccode_node_unref (array_iter_incr), NULL));
	}
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cfor);
	_tmp27 = NULL;
	_tmp26 = NULL;
	iter_call = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp31 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	index_name = (g_free (index_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(cforblock == NULL) ? NULL : (cforblock = (vala_ccode_node_unref (cforblock), NULL));
	(cforfragment == NULL) ? NULL : (cforfragment = (vala_ccode_node_unref (cforfragment), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static void vala_dbus_module_write_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr, ValaCCodeExpression* struct_expr) {
	char* subiter_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp5;
	ValaCCodeUnaryExpression* _tmp7;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeUnaryExpression* _tmp16;
	ValaCCodeUnaryExpression* _tmp18;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (st != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (struct_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp1 = NULL;
	_tmp2 = NULL;
	iter_call = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("DBUS_TYPE_STRUCT")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_constant_new ("NULL")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp8 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp8 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	{
		GeeList* _tmp9;
		GeeIterator* _tmp10;
		GeeIterator* _f_it;
		_tmp9 = NULL;
		_tmp10 = NULL;
		_f_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_struct_get_fields (st))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			ValaCCodeMemberAccess* _tmp13;
			char* _tmp12;
			ValaCCodeIdentifier* _tmp11;
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				continue;
			}
			_tmp13 = NULL;
			_tmp12 = NULL;
			_tmp11 = NULL;
			vala_dbus_module_write_expression (self, fragment, vala_field_get_field_type (f), (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) (_tmp13 = vala_ccode_member_access_new (struct_expr, _tmp12 = vala_field_get_cname (f), FALSE)));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			_tmp12 = (g_free (_tmp12), NULL);
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	_tmp15 = NULL;
	_tmp14 = NULL;
	iter_call = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp15);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp19 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static void vala_dbus_module_write_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* subiter_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp0;
	ValaCCodeIfStatement* clastif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	clastif = NULL;
	{
		ValaDBusModuleBasicTypeInfo* basic_type_collection;
		int basic_type_collection_length1;
		int basic_type_it;
		basic_type_collection = VALA_DBUS_MODULE_basic_types;
		basic_type_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (basic_type_it = 0; basic_type_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); basic_type_it = basic_type_it + 1) {
			ValaDBusModuleBasicTypeInfo basic_type;
			basic_type = basic_type_collection[basic_type_it];
			{
				ValaCCodeIdentifier* _tmp1;
				ValaCCodeFunctionCall* _tmp2;
				ValaCCodeFunctionCall* type_call;
				ValaCCodeUnaryExpression* _tmp3;
				ValaCCodeIdentifier* _tmp4;
				ValaCCodeBinaryExpression* _tmp5;
				ValaCCodeBinaryExpression* type_check;
				ValaCCodeBlock* type_block;
				ValaCCodeFragment* type_fragment;
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* iter_call;
				ValaCCodeUnaryExpression* _tmp8;
				ValaCCodeIdentifier* _tmp9;
				ValaCCodeConstant* _tmp11;
				char* _tmp10;
				ValaCCodeUnaryExpression* _tmp13;
				ValaCCodeIdentifier* _tmp12;
				ValaCCodeExpressionStatement* _tmp14;
				ValaCCodeIdentifier* _tmp15;
				ValaCCodeFunctionCall* _tmp16;
				ValaCCodeFunctionCall* value_get;
				ValaCCodeUnaryExpression* _tmp17;
				ValaCCodeIdentifier* _tmp18;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeIdentifier* _tmp19;
				ValaCCodeUnaryExpression* _tmp21;
				ValaCCodeUnaryExpression* _tmp23;
				ValaCCodeIdentifier* _tmp22;
				ValaCCodeExpressionStatement* _tmp24;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp26;
				ValaCCodeIfStatement* _tmp25;
				/* ensure that there is only one case per GType*/
				if (basic_type.get_value_function == NULL) {
					continue;
				}
				_tmp1 = NULL;
				_tmp2 = NULL;
				type_call = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
				_tmp3 = NULL;
				vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, expr)));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				_tmp4 = NULL;
				_tmp5 = NULL;
				type_check = (_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) type_call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (basic_type.gtype))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
				type_block = vala_ccode_block_new ();
				type_fragment = vala_ccode_fragment_new ();
				vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) type_fragment);
				_tmp6 = NULL;
				_tmp7 = NULL;
				iter_call = (_tmp7 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
				_tmp8 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
				(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("DBUS_TYPE_VARIANT")));
				(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new (_tmp10 = g_strdup_printf ("\"%s\"", basic_type.signature))));
				(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp13 = NULL;
				_tmp12 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (subiter_name)))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp14 = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
				(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
				_tmp15 = NULL;
				_tmp16 = NULL;
				value_get = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (basic_type.get_value_function))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
				_tmp17 = NULL;
				vala_ccode_function_call_add_argument (value_get, (ValaCCodeExpression*) (_tmp17 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, expr)));
				(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
				_tmp18 = NULL;
				vala_dbus_module_write_basic (self, type_fragment, &basic_type, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) value_get);
				(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
				_tmp20 = NULL;
				_tmp19 = NULL;
				iter_call = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp20);
				(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp21 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp23 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (subiter_name)))));
				(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
				(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
				_tmp24 = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp24 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
				(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
				cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) type_check, (ValaCCodeStatement*) type_block, NULL);
				if (clastif == NULL) {
					vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cif);
				} else {
					vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
				}
				_tmp26 = NULL;
				_tmp25 = NULL;
				clastif = (_tmp26 = (_tmp25 = cif, (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp26);
				(type_call == NULL) ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL));
				(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
				(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
				(type_fragment == NULL) ? NULL : (type_fragment = (vala_ccode_node_unref (type_fragment), NULL));
				(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
				(value_get == NULL) ? NULL : (value_get = (vala_ccode_node_unref (value_get), NULL));
				(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
			}
		}
	}
	subiter_name = (g_free (subiter_name), NULL);
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL));
}


static void vala_dbus_module_write_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* hash_table_expr) {
	char* subiter_name;
	char* entryiter_name;
	char* tableiter_name;
	char* key_name;
	char* value_name;
	GeeList* type_args;
	ValaDataType* key_type;
	ValaDataType* value_type;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeConstant* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeUnaryExpression* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp11;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeDeclaration* _tmp15;
	ValaCCodeVariableDeclarator* _tmp16;
	ValaCCodeVariableDeclarator* _tmp17;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* iter_init_call;
	ValaCCodeUnaryExpression* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeExpressionStatement* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeFunctionCall* _tmp24;
	ValaCCodeFunctionCall* iter_next_call;
	ValaCCodeUnaryExpression* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeUnaryExpression* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeUnaryExpression* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeBlock* cwhileblock;
	ValaCCodeFragment* cwhilefragment;
	ValaCCodeWhileStatement* cwhile;
	ValaCCodeDeclaration* _tmp32;
	char* _tmp31;
	ValaCCodeVariableDeclarator* _tmp33;
	ValaCCodeDeclaration* _tmp35;
	char* _tmp34;
	ValaCCodeVariableDeclarator* _tmp36;
	ValaCCodeFunctionCall* _tmp38;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeUnaryExpression* _tmp40;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeIdentifier* _tmp41;
	ValaCCodeConstant* _tmp42;
	ValaCCodeUnaryExpression* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeExpressionStatement* _tmp45;
	ValaCCodeExpressionStatement* _tmp50;
	ValaCCodeAssignment* _tmp49;
	ValaCCodeExpression* _tmp48;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeAssignment* _tmp54;
	ValaCCodeExpression* _tmp53;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeIdentifier* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeIdentifier* _tmp59;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeFunctionCall* _tmp61;
	ValaCCodeIdentifier* _tmp60;
	ValaCCodeUnaryExpression* _tmp63;
	ValaCCodeIdentifier* _tmp62;
	ValaCCodeUnaryExpression* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeExpressionStatement* _tmp66;
	ValaCCodeFunctionCall* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeUnaryExpression* _tmp69;
	ValaCCodeUnaryExpression* _tmp71;
	ValaCCodeIdentifier* _tmp70;
	ValaCCodeExpressionStatement* _tmp72;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (hash_table_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	entryiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	tableiter_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	key_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	value_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	type_args = vala_data_type_get_type_arguments ((ValaDataType*) type);
	g_assert (gee_collection_get_size ((GeeCollection*) type_args) == 2);
	key_type = (ValaDataType*) gee_list_get (type_args, 0);
	value_type = (ValaDataType*) gee_list_get (type_args, 1);
	_tmp0 = NULL;
	_tmp1 = NULL;
	iter_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("DBUS_TYPE_ARRAY")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new (_tmp6 = g_strdup_printf ("\"{%s%s}\"", _tmp4 = vala_data_type_get_type_signature (key_type), _tmp5 = vala_data_type_get_type_signature (value_type)))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp10 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp11 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new (subiter_name, NULL)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new (entryiter_name, NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ("GHashTableIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new (tableiter_name, NULL)));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp15 = NULL;
	cdecl_ = (_tmp15 = vala_ccode_declaration_new ("gpointer"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp16 = vala_ccode_variable_declarator_new (key_name, NULL)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp17 = vala_ccode_variable_declarator_new (value_name, NULL)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cdecl_);
	_tmp18 = NULL;
	_tmp19 = NULL;
	iter_init_call = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("g_hash_table_iter_init"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
	_tmp21 = NULL;
	_tmp20 = NULL;
	vala_ccode_function_call_add_argument (iter_init_call, (ValaCCodeExpression*) (_tmp21 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (tableiter_name)))));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	vala_ccode_function_call_add_argument (iter_init_call, hash_table_expr);
	_tmp22 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_init_call)));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp23 = NULL;
	_tmp24 = NULL;
	iter_next_call = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("g_hash_table_iter_next"))), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp24);
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new (tableiter_name)))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (key_name)))));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (value_name)))));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	cwhileblock = vala_ccode_block_new ();
	cwhilefragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cwhileblock, (ValaCCodeNode*) cwhilefragment);
	cwhile = vala_ccode_while_statement_new ((ValaCCodeExpression*) iter_next_call, (ValaCCodeStatement*) cwhileblock);
	_tmp32 = NULL;
	_tmp31 = NULL;
	cdecl_ = (_tmp32 = vala_ccode_declaration_new (_tmp31 = vala_data_type_get_cname (key_type)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp32);
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp33 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp33 = vala_ccode_variable_declarator_new ("_key", NULL)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) cdecl_);
	_tmp35 = NULL;
	_tmp34 = NULL;
	cdecl_ = (_tmp35 = vala_ccode_declaration_new (_tmp34 = vala_data_type_get_cname (value_type)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp35);
	_tmp34 = (g_free (_tmp34), NULL);
	_tmp36 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp36 = vala_ccode_variable_declarator_new ("_value", NULL)));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) cdecl_);
	_tmp38 = NULL;
	_tmp37 = NULL;
	iter_call = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp38);
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp40 = NULL;
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp40 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("DBUS_TYPE_DICT_ENTRY")));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new ("NULL")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp44 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp45 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp45 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp50 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("_key")), _tmp48 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (key_name)), key_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp53 = NULL;
	_tmp52 = NULL;
	_tmp51 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp55 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("_value")), _tmp53 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (value_name)), value_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_dbus_module_write_expression (self, cwhilefragment, key_type, (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (entryiter_name)), (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("_key")));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp59 = NULL;
	_tmp58 = NULL;
	vala_dbus_module_write_expression (self, cwhilefragment, value_type, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new (entryiter_name)), (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("_value")));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	_tmp61 = NULL;
	_tmp60 = NULL;
	iter_call = (_tmp61 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp61);
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	_tmp63 = NULL;
	_tmp62 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp63 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	_tmp65 = NULL;
	_tmp64 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp65 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
	(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
	_tmp66 = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp66 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cwhile);
	_tmp68 = NULL;
	_tmp67 = NULL;
	iter_call = (_tmp68 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp68);
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	_tmp69 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp69 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
	_tmp71 = NULL;
	_tmp70 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp71 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (subiter_name)))));
	(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	_tmp72 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp72 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	entryiter_name = (g_free (entryiter_name), NULL);
	tableiter_name = (g_free (tableiter_name), NULL);
	key_name = (g_free (key_name), NULL);
	value_name = (g_free (value_name), NULL);
	(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
	(key_type == NULL) ? NULL : (key_type = (vala_code_node_unref (key_type), NULL));
	(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(iter_init_call == NULL) ? NULL : (iter_init_call = (vala_ccode_node_unref (iter_init_call), NULL));
	(iter_next_call == NULL) ? NULL : (iter_next_call = (vala_ccode_node_unref (iter_next_call), NULL));
	(cwhileblock == NULL) ? NULL : (cwhileblock = (vala_ccode_node_unref (cwhileblock), NULL));
	(cwhilefragment == NULL) ? NULL : (cwhilefragment = (vala_ccode_node_unref (cwhilefragment), NULL));
	(cwhile == NULL) ? NULL : (cwhile = (vala_ccode_node_unref (cwhile), NULL));
}


void vala_dbus_module_write_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	ValaDBusModuleBasicTypeInfo basic_type = {0};
	char* _tmp0;
	gboolean _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	if ((_tmp1 = vala_dbus_module_get_basic_type_info (self, _tmp0 = vala_data_type_get_type_signature (type), &basic_type), _tmp0 = (g_free (_tmp0), NULL), _tmp1)) {
		vala_dbus_module_write_basic (self, fragment, &basic_type, iter_expr, expr);
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			vala_dbus_module_write_array (self, fragment, VALA_ARRAY_TYPE (type), iter_expr, expr);
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				ValaCCodeExpression* _tmp2;
				ValaCCodeExpression* st_expr;
				char* _tmp4;
				gboolean _tmp5;
				_tmp2 = NULL;
				st_expr = (_tmp2 = expr, (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2));
				if (vala_data_type_get_nullable (type)) {
					ValaCCodeExpression* _tmp3;
					_tmp3 = NULL;
					st_expr = (_tmp3 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, st_expr), (st_expr == NULL) ? NULL : (st_expr = (vala_ccode_node_unref (st_expr), NULL)), _tmp3);
				}
				_tmp4 = NULL;
				if ((_tmp5 = _vala_strcmp0 (_tmp4 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.Value") == 0, _tmp4 = (g_free (_tmp4), NULL), _tmp5)) {
					vala_dbus_module_write_value (self, fragment, iter_expr, st_expr);
				} else {
					vala_dbus_module_write_struct (self, fragment, VALA_STRUCT (vala_data_type_get_data_type (type)), iter_expr, st_expr);
				}
				(st_expr == NULL) ? NULL : (st_expr = (vala_ccode_node_unref (st_expr), NULL));
			} else {
				if (VALA_IS_OBJECT_TYPE (type)) {
					char* _tmp6;
					gboolean _tmp7;
					_tmp6 = NULL;
					if ((_tmp7 = _vala_strcmp0 (_tmp6 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.HashTable") == 0, _tmp6 = (g_free (_tmp6), NULL), _tmp7)) {
						vala_dbus_module_write_hash_table (self, fragment, VALA_OBJECT_TYPE (type), iter_expr, expr);
					}
				} else {
					char* _tmp9;
					char* _tmp8;
					_tmp9 = NULL;
					_tmp8 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp9 = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp8 = vala_code_node_to_string ((ValaCodeNode*) type)));
					_tmp9 = (g_free (_tmp9), NULL);
					_tmp8 = (g_free (_tmp8), NULL);
				}
			}
		}
	}
}


static ValaDBusModuleBasicTypeInfo* vala_dbus_module_basic_type_info_dup (const ValaDBusModuleBasicTypeInfo* self) {
	ValaDBusModuleBasicTypeInfo* dup;
	dup = g_new0 (ValaDBusModuleBasicTypeInfo, 1);
	memcpy (dup, self, sizeof (ValaDBusModuleBasicTypeInfo));
	return dup;
}


static void vala_dbus_module_basic_type_info_free (ValaDBusModuleBasicTypeInfo* self) {
	g_free (self);
}


static GType vala_dbus_module_basic_type_info_get_type (void) {
	static GType vala_dbus_module_basic_type_info_type_id = 0;
	if (vala_dbus_module_basic_type_info_type_id == 0) {
		vala_dbus_module_basic_type_info_type_id = g_boxed_type_register_static ("ValaDBusModuleBasicTypeInfo", (GBoxedCopyFunc) vala_dbus_module_basic_type_info_dup, (GBoxedFreeFunc) vala_dbus_module_basic_type_info_free);
	}
	return vala_dbus_module_basic_type_info_type_id;
}


static void vala_dbus_module_class_init (ValaDBusModuleClass * klass) {
	vala_dbus_module_parent_class = g_type_class_peek_parent (klass);
}


static void vala_dbus_module_instance_init (ValaDBusModule * self) {
}


GType vala_dbus_module_get_type (void) {
	static GType vala_dbus_module_type_id = 0;
	if (vala_dbus_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusModule), 0, (GInstanceInitFunc) vala_dbus_module_instance_init, NULL };
		vala_dbus_module_type_id = g_type_register_static (VALA_TYPE_GASYNC_MODULE, "ValaDBusModule", &g_define_type_info, 0);
	}
	return vala_dbus_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




