/* set.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/set.h>







static void gee_set_base_init (GeeSetIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gee_set_get_type (void) {
	static GType gee_set_type_id = 0;
	if (gee_set_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeSetIface), (GBaseInitFunc) gee_set_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		gee_set_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeSet", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_set_type_id, GEE_TYPE_COLLECTION);
	}
	return gee_set_type_id;
}




