/* valaccodelabel.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodelabel.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeLabelPrivate {
	char* _name;
};

#define VALA_CCODE_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_LABEL, ValaCCodeLabelPrivate))
enum  {
	VALA_CCODE_LABEL_DUMMY_PROPERTY
};
static void vala_ccode_label_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_label_parent_class = NULL;
static void vala_ccode_label_finalize (ValaCCodeNode* obj);



ValaCCodeLabel* vala_ccode_label_construct (GType object_type, const char* name) {
	ValaCCodeLabel* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeLabel*) g_type_create_instance (object_type);
	vala_ccode_label_set_name (self, name);
	return self;
}


ValaCCodeLabel* vala_ccode_label_new (const char* name) {
	return vala_ccode_label_construct (VALA_TYPE_CCODE_LABEL, name);
}


static void vala_ccode_label_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeLabel * self;
	self = (ValaCCodeLabel*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_string (writer, ":");
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_label_get_name (ValaCCodeLabel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_label_set_name (ValaCCodeLabel* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


static void vala_ccode_label_class_init (ValaCCodeLabelClass * klass) {
	vala_ccode_label_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_label_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeLabelPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_label_real_write;
}


static void vala_ccode_label_instance_init (ValaCCodeLabel * self) {
	self->priv = VALA_CCODE_LABEL_GET_PRIVATE (self);
}


static void vala_ccode_label_finalize (ValaCCodeNode* obj) {
	ValaCCodeLabel * self;
	self = VALA_CCODE_LABEL (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_label_parent_class)->finalize (obj);
}


GType vala_ccode_label_get_type (void) {
	static GType vala_ccode_label_type_id = 0;
	if (vala_ccode_label_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeLabel), 0, (GInstanceInitFunc) vala_ccode_label_instance_init, NULL };
		vala_ccode_label_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeLabel", &g_define_type_info, 0);
	}
	return vala_ccode_label_type_id;
}




