/* valadynamicproperty.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALADYNAMICPROPERTY_H__
#define __VALA_VALADYNAMICPROPERTY_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valaproperty.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valasemanticanalyzer.h>

G_BEGIN_DECLS


#define VALA_TYPE_DYNAMIC_PROPERTY (vala_dynamic_property_get_type ())
#define VALA_DYNAMIC_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicProperty))
#define VALA_DYNAMIC_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyClass))
#define VALA_IS_DYNAMIC_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_PROPERTY))
#define VALA_IS_DYNAMIC_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_PROPERTY))
#define VALA_DYNAMIC_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyClass))

typedef struct _ValaDynamicProperty ValaDynamicProperty;
typedef struct _ValaDynamicPropertyClass ValaDynamicPropertyClass;
typedef struct _ValaDynamicPropertyPrivate ValaDynamicPropertyPrivate;

/**
 * Represents a late bound property.
 */
struct _ValaDynamicProperty {
	ValaProperty parent_instance;
	ValaDynamicPropertyPrivate * priv;
};

struct _ValaDynamicPropertyClass {
	ValaPropertyClass parent_class;
};


ValaDynamicProperty* vala_dynamic_property_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference);
ValaDynamicProperty* vala_dynamic_property_new (ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference);
ValaDataType* vala_dynamic_property_get_dynamic_type (ValaDynamicProperty* self);
void vala_dynamic_property_set_dynamic_type (ValaDynamicProperty* self, ValaDataType* value);
GType vala_dynamic_property_get_type (void);


G_END_DECLS

#endif
