/* valagerrormodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valagerrormodule.h>
#include <ccode/valaccodeenum.h>
#include <vala/valatypesymbol.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <vala/valacodevisitor.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodefunction.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valaexpression.h>
#include <vala/valastatement.h>
#include <gee/list.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <gee/collection.h>
#include <ccode/valaccodelabel.h>
#include <vala/valamethod.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <gobject/valaccodebasemodule.h>




struct _ValaGErrorModulePrivate {
	gint current_try_id;
	gint next_try_id;
};

#define VALA_GERROR_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GERROR_MODULE, ValaGErrorModulePrivate))
enum  {
	VALA_GERROR_MODULE_DUMMY_PROPERTY
};
static void vala_gerror_module_real_visit_error_domain (ValaCCodeModule* base, ValaErrorDomain* edomain);
static void vala_gerror_module_real_visit_error_code (ValaCCodeModule* base, ValaErrorCode* ecode);
static void vala_gerror_module_real_visit_throw_statement (ValaCCodeModule* base, ValaThrowStatement* stmt);
static ValaCCodeStatement* vala_gerror_module_real_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
static void vala_gerror_module_real_add_simple_check (ValaCCodeModule* base, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_gerror_module_real_visit_try_statement (ValaCCodeModule* base, ValaTryStatement* stmt);
static void vala_gerror_module_real_visit_catch_clause (ValaCCodeModule* base, ValaCatchClause* clause);
static gpointer vala_gerror_module_parent_class = NULL;
static void vala_gerror_module_finalize (ValaCCodeModule* obj);



ValaGErrorModule* vala_gerror_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGErrorModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type, codegen, next);
	return self;
}


ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE, codegen, next);
}


static void vala_gerror_module_real_visit_error_domain (ValaCCodeModule* base, ValaErrorDomain* edomain) {
	ValaGErrorModule * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* _tmp4;
	char* quark_fun_name;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeMacroReplacement* _tmp7;
	ValaCCodeMacroReplacement* error_domain_define;
	char* _tmp8;
	ValaCCodeFunction* _tmp9;
	ValaCCodeFunction* cquark_fun;
	ValaCCodeBlock* cquark_block;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* cquark_call;
	ValaCCodeConstant* _tmp15;
	char* _tmp14;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeReturnStatement* _tmp16;
	ValaCCodeFunction* _tmp17;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	((ValaCCodeBaseModule*) self)->cenum = (_tmp1 = vala_ccode_enum_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) edomain, FALSE)), (((ValaCCodeBaseModule*) self)->cenum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->cenum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->cenum), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) edomain)) != NULL) {
		ValaCCodeComment* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_definition, (ValaCCodeNode*) (_tmp2 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) edomain)))));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->cenum);
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp3 = NULL;
	_tmp4 = NULL;
	quark_fun_name = (_tmp4 = g_strconcat (_tmp3 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain), "quark", NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	error_domain_define = (_tmp7 = vala_ccode_macro_replacement_new (_tmp5 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) edomain, NULL), _tmp6 = g_strconcat (quark_fun_name, " ()", NULL)), _tmp6 = (g_free (_tmp6), NULL), _tmp5 = (g_free (_tmp5), NULL), _tmp7);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_definition, (ValaCCodeNode*) error_domain_define);
	_tmp8 = NULL;
	_tmp9 = NULL;
	cquark_fun = (_tmp9 = vala_ccode_function_new (quark_fun_name, _tmp8 = vala_typesymbol_get_cname (vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->gquark_type), FALSE)), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
	cquark_block = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	cquark_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new (_tmp14 = g_strconcat (_tmp13 = g_strconcat ("\"", _tmp12 = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), NULL), "-quark\"", NULL))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp13 = (g_free (_tmp13), NULL);
	_tmp12 = (g_free (_tmp12), NULL);
	_tmp16 = NULL;
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) (_tmp16 = vala_ccode_return_statement_new ((ValaCCodeExpression*) cquark_call)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp17 = vala_ccode_function_copy (cquark_fun)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	vala_ccode_function_set_block (cquark_fun, cquark_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cquark_fun);
	quark_fun_name = (g_free (quark_fun_name), NULL);
	(error_domain_define == NULL) ? NULL : (error_domain_define = (vala_ccode_node_unref (error_domain_define), NULL));
	(cquark_fun == NULL) ? NULL : (cquark_fun = (vala_ccode_node_unref (cquark_fun), NULL));
	(cquark_block == NULL) ? NULL : (cquark_block = (vala_ccode_node_unref (cquark_block), NULL));
	(cquark_call == NULL) ? NULL : (cquark_call = (vala_ccode_node_unref (cquark_call), NULL));
}


static void vala_gerror_module_real_visit_error_code (ValaCCodeModule* base, ValaErrorCode* ecode) {
	ValaGErrorModule * self;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (ecode != NULL);
	if (vala_error_code_get_value (ecode) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->cenum, _tmp1 = vala_ccode_enum_value_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept ((ValaCodeNode*) vala_error_code_get_value (ecode), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->cenum, _tmp3 = vala_ccode_enum_value_new (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_error_code_get_value (ecode)))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_gerror_module_real_visit_throw_statement (ValaCCodeModule* base, ValaThrowStatement* stmt) {
	ValaGErrorModule * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpression* _tmp0;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeAssignment* cassign;
	ValaCCodeExpressionStatement* _tmp2;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	cfrag = vala_ccode_fragment_new ();
	/* method will fail*/
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassign = (_tmp1 = vala_ccode_assignment_new (_tmp0 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_throw_statement_get_error_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp2 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassign)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) stmt, cfrag);
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_throw_statement_get_error_expression (stmt)->temp_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL));
}


static ValaCCodeStatement* vala_gerror_module_real_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cpropagate;
	ValaCCodeExpression* _tmp2;
	ValaCCodeBlock* cerror_block;
	ValaCCodeExpressionStatement* _tmp3;
	ValaCCodeFragment* free_frag;
	ValaCCodeStatement* _tmp7;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (error_expr != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cpropagate = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_propagate_error"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cpropagate, _tmp2 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "error"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_function_call_add_argument (cpropagate, error_expr);
	cerror_block = vala_ccode_block_new ();
	_tmp3 = NULL;
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp3 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cpropagate)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	/* free local variables*/
	free_frag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, FALSE);
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
	if (VALA_IS_VOID_TYPE (((ValaCCodeBaseModule*) self)->current_return_type)) {
		ValaCCodeReturnStatement* _tmp4;
		_tmp4 = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp4 = vala_ccode_return_statement_new (NULL)));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp6;
		ValaCCodeExpression* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp6 = vala_ccode_return_statement_new (_tmp5 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_return_type, FALSE))));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	}
	_tmp7 = NULL;
	return (_tmp7 = (ValaCCodeStatement*) cerror_block, (cpropagate == NULL) ? NULL : (cpropagate = (vala_ccode_node_unref (cpropagate), NULL)), (free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL)), _tmp7);
}


ValaCCodeStatement* vala_gerror_module_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr) {
	return VALA_GERROR_MODULE_GET_CLASS (self)->return_with_exception (self, error_expr);
}


static void vala_gerror_module_real_add_simple_check (ValaCCodeModule* base, ValaCodeNode* node, ValaCCodeFragment* cfrag) {
	ValaGErrorModule * self;
	ValaCCodeExpression* inner_error;
	ValaCCodeFragment* cprint_frag;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* _tmp9;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeStatement* cerror_handler;
	ValaCCodeConstant* _tmp30;
	ValaCCodeBinaryExpression* _tmp31;
	ValaCCodeBinaryExpression* ccond;
	ValaCCodeIfStatement* _tmp32;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (cfrag != NULL);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	inner_error = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error");
	cprint_frag = vala_ccode_fragment_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccritical = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_critical"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp2 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\"")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp3 = vala_ccode_constant_new ("__FILE__")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("__LINE__")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer (inner_error, "message")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_fragment_append (cprint_frag, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccritical)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	_tmp8 = NULL;
	cclear = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_clear_error"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (cclear, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_fragment_append (cprint_frag, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cclear)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	cerror_handler = NULL;
	if (((ValaCCodeBaseModule*) self)->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeFragment* free_frag;
		ValaCCodeGotoStatement* _tmp19;
		char* _tmp18;
		ValaCCodeStatement* _tmp21;
		ValaCCodeStatement* _tmp20;
		/* surrounding try found*/
		cerror_block = vala_ccode_block_new ();
		/* free local variables*/
		free_frag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_error_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, ((ValaCCodeBaseModule*) self)->current_try);
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
		{
			GeeList* _tmp11;
			GeeIterator* _tmp12;
			GeeIterator* _clause_it;
			_tmp11 = NULL;
			_tmp12 = NULL;
			_clause_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_try_statement_get_catch_clauses (((ValaCCodeBaseModule*) self)->current_try))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
			while (gee_iterator_next (_clause_it)) {
				ValaCatchClause* clause;
				ValaCCodeGotoStatement* cgoto_stmt;
				clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
				/* go to catch clause if error domain matches*/
				cgoto_stmt = vala_ccode_goto_statement_new (vala_catch_clause_get_clabel_name (clause));
				if (vala_data_type_equals (vala_catch_clause_get_error_type (clause), (ValaDataType*) ((ValaCCodeBaseModule*) self)->gerror_type)) {
					/* general catch clause*/
					vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) cgoto_stmt);
				} else {
					ValaCCodeIdentifier* _tmp15;
					char* _tmp14;
					ValaCCodeMemberAccess* _tmp13;
					ValaCCodeBinaryExpression* _tmp16;
					ValaCCodeBinaryExpression* ccond;
					ValaCCodeBlock* cgoto_block;
					ValaCCodeIfStatement* _tmp17;
					_tmp15 = NULL;
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp16 = NULL;
					ccond = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp13 = vala_ccode_member_access_new_pointer (inner_error, "domain")), (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_catch_clause_get_error_type (clause)), NULL)))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp16);
					cgoto_block = vala_ccode_block_new ();
					vala_ccode_block_add_statement (cgoto_block, (ValaCCodeNode*) cgoto_stmt);
					_tmp17 = NULL;
					vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp17 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cgoto_block, NULL)));
					(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
					(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
					(cgoto_block == NULL) ? NULL : (cgoto_block = (vala_ccode_node_unref (cgoto_block), NULL));
				}
				(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
				(cgoto_stmt == NULL) ? NULL : (cgoto_stmt = (vala_ccode_node_unref (cgoto_stmt), NULL));
			}
			(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
		}
		/* go to finally clause if no catch clause matches*/
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp19 = vala_ccode_goto_statement_new (_tmp18 = g_strdup_printf ("__finally%d", self->priv->current_try_id))));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp18 = (g_free (_tmp18), NULL);
		_tmp21 = NULL;
		_tmp20 = NULL;
		cerror_handler = (_tmp21 = (_tmp20 = (ValaCCodeStatement*) cerror_block, (_tmp20 == NULL) ? NULL : vala_ccode_node_ref (_tmp20)), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp21);
		(cerror_block == NULL) ? NULL : (cerror_block = (vala_ccode_node_unref (cerror_block), NULL));
		(free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL));
	} else {
		gboolean _tmp22;
		_tmp22 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			GeeList* _tmp23;
			_tmp23 = NULL;
			_tmp22 = gee_collection_get_size ((GeeCollection*) (_tmp23 = vala_code_node_get_error_types ((ValaCodeNode*) ((ValaCCodeBaseModule*) self)->current_method))) > 0;
			(_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL));
		} else {
			_tmp22 = FALSE;
		}
		if (_tmp22) {
			ValaCCodeStatement* _tmp24;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			_tmp24 = NULL;
			cerror_handler = (_tmp24 = vala_gerror_module_return_with_exception (self, inner_error), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp24);
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeFragment* free_frag;
			ValaCCodeStatement* _tmp29;
			ValaCCodeStatement* _tmp28;
			/* unhandled error*/
			cerror_block = vala_ccode_block_new ();
			/* free local variables*/
			free_frag = vala_ccode_fragment_new ();
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, FALSE);
			vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) cprint_frag);
			if (VALA_IS_VOID_TYPE (((ValaCCodeBaseModule*) self)->current_return_type)) {
				ValaCCodeReturnStatement* _tmp25;
				_tmp25 = NULL;
				vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp25 = vala_ccode_return_statement_new (NULL)));
				(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			} else {
				if (((ValaCCodeBaseModule*) self)->current_return_type != NULL) {
					ValaCCodeReturnStatement* _tmp27;
					ValaCCodeExpression* _tmp26;
					_tmp27 = NULL;
					_tmp26 = NULL;
					vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp27 = vala_ccode_return_statement_new (_tmp26 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_return_type, FALSE))));
					(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
					(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				}
			}
			_tmp29 = NULL;
			_tmp28 = NULL;
			cerror_handler = (_tmp29 = (_tmp28 = (ValaCCodeStatement*) cerror_block, (_tmp28 == NULL) ? NULL : vala_ccode_node_ref (_tmp28)), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp29);
			(cerror_block == NULL) ? NULL : (cerror_block = (vala_ccode_node_unref (cerror_block), NULL));
			(free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL));
		}
	}
	_tmp30 = NULL;
	_tmp31 = NULL;
	ccond = (_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, inner_error, (ValaCCodeExpression*) (_tmp30 = vala_ccode_constant_new ("NULL"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	_tmp32 = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp32 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccond, cerror_handler, NULL)));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(inner_error == NULL) ? NULL : (inner_error = (vala_ccode_node_unref (inner_error), NULL));
	(cprint_frag == NULL) ? NULL : (cprint_frag = (vala_ccode_node_unref (cprint_frag), NULL));
	(ccritical == NULL) ? NULL : (ccritical = (vala_ccode_node_unref (ccritical), NULL));
	(cclear == NULL) ? NULL : (cclear = (vala_ccode_node_unref (cclear), NULL));
	(cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL));
	(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
}


static void vala_gerror_module_real_visit_try_statement (ValaCCodeModule* base, ValaTryStatement* stmt) {
	ValaGErrorModule * self;
	gint this_try_id;
	ValaTryStatement* _tmp0;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* _tmp2;
	ValaTryStatement* _tmp1;
	ValaTryStatement* _tmp8;
	ValaTryStatement* _tmp7;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp16;
	char* _tmp15;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	this_try_id = self->priv->next_try_id++;
	_tmp0 = NULL;
	old_try = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_try, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	old_try_id = self->priv->current_try_id;
	_tmp2 = NULL;
	_tmp1 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp2 = (_tmp1 = stmt, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp2);
	self->priv->current_try_id = this_try_id;
	{
		GeeList* _tmp3;
		GeeIterator* _tmp4;
		GeeIterator* _clause_it;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_clause_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_try_statement_get_catch_clauses (stmt))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
		while (gee_iterator_next (_clause_it)) {
			ValaCatchClause* clause;
			char* _tmp6;
			char* _tmp5;
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_catch_clause_set_clabel_name (clause, _tmp6 = g_strdup_printf ("__catch%d_%s", this_try_id, _tmp5 = vala_data_type_get_lower_case_cname (vala_catch_clause_get_error_type (clause), NULL)));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp8 = NULL;
	_tmp7 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp8 = (_tmp7 = old_try, (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp8);
	self->priv->current_try_id = old_try_id;
	{
		GeeList* _tmp9;
		GeeIterator* _tmp10;
		GeeIterator* _clause_it;
		_tmp9 = NULL;
		_tmp10 = NULL;
		_clause_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_try_statement_get_catch_clauses (stmt))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
		while (gee_iterator_next (_clause_it)) {
			ValaCatchClause* clause;
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			vala_code_node_accept ((ValaCodeNode*) clause, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_try_statement_get_body (stmt)));
	{
		GeeList* _tmp11;
		GeeIterator* _tmp12;
		GeeIterator* _clause_it;
		_tmp11 = NULL;
		_tmp12 = NULL;
		_clause_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_try_statement_get_catch_clauses (stmt))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
		while (gee_iterator_next (_clause_it)) {
			ValaCatchClause* clause;
			ValaCCodeGotoStatement* _tmp14;
			char* _tmp13;
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp14 = vala_ccode_goto_statement_new (_tmp13 = g_strdup_printf ("__finally%d", this_try_id))));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			_tmp13 = (g_free (_tmp13), NULL);
			vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) clause));
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp16 = vala_ccode_label_new (_tmp15 = g_strdup_printf ("__finally%d", this_try_id))));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp15 = (g_free (_tmp15), NULL);
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt)));
	}
	/* check for errors not handled by this try statement
	 may be handled by outer try statements or propagated*/
	vala_ccode_module_add_simple_check ((ValaCCodeModule*) self, (ValaCodeNode*) stmt, cfrag);
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	(old_try == NULL) ? NULL : (old_try = (vala_code_node_unref (old_try), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_gerror_module_real_visit_catch_clause (ValaCCodeModule* base, ValaCatchClause* clause) {
	ValaGErrorModule * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp0;
	ValaCCodeBlock* cblock;
	const char* _tmp1;
	char* variable_name;
	gboolean _tmp3;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeAssignment* _tmp12;
	ValaCCodeConstant* _tmp11;
	ValaCCodeExpression* _tmp10;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	if (vala_catch_clause_get_error_variable (clause) != NULL) {
		vala_symbol_set_active ((ValaSymbol*) vala_catch_clause_get_error_variable (clause), TRUE);
	}
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	vala_code_node_accept_children ((ValaCodeNode*) clause, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	cfrag = vala_ccode_fragment_new ();
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp0 = vala_ccode_label_new (vala_catch_clause_get_clabel_name (clause))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	cblock = vala_ccode_block_new ();
	_tmp1 = NULL;
	variable_name = (_tmp1 = vala_catch_clause_get_variable_name (clause), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (variable_name == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		variable_name = (_tmp2 = g_strdup ("__err"), variable_name = (g_free (variable_name), NULL), _tmp2);
	}
	_tmp3 = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
		_tmp3 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		ValaCCodeExpressionStatement* _tmp7;
		ValaCCodeAssignment* _tmp6;
		ValaCCodeExpression* _tmp5;
		ValaCCodeExpression* _tmp4;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GError *", variable_name);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_assignment_new (_tmp4 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, variable_name), _tmp5 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	} else {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp9;
		ValaCCodeExpression* _tmp8;
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new (variable_name, _tmp8 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"))));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	}
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_assignment_new (_tmp10 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"), (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_catch_clause_get_body (clause)));
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cblock);
	vala_code_node_set_ccodenode ((ValaCodeNode*) clause, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	variable_name = (g_free (variable_name), NULL);
}


static void vala_gerror_module_class_init (ValaGErrorModuleClass * klass) {
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_gerror_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGErrorModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->visit_error_domain = vala_gerror_module_real_visit_error_domain;
	VALA_CCODE_MODULE_CLASS (klass)->visit_error_code = vala_gerror_module_real_visit_error_code;
	VALA_CCODE_MODULE_CLASS (klass)->visit_throw_statement = vala_gerror_module_real_visit_throw_statement;
	VALA_GERROR_MODULE_CLASS (klass)->return_with_exception = vala_gerror_module_real_return_with_exception;
	VALA_CCODE_MODULE_CLASS (klass)->add_simple_check = vala_gerror_module_real_add_simple_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_try_statement = vala_gerror_module_real_visit_try_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_catch_clause = vala_gerror_module_real_visit_catch_clause;
}


static void vala_gerror_module_instance_init (ValaGErrorModule * self) {
	self->priv = VALA_GERROR_MODULE_GET_PRIVATE (self);
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
}


static void vala_gerror_module_finalize (ValaCCodeModule* obj) {
	ValaGErrorModule * self;
	self = VALA_GERROR_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}


GType vala_gerror_module_get_type (void) {
	static GType vala_gerror_module_type_id = 0;
	if (vala_gerror_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
		vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
	}
	return vala_gerror_module_type_id;
}




