/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodememberaccess.h>




struct _ValaCCodeMemberAccessPrivate {
	ValaCCodeExpression* _inner;
	char* _member_name;
	gboolean _is_pointer;
};

#define VALA_CCODE_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MEMBER_ACCESS, ValaCCodeMemberAccessPrivate))
enum  {
	VALA_CCODE_MEMBER_ACCESS_DUMMY_PROPERTY
};
static void vala_ccode_member_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_member_access_parent_class = NULL;
static void vala_ccode_member_access_finalize (ValaCCodeNode* obj);



ValaCCodeMemberAccess* vala_ccode_member_access_construct (GType object_type, ValaCCodeExpression* container, const char* member, gboolean pointer) {
	ValaCCodeMemberAccess* self;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	self = (ValaCCodeMemberAccess*) g_type_create_instance (object_type);
	vala_ccode_member_access_set_inner (self, container);
	vala_ccode_member_access_set_member_name (self, member);
	vala_ccode_member_access_set_is_pointer (self, pointer);
	return self;
}


ValaCCodeMemberAccess* vala_ccode_member_access_new (ValaCCodeExpression* container, const char* member, gboolean pointer) {
	return vala_ccode_member_access_construct (VALA_TYPE_CCODE_MEMBER_ACCESS, container, member, pointer);
}


ValaCCodeMemberAccess* vala_ccode_member_access_construct_pointer (GType object_type, ValaCCodeExpression* container, const char* member) {
	ValaCCodeMemberAccess* self;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	self = (ValaCCodeMemberAccess*) g_type_create_instance (object_type);
	vala_ccode_member_access_set_inner (self, container);
	vala_ccode_member_access_set_member_name (self, member);
	vala_ccode_member_access_set_is_pointer (self, TRUE);
	return self;
}


ValaCCodeMemberAccess* vala_ccode_member_access_new_pointer (ValaCCodeExpression* container, const char* member) {
	return vala_ccode_member_access_construct_pointer (VALA_TYPE_CCODE_MEMBER_ACCESS, container, member);
}


static void vala_ccode_member_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeMemberAccess * self;
	self = (ValaCCodeMemberAccess*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_expression_write_inner (self->priv->_inner, writer);
	if (self->priv->_is_pointer) {
		vala_ccode_writer_write_string (writer, "->");
	} else {
		vala_ccode_writer_write_string (writer, ".");
	}
	vala_ccode_writer_write_string (writer, self->priv->_member_name);
}


ValaCCodeExpression* vala_ccode_member_access_get_inner (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_ccode_member_access_set_inner (ValaCCodeMemberAccess* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL)), _tmp2);
}


const char* vala_ccode_member_access_get_member_name (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_member_name;
}


void vala_ccode_member_access_set_member_name (ValaCCodeMemberAccess* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_member_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_member_name = (g_free (self->priv->_member_name), NULL), _tmp2);
}


gboolean vala_ccode_member_access_get_is_pointer (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_is_pointer;
}


void vala_ccode_member_access_set_is_pointer (ValaCCodeMemberAccess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_pointer = value;
}


static void vala_ccode_member_access_class_init (ValaCCodeMemberAccessClass * klass) {
	vala_ccode_member_access_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeMemberAccessPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_member_access_real_write;
}


static void vala_ccode_member_access_instance_init (ValaCCodeMemberAccess * self) {
	self->priv = VALA_CCODE_MEMBER_ACCESS_GET_PRIVATE (self);
}


static void vala_ccode_member_access_finalize (ValaCCodeNode* obj) {
	ValaCCodeMemberAccess * self;
	self = VALA_CCODE_MEMBER_ACCESS (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL));
	self->priv->_member_name = (g_free (self->priv->_member_name), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_member_access_parent_class)->finalize (obj);
}


GType vala_ccode_member_access_get_type (void) {
	static GType vala_ccode_member_access_type_id = 0;
	if (vala_ccode_member_access_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccess), 0, (GInstanceInitFunc) vala_ccode_member_access_instance_init, NULL };
		vala_ccode_member_access_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeMemberAccess", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_type_id;
}




