/* valausingdirective.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valausingdirective.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaUsingDirectivePrivate {
	ValaSymbol* _namespace_symbol;
};

#define VALA_USING_DIRECTIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectivePrivate))
enum  {
	VALA_USING_DIRECTIVE_DUMMY_PROPERTY
};
static void vala_using_directive_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_using_directive_parent_class = NULL;
static void vala_using_directive_finalize (ValaCodeNode* obj);



/**
 * Creates a new using directive.
 *
 * @param namespace_symbol namespace symbol
 * @return                 newly created using directive
 */
ValaUsingDirective* vala_using_directive_construct (GType object_type, ValaSymbol* namespace_symbol, ValaSourceReference* source_reference) {
	ValaUsingDirective* self;
	g_return_val_if_fail (namespace_symbol != NULL, NULL);
	self = (ValaUsingDirective*) g_type_create_instance (object_type);
	vala_using_directive_set_namespace_symbol (self, namespace_symbol);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaUsingDirective* vala_using_directive_new (ValaSymbol* namespace_symbol, ValaSourceReference* source_reference) {
	return vala_using_directive_construct (VALA_TYPE_USING_DIRECTIVE, namespace_symbol, source_reference);
}


static void vala_using_directive_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaUsingDirective * self;
	self = (ValaUsingDirective*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_using_directive (visitor, self);
}


ValaSymbol* vala_using_directive_get_namespace_symbol (ValaUsingDirective* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_namespace_symbol;
}


void vala_using_directive_set_namespace_symbol (ValaUsingDirective* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_namespace_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_namespace_symbol == NULL) ? NULL : (self->priv->_namespace_symbol = (vala_code_node_unref (self->priv->_namespace_symbol), NULL)), _tmp2);
}


static void vala_using_directive_class_init (ValaUsingDirectiveClass * klass) {
	vala_using_directive_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_using_directive_finalize;
	g_type_class_add_private (klass, sizeof (ValaUsingDirectivePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_using_directive_real_accept;
}


static void vala_using_directive_instance_init (ValaUsingDirective * self) {
	self->priv = VALA_USING_DIRECTIVE_GET_PRIVATE (self);
}


static void vala_using_directive_finalize (ValaCodeNode* obj) {
	ValaUsingDirective * self;
	self = VALA_USING_DIRECTIVE (obj);
	(self->priv->_namespace_symbol == NULL) ? NULL : (self->priv->_namespace_symbol = (vala_code_node_unref (self->priv->_namespace_symbol), NULL));
	VALA_CODE_NODE_CLASS (vala_using_directive_parent_class)->finalize (obj);
}


GType vala_using_directive_get_type (void) {
	static GType vala_using_directive_type_id = 0;
	if (vala_using_directive_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUsingDirectiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_using_directive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUsingDirective), 0, (GInstanceInitFunc) vala_using_directive_instance_init, NULL };
		vala_using_directive_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaUsingDirective", &g_define_type_info, 0);
	}
	return vala_using_directive_type_id;
}




