/* valanulltype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanulltype.h>
#include <vala/valacodenode.h>
#include <vala/valapointertype.h>
#include <vala/valatypesymbol.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>




enum  {
	VALA_NULL_TYPE_DUMMY_PROPERTY
};
static gboolean vala_null_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static ValaDataType* vala_null_type_real_copy (ValaDataType* base);
static char* vala_null_type_real_get_cname (ValaDataType* base);
static gboolean vala_null_type_real_is_disposable (ValaDataType* base);
static gpointer vala_null_type_parent_class = NULL;



ValaNullType* vala_null_type_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaNullType* self;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaNullType*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaNullType* vala_null_type_new (ValaSourceReference* source_reference) {
	return vala_null_type_construct (VALA_TYPE_NULL_TYPE, source_reference);
}


static gboolean vala_null_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaNullType * self;
	gboolean _tmp0;
	gboolean _tmp4;
	gboolean _tmp5;
	gboolean _tmp6;
	gboolean _tmp9;
	gboolean _tmp10;
	self = (ValaNullType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp0 = FALSE;
	if (!(VALA_IS_POINTER_TYPE (target_type))) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (VALA_IS_NULL_TYPE (target_type)) {
			_tmp1 = TRUE;
		} else {
			gboolean _tmp2;
			_tmp2 = FALSE;
			if (vala_data_type_get_data_type (target_type) == NULL) {
				_tmp2 = vala_data_type_get_type_parameter (target_type) == NULL;
			} else {
				_tmp2 = FALSE;
			}
			_tmp1 = (_tmp2);
		}
		_tmp0 = (_tmp1);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		return TRUE;
	}
	_tmp4 = FALSE;
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		_tmp6 = TRUE;
	} else {
		_tmp6 = VALA_IS_POINTER_TYPE (target_type);
	}
	if (_tmp6) {
		_tmp5 = TRUE;
	} else {
		_tmp5 = vala_data_type_get_nullable (target_type);
	}
	if (_tmp5) {
		_tmp4 = TRUE;
	} else {
		ValaAttribute* _tmp7;
		_tmp7 = NULL;
		_tmp4 = (_tmp7 = vala_code_node_get_attribute ((ValaCodeNode*) vala_data_type_get_data_type (target_type), "PointerType")) != NULL;
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL));
	}
	/* null can be cast to any reference or array type or pointer type */
	if (_tmp4) {
		return TRUE;
	}
	_tmp9 = FALSE;
	_tmp10 = FALSE;
	if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type))) {
		_tmp10 = TRUE;
	} else {
		_tmp10 = VALA_IS_ARRAY_TYPE (target_type);
	}
	if (_tmp10) {
		_tmp9 = TRUE;
	} else {
		_tmp9 = VALA_IS_DELEGATE_TYPE (target_type);
	}
	if (_tmp9) {
		return TRUE;
	}
	/* null is not compatible with any other type (i.e. value types) */
	return FALSE;
}


static ValaDataType* vala_null_type_real_copy (ValaDataType* base) {
	ValaNullType * self;
	self = (ValaNullType*) base;
	return (ValaDataType*) vala_null_type_new (vala_code_node_get_source_reference ((ValaCodeNode*) self));
}


static char* vala_null_type_real_get_cname (ValaDataType* base) {
	ValaNullType * self;
	self = (ValaNullType*) base;
	return g_strdup ("gpointer");
}


static gboolean vala_null_type_real_is_disposable (ValaDataType* base) {
	ValaNullType * self;
	self = (ValaNullType*) base;
	return FALSE;
}


static void vala_null_type_class_init (ValaNullTypeClass * klass) {
	vala_null_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_null_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_null_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_null_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_disposable = vala_null_type_real_is_disposable;
}


static void vala_null_type_instance_init (ValaNullType * self) {
}


GType vala_null_type_get_type (void) {
	static GType vala_null_type_type_id = 0;
	if (vala_null_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNullTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_null_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNullType), 0, (GInstanceInitFunc) vala_null_type_instance_init, NULL };
		vala_null_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaNullType", &g_define_type_info, 0);
	}
	return vala_null_type_type_id;
}




