/* valaccodeincludedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeincludedirective.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeIncludeDirectivePrivate {
	char* _filename;
	gboolean _local;
};

#define VALA_CCODE_INCLUDE_DIRECTIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectivePrivate))
enum  {
	VALA_CCODE_INCLUDE_DIRECTIVE_DUMMY_PROPERTY
};
static void vala_ccode_include_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_include_directive_parent_class = NULL;
static void vala_ccode_include_directive_finalize (ValaCCodeNode* obj);



ValaCCodeIncludeDirective* vala_ccode_include_directive_construct (GType object_type, const char* _filename, gboolean _local) {
	ValaCCodeIncludeDirective* self;
	g_return_val_if_fail (_filename != NULL, NULL);
	self = (ValaCCodeIncludeDirective*) g_type_create_instance (object_type);
	vala_ccode_include_directive_set_filename (self, _filename);
	vala_ccode_include_directive_set_local (self, _local);
	return self;
}


ValaCCodeIncludeDirective* vala_ccode_include_directive_new (const char* _filename, gboolean _local) {
	return vala_ccode_include_directive_construct (VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, _filename, _local);
}


static void vala_ccode_include_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeIncludeDirective * self;
	self = (ValaCCodeIncludeDirective*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#include ");
	if (self->priv->_local) {
		vala_ccode_writer_write_string (writer, "\"");
		vala_ccode_writer_write_string (writer, self->priv->_filename);
		vala_ccode_writer_write_string (writer, "\"");
	} else {
		vala_ccode_writer_write_string (writer, "<");
		vala_ccode_writer_write_string (writer, self->priv->_filename);
		vala_ccode_writer_write_string (writer, ">");
	}
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_include_directive_get_filename (ValaCCodeIncludeDirective* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_filename;
}


void vala_ccode_include_directive_set_filename (ValaCCodeIncludeDirective* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_filename = (g_free (self->priv->_filename), NULL), _tmp2);
}


gboolean vala_ccode_include_directive_get_local (ValaCCodeIncludeDirective* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_local;
}


void vala_ccode_include_directive_set_local (ValaCCodeIncludeDirective* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_local = value;
}


static void vala_ccode_include_directive_class_init (ValaCCodeIncludeDirectiveClass * klass) {
	vala_ccode_include_directive_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_include_directive_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeIncludeDirectivePrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_include_directive_real_write;
}


static void vala_ccode_include_directive_instance_init (ValaCCodeIncludeDirective * self) {
	self->priv = VALA_CCODE_INCLUDE_DIRECTIVE_GET_PRIVATE (self);
}


static void vala_ccode_include_directive_finalize (ValaCCodeNode* obj) {
	ValaCCodeIncludeDirective * self;
	self = VALA_CCODE_INCLUDE_DIRECTIVE (obj);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_include_directive_parent_class)->finalize (obj);
}


GType vala_ccode_include_directive_get_type (void) {
	static GType vala_ccode_include_directive_type_id = 0;
	if (vala_ccode_include_directive_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeIncludeDirectiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_include_directive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeIncludeDirective), 0, (GInstanceInitFunc) vala_ccode_include_directive_instance_init, NULL };
		vala_ccode_include_directive_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeIncludeDirective", &g_define_type_info, 0);
	}
	return vala_ccode_include_directive_type_id;
}




