/* valainterfacetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainterfacetype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valacodenode.h>




struct _ValaInterfaceTypePrivate {
	ValaInterface* _interface_symbol;
};

#define VALA_INTERFACE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_TYPE, ValaInterfaceTypePrivate))
enum  {
	VALA_INTERFACE_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_interface_type_real_copy (ValaDataType* base);
static char* vala_interface_type_real_get_cname (ValaDataType* base);
static gpointer vala_interface_type_parent_class = NULL;
static void vala_interface_type_finalize (ValaCodeNode* obj);



ValaInterfaceType* vala_interface_type_construct (GType object_type, ValaInterface* interface_symbol) {
	ValaInterfaceType* self;
	g_return_val_if_fail (interface_symbol != NULL, NULL);
	self = (ValaInterfaceType*) g_type_create_instance (object_type);
	vala_interface_type_set_interface_symbol (self, interface_symbol);
	return self;
}


ValaInterfaceType* vala_interface_type_new (ValaInterface* interface_symbol) {
	return vala_interface_type_construct (VALA_TYPE_INTERFACE_TYPE, interface_symbol);
}


static ValaDataType* vala_interface_type_real_copy (ValaDataType* base) {
	ValaInterfaceType * self;
	ValaInterfaceType* result;
	self = (ValaInterfaceType*) base;
	result = vala_interface_type_new (self->priv->_interface_symbol);
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_is_dynamic ((ValaDataType*) result, vala_data_type_get_is_dynamic ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) result, vala_data_type_get_floating_reference ((ValaDataType*) self));
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _arg_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_arg_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_data_type_get_type_arguments ((ValaDataType*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_arg_it)) {
			ValaDataType* arg;
			ValaDataType* _tmp2;
			arg = (ValaDataType*) gee_iterator_get (_arg_it);
			_tmp2 = NULL;
			vala_data_type_add_type_argument ((ValaDataType*) result, _tmp2 = vala_data_type_copy (arg));
			(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	return (ValaDataType*) result;
}


static char* vala_interface_type_real_get_cname (ValaDataType* base) {
	ValaInterfaceType * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaInterfaceType*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%sIface*", _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_interface_symbol, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


ValaInterface* vala_interface_type_get_interface_symbol (ValaInterfaceType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_interface_symbol;
}


void vala_interface_type_set_interface_symbol (ValaInterfaceType* self, ValaInterface* value) {
	g_return_if_fail (self != NULL);
	self->priv->_interface_symbol = value;
}


static void vala_interface_type_class_init (ValaInterfaceTypeClass * klass) {
	vala_interface_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_interface_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfaceTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_interface_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_interface_type_real_get_cname;
}


static void vala_interface_type_instance_init (ValaInterfaceType * self) {
	self->priv = VALA_INTERFACE_TYPE_GET_PRIVATE (self);
}


static void vala_interface_type_finalize (ValaCodeNode* obj) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (obj);
	VALA_CODE_NODE_CLASS (vala_interface_type_parent_class)->finalize (obj);
}


GType vala_interface_type_get_type (void) {
	static GType vala_interface_type_type_id = 0;
	if (vala_interface_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceType), 0, (GInstanceInitFunc) vala_interface_type_instance_init, NULL };
		vala_interface_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaInterfaceType", &g_define_type_info, 0);
	}
	return vala_interface_type_type_id;
}




