/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valagsignalmodule.h>
#include <vala/valapointertype.h>
#include <vala/valaerrortype.h>
#include <vala/valaarraytype.h>
#include <vala/valavoidtype.h>
#include <vala/valaenum.h>
#include <vala/valaformalparameter.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <vala/valastruct.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <vala/valaexpression.h>
#include <vala/valastringliteral.h>
#include <vala/valamethod.h>
#include <vala/valadynamicsignal.h>
#include <vala/valamember.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valabaseaccess.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodearraymodule.h>
#include <gobject/valaccodememberaccessmodule.h>




enum  {
	VALA_GSIGNAL_MODULE_DUMMY_PROPERTY
};
static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus);
static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus);
static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t);
static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p);
static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig);
static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus);
static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type);
static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
static void vala_gsignal_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr);
static ValaCCodeExpression* vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_gsignal_module_parent_class = NULL;



ValaGSignalModule* vala_gsignal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGSignalModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type, codegen, next);
	return self;
}


ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE, codegen, next);
}


static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_data_type_get_type_parameter (t) != NULL;
	}
	if (_tmp0) {
		const char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = ("POINTER"), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			const char* _tmp3;
			_tmp3 = NULL;
			return (_tmp3 = ("POINTER"), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				if (dbus) {
					const char* _tmp5;
					_tmp5 = NULL;
					return (_tmp5 = ("BOXED"), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5));
				} else {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (t)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						const char* _tmp7;
						_tmp7 = NULL;
						return (_tmp7 = ("BOXED_INT"), (_tmp7 == NULL) ? NULL : g_strdup (_tmp7));
					} else {
						const char* _tmp9;
						_tmp9 = NULL;
						return (_tmp9 = ("POINTER_INT"), (_tmp9 == NULL) ? NULL : g_strdup (_tmp9));
					}
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					const char* _tmp11;
					_tmp11 = NULL;
					return (_tmp11 = ("VOID"), (_tmp11 == NULL) ? NULL : g_strdup (_tmp11));
				} else {
					gboolean _tmp13;
					_tmp13 = FALSE;
					if (dbus) {
						char* _tmp14;
						_tmp14 = NULL;
						_tmp13 = g_str_has_prefix (_tmp14 = vala_data_type_get_type_signature (t), "(");
						_tmp14 = (g_free (_tmp14), NULL);
					} else {
						_tmp13 = FALSE;
					}
					if (_tmp13) {
						const char* _tmp15;
						_tmp15 = NULL;
						return (_tmp15 = ("BOXED"), (_tmp15 == NULL) ? NULL : g_strdup (_tmp15));
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							ValaEnum* _tmp17;
							ValaEnum* en;
							_tmp17 = NULL;
							en = (_tmp17 = VALA_ENUM (vala_data_type_get_data_type (t)), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
							if (dbus) {
								if (vala_enum_get_is_flags (en)) {
									const char* _tmp18;
									char* _tmp19;
									_tmp18 = NULL;
									_tmp19 = NULL;
									return (_tmp19 = (_tmp18 = ("UINT"), (_tmp18 == NULL) ? NULL : g_strdup (_tmp18)), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp19);
								} else {
									const char* _tmp20;
									char* _tmp21;
									_tmp20 = NULL;
									_tmp21 = NULL;
									return (_tmp21 = (_tmp20 = ("INT"), (_tmp20 == NULL) ? NULL : g_strdup (_tmp20)), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp21);
								}
							} else {
								char* _tmp22;
								_tmp22 = NULL;
								return (_tmp22 = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) en), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp22);
							}
							(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
						} else {
							return vala_typesymbol_get_marshaller_type_name (vala_data_type_get_data_type (t));
						}
					}
				}
			}
		}
	}
}


static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	} else {
		return vala_gsignal_module_get_marshaller_type_name (self, vala_formal_parameter_get_parameter_type (param), dbus);
	}
}


static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus) {
	ValaGSignalModule * self;
	char* signature;
	char* ret;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	char* _tmp6;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus);
	ret = NULL;
	if (prefix == NULL) {
		if (gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	ret = (_tmp1 = g_strdup_printf ("%s_%s_", prefix, _tmp0 = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus)), ret = (g_free (ret), NULL), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	_tmp2 = FALSE;
	if (params == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = gee_collection_get_size ((GeeCollection*) params) == 0;
	}
	if (_tmp2) {
		char* _tmp3;
		_tmp3 = NULL;
		ret = (_tmp3 = g_strconcat (ret, "_VOID", NULL), ret = (g_free (ret), NULL), _tmp3);
	} else {
		{
			GeeIterator* _p_it;
			_p_it = gee_iterable_iterator ((GeeIterable*) params);
			while (gee_iterator_next (_p_it)) {
				ValaFormalParameter* p;
				char* _tmp5;
				char* _tmp4;
				p = (ValaFormalParameter*) gee_iterator_get (_p_it);
				_tmp5 = NULL;
				_tmp4 = NULL;
				ret = (_tmp5 = g_strdup_printf ("%s_%s", ret, _tmp4 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus)), ret = (g_free (ret), NULL), _tmp5);
				_tmp4 = (g_free (_tmp4), NULL);
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			}
			(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
		}
	}
	_tmp6 = NULL;
	return (_tmp6 = ret, signature = (g_free (signature), NULL), _tmp6);
}


static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_data_type_get_type_parameter (t) != NULL;
	}
	if (_tmp0) {
		return g_strdup ("gpointer");
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			return g_strdup ("void");
		} else {
			if (vala_data_type_get_data_type (t) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
				return g_strdup ("const char*");
			} else {
				gboolean _tmp4;
				_tmp4 = FALSE;
				if (VALA_IS_CLASS (vala_data_type_get_data_type (t))) {
					_tmp4 = TRUE;
				} else {
					_tmp4 = VALA_IS_INTERFACE (vala_data_type_get_data_type (t));
				}
				if (_tmp4) {
					return g_strdup ("gpointer");
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (t))) {
						ValaStruct* _tmp6;
						ValaStruct* st;
						_tmp6 = NULL;
						st = (_tmp6 = VALA_STRUCT (vala_data_type_get_data_type (t)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
						if (vala_struct_is_simple_type (st)) {
							char* _tmp7;
							_tmp7 = NULL;
							return (_tmp7 = vala_typesymbol_get_cname (vala_data_type_get_data_type (t), FALSE), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp7);
						} else {
							char* _tmp8;
							_tmp8 = NULL;
							return (_tmp8 = g_strdup ("gpointer"), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp8);
						}
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							return g_strdup ("gint");
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								return g_strdup ("gpointer");
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									return g_strdup ("gpointer");
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
		return g_strdup ("gpointer");
	} else {
		return vala_gsignal_module_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_parameter_type (p));
	}
}


static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	char* signature;
	char* _tmp1;
	char* _tmp0;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	signature = (_tmp1 = g_strdup_printf ("%s:", _tmp0 = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus)), signature = (g_free (signature), NULL), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	_tmp2 = FALSE;
	if (params == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = gee_collection_get_size ((GeeCollection*) params) == 0;
	}
	if (_tmp2) {
		char* _tmp3;
		_tmp3 = NULL;
		signature = (_tmp3 = g_strconcat (signature, "VOID", NULL), signature = (g_free (signature), NULL), _tmp3);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeIterator* _p_it;
			_p_it = gee_iterable_iterator ((GeeIterable*) params);
			while (gee_iterator_next (_p_it)) {
				ValaFormalParameter* p;
				p = (ValaFormalParameter*) gee_iterator_get (_p_it);
				if (first) {
					char* _tmp5;
					char* _tmp4;
					_tmp5 = NULL;
					_tmp4 = NULL;
					signature = (_tmp5 = g_strconcat (signature, _tmp4 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus), NULL), signature = (g_free (signature), NULL), _tmp5);
					_tmp4 = (g_free (_tmp4), NULL);
					first = FALSE;
				} else {
					char* _tmp7;
					char* _tmp6;
					_tmp7 = NULL;
					_tmp6 = NULL;
					signature = (_tmp7 = g_strdup_printf ("%s,%s", signature, _tmp6 = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus)), signature = (g_free (signature), NULL), _tmp7);
					_tmp6 = (g_free (_tmp6), NULL);
				}
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			}
			(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
		}
	}
	return signature;
}


static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig) {
	ValaGSignalModule * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	GeeList* _tmp3;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	/* parent_symbol may be null for dynamic signals*/
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) sig), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sig), "Signals are not supported in compact classes");
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp3 = NULL;
	vala_ccode_module_generate_marshaller ((ValaCCodeModule*) self, _tmp3 = vala_signal_get_parameters (sig), vala_signal_get_return_type (sig), FALSE);
	(_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	ValaGSignalModule * self;
	char* signature;
	gint n_params;
	gint i;
	char* _tmp0;
	gboolean _tmp1;
	char* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFormalParameter* _tmp9;
	ValaCCodeFunction* _tmp10;
	ValaCCodeBlock* marshaller_body;
	char* _tmp11;
	ValaCCodeFunctionDeclarator* _tmp12;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp13;
	ValaCCodeFormalParameter* _tmp20;
	ValaCCodeTypeDefinition* _tmp22;
	char* _tmp21;
	char* _tmp23;
	ValaCCodeDeclaration* _tmp24;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp25;
	ValaCCodeDeclaration* _tmp26;
	ValaCCodeVariableDeclarator* _tmp29;
	ValaCCodeCastExpression* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeDeclaration* _tmp30;
	ValaCCodeVariableDeclarator* _tmp31;
	ValaCCodeVariableDeclarator* _tmp32;
	ValaCCodeFunctionCall* fc;
	gboolean _tmp33;
	ValaCCodeFunctionCall* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeBinaryExpression* _tmp48;
	ValaCCodeConstant* _tmp47;
	char* _tmp46;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeExpressionStatement* _tmp49;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeMemberAccess* _tmp51;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp53;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeMemberAccess* _tmp54;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp55;
	ValaCCodeFunctionCall* _tmp56;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp57;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp60;
	ValaCCodeAssignment* _tmp59;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeExpressionStatement* _tmp63;
	ValaCCodeAssignment* _tmp62;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp66;
	ValaCCodeAssignment* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeExpressionStatement* _tmp69;
	ValaCCodeAssignment* _tmp68;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeIfStatement* _tmp70;
	ValaCCodeCastExpression* _tmp78;
	char* _tmp77;
	ValaCCodeConditionalExpression* _tmp76;
	ValaCCodeMemberAccess* _tmp75;
	ValaCCodeIdentifier* _tmp74;
	ValaCCodeIdentifier* _tmp73;
	ValaCCodeIdentifier* _tmp72;
	ValaCCodeIdentifier* _tmp71;
	ValaCCodeAssignment* _tmp79;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp80;
	ValaCCodeFunctionCall* _tmp82;
	ValaCCodeIdentifier* _tmp81;
	ValaCCodeIdentifier* _tmp83;
	ValaCCodeIdentifier* _tmp112;
	gboolean _tmp113;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	signature = NULL;
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp0 = NULL;
	signature = (_tmp0 = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus), signature = (g_free (signature), NULL), _tmp0);
	_tmp1 = FALSE;
	if (gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature)) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	}
	if (_tmp1) {
		signature = (g_free (signature), NULL);
		return;
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	signal_marshaller = (_tmp3 = vala_ccode_function_new (_tmp2 = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, NULL, dbus), "void"), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp4 = vala_ccode_formal_parameter_new ("closure", "GClosure *"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp5 = vala_ccode_formal_parameter_new ("return_value", "GValue *"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp6 = vala_ccode_formal_parameter_new ("n_param_values", "guint"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp7 = vala_ccode_formal_parameter_new ("param_values", "const GValue *"));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp8 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer"));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp9 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp9 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer"));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_signal_marshaller_declaration, (ValaCCodeNode*) (_tmp10 = vala_ccode_function_copy (signal_marshaller)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	marshaller_body = vala_ccode_block_new ();
	_tmp11 = NULL;
	_tmp12 = NULL;
	callback_decl = (_tmp12 = vala_ccode_function_declarator_new (_tmp11 = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus)), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp13 = vala_ccode_formal_parameter_new ("data1", "gpointer"));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	n_params = 1;
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_p_it)) {
			ValaFormalParameter* p;
			ValaCCodeFormalParameter* _tmp16;
			char* _tmp15;
			char* _tmp14;
			gboolean _tmp17;
			p = (ValaFormalParameter*) gee_iterator_get (_p_it);
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_function_declarator_add_parameter (callback_decl, _tmp16 = vala_ccode_formal_parameter_new (_tmp14 = g_strdup_printf ("arg_%d", n_params), _tmp15 = vala_gsignal_module_get_value_type_name_from_parameter (self, p)));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			_tmp15 = (g_free (_tmp15), NULL);
			_tmp14 = (g_free (_tmp14), NULL);
			n_params++;
			_tmp17 = FALSE;
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p))) {
				_tmp17 = !dbus;
			} else {
				_tmp17 = FALSE;
			}
			if (_tmp17) {
				ValaCCodeFormalParameter* _tmp19;
				char* _tmp18;
				_tmp19 = NULL;
				_tmp18 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, _tmp19 = vala_ccode_formal_parameter_new (_tmp18 = g_strdup_printf ("arg_%d", n_params), "gint"));
				(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
				_tmp18 = (g_free (_tmp18), NULL);
				n_params++;
			}
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	_tmp20 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp20 = vala_ccode_formal_parameter_new ("data2", "gpointer"));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp22 = vala_ccode_type_definition_new (_tmp21 = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type), (ValaCCodeDeclarator*) callback_decl)));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp21 = (g_free (_tmp21), NULL);
	_tmp23 = NULL;
	_tmp24 = NULL;
	var_decl = (_tmp24 = vala_ccode_declaration_new (_tmp23 = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus)), _tmp23 = (g_free (_tmp23), NULL), _tmp24);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp25 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp25 = vala_ccode_variable_declarator_new ("callback")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp26 = NULL;
	var_decl = (_tmp26 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp26);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp29 = vala_ccode_variable_declarator_new_with_initializer ("cc", (ValaCCodeExpression*) (_tmp28 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("closure")), "GCClosure *")))));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp30 = NULL;
	var_decl = (_tmp30 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp30);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp31 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp31 = vala_ccode_variable_declarator_new ("data1")));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp32 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp32 = vala_ccode_variable_declarator_new ("data2")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	fc = NULL;
	_tmp33 = FALSE;
	if (vala_data_type_get_data_type (return_type) != NULL) {
		_tmp33 = TRUE;
	} else {
		_tmp33 = vala_data_type_is_array (return_type);
	}
	if (_tmp33) {
		ValaCCodeDeclaration* _tmp35;
		char* _tmp34;
		ValaCCodeVariableDeclarator* _tmp36;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeBinaryExpression* _tmp41;
		ValaCCodeConstant* _tmp40;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeExpressionStatement* _tmp42;
		_tmp35 = NULL;
		_tmp34 = NULL;
		var_decl = (_tmp35 = vala_ccode_declaration_new (_tmp34 = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type)), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp35);
		_tmp34 = (g_free (_tmp34), NULL);
		_tmp36 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp36 = vala_ccode_variable_declarator_new ("v_return")));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
		_tmp38 = NULL;
		_tmp37 = NULL;
		fc = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp38);
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		_tmp41 = NULL;
		_tmp40 = NULL;
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp41 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("return_value")), (ValaCCodeExpression*) (_tmp40 = vala_ccode_constant_new ("NULL")))));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		_tmp42 = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp42 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	}
	_tmp44 = NULL;
	_tmp43 = NULL;
	fc = (_tmp44 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp44);
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp48 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new ("n_param_values")), (ValaCCodeExpression*) (_tmp47 = vala_ccode_constant_new (_tmp46 = g_strdup_printf ("%i", n_params))))));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp46 = (g_free (_tmp46), NULL);
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp49 = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp49 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp50 = NULL;
	_tmp51 = NULL;
	data = (_tmp51 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("closure")), "data", TRUE), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)), _tmp51);
	_tmp53 = NULL;
	_tmp52 = NULL;
	_tmp54 = NULL;
	param = (_tmp54 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp53 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("param_values")), "data[0]", TRUE)), "v_pointer", FALSE), (_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), _tmp54);
	_tmp55 = NULL;
	_tmp56 = NULL;
	cond = (_tmp56 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA"))), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)), _tmp56);
	_tmp57 = NULL;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("closure")));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	true_block = vala_ccode_block_new ();
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp58 = NULL;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) (_tmp60 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("data1")), (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	_tmp63 = NULL;
	_tmp62 = NULL;
	_tmp61 = NULL;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) (_tmp63 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp62 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("data2")), (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	false_block = vala_ccode_block_new ();
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) (_tmp66 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("data1")), (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
	(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp67 = NULL;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) (_tmp69 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp68 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("data2")), (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
	(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	_tmp70 = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp70 = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) true_block, (ValaCCodeStatement*) false_block)));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	_tmp78 = NULL;
	_tmp77 = NULL;
	_tmp76 = NULL;
	_tmp75 = NULL;
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	_tmp71 = NULL;
	_tmp79 = NULL;
	c_assign = (_tmp79 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp71 = vala_ccode_identifier_new ("callback")), (ValaCCodeExpression*) (_tmp78 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp76 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("marshal_data")), (ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new ("marshal_data")), (ValaCCodeExpression*) (_tmp75 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new ("cc")), "callback", TRUE)))), _tmp77 = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)), _tmp77 = (g_free (_tmp77), NULL), (_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)), (_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)), (_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)), (_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), (_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)), _tmp79);
	_tmp80 = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp80 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) c_assign)));
	(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
	_tmp82 = NULL;
	_tmp81 = NULL;
	fc = (_tmp82 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new ("callback"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp82);
	(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
	_tmp83 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp83 = vala_ccode_identifier_new ("data1")));
	(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
	i = 1;
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_p_it)) {
			ValaFormalParameter* p;
			char* get_value_function;
			gboolean is_array;
			ValaCCodeIdentifier* _tmp99;
			ValaCCodeFunctionCall* _tmp100;
			ValaCCodeFunctionCall* inner_fc;
			ValaCCodeBinaryExpression* _tmp104;
			ValaCCodeIdentifier* _tmp103;
			char* _tmp102;
			ValaCCodeIdentifier* _tmp101;
			gboolean _tmp105;
			p = (ValaFormalParameter*) gee_iterator_get (_p_it);
			get_value_function = NULL;
			is_array = vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p));
			if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
				char* _tmp84;
				_tmp84 = NULL;
				get_value_function = (_tmp84 = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp84);
			} else {
				if (is_array) {
					if (dbus) {
						char* _tmp85;
						_tmp85 = NULL;
						get_value_function = (_tmp85 = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp85);
					} else {
						if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (p))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
							char* _tmp86;
							_tmp86 = NULL;
							get_value_function = (_tmp86 = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp86);
						} else {
							char* _tmp87;
							_tmp87 = NULL;
							get_value_function = (_tmp87 = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp87);
						}
					}
				} else {
					gboolean _tmp88;
					_tmp88 = FALSE;
					if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (p))) {
						_tmp88 = TRUE;
					} else {
						_tmp88 = vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (p)) != NULL;
					}
					if (_tmp88) {
						char* _tmp89;
						_tmp89 = NULL;
						get_value_function = (_tmp89 = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp89);
					} else {
						if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (p))) {
							char* _tmp90;
							_tmp90 = NULL;
							get_value_function = (_tmp90 = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp90);
						} else {
							gboolean _tmp91;
							_tmp91 = FALSE;
							if (dbus) {
								char* _tmp92;
								_tmp92 = NULL;
								_tmp91 = g_str_has_prefix (_tmp92 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (p)), "(");
								_tmp92 = (g_free (_tmp92), NULL);
							} else {
								_tmp91 = FALSE;
							}
							if (_tmp91) {
								char* _tmp93;
								_tmp93 = NULL;
								get_value_function = (_tmp93 = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp93);
							} else {
								gboolean _tmp94;
								_tmp94 = FALSE;
								if (dbus) {
									_tmp94 = VALA_IS_ENUM (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)));
								} else {
									_tmp94 = FALSE;
								}
								if (_tmp94) {
									ValaEnum* _tmp95;
									ValaEnum* en;
									_tmp95 = NULL;
									en = (_tmp95 = VALA_ENUM (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (_tmp95 == NULL) ? NULL : vala_code_node_ref (_tmp95));
									if (vala_enum_get_is_flags (en)) {
										char* _tmp96;
										_tmp96 = NULL;
										get_value_function = (_tmp96 = g_strdup ("g_value_get_uint"), get_value_function = (g_free (get_value_function), NULL), _tmp96);
									} else {
										char* _tmp97;
										_tmp97 = NULL;
										get_value_function = (_tmp97 = g_strdup ("g_value_get_int"), get_value_function = (g_free (get_value_function), NULL), _tmp97);
									}
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
								} else {
									char* _tmp98;
									_tmp98 = NULL;
									get_value_function = (_tmp98 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), get_value_function = (g_free (get_value_function), NULL), _tmp98);
								}
							}
						}
					}
				}
			}
			_tmp99 = NULL;
			_tmp100 = NULL;
			inner_fc = (_tmp100 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new (get_value_function))), (_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL)), _tmp100);
			_tmp104 = NULL;
			_tmp103 = NULL;
			_tmp102 = NULL;
			_tmp101 = NULL;
			vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) (_tmp104 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new ("param_values")), (ValaCCodeExpression*) (_tmp103 = vala_ccode_identifier_new (_tmp102 = g_strdup_printf ("%i", i))))));
			(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
			(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
			_tmp102 = (g_free (_tmp102), NULL);
			(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
			vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
			i++;
			_tmp105 = FALSE;
			if (is_array) {
				_tmp105 = !dbus;
			} else {
				_tmp105 = FALSE;
			}
			if (_tmp105) {
				ValaCCodeFunctionCall* _tmp107;
				ValaCCodeIdentifier* _tmp106;
				ValaCCodeBinaryExpression* _tmp111;
				ValaCCodeIdentifier* _tmp110;
				char* _tmp109;
				ValaCCodeIdentifier* _tmp108;
				_tmp107 = NULL;
				_tmp106 = NULL;
				inner_fc = (_tmp107 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new ("g_value_get_int"))), (inner_fc == NULL) ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL)), _tmp107);
				(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
				_tmp111 = NULL;
				_tmp110 = NULL;
				_tmp109 = NULL;
				_tmp108 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) (_tmp111 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new ("param_values")), (ValaCCodeExpression*) (_tmp110 = vala_ccode_identifier_new (_tmp109 = g_strdup_printf ("%i", i))))));
				(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
				(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
				_tmp109 = (g_free (_tmp109), NULL);
				(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
				vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
				i++;
			}
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			get_value_function = (g_free (get_value_function), NULL);
			(inner_fc == NULL) ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	_tmp112 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp112 = vala_ccode_identifier_new ("data2")));
	(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
	_tmp113 = FALSE;
	if (vala_data_type_get_data_type (return_type) != NULL) {
		_tmp113 = TRUE;
	} else {
		_tmp113 = vala_data_type_is_array (return_type);
	}
	if (_tmp113) {
		ValaCCodeExpressionStatement* _tmp116;
		ValaCCodeAssignment* _tmp115;
		ValaCCodeIdentifier* _tmp114;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp145;
		ValaCCodeIdentifier* _tmp146;
		ValaCCodeExpressionStatement* _tmp147;
		_tmp116 = NULL;
		_tmp115 = NULL;
		_tmp114 = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp116 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp115 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new ("v_return")), (ValaCCodeExpression*) fc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
		(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
		(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
		set_fc = NULL;
		if (vala_data_type_is_array (return_type)) {
			if (dbus) {
				ValaCCodeFunctionCall* _tmp118;
				ValaCCodeIdentifier* _tmp117;
				_tmp118 = NULL;
				_tmp117 = NULL;
				set_fc = (_tmp118 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp117 = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp118);
				(_tmp117 == NULL) ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL));
			} else {
				if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (return_type)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeFunctionCall* _tmp120;
					ValaCCodeIdentifier* _tmp119;
					_tmp120 = NULL;
					_tmp119 = NULL;
					set_fc = (_tmp120 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp120);
					(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
				} else {
					ValaCCodeFunctionCall* _tmp122;
					ValaCCodeIdentifier* _tmp121;
					_tmp122 = NULL;
					_tmp121 = NULL;
					set_fc = (_tmp122 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp122);
					(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
				}
			}
		} else {
			if (vala_data_type_get_type_parameter (return_type) != NULL) {
				ValaCCodeFunctionCall* _tmp124;
				ValaCCodeIdentifier* _tmp123;
				_tmp124 = NULL;
				_tmp123 = NULL;
				set_fc = (_tmp124 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp123 = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp124);
				(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeFunctionCall* _tmp126;
					ValaCCodeIdentifier* _tmp125;
					_tmp126 = NULL;
					_tmp125 = NULL;
					set_fc = (_tmp126 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp125 = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp126);
					(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
				} else {
					if (vala_data_type_get_data_type (return_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						ValaCCodeFunctionCall* _tmp128;
						ValaCCodeIdentifier* _tmp127;
						_tmp128 = NULL;
						_tmp127 = NULL;
						set_fc = (_tmp128 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp127 = vala_ccode_identifier_new ("g_value_take_string"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp128);
						(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
					} else {
						gboolean _tmp129;
						_tmp129 = FALSE;
						if (VALA_IS_CLASS (vala_data_type_get_data_type (return_type))) {
							_tmp129 = TRUE;
						} else {
							_tmp129 = VALA_IS_INTERFACE (vala_data_type_get_data_type (return_type));
						}
						if (_tmp129) {
							ValaCCodeFunctionCall* _tmp131;
							ValaCCodeIdentifier* _tmp130;
							_tmp131 = NULL;
							_tmp130 = NULL;
							set_fc = (_tmp131 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp130 = vala_ccode_identifier_new ("g_value_take_object"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp131);
							(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
						} else {
							gboolean _tmp132;
							_tmp132 = FALSE;
							if (dbus) {
								char* _tmp133;
								_tmp133 = NULL;
								_tmp132 = g_str_has_prefix (_tmp133 = vala_data_type_get_type_signature (return_type), "(");
								_tmp133 = (g_free (_tmp133), NULL);
							} else {
								_tmp132 = FALSE;
							}
							if (_tmp132) {
								ValaCCodeFunctionCall* _tmp135;
								ValaCCodeIdentifier* _tmp134;
								_tmp135 = NULL;
								_tmp134 = NULL;
								set_fc = (_tmp135 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp134 = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp135);
								(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
							} else {
								gboolean _tmp136;
								_tmp136 = FALSE;
								if (dbus) {
									_tmp136 = VALA_IS_ENUM (vala_data_type_get_data_type (return_type));
								} else {
									_tmp136 = FALSE;
								}
								if (_tmp136) {
									ValaEnum* _tmp137;
									ValaEnum* en;
									_tmp137 = NULL;
									en = (_tmp137 = VALA_ENUM (vala_data_type_get_data_type (return_type)), (_tmp137 == NULL) ? NULL : vala_code_node_ref (_tmp137));
									if (vala_enum_get_is_flags (en)) {
										ValaCCodeFunctionCall* _tmp139;
										ValaCCodeIdentifier* _tmp138;
										_tmp139 = NULL;
										_tmp138 = NULL;
										set_fc = (_tmp139 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp138 = vala_ccode_identifier_new ("g_value_set_uint"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp139);
										(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
									} else {
										ValaCCodeFunctionCall* _tmp141;
										ValaCCodeIdentifier* _tmp140;
										_tmp141 = NULL;
										_tmp140 = NULL;
										set_fc = (_tmp141 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp140 = vala_ccode_identifier_new ("g_value_set_int"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp141);
										(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
									}
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
								} else {
									ValaCCodeFunctionCall* _tmp144;
									ValaCCodeIdentifier* _tmp143;
									char* _tmp142;
									_tmp144 = NULL;
									_tmp143 = NULL;
									_tmp142 = NULL;
									set_fc = (_tmp144 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp143 = vala_ccode_identifier_new (_tmp142 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (return_type))))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp144);
									(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL));
									_tmp142 = (g_free (_tmp142), NULL);
								}
							}
						}
					}
				}
			}
		}
		_tmp145 = NULL;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) (_tmp145 = vala_ccode_identifier_new ("return_value")));
		(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
		_tmp146 = NULL;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) (_tmp146 = vala_ccode_identifier_new ("v_return")));
		(_tmp146 == NULL) ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL));
		_tmp147 = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp147 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_fc)));
		(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
		(set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL));
	} else {
		ValaCCodeExpressionStatement* _tmp148;
		_tmp148 = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp148 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
		(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_signal_marshaller_definition, (ValaCCodeNode*) signal_marshaller);
	gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	signature = (g_free (signature), NULL);
	(signal_marshaller == NULL) ? NULL : (signal_marshaller = (vala_ccode_node_unref (signal_marshaller), NULL));
	(marshaller_body == NULL) ? NULL : (marshaller_body = (vala_ccode_node_unref (marshaller_body), NULL));
	(callback_decl == NULL) ? NULL : (callback_decl = (vala_ccode_node_unref (callback_decl), NULL));
	(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
	(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	(data == NULL) ? NULL : (data = (vala_ccode_node_unref (data), NULL));
	(param == NULL) ? NULL : (param = (vala_ccode_node_unref (param), NULL));
	(cond == NULL) ? NULL : (cond = (vala_ccode_node_unref (cond), NULL));
	(true_block == NULL) ? NULL : (true_block = (vala_ccode_node_unref (true_block), NULL));
	(false_block == NULL) ? NULL : (false_block = (vala_ccode_node_unref (false_block), NULL));
	(c_assign == NULL) ? NULL : (c_assign = (vala_ccode_node_unref (c_assign), NULL));
}


static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaGSignalModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp6;
	char* _tmp5;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	ValaCCodeConstant* _tmp10;
	GeeList* _tmp11;
	char* _tmp12;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gboolean _tmp13;
	gint params_len;
	ValaCCodeConstant* _tmp20;
	char* _tmp19;
	ValaCCodeFunctionCall* _tmp30;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_signal_new"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new (_tmp3 = g_strdup_printf ("\"%s\"", _tmp2 = vala_signal_get_cname (sig)))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (_tmp5 = vala_typesymbol_get_type_id (type))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST")));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("0")));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("NULL")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	_tmp12 = NULL;
	marshaller = (_tmp12 = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp11 = vala_signal_get_parameters (sig), vala_signal_get_return_type (sig), NULL, FALSE), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) marshal_arg);
	params = vala_signal_get_parameters (sig);
	_tmp13 = FALSE;
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig))) {
		_tmp13 = TRUE;
	} else {
		_tmp13 = vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL;
	}
	if (_tmp13) {
		ValaCCodeConstant* _tmp14;
		_tmp14 = NULL;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("G_TYPE_POINTER")));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp15;
			_tmp15 = NULL;
			vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new ("G_TYPE_POINTER")));
			(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp16;
				_tmp16 = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp16 = vala_ccode_constant_new ("G_TYPE_NONE")));
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			} else {
				ValaCCodeConstant* _tmp18;
				char* _tmp17;
				_tmp18 = NULL;
				_tmp17 = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new (_tmp17 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))));
				(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
				_tmp17 = (g_free (_tmp17), NULL);
			}
		}
	}
	params_len = 0;
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			params_len++;
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
				params_len++;
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new (_tmp19 = g_strdup_printf ("%d", params_len))));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp19 = (g_free (_tmp19), NULL);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
				ValaCCodeConstant* _tmp23;
				if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeConstant* _tmp21;
					_tmp21 = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("G_TYPE_STRV")));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				} else {
					ValaCCodeConstant* _tmp22;
					_tmp22 = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("G_TYPE_POINTER")));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
				}
				_tmp23 = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("G_TYPE_INT")));
				(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			} else {
				gboolean _tmp24;
				gboolean _tmp25;
				_tmp24 = FALSE;
				_tmp25 = FALSE;
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					_tmp25 = TRUE;
				} else {
					_tmp25 = vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (param)) != NULL;
				}
				if (_tmp25) {
					_tmp24 = TRUE;
				} else {
					_tmp24 = vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN;
				}
				if (_tmp24) {
					ValaCCodeConstant* _tmp26;
					_tmp26 = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new ("G_TYPE_POINTER")));
					(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				} else {
					if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						ValaCCodeConstant* _tmp27;
						_tmp27 = NULL;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp27 = vala_ccode_constant_new ("G_TYPE_POINTER")));
						(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
					} else {
						ValaCCodeConstant* _tmp29;
						char* _tmp28;
						_tmp29 = NULL;
						_tmp28 = NULL;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp29 = vala_ccode_constant_new (_tmp28 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))));
						(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
						_tmp28 = (g_free (_tmp28), NULL);
					}
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp30 = NULL;
	return (_tmp30 = csignew, marshaller = (g_free (marshaller), NULL), (marshal_arg == NULL) ? NULL : (marshal_arg = (vala_ccode_node_unref (marshal_arg), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp30);
}


static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	char* _tmp0;
	ValaCCodeExpression* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp0 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	return VALA_GSIGNAL_MODULE_GET_CLASS (self)->get_dbus_g_type (self, data_type);
}


static void vala_gsignal_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr) {
	ValaGSignalModule * self;
	gboolean _tmp0;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr))) {
		_tmp0 = VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)));
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaSignal* _tmp1;
		ValaSignal* sig;
		ValaMemberAccess* _tmp2;
		ValaMemberAccess* ma;
		GeeList* _tmp3;
		ValaExpression* _tmp4;
		ValaStringLiteral* _tmp5;
		ValaStringLiteral* detail_expr;
		char* signal_detail;
		ValaCCodeIdentifier* _tmp6;
		ValaCCodeFunctionCall* _tmp7;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeConstant* _tmp8;
		/* detailed signal emission*/
		_tmp1 = NULL;
		sig = (_tmp1 = VALA_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = NULL;
		ma = (_tmp2 = VALA_MEMBER_ACCESS (vala_element_access_get_container (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		detail_expr = (_tmp5 = (_tmp4 = (ValaExpression*) gee_list_get (_tmp3 = vala_element_access_get_indices (expr), 0), VALA_IS_STRING_LITERAL (_tmp4) ? ((ValaStringLiteral*) _tmp4) : NULL), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp5);
		signal_detail = vala_string_literal_eval (detail_expr);
		_tmp6 = NULL;
		_tmp7 = NULL;
		ccall = (_tmp7 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp8 = vala_signal_get_canonical_cconstant (sig, signal_detail)));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
		signal_detail = (g_free (signal_detail), NULL);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static ValaCCodeExpression* vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment) {
	ValaSignal* _tmp0;
	ValaSignal* sig;
	ValaMethod* _tmp1;
	ValaMethod* m;
	ValaTypeSymbol* _tmp3;
	ValaSymbol* _tmp2;
	ValaTypeSymbol* target_type_symbol;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeFunctionCall* _tmp13;
	ValaCCodeFunctionCall* ccall;
	char* signal_detail;
	ValaMemberAccess* ma;
	ValaCCodeCastExpression* _tmp46;
	ValaCCodeExpression* _tmp55;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp0 = NULL;
	sig = (_tmp0 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (assignment))), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	target_type_symbol = (_tmp3 = (_tmp2 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_TYPESYMBOL (_tmp2) ? ((ValaTypeSymbol*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp4;
			_tmp4 = NULL;
			connect_func = (_tmp4 = vala_ccode_module_get_dynamic_signal_connect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp4);
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
				gboolean _tmp5;
				_tmp5 = FALSE;
				if (target_type_symbol != NULL) {
					_tmp5 = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
				} else {
					_tmp5 = FALSE;
				}
				if (_tmp5) {
					char* _tmp6;
					_tmp6 = NULL;
					connect_func = (_tmp6 = g_strdup ("g_signal_connect_object"), connect_func = (g_free (connect_func), NULL), _tmp6);
				} else {
					char* _tmp7;
					_tmp7 = NULL;
					connect_func = (_tmp7 = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp7);
				}
			} else {
				char* _tmp8;
				_tmp8 = NULL;
				connect_func = (_tmp8 = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp8);
			}
		}
	} else {
		if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
				char* _tmp9;
				_tmp9 = NULL;
				connect_func = (_tmp9 = vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp9);
			} else {
				char* _tmp10;
				_tmp10 = NULL;
				connect_func = (_tmp10 = g_strdup ("g_signal_handlers_disconnect_matched"), connect_func = (g_free (connect_func), NULL), _tmp10);
			}
			disconnect = TRUE;
		} else {
			ValaCCodeExpression* _tmp11;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) assignment), "Specified compound assignment type for signals not supported.");
			_tmp11 = NULL;
			return (_tmp11 = NULL, (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL)), connect_func = (g_free (connect_func), NULL), _tmp11);
		}
	}
	_tmp12 = NULL;
	_tmp13 = NULL;
	ccall = (_tmp13 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (connect_func))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	signal_detail = NULL;
	/* first argument: instance of sender*/
	ma = NULL;
	if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (assignment))) {
		ValaElementAccess* _tmp14;
		ValaElementAccess* ea;
		ValaMemberAccess* _tmp16;
		ValaMemberAccess* _tmp15;
		GeeList* _tmp17;
		ValaExpression* _tmp18;
		ValaStringLiteral* _tmp19;
		ValaStringLiteral* detail_expr;
		char* _tmp21;
		_tmp14 = NULL;
		ea = (_tmp14 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment)), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
		_tmp16 = NULL;
		_tmp15 = NULL;
		ma = (_tmp16 = (_tmp15 = VALA_MEMBER_ACCESS (vala_element_access_get_container (ea)), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp16);
		_tmp17 = NULL;
		_tmp18 = NULL;
		_tmp19 = NULL;
		detail_expr = (_tmp19 = (_tmp18 = (ValaExpression*) gee_list_get (_tmp17 = vala_element_access_get_indices (ea), 0), VALA_IS_STRING_LITERAL (_tmp18) ? ((ValaStringLiteral*) _tmp18) : NULL), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp19);
		if (detail_expr == NULL) {
			ValaCCodeExpression* _tmp20;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr), "internal error: only literal string details supported");
			_tmp20 = NULL;
			return (_tmp20 = NULL, (ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL)), (detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL)), (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL)), connect_func = (g_free (connect_func), NULL), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), signal_detail = (g_free (signal_detail), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp20);
		}
		_tmp21 = NULL;
		signal_detail = (_tmp21 = vala_string_literal_eval (detail_expr), signal_detail = (g_free (signal_detail), NULL), _tmp21);
		(ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL));
		(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
	} else {
		ValaMemberAccess* _tmp23;
		ValaMemberAccess* _tmp22;
		_tmp23 = NULL;
		_tmp22 = NULL;
		ma = (_tmp23 = (_tmp22 = VALA_MEMBER_ACCESS (vala_assignment_get_left (assignment)), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp23);
	}
	if (vala_member_access_get_inner (ma) != NULL) {
		ValaCCodeExpression* _tmp24;
		_tmp24 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp24 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	} else {
		ValaCCodeIdentifier* _tmp25;
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("self")));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp27;
		char* _tmp26;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp27 = vala_ccode_constant_new (_tmp26 = g_strdup_printf ("\"%s\"", vala_symbol_get_name ((ValaSymbol*) sig)))));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp26 = (g_free (_tmp26), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp28;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp28 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp28 = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		} else {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp31;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp33;
			ValaTypeSymbol* _tmp34;
			ValaTypeSymbol* decl_type;
			ValaCCodeIdentifier* _tmp36;
			char* _tmp35;
			ValaCCodeUnaryExpression* _tmp38;
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeConstant* _tmp42;
			ValaCCodeIdentifier* _tmp43;
			ValaCCodeConstant* _tmp44;
			ValaCCodeConstant* _tmp45;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp29;
				_tmp29 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			} else {
				ValaCCodeConstant* _tmp30;
				_tmp30 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp30 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
			}
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->uint_type, TRUE, NULL);
			gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
			_tmp31 = NULL;
			_tmp32 = NULL;
			parse_call = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("g_signal_parse_name"))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
			_tmp33 = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp33 = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			_tmp34 = NULL;
			decl_type = (_tmp34 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), (_tmp34 == NULL) ? NULL : vala_code_node_ref (_tmp34));
			_tmp36 = NULL;
			_tmp35 = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new (_tmp35 = vala_typesymbol_get_type_id (decl_type))));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
			_tmp35 = (g_free (_tmp35), NULL);
			_tmp38 = NULL;
			_tmp37 = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp38 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))))));
			(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp39;
				_tmp39 = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp39 = vala_ccode_constant_new ("NULL")));
				(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
			} else {
				ValaLocalVariable* detail_temp_decl;
				ValaCCodeUnaryExpression* _tmp41;
				ValaCCodeIdentifier* _tmp40;
				detail_temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL);
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, detail_temp_decl);
				_tmp41 = NULL;
				_tmp40 = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp41 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) detail_temp_decl))))));
				(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
				(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
				(detail_temp_decl == NULL) ? NULL : (detail_temp_decl = (vala_code_node_unref (detail_temp_decl), NULL));
			}
			_tmp42 = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new ("FALSE")));
			(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) parse_call);
			_tmp43 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
			(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccomma);
			/* fourth argument: detail*/
			_tmp44 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("0")));
			(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
			/* fifth argument: closure*/
			_tmp45 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("NULL")));
			(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(parse_call == NULL) ? NULL : (parse_call = (vala_ccode_node_unref (parse_call), NULL));
			(decl_type == NULL) ? NULL : (decl_type = (vala_code_node_unref (decl_type), NULL));
		}
	}
	/* third resp. sixth argument: handler*/
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp46 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_assignment_get_right (assignment))), "GCallback")));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp50;
		gboolean _tmp51;
		gboolean _tmp52;
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (assignment))) {
			ValaMemberAccess* _tmp47;
			ValaMemberAccess* right_ma;
			_tmp47 = NULL;
			right_ma = (_tmp47 = VALA_MEMBER_ACCESS (vala_assignment_get_right (assignment)), (_tmp47 == NULL) ? NULL : vala_code_node_ref (_tmp47));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (right_ma))));
			} else {
				ValaCCodeIdentifier* _tmp48;
				_tmp48 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("self")));
				(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
			}
			(right_ma == NULL) ? NULL : (right_ma = (vala_code_node_unref (right_ma), NULL));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (assignment))) {
				ValaCCodeIdentifier* _tmp49;
				_tmp49 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("self")));
				(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
			}
		}
		_tmp50 = FALSE;
		_tmp51 = FALSE;
		_tmp52 = FALSE;
		if (!disconnect) {
			_tmp52 = !(VALA_IS_DYNAMIC_SIGNAL (sig));
		} else {
			_tmp52 = FALSE;
		}
		if (_tmp52) {
			_tmp51 = target_type_symbol != NULL;
		} else {
			_tmp51 = FALSE;
		}
		if (_tmp51) {
			_tmp50 = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
		} else {
			_tmp50 = FALSE;
		}
		if (_tmp50) {
			ValaCCodeConstant* _tmp53;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp53 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp53 = vala_ccode_constant_new ("0")));
			(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
		}
	} else {
		ValaCCodeConstant* _tmp54;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp54 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp54 = vala_ccode_constant_new ("NULL")));
		(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	}
	_tmp55 = NULL;
	return (_tmp55 = (ValaCCodeExpression*) ccall, (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL)), connect_func = (g_free (connect_func), NULL), signal_detail = (g_free (signal_detail), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp55);
}


static void vala_gsignal_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaGSignalModule * self;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)))) {
		gboolean _tmp0;
		ValaCCodeExpression* _tmp1;
		vala_code_node_accept ((ValaCodeNode*) vala_assignment_get_right (assignment), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp0 = FALSE;
		if (vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_left (assignment))) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_right (assignment));
		}
		if (_tmp0) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) (_tmp1 = vala_gsignal_module_emit_signal_assignment (self, assignment)));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), assignment);
	}
}


static void vala_gsignal_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaGSignalModule * self;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaCCodeExpression* pub_inst;
		ValaSignal* _tmp2;
		ValaSignal* sig;
		ValaTypeSymbol* _tmp3;
		ValaTypeSymbol* cl;
		gboolean _tmp4;
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		pub_inst = NULL;
		if (vala_member_access_get_inner (expr) != NULL) {
			ValaCCodeExpression* _tmp1;
			ValaCCodeExpression* _tmp0;
			_tmp1 = NULL;
			_tmp0 = NULL;
			pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1);
		}
		_tmp2 = NULL;
		sig = (_tmp2 = VALA_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		cl = (_tmp3 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
		_tmp4 = FALSE;
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			_tmp4 = vala_signal_get_is_virtual (sig);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			ValaMethod* m;
			ValaClass* _tmp5;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp8;
			char* _tmp7;
			char* _tmp6;
			ValaCCodeFunctionCall* _tmp9;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp12;
			char* _tmp11;
			char* _tmp10;
			ValaCCodeMemberAccess* _tmp13;
			m = vala_signal_get_method_handler (sig);
			_tmp5 = NULL;
			base_class = (_tmp5 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp9 = NULL;
			vcast = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strdup_printf ("%s_CLASS", _tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp9);
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp10 = NULL;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("%s_parent_class", _tmp10 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
			_tmp11 = (g_free (_tmp11), NULL);
			_tmp10 = (g_free (_tmp10), NULL);
			_tmp13 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp13 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_symbol_get_name ((ValaSymbol*) m))));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
			(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
			(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return;
		}
		if (vala_signal_get_has_emitter (sig)) {
			ValaCCodeIdentifier* _tmp16;
			char* _tmp15;
			char* _tmp14;
			ValaCCodeFunctionCall* _tmp17;
			ValaCCodeFunctionCall* ccall;
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp17 = NULL;
			ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = g_strdup_printf ("%s_%s", _tmp14 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) sig))))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp15 = (g_free (_tmp15), NULL), _tmp14 = (g_free (_tmp14), NULL), _tmp17);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		} else {
			ValaCCodeIdentifier* _tmp18;
			ValaCCodeFunctionCall* _tmp19;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* _tmp20;
			_tmp18 = NULL;
			_tmp19 = NULL;
			ccall = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20 = vala_signal_get_canonical_cconstant (sig, NULL)));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		}
		(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static void vala_gsignal_module_class_init (ValaGSignalModuleClass * klass) {
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->get_marshaller_function = vala_gsignal_module_real_get_marshaller_function;
	VALA_CCODE_MODULE_CLASS (klass)->visit_signal = vala_gsignal_module_real_visit_signal;
	VALA_CCODE_MODULE_CLASS (klass)->generate_marshaller = vala_gsignal_module_real_generate_marshaller;
	VALA_CCODE_MODULE_CLASS (klass)->get_signal_creation = vala_gsignal_module_real_get_signal_creation;
	VALA_GSIGNAL_MODULE_CLASS (klass)->get_dbus_g_type = vala_gsignal_module_real_get_dbus_g_type;
	VALA_CCODE_MODULE_CLASS (klass)->visit_element_access = vala_gsignal_module_real_visit_element_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_gsignal_module_real_visit_assignment;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_gsignal_module_real_visit_member_access;
}


static void vala_gsignal_module_instance_init (ValaGSignalModule * self) {
}


GType vala_gsignal_module_get_type (void) {
	static GType vala_gsignal_module_type_id = 0;
	if (vala_gsignal_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	}
	return vala_gsignal_module_type_id;
}




